/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.searchguard.test.DynamicSgConfig;
import com.floragunn.searchguard.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.rest.RestHelper;
import org.apache.http.Header;
import org.elasticsearch.common.settings.Settings;
import org.junit.Assert;
import org.junit.Test;

public class HealthTests
extends SingleClusterTest {
    @Test
    public void testHealth() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), Settings.EMPTY);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/health?pretty&mode=lenient", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println(res.getBody());
        this.assertContains(res, "*UP*");
        this.assertNotContains(res, "*DOWN*");
        this.assertNotContains(res, "*strict*");
        res = rh.executeGetRequest("_searchguard/health?pretty", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println(res.getBody());
        this.assertContains(res, "*UP*");
        this.assertContains(res, "*strict*");
        this.assertNotContains(res, "*DOWN*");
    }

    @Test
    public void testHealthUnitialized() throws Exception {
        this.setup(Settings.EMPTY, null, Settings.EMPTY, false);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/health?pretty&mode=lenient", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println(res.getBody());
        this.assertContains(res, "*UP*");
        this.assertNotContains(res, "*DOWN*");
        this.assertNotContains(res, "*strict*");
        res = rh.executeGetRequest("_searchguard/health?pretty", new Header[0]);
        Assert.assertEquals((long)503L, (long)res.getStatusCode());
        System.out.println(res.getBody());
        this.assertContains(res, "*DOWN*");
        this.assertContains(res, "*strict*");
        this.assertNotContains(res, "*UP*");
    }
}

