/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.configuration.PrivilegesInterceptorImpl;
import com.floragunn.searchguard.test.DynamicSgConfig;
import com.floragunn.searchguard.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.file.FileHelper;
import com.floragunn.searchguard.test.helper.rest.RestHelper;
import java.util.ArrayList;
import org.apache.http.Header;
import org.apache.http.NoHttpResponseException;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.core.LogEvent;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class HttpIntegrationTests
extends SingleClusterTest {
    @Test
    public void testHTTPBasic() throws Exception {
        ConfigUpdateResponse cur;
        Settings settings = Settings.builder().putList("searchguard.authcz.rest_impersonation_user.worf", new String[]{"knuddel", "nonexists"}).build();
        this.setup(settings);
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.admin().indices().create(new CreateIndexRequest("copysf")).actionGet();
            tc.index(((IndexRequest)new IndexRequest("vulcangov").type("kolinahr").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("starfleet").type("ships").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("starfleet_academy").type("students").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("starfleet_library").type("public").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("klingonempire").type("ships").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("public").type("legends").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("v2").type("legends").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("v3").type("legends").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("spock").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("kirk").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("role01_role02").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"starfleet", "starfleet_academy", "starfleet_library"}).alias("sf"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"klingonempire", "vulcangov"}).alias("nonsf"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"public"}).alias("unrestricted"))).actionGet();
        }
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[0]).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("_search", new Header[0]).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeDeleteRequest("nonexistentindex*", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest(".nonexistentindex*", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("searchguard/config/2", "{}", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)404L, (long)rh.executeGetRequest("searchguard/config/0", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)404L, (long)rh.executeGetRequest("xxxxyyyy/config/0", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("abc", "abc:abc")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("userwithnopassword", "")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("userwithblankpassword", "")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "wrongpasswd")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic wrongheader")}).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic ")}).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic")}).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("picard", "picard")).getStatusCode());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "wrongpasswd")).getStatusCode());
        }
        Assert.assertEquals((long)200L, (long)rh.executePutRequest("/theindex", "{}", HttpIntegrationTests.encodeBasicHeader("theindexadmin", "theindexadmin")).getStatusCode());
        Assert.assertEquals((long)201L, (long)rh.executePutRequest("/theindex/type/1?refresh=true", "{\"a\":0}", HttpIntegrationTests.encodeBasicHeader("theindexadmin", "theindexadmin")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeDeleteRequest("/theindex", HttpIntegrationTests.encodeBasicHeader("theindexadmin", "theindexadmin")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeDeleteRequest("/klingonempire", HttpIntegrationTests.encodeBasicHeader("theindexadmin", "theindexadmin")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("starfleet/_search", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("_search", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("starfleet/ships/_search?pretty", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeDeleteRequest("searchguard/", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("/searchguard/_close", null, HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("/searchguard/_upgrade", null, HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("/searchguard/_mapping/config", "{}", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("searchguard/", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("searchguard/config/2", "{}", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("searchguard/config/0", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeDeleteRequest("searchguard/config/0", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("searchguard/config/0", "{}", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        RestHelper.HttpResponse resc = rh.executeGetRequest("_cat/indices/public?v", HttpIntegrationTests.encodeBasicHeader("bug108", "nagilum"));
        Assert.assertTrue((boolean)resc.getBody().contains("green"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("role01_role02/type01/_search?pretty", HttpIntegrationTests.encodeBasicHeader("user_role01_role02_role03", "user_role01_role02_role03")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("role01_role02/type01/_search?pretty", HttpIntegrationTests.encodeBasicHeader("user_role01", "user_role01")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("spock/type01/_search?pretty", HttpIntegrationTests.encodeBasicHeader("spock", "spock")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("spock/type01/_search?pretty", HttpIntegrationTests.encodeBasicHeader("kirk", "kirk")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("kirk/type01/_search?pretty", HttpIntegrationTests.encodeBasicHeader("kirk", "kirk")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("_mapping/config", "{\"i\" : [\"4\"]}", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("searchguard/_mget", "{\"ids\" : [\"0\"]}", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("starfleet/ships/_search?pretty", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("searchguard").type("sg").id("roles").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{"roles", FileHelper.readYamlContent("sg_roles_deny.yml")})).actionGet();
            cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"roles"})).actionGet();
            Assert.assertFalse((boolean)cur.hasFailures());
            Assert.assertEquals((long)this.clusterInfo.numNodes, (long)cur.getNodes().size());
        }
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("starfleet/ships/_search?pretty", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        tc = this.getInternalTransportClient();
        var5_9 = null;
        try {
            tc.index(((IndexRequest)new IndexRequest("searchguard").type("sg").id("roles").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{"roles", FileHelper.readYamlContent("sg_roles.yml")})).actionGet();
            cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"roles"})).actionGet();
            Assert.assertFalse((boolean)cur.hasFailures());
            Assert.assertEquals((long)this.clusterInfo.numNodes, (long)cur.getNodes().size());
        }
        catch (Throwable cur2) {
            var5_9 = cur2;
            throw cur2;
        }
        finally {
            if (tc != null) {
                if (var5_9 != null) {
                    try {
                        tc.close();
                    }
                    catch (Throwable cur2) {
                        var5_9.addSuppressed(cur2);
                    }
                } else {
                    tc.close();
                }
            }
        }
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("starfleet/ships/_search?pretty", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        RestHelper.HttpResponse res = rh.executeGetRequest("_search?pretty", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("\"total\" : 11"));
        Assert.assertTrue((!res.getBody().contains("searchguard") ? 1 : 0) != 0);
        res = rh.executeGetRequest("_nodes/stats?pretty", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("total_in_bytes"));
        Assert.assertTrue((boolean)res.getBody().contains("max_file_descriptors"));
        Assert.assertTrue((boolean)res.getBody().contains("buffer_pools"));
        Assert.assertFalse((boolean)res.getBody().contains("\"nodes\" : { }"));
        res = rh.executePostRequest("*/_upgrade", "", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        System.out.println(res.getBody());
        System.out.println(res.getStatusReason());
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        String bulkBody = "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator();
        res = rh.executePostRequest("_bulk", bulkBody, HttpIntegrationTests.encodeBasicHeader("writer", "writer"));
        System.out.println(res.getBody());
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("\"errors\":false"));
        Assert.assertTrue((boolean)res.getBody().contains("\"status\":201"));
        res = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("sg_tenant", "unittesttenant"), HttpIntegrationTests.encodeBasicHeader("worf", "worf")});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("sg_tenants"));
        Assert.assertTrue((boolean)res.getBody().contains("unittesttenant"));
        Assert.assertTrue((boolean)res.getBody().contains("\"kltentrw\":true"));
        Assert.assertTrue((boolean)res.getBody().contains("\"user_name\":\"worf\""));
        res = rh.executeGetRequest("_searchguard/authinfo", HttpIntegrationTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("sg_tenants"));
        Assert.assertTrue((boolean)res.getBody().contains("\"user_requested_tenant\":null"));
        Assert.assertTrue((boolean)res.getBody().contains("\"kltentrw\":true"));
        Assert.assertTrue((boolean)res.getBody().contains("\"user_name\":\"worf\""));
        Assert.assertTrue((boolean)res.getBody().contains("\"custom_attribute_names\":[]"));
        Assert.assertFalse((boolean)res.getBody().contains("attributes="));
        Assert.assertTrue((PrivilegesInterceptorImpl.count > 0 ? 1 : 0) != 0);
        res = rh.executeGetRequest("_searchguard/authinfo?pretty", HttpIntegrationTests.encodeBasicHeader("custattr", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("sg_tenants"));
        Assert.assertTrue((boolean)res.getBody().contains("\"user_requested_tenant\" : null"));
        Assert.assertTrue((boolean)res.getBody().contains("\"user_name\" : \"custattr\""));
        Assert.assertTrue((boolean)res.getBody().contains("\"custom_attribute_names\" : ["));
        Assert.assertTrue((boolean)res.getBody().contains("attr.internal.c3"));
        Assert.assertTrue((boolean)res.getBody().contains("attr.internal.c1"));
        Assert.assertTrue((PrivilegesInterceptorImpl.count > 0 ? 1 : 0) != 0);
        res = rh.executeGetRequest("v2/_search", HttpIntegrationTests.encodeBasicHeader("custattr", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("v3/_search", HttpIntegrationTests.encodeBasicHeader("custattr", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        String reindex = "{\"source\": {\"index\": \"starfleet\"},\"dest\": {\"index\": \"copysf\"}}";
        res = rh.executePostRequest("_reindex?pretty", "{\"source\": {\"index\": \"starfleet\"},\"dest\": {\"index\": \"copysf\"}}", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("\"total\" : 1"));
        Assert.assertTrue((boolean)res.getBody().contains("\"batches\" : 1"));
        Assert.assertTrue((boolean)res.getBody().contains("\"failures\" : [ ]"));
        res = rh.executeGetRequest("/_searchguard/authinfo", new Header[]{new BasicHeader("sg_impersonate_as", "knuddel"), HttpIntegrationTests.encodeBasicHeader("worf", "worf")});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("name=knuddel"));
        Assert.assertTrue((boolean)res.getBody().contains("attr.internal.test1"));
        Assert.assertFalse((boolean)res.getBody().contains("worf"));
        res = rh.executeGetRequest("/_searchguard/authinfo", new Header[]{new BasicHeader("sg_impersonate_as", "nonexists"), HttpIntegrationTests.encodeBasicHeader("worf", "worf")});
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/_searchguard/authinfo", new Header[]{new BasicHeader("sg_impersonate_as", "notallowed"), HttpIntegrationTests.encodeBasicHeader("worf", "worf")});
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
    }

    @Test
    public void testHTTPSCompressionEnabled() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("truststore.jks")).put("http.compression", true).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings, true);
        RestHelper rh = this.restHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/sslinfo", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println(res);
        this.assertContains(res, "*ssl_protocol\":\"TLSv1.2*");
        res = rh.executeGetRequest("_nodes", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println(res);
        this.assertNotContains(res, "*\"compression\":\"false\"*");
        this.assertContains(res, "*\"compression\":\"true\"*");
    }

    @Test
    public void testHTTPSCompression() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("truststore.jks")).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings, true);
        RestHelper rh = this.restHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/sslinfo", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println(res);
        this.assertContains(res, "*ssl_protocol\":\"TLSv1.2*");
        res = rh.executeGetRequest("_nodes", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println(res);
        this.assertContains(res, "*\"compression\":\"false\"*");
        this.assertNotContains(res, "*\"compression\":\"true\"*");
    }

    @Test
    public void testHTTPAnon() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_anon.yml"), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", new Header[0]).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "wrong")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        RestHelper.HttpResponse resc = rh.executeGetRequest("_searchguard/authinfo", new Header[0]);
        System.out.println(resc.getBody());
        Assert.assertTrue((boolean)resc.getBody().contains("sg_anonymous"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("_searchguard/authinfo?pretty=true", new Header[0]);
        System.out.println(resc.getBody());
        Assert.assertTrue((boolean)resc.getBody().contains("\"remote_address\" : \""));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("_searchguard/authinfo", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        System.out.println(resc.getBody());
        Assert.assertTrue((boolean)resc.getBody().contains("nagilum"));
        Assert.assertFalse((boolean)resc.getBody().contains("sg_anonymous"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("searchguard").type("sg").id("config").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{"config", FileHelper.readYamlContent("sg_config.yml")})).actionGet();
            tc.index(((IndexRequest)new IndexRequest("searchguard").type("sg").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("internalusers").source(new Object[]{"internalusers", FileHelper.readYamlContent("sg_internal_users.yml")})).actionGet();
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertFalse((boolean)cur.hasFailures());
            Assert.assertEquals((long)this.clusterInfo.numNodes, (long)cur.getNodes().size());
        }
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[0]).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("_searchguard/authinfo", new Header[0]).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "wrong")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
    }

    @Test
    public void testHTTPClientCert() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("truststore.jks")).putList("searchguard.ssl.http.enabled_protocols", new String[]{"TLSv1.1", "TLSv1.2"}).putList("searchguard.ssl.http.enabled_ciphers", new String[]{"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"}).putList("searchguard.ssl.transport.enabled_protocols", new String[]{"TLSv1.1", "TLSv1.2"}).putList("searchguard.ssl.transport.enabled_ciphers", new String[]{"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"}).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_clientcert.yml"), settings, true);
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("vulcangov").type("type").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertFalse((boolean)cur.hasFailures());
            Assert.assertEquals((long)this.clusterInfo.numNodes, (long)cur.getNodes().size());
        }
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        rh.keystore = "spock-keystore.jks";
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_search", new Header[0]).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("searchguard/sg/x", "{}", new Header[0]).getStatusCode());
        rh.keystore = "kirk-keystore.jks";
        Assert.assertEquals((long)201L, (long)rh.executePutRequest("searchguard/sg/y", "{}", new Header[0]).getStatusCode());
        RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/authinfo", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println(res.getBody());
    }

    @Test
    @Ignore
    public void testHTTPPlaintextErrMsg() throws Exception {
        try {
            Settings settings = Settings.builder().put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("truststore.jks")).put("searchguard.ssl.http.enabled", true).build();
            this.setup(settings);
            RestHelper rh = this.nonSslRestHelper();
            rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "worf"));
            Assert.fail();
        }
        catch (NoHttpResponseException e) {
            this.clusterHelper.stopCluster();
            Assert.assertNotNull((Object)appender);
            ArrayList logEvents = new ArrayList(appender.getEvents());
            Assert.assertTrue((logEvents.size() > 0 ? 1 : 0) != 0);
            for (LogEvent evt : logEvents) {
                System.out.println("--> " + evt.getMessage().getFormattedMessage());
                if (!evt.getMessage().getFormattedMessage().contains("speaks http plaintext instead of ssl, will close the channel")) continue;
                return;
            }
            Assert.fail((String)((Object)logEvents).toString());
        }
    }

    @Test
    public void testHTTPProxyDefault() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_proxy.yml"), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[0]).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "localhost,192.168.0.1,10.0.0.2"), new BasicHeader("x-proxy-user", "scotty"), HttpIntegrationTests.encodeBasicHeader("nagilum-wrong", "nagilum-wrong")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "localhost,192.168.0.1,10.0.0.2"), new BasicHeader("x-proxy-user-wrong", "scotty"), HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")}).getStatusCode());
        Assert.assertEquals((long)500L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "a"), new BasicHeader("x-proxy-user", "scotty"), HttpIntegrationTests.encodeBasicHeader("nagilum-wrong", "nagilum-wrong")}).getStatusCode());
        Assert.assertEquals((long)500L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "a,b,c"), new BasicHeader("x-proxy-user", "scotty")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "localhost,192.168.0.1,10.0.0.2"), new BasicHeader("x-proxy-user", "scotty")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "localhost,192.168.0.1,10.0.0.2"), new BasicHeader("X-Proxy-User", "scotty")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("x-forwarded-for", "localhost,192.168.0.1,10.0.0.2"), new BasicHeader("x-proxy-user", "scotty"), new BasicHeader("x-proxy-roles", "starfleet,engineer")}).getStatusCode());
    }

    @Test
    public void testHTTPProxyRolesSeparator() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_proxy_custom.yml"), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("/_searchguard/authinfo", new Header[]{new BasicHeader("x-forwarded-for", "localhost,192.168.0.1,10.0.0.2"), new BasicHeader("user", "scotty"), new BasicHeader("roles", "starfleet,engineer")});
        Assert.assertTrue((String)"Expected one backend role since separator is incorrect", (boolean)res.getBody().contains("\"backend_roles\":[\"starfleet,engineer\"]"));
        res = rh.executeGetRequest("/_searchguard/authinfo", new Header[]{new BasicHeader("x-forwarded-for", "localhost,192.168.0.1,10.0.0.2"), new BasicHeader("user", "scotty"), new BasicHeader("roles", "starfleet;engineer")});
        Assert.assertTrue((String)("Expected two backend roles string since separator is correct: " + res.getBody()), (boolean)res.getBody().contains("\"backend_roles\":[\"starfleet\",\"engineer\"]"));
    }

    @Test
    public void testHTTPBasic2() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), Settings.EMPTY);
        try (TransportClient tc = this.getInternalTransportClient(this.clusterInfo, Settings.EMPTY);){
            tc.admin().indices().create(new CreateIndexRequest("copysf")).actionGet();
            tc.index(((IndexRequest)new IndexRequest("vulcangov").type("kolinahr").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("starfleet").type("ships").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("starfleet_academy").type("students").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("starfleet_library").type("public").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("klingonempire").type("ships").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("public").type("legends").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("spock").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("kirk").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("role01_role02").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"starfleet", "starfleet_academy", "starfleet_library"}).alias("sf"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"klingonempire", "vulcangov"}).alias("nonsf"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"public"}).alias("unrestricted"))).actionGet();
        }
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[0]).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeDeleteRequest("nonexistentindex*", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest(".nonexistentindex*", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("searchguard/config/2", "{}", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)404L, (long)rh.executeGetRequest("searchguard/config/0", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)404L, (long)rh.executeGetRequest("xxxxyyyy/config/0", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("abc", "abc:abc")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("userwithnopassword", "")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("userwithblankpassword", "")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "wrongpasswd")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic wrongheader")}).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic ")}).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "Basic")}).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[]{new BasicHeader("Authorization", "")}).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("picard", "picard")).getStatusCode());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "wrongpasswd")).getStatusCode());
        }
        Assert.assertEquals((long)200L, (long)rh.executePutRequest("/theindex", "{}", HttpIntegrationTests.encodeBasicHeader("theindexadmin", "theindexadmin")).getStatusCode());
        Assert.assertEquals((long)201L, (long)rh.executePutRequest("/theindex/type/1?refresh=true", "{\"a\":0}", HttpIntegrationTests.encodeBasicHeader("theindexadmin", "theindexadmin")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeDeleteRequest("/theindex", HttpIntegrationTests.encodeBasicHeader("theindexadmin", "theindexadmin")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeDeleteRequest("/klingonempire", HttpIntegrationTests.encodeBasicHeader("theindexadmin", "theindexadmin")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("starfleet/_search", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("_search", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("starfleet/ships/_search?pretty", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeDeleteRequest("searchguard/", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("/searchguard/_close", null, HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("/searchguard/_upgrade", null, HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("/searchguard/_mapping/config", "{}", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("searchguard/", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("searchguard/config/2", "{}", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("searchguard/config/0", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeDeleteRequest("searchguard/config/0", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("searchguard/config/0", "{}", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        RestHelper.HttpResponse resc = rh.executeGetRequest("_cat/indices/public", HttpIntegrationTests.encodeBasicHeader("bug108", "nagilum"));
        System.out.println(resc.getBody());
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("role01_role02/type01/_search?pretty", HttpIntegrationTests.encodeBasicHeader("user_role01_role02_role03", "user_role01_role02_role03")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("role01_role02/type01/_search?pretty", HttpIntegrationTests.encodeBasicHeader("user_role01", "user_role01")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("spock/type01/_search?pretty", HttpIntegrationTests.encodeBasicHeader("spock", "spock")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("spock/type01/_search?pretty", HttpIntegrationTests.encodeBasicHeader("kirk", "kirk")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("kirk/type01/_search?pretty", HttpIntegrationTests.encodeBasicHeader("kirk", "kirk")).getStatusCode());
        System.out.println("ok");
    }

    @Test
    public void testBulk() throws Exception {
        Settings settings = Settings.builder().put("searchguard.roles_mapping_resolution", "BOTH").build();
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgRoles("sg_roles_bulk.yml"), settings);
        RestHelper rh = this.nonSslRestHelper();
        String bulkBody = "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator();
        RestHelper.HttpResponse res = rh.executePostRequest("_bulk", bulkBody, HttpIntegrationTests.encodeBasicHeader("bulk", "nagilum"));
        System.out.println(res.getBody());
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("\"errors\":false"));
        Assert.assertTrue((boolean)res.getBody().contains("\"status\":201"));
    }

    @Test
    public void test557() throws Exception {
        Settings settings = Settings.builder().put("searchguard.roles_mapping_resolution", "BOTH").build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings);
        try (TransportClient tc = this.getInternalTransportClient(this.clusterInfo, Settings.EMPTY);){
            tc.admin().indices().create(new CreateIndexRequest("copysf")).actionGet();
            tc.index(((IndexRequest)new IndexRequest("vulcangov").type("kolinahr").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("starfleet").type("ships").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("starfleet_academy").type("students").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        }
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executePostRequest("/*/_search", "{\"size\":0,\"aggs\":{\"indices\":{\"terms\":{\"field\":\"_index\",\"size\":10}}}}", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        System.out.println(res.getBody());
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("starfleet_academy"));
        res = rh.executePostRequest("/*/_search", "{\"size\":0,\"aggs\":{\"indices\":{\"terms\":{\"field\":\"_index\",\"size\":10}}}}", HttpIntegrationTests.encodeBasicHeader("557", "nagilum"));
        System.out.println(res.getBody());
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("starfleet_academy"));
    }

    @Test
    public void testITT1635() throws Exception {
        Settings settings = Settings.builder().put("searchguard.roles_mapping_resolution", "BOTH").build();
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_dnfof.yml").setSgRoles("sg_roles_itt1635.yml"), settings);
        try (TransportClient tc = this.getInternalTransportClient(this.clusterInfo, Settings.EMPTY);){
            tc.index(((IndexRequest)new IndexRequest("esb-prod-1").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("esb-prod-2").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":2}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("esb-prod-3").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":3}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("esb-prod-4").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":4}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("esb-prod-5").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":5}", XContentType.JSON)).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"esb-prod-1", "esb-prod-2", "esb-prod-3", "esb-prod-4", "esb-prod-5"}).alias("esb-prod-all"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"esb-prod-1"}).alias("esb-alias-1"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"esb-prod-2"}).alias("esb-alias-2"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"esb-prod-3"}).alias("esb-alias-3"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"esb-prod-4"}).alias("esb-alias-4"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"esb-prod-5"}).alias("esb-alias-5"))).actionGet();
        }
        RestHelper rh = this.nonSslRestHelper();
        System.out.println("###1");
        RestHelper.HttpResponse res = rh.executeGetRequest("/esb-prod-*/_search?pretty", HttpIntegrationTests.encodeBasicHeader("itt1635", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println("###2");
        res = rh.executeGetRequest("/esb-alias-*/_search?pretty", HttpIntegrationTests.encodeBasicHeader("itt1635", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println("###3");
        res = rh.executeGetRequest("/esb-prod-all/_search?pretty", HttpIntegrationTests.encodeBasicHeader("itt1635", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
    }

    @Test
    public void testTenantInfo() throws Exception {
        Settings settings = Settings.builder().build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings);
        try (TransportClient tc = this.getInternalTransportClient(this.clusterInfo, Settings.EMPTY);){
            tc.index(((IndexRequest)new IndexRequest(".kibana-6").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":2}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest(".kibana_-1139640511_admin1").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":3}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest(".kibana_-1386441176_praxisrw").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":3}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest(".kibana_-634608247_abcdef22").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":3}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest(".kibana_-12345_123456").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":3}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest(".kibana2_-12345_123456").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":3}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest(".kibana_9876_xxx_ccc").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":3}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest(".kibana_fff_eee").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":3}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("esb-prod-5").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":5}", XContentType.JSON)).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{".kibana-6"}).alias(".kibana"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"esb-prod-5"}).alias(".kibana_-2014056163_kltentrw"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"esb-prod-5"}).alias("esb-alias-5"))).actionGet();
        }
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("/_searchguard/tenantinfo?pretty", HttpIntegrationTests.encodeBasicHeader("itt1635", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/_searchguard/tenantinfo?pretty", HttpIntegrationTests.encodeBasicHeader("kibanaserver", "kibanaserver"));
        System.out.println(res.getBody());
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("\".kibana_-1139640511_admin1\" : \"admin_1\""));
        Assert.assertTrue((boolean)res.getBody().contains("\".kibana_-1386441176_praxisrw\" : \"praxisrw\""));
        Assert.assertTrue((boolean)res.getBody().contains(".kibana_-2014056163_kltentrw\" : \"kltentrw\""));
        Assert.assertTrue((boolean)res.getBody().contains("\".kibana_-634608247_abcdef22\" : \"abcdef_2_2\""));
        Assert.assertTrue((boolean)res.getBody().contains("\".kibana_-12345_123456\" : \"__private__\""));
        Assert.assertFalse((boolean)res.getBody().contains(".kibana-6"));
        Assert.assertFalse((boolean)res.getBody().contains("esb-"));
        Assert.assertFalse((boolean)res.getBody().contains("xxx"));
        Assert.assertFalse((boolean)res.getBody().contains(".kibana2"));
    }

    @Test
    public void testRestImpersonation() throws Exception {
        Settings settings = Settings.builder().putList("searchguard.authcz.rest_impersonation_user.worf", new String[]{"someotherusernotininternalusersfile"}).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_rest_impersonation.yml"), settings);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("/_searchguard/authinfo", new Header[]{new BasicHeader("sg_impersonate_as", "someotherusernotininternalusersfile"), HttpIntegrationTests.encodeBasicHeader("worf", "worf")});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("name=someotherusernotininternalusersfile"));
        Assert.assertFalse((boolean)res.getBody().contains("worf"));
    }

    @Test
    public void testSslOnlyMode() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl_only", true).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("/_searchguard/sslinfo", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("/xyz/_doc/1", "{\"a\":5}", new Header[0]);
        Assert.assertEquals((long)201L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/_mappings", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/_search", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
    }

    @Test
    public void testAll() throws Exception {
        Settings settings = Settings.builder().build();
        this.setup(settings);
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("abcdef").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        }
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("_all/_search", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("*/_search", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("_search", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
    }

    @Test
    public void testRateLimiting() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_auth_ratelimiting.yml"), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "wrong")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "wrong")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "wrong")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("x1", "wrong")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("x2", "wrong")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("x3", "wrong")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("x4", "wrong")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("x5", "wrong")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("x6", "wrong")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("x7", "wrong")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("x8", "wrong")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", HttpIntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
    }

    @Test
    public void testEnvReplace() throws Exception {
        Settings settings = Settings.builder().build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings);
        try (TransportClient tc = this.getInternalTransportClient(this.clusterInfo, Settings.EMPTY);){
            tc.index(((IndexRequest)new IndexRequest("index1").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("index2").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":2}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("index3").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":3}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("env.replace@example.comp.com").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":4}", XContentType.JSON)).actionGet();
        }
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("/index1/_search?pretty", HttpIntegrationTests.encodeBasicHeader("env.replace@example.comp.com", "nagilum"));
        Assert.assertEquals((String)res.getBody(), (long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/index2/_search?pretty", HttpIntegrationTests.encodeBasicHeader("env.replace@example.comp.com", "nagilum"));
        Assert.assertEquals((String)res.getBody(), (long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/env.replace@example.comp.com/_search?pretty", HttpIntegrationTests.encodeBasicHeader("env.replace@example.comp.com", "nagilum"));
        Assert.assertEquals((String)res.getBody(), (long)200L, (long)res.getStatusCode());
    }

    @Test
    public void testNoEnvReplace() throws Exception {
        Settings settings = Settings.builder().put("searchguard.disable_envvar_replacement", true).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings);
        try (TransportClient tc = this.getInternalTransportClient(this.clusterInfo, Settings.EMPTY);){
            tc.index(((IndexRequest)new IndexRequest("index1").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("index2").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":2}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("index3").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":3}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("env.replace@example.comp.com").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":4}", XContentType.JSON)).actionGet();
        }
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("/index1/_search?pretty", HttpIntegrationTests.encodeBasicHeader("env.replace@example.comp.com", "nagilum"));
        Assert.assertEquals((String)res.getBody(), (long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/index2/_search?pretty", HttpIntegrationTests.encodeBasicHeader("env.replace@example.comp.com", "nagilum"));
        Assert.assertEquals((String)res.getBody(), (long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/env.replace@example.comp.com/_search?pretty", HttpIntegrationTests.encodeBasicHeader("env.replace@example.comp.com", "nagilum"));
        Assert.assertEquals((String)res.getBody(), (long)200L, (long)res.getStatusCode());
    }
}

