/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.searchguard.support.SgUtils;
import com.floragunn.searchguard.test.DynamicSgConfig;
import com.floragunn.searchguard.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.rest.RestHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.http.Header;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.indices.InvalidTypeNameException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class IndexIntegrationTests
extends SingleClusterTest {
    @Test
    public void testComposite() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_composite_config.yml").setSgRoles("sg_roles_composite.yml"), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("starfleet").type("ships").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("klingonempire").type("ships").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("public").type("legends").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        }
        String msearchBody = "{\"index\":\"starfleet\", \"type\":\"ships\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator() + "{\"index\":\"klingonempire\", \"type\":\"ships\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator() + "{\"index\":\"public\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator();
        RestHelper.HttpResponse resc = rh.executePostRequest("_msearch", msearchBody, IndexIntegrationTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("\"_index\":\"klingonempire\""));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("hits"));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("no permissions for [indices:data/read/search]"));
    }

    @Test
    public void testBulkShards() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgRoles("sg_roles_bs.yml"), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("test").type("type1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"field2\":\"init\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("lorem").type("type1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"field2\":\"init\"}", XContentType.JSON)).actionGet();
        }
        String bulkBody = "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field2\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"3\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"4\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"5\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"lorem\", \"_type\" : \"type1\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"lorem\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"lorem\", \"_type\" : \"type1\", \"_id\" : \"3\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"lorem\", \"_type\" : \"type1\", \"_id\" : \"4\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"lorem\", \"_type\" : \"type1\", \"_id\" : \"5\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"delete\" : { \"_index\" : \"lorem\", \"_type\" : \"type1\", \"_id\" : \"5\" } }" + System.lineSeparator();
        System.out.println("############ _bulk");
        RestHelper.HttpResponse res = rh.executePostRequest("_bulk?refresh=true&pretty=true", bulkBody, IndexIntegrationTests.encodeBasicHeader("worf", "worf"));
        System.out.println(res.getBody());
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("\"errors\" : true"));
        Assert.assertTrue((boolean)res.getBody().contains("\"status\" : 201"));
        Assert.assertTrue((boolean)res.getBody().contains("no permissions for"));
        System.out.println("############ check shards");
        System.out.println(rh.executeGetRequest("_cat/shards?v", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum")));
    }

    @Test
    public void testCreateIndex() throws Exception {
        this.setup();
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((String)"Unable to create index 'nag'", (long)200L, (long)rh.executePutRequest("nag1", null, IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((String)"Unable to create index 'starfleet_library'", (long)200L, (long)rh.executePutRequest("starfleet_library", null, IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        this.clusterHelper.waitForCluster(ClusterHealthStatus.GREEN, TimeValue.timeValueSeconds((long)10L), this.clusterInfo.numNodes);
        Assert.assertEquals((String)"Unable to close index 'starfleet_library'", (long)200L, (long)rh.executePostRequest("starfleet_library/_close", null, IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        RestHelper.HttpResponse res = rh.executePostRequest("starfleet_library/_open", null, IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((String)"Unable to open index 'starfleet_library'", (long)200L, (long)res.getStatusCode());
        Assert.assertTrue((String)"open index 'starfleet_library' not acknowledged", (boolean)res.getBody().contains("acknowledged"));
        Assert.assertFalse((String)"open index 'starfleet_library' not acknowledged", (boolean)res.getBody().contains("false"));
        this.clusterHelper.waitForCluster(ClusterHealthStatus.GREEN, TimeValue.timeValueSeconds((long)10L), this.clusterInfo.numNodes);
        Assert.assertEquals((long)403L, (long)rh.executePutRequest("public", null, IndexIntegrationTests.encodeBasicHeader("spock", "spock")).getStatusCode());
    }

    @Test
    public void testFilteredAlias() throws Exception {
        this.setup();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("theindex").type("type1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("otherindex").type("type1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().alias("alias1").filter((QueryBuilder)QueryBuilders.termQuery((String)"_type", (String)"type1")).index("theindex"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().alias("alias2").filter((QueryBuilder)QueryBuilders.termQuery((String)"_type", (String)"type2")).index("theindex"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().alias("alias3").filter((QueryBuilder)QueryBuilders.termQuery((String)"_type", (String)"type2")).index("otherindex"))).actionGet();
        }
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse resc = rh.executeGetRequest("alias*/_search", IndexIntegrationTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("theindex/_search", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("alias3/_search", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("_cat/indices", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
    }

    @Test
    public void testIndexTypeEvaluation() throws Exception {
        this.setup();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("foo1").type("bar").id("1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("foo2").type("bar").id("2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":2}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("foo").type("baz").id("3").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":3}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("fooba").type("z").id("4").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":4}", XContentType.JSON)).actionGet();
            try {
                tc.index(((IndexRequest)new IndexRequest("x#a").type("xxx").id("4a").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":4}", XContentType.JSON)).actionGet();
                Assert.fail((String)"Indexname can contain #");
            }
            catch (InvalidIndexNameException invalidIndexNameException) {
                // empty catch block
            }
            try {
                tc.index(((IndexRequest)new IndexRequest("xa").type("x#a").id("4a").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":4}", XContentType.JSON)).actionGet();
                Assert.fail((String)"Typename can contain #");
            }
            catch (InvalidTypeNameException invalidTypeNameException) {
                // empty catch block
            }
        }
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse resc = rh.executeGetRequest("/foo1/bar/_search?pretty", IndexIntegrationTests.encodeBasicHeader("baz", "worf"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("\"content\" : 1"));
        resc = rh.executeGetRequest("/foo2/bar/_search?pretty", IndexIntegrationTests.encodeBasicHeader("baz", "worf"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("\"content\" : 2"));
        resc = rh.executeGetRequest("/foo/baz/_search?pretty", IndexIntegrationTests.encodeBasicHeader("baz", "worf"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("\"content\" : 3"));
        resc = rh.executeGetRequest("/fooba/z/_search?pretty", IndexIntegrationTests.encodeBasicHeader("baz", "worf"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("/foo1/bar/1?pretty", IndexIntegrationTests.encodeBasicHeader("baz", "worf"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("\"found\" : true"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"content\" : 1"));
        resc = rh.executeGetRequest("/foo2/bar/2?pretty", IndexIntegrationTests.encodeBasicHeader("baz", "worf"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("\"content\" : 2"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"found\" : true"));
        resc = rh.executeGetRequest("/foo/baz/3?pretty", IndexIntegrationTests.encodeBasicHeader("baz", "worf"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("\"content\" : 3"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"found\" : true"));
        resc = rh.executeGetRequest("/fooba/z/4?pretty", IndexIntegrationTests.encodeBasicHeader("baz", "worf"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("/foo*/_search?pretty", IndexIntegrationTests.encodeBasicHeader("baz", "worf"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("/foo*,-fooba/bar/_search?pretty", IndexIntegrationTests.encodeBasicHeader("baz", "worf"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("\"content\" : 1"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"content\" : 2"));
    }

    @Test
    public void testIndices() throws Exception {
        this.setup();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("nopermindex").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("logstash-1").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("logstash-2").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("logstash-3").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("logstash-4").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            SimpleDateFormat sdf = new SimpleDateFormat("YYYY.MM.dd", SgUtils.EN_Locale);
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            String date = sdf.format(new Date());
            tc.index(((IndexRequest)new IndexRequest("logstash-" + date).type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        }
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = null;
        res = rh.executeGetRequest("/logstash-1/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/logstash-nonex/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)404L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/logstash-nonex,logstash-1/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)404L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/nopermindex/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/does-not-exist-and-no-perm/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/logstash-1/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/logstash-nonex/_search", IndexIntegrationTests.encodeBasicHeader("nouser", "nosuer"));
        Assert.assertEquals((long)401L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/logstash-nonex/_search", new Header[0]);
        Assert.assertEquals((long)401L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/_all/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/*/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/nopermindex,logstash-1,nonexist/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/logstash-1,nonexist/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/nonexist/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/%3Clogstash-%7Bnow%2Fd%7D%3E/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/%3Cnonex-%7Bnow%2Fd%7D%3E/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/%3Clogstash-%7Bnow%2Fd%7D%3E,logstash-*/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/%3Clogstash-%7Bnow%2Fd%7D%3E,logstash-1/_search", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("/logstash-b/logs/1", "{}", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)201L, (long)res.getStatusCode());
        res = rh.executePutRequest("/%3Clogstash-cnew-%7Bnow%2Fd%7D%3E", "{}", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("/%3Clogstash-new-%7Bnow%2Fd%7D%3E/logs/1", "{}", IndexIntegrationTests.encodeBasicHeader("logstash", "nagilum"));
        Assert.assertEquals((long)201L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/_cat/indices?v", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println(res.getBody());
        Assert.assertTrue((boolean)res.getBody().contains("logstash-b"));
        Assert.assertTrue((boolean)res.getBody().contains("logstash-new-20"));
        Assert.assertTrue((boolean)res.getBody().contains("logstash-cnew-20"));
        Assert.assertFalse((boolean)res.getBody().contains("<"));
    }

    @Test
    public void testAliases() throws Exception {
        Settings settings = Settings.builder().put("searchguard.roles_mapping_resolution", "BOTH").build();
        this.setup(settings);
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("nopermindex").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("logstash-1").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("logstash-2").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("logstash-3").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("logstash-4").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("logstash-5").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("logstash-del").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("logstash-del-ok").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            String date = new SimpleDateFormat("YYYY.MM.dd").format(new Date());
            tc.index(((IndexRequest)new IndexRequest("logstash-" + date).type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"nopermindex"}).alias("nopermalias"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"searchguard"}).alias("mysgi"))).actionGet();
        }
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = null;
        res = rh.executePostRequest("/mysgi/sg", "{}", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/mysgi/_search?pretty", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        this.assertContains(res, "*\"hits\" : {*\"total\" : 0,*\"hits\" : [ ]*");
        System.out.println("#### add alias to allowed index");
        res = rh.executePutRequest("/logstash-1/_alias/alog1", "", IndexIntegrationTests.encodeBasicHeader("aliasmngt", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println("#### add alias to not existing (no perm)");
        res = rh.executePutRequest("/nonexitent/_alias/alnp", "", IndexIntegrationTests.encodeBasicHeader("aliasmngt", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        System.out.println("#### add alias to not existing (with perm)");
        res = rh.executePutRequest("/logstash-nonex/_alias/alnp", "", IndexIntegrationTests.encodeBasicHeader("aliasmngt", "nagilum"));
        Assert.assertEquals((long)404L, (long)res.getStatusCode());
        System.out.println("#### add alias to not allowed index");
        res = rh.executePutRequest("/nopermindex/_alias/alnp", "", IndexIntegrationTests.encodeBasicHeader("aliasmngt", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        String aliasRemoveIndex = "{\"actions\" : [{ \"add\":  { \"index\": \"logstash-del-ok\", \"alias\": \"logstash-del\" } },{ \"remove_index\": { \"index\": \"logstash-del\" } }  ]}";
        System.out.println("#### remove_index");
        res = rh.executePostRequest("/_aliases", aliasRemoveIndex, IndexIntegrationTests.encodeBasicHeader("aliasmngt", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        System.out.println("#### get alias for permitted index");
        res = rh.executeGetRequest("/logstash-1/_alias/alog1", IndexIntegrationTests.encodeBasicHeader("aliasmngt", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println("#### get alias for all indices");
        res = rh.executeGetRequest("/_alias/alog1", IndexIntegrationTests.encodeBasicHeader("aliasmngt", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        System.out.println("#### get alias no perm");
        res = rh.executeGetRequest("/_alias/nopermalias", IndexIntegrationTests.encodeBasicHeader("aliasmngt", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        String alias = "{\"aliases\": {\"alias1\": {}}}";
        System.out.println("#### create alias along with index");
        res = rh.executePutRequest("/beats-withalias", alias, IndexIntegrationTests.encodeBasicHeader("aliasmngt", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
    }

    @Test
    public void testAliasResolution() throws Exception {
        Settings settings = Settings.builder().build();
        this.setup(settings);
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("concreteindex-1").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"concreteindex-1"}).alias("calias-1"))).actionGet();
            tc.index(((IndexRequest)new IndexRequest(".kibana-6").type("doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{".kibana-6"}).alias(".kibana"))).actionGet();
        }
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("calias-1/_search?pretty", IndexIntegrationTests.encodeBasicHeader("aliastest", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("calias-*/_search?pretty", IndexIntegrationTests.encodeBasicHeader("aliastest", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("*kibana/_search?pretty", IndexIntegrationTests.encodeBasicHeader("aliastest", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest(".ki*ana/_search?pretty", IndexIntegrationTests.encodeBasicHeader("aliastest", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest(".kibana/_search?pretty", IndexIntegrationTests.encodeBasicHeader("aliastest", "nagilum")).getStatusCode());
    }

    @Test
    public void testCCSIndexResolve() throws Exception {
        this.setup();
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest(".abc-6").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        }
        RestHelper.HttpResponse res = rh.executeGetRequest("ggg:.abc-6,.abc-6/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/*:.abc-6,.abc-6/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
    }

    @Test
    @Ignore
    public void testCCSIndexResolve2() throws Exception {
        this.setup();
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest(".abc").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("xyz").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":2}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("noperm").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":3}", XContentType.JSON)).actionGet();
        }
        RestHelper.HttpResponse res = rh.executeGetRequest("/*:.abc,.abc/_search", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((String)res.getBody(), (boolean)res.getBody().contains("\"content\":1"));
        res = rh.executeGetRequest("/ba*bcuzh/_search", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertTrue((String)res.getBody(), (boolean)res.getBody().contains("\"content\":12"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/*:.abc/_search", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertTrue((String)res.getBody(), (boolean)res.getBody().contains("\"content\":1"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/*:xyz,xyz/_search", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((String)res.getBody(), (boolean)res.getBody().contains("\"content\":2"));
        res = rh.executeGetRequest("/*:.abc/_search", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((String)res.getBody(), (boolean)res.getBody().contains("\"content\":1"));
        res = rh.executeGetRequest("/*:xyz/_search", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((String)res.getBody(), (boolean)res.getBody().contains("\"content\":2"));
        res = rh.executeGetRequest("/.abc/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/xyz/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/*:.abc,.abc/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/*:xyz,xyz/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/*:.abc/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/*:xyz/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/*:noperm/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/*:noperm/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println(res.getBody());
        res = rh.executeGetRequest("/*:noexists/_search", IndexIntegrationTests.encodeBasicHeader("ccsresolv", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println(res.getBody());
    }

    @Test
    public void testIndexResolveIgnoreUnavailable() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_respect_indices_options.yml").setSgRoles("sg_roles_bs.yml"), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("test").type("type1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"field2\":\"init\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("lorem").type("type1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"field2\":\"init\"}", XContentType.JSON)).actionGet();
        }
        String msearchBody = "{\"index\": [\"tes*\",\"-.searchguard\",\"-missing\"], \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"match_all\":{}}}" + System.lineSeparator();
        RestHelper.HttpResponse resc = rh.executePostRequest("_msearch", msearchBody, IndexIntegrationTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("\"hits\":{\"total\":1"));
    }

    @Test
    public void testIndexResolveIndicesAlias() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("foo-index").type("_doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"field2\":\"init\"}", XContentType.JSON)).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"foo-index"}).alias("foo-alias"))).actionGet();
            tc.admin().indices().delete(new DeleteIndexRequest("foo-index")).actionGet();
        }
        RestHelper.HttpResponse resc = rh.executeGetRequest("/_cat/aliases", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertFalse((boolean)resc.getBody().contains("foo"));
        resc = rh.executeGetRequest("/foo-alias/_search", IndexIntegrationTests.encodeBasicHeader("foo_index", "nagilum"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("/foo-index/_search", IndexIntegrationTests.encodeBasicHeader("foo_index", "nagilum"));
        Assert.assertEquals((long)404L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("/foo-alias/_search", IndexIntegrationTests.encodeBasicHeader("foo_all", "nagilum"));
        Assert.assertEquals((long)404L, (long)resc.getStatusCode());
    }

    @Test
    public void testIndexResolveMinus() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("foo-abc").type("_doc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"field2\":\"init\"}", XContentType.JSON)).actionGet();
        }
        RestHelper.HttpResponse resc = rh.executeGetRequest("/**/_search", IndexIntegrationTests.encodeBasicHeader("foo_all", "nagilum"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("/*/_search", IndexIntegrationTests.encodeBasicHeader("foo_all", "nagilum"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("/_search", IndexIntegrationTests.encodeBasicHeader("foo_all", "nagilum"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("/**,-foo*/_search", IndexIntegrationTests.encodeBasicHeader("foo_all", "nagilum"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("/*,-foo*/_search", IndexIntegrationTests.encodeBasicHeader("foo_all", "nagilum"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("/**,-searchg*/_search", IndexIntegrationTests.encodeBasicHeader("foo_all", "nagilum"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("/*,-searchg*/_search", IndexIntegrationTests.encodeBasicHeader("foo_all", "nagilum"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("/*,-searchg*,-foo*/_search", IndexIntegrationTests.encodeBasicHeader("foo_all", "nagilum"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("/_all,-searchg*/_search", IndexIntegrationTests.encodeBasicHeader("foo_all", "nagilum"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("/_all,-searchg*/_search", IndexIntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)400L, (long)resc.getStatusCode());
    }
}

