/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.action.whoami.WhoAmIAction;
import com.floragunn.searchguard.action.whoami.WhoAmIRequest;
import com.floragunn.searchguard.action.whoami.WhoAmIResponse;
import com.floragunn.searchguard.test.DynamicSgConfig;
import com.floragunn.searchguard.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.file.FileHelper;
import com.floragunn.searchguard.test.helper.rest.RestHelper;
import java.io.File;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.junit.Assert;
import org.junit.Test;

public class InitializationIntegrationTests
extends SingleClusterTest {
    @Test
    public void testEnsureInitViaRestDoesWork() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("truststore.jks")).build();
        this.setup(Settings.EMPTY, null, settings, false);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        Assert.assertEquals((long)503L, (long)rh.executePutRequest("searchguard/config/0", "{}", InitializationIntegrationTests.encodeBasicHeader("___", "")).getStatusCode());
        Assert.assertEquals((long)503L, (long)rh.executePutRequest("searchguard/sg/config", "{}", InitializationIntegrationTests.encodeBasicHeader("___", "")).getStatusCode());
        rh.keystore = "kirk-keystore.jks";
        Assert.assertEquals((long)201L, (long)rh.executePutRequest("searchguard/sg/config", "{}", InitializationIntegrationTests.encodeBasicHeader("___", "")).getStatusCode());
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"tx_size_in_bytes\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"rx_count\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"rx_size_in_bytes\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"tx_count\" : 0"));
    }

    @Test
    public void testWhoAmI() throws Exception {
        WhoAmIResponse wres;
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgInternalUsers("sg_internal_empty.yml").setSgRoles("sg_roles_deny.yml"), Settings.EMPTY, true);
        try (TransportClient tc = this.getUserTransportClient(this.clusterInfo, "spock-keystore.jks", Settings.EMPTY);){
            wres = (WhoAmIResponse)tc.execute((Action)WhoAmIAction.INSTANCE, (ActionRequest)new WhoAmIRequest()).actionGet();
            System.out.println(wres);
            Assert.assertEquals((String)wres.toString(), (Object)"CN=spock,OU=client,O=client,L=Test,C=DE", (Object)wres.getDn());
            Assert.assertFalse((String)wres.toString(), (boolean)wres.isAdmin());
            Assert.assertFalse((String)wres.toString(), (boolean)wres.isAuthenticated());
            Assert.assertFalse((String)wres.toString(), (boolean)wres.isNodeCertificateRequest());
        }
        tc = this.getUserTransportClient(this.clusterInfo, "node-0-keystore.jks", Settings.EMPTY);
        var2_2 = null;
        try {
            wres = (WhoAmIResponse)tc.execute((Action)WhoAmIAction.INSTANCE, (ActionRequest)new WhoAmIRequest()).actionGet();
            System.out.println(wres);
            Assert.assertEquals((String)wres.toString(), (Object)"CN=node-0.example.com,OU=SSL,O=Test,L=Test,C=DE", (Object)wres.getDn());
            Assert.assertFalse((String)wres.toString(), (boolean)wres.isAdmin());
            Assert.assertFalse((String)wres.toString(), (boolean)wres.isAuthenticated());
            Assert.assertTrue((String)wres.toString(), (boolean)wres.isNodeCertificateRequest());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tc != null) {
                if (var2_2 != null) {
                    try {
                        tc.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tc.close();
                }
            }
        }
    }

    @Test
    public void testConfigHotReload() throws Exception {
        RestHelper.HttpResponse res;
        this.setup();
        RestHelper rh = this.nonSslRestHelper();
        Header spock = InitializationIntegrationTests.encodeBasicHeader("spock", "spock");
        for (TransportAddress transportAddress : this.clusterInfo.httpAdresses) {
            res = rh.executeRequest((HttpUriRequest)new HttpGet("http://" + transportAddress.getAddress() + ":" + transportAddress.getPort() + "/_searchguard/authinfo?pretty=true"), spock);
            Assert.assertTrue((boolean)res.getBody().contains("spock"));
            Assert.assertFalse((boolean)res.getBody().contains("additionalrole"));
            Assert.assertTrue((boolean)res.getBody().contains("vulcan"));
        }
        Throwable throwable = null;
        try (TransportClient tc = this.getInternalTransportClient();){
            Assert.assertEquals((long)this.clusterInfo.numNodes, (long)((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes().size());
            tc.index(((IndexRequest)new IndexRequest("searchguard").type("sg").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("internalusers").source(new Object[]{"internalusers", FileHelper.readYamlContent("sg_internal_users_spock_add_roles.yml")})).actionGet();
            ConfigUpdateResponse cur2 = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertFalse((boolean)cur2.hasFailures());
            Assert.assertEquals((long)this.clusterInfo.numNodes, (long)cur2.getNodes().size());
        }
        catch (Throwable cur2) {
            Throwable throwable2 = cur2;
            throw cur2;
        }
        for (TransportAddress transportAddress : this.clusterInfo.httpAdresses) {
            this.log.debug("http://" + transportAddress.getAddress() + ":" + transportAddress.getPort());
            res = rh.executeRequest((HttpUriRequest)new HttpGet("http://" + transportAddress.getAddress() + ":" + transportAddress.getPort() + "/_searchguard/authinfo?pretty=true"), spock);
            Assert.assertTrue((boolean)res.getBody().contains("spock"));
            Assert.assertTrue((boolean)res.getBody().contains("additionalrole1"));
            Assert.assertTrue((boolean)res.getBody().contains("additionalrole2"));
            Assert.assertFalse((boolean)res.getBody().contains("starfleet"));
        }
        tc = this.getInternalTransportClient();
        Throwable throwable3 = null;
        try {
            Assert.assertEquals((long)this.clusterInfo.numNodes, (long)((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes().size());
            tc.index(((IndexRequest)new IndexRequest("searchguard").type("sg").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("config").source(new Object[]{"config", FileHelper.readYamlContent("sg_config_anon.yml")})).actionGet();
            ConfigUpdateResponse cur3 = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config"})).actionGet();
            Assert.assertFalse((boolean)cur3.hasFailures());
            Assert.assertEquals((long)this.clusterInfo.numNodes, (long)cur3.getNodes().size());
        }
        catch (Throwable cur3) {
            Throwable throwable4 = cur3;
            throw cur3;
        }
        finally {
            if (tc != null) {
                if (throwable3 != null) {
                    try {
                        tc.close();
                    }
                    catch (Throwable cur3) {
                        throwable3.addSuppressed(cur3);
                    }
                } else {
                    tc.close();
                }
            }
        }
        for (TransportAddress transportAddress : this.clusterInfo.httpAdresses) {
            res = rh.executeRequest((HttpUriRequest)new HttpGet("http://" + transportAddress.getAddress() + ":" + transportAddress.getPort() + "/_searchguard/authinfo?pretty=true"), new Header[0]);
            this.log.debug(res.getBody());
            Assert.assertTrue((boolean)res.getBody().contains("sg_role_host1"));
            Assert.assertTrue((boolean)res.getBody().contains("sg_anonymous"));
            Assert.assertTrue((boolean)res.getBody().contains("name=sg_anonymous"));
            Assert.assertTrue((boolean)res.getBody().contains("roles=[sg_anonymous_backendrole]"));
            Assert.assertEquals((long)200L, (long)res.getStatusCode());
        }
    }

    @Test
    public void testDefaultConfig() throws Exception {
        System.setProperty("sg.default_init.dir", new File("./sgconfig").getAbsolutePath());
        Settings settings = Settings.builder().put("searchguard.allow_default_init_sgindex", true).build();
        this.setup(Settings.EMPTY, null, settings, false);
        RestHelper rh = this.nonSslRestHelper();
        Thread.sleep(10000L);
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", InitializationIntegrationTests.encodeBasicHeader("admin", "admin")).getStatusCode());
    }

    @Test
    public void testDisabled() throws Exception {
        Settings settings = Settings.builder().put("searchguard.disabled", true).build();
        this.setup(Settings.EMPTY, null, settings, false);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse resc = rh.executeGetRequest("_search", new Header[0]);
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("hits"));
    }

    @Test
    public void testDiscoveryWithoutInitialization() throws Exception {
        this.setup(Settings.EMPTY, null, Settings.EMPTY, false);
        Assert.assertEquals((long)this.clusterInfo.numNodes, (long)((ClusterHealthResponse)this.clusterHelper.nodeClient().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getNumberOfNodes());
        Assert.assertEquals((Object)ClusterHealthStatus.GREEN, (Object)((ClusterHealthResponse)this.clusterHelper.nodeClient().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getStatus());
    }

    @Test
    public void testDefaultInit() throws Exception {
        Settings b = Settings.builder().put("searchguard.allow_default_init_sgindex", true).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), b, false);
        RestHelper rh = this.nonSslRestHelper();
        Thread.sleep(5000L);
        RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/license?pretty", InitializationIntegrationTests.encodeBasicHeader("admin", "admin"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println(res.getBody());
        this.assertContains(res, "*TRIAL*");
        this.assertNotContains(res, "*FULL*");
    }
}

