/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.action.whoami.WhoAmIAction;
import com.floragunn.searchguard.action.whoami.WhoAmIRequest;
import com.floragunn.searchguard.action.whoami.WhoAmIResponse;
import com.floragunn.searchguard.http.HTTPClientCertAuthenticator;
import com.floragunn.searchguard.test.DynamicSgConfig;
import com.floragunn.searchguard.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.file.FileHelper;
import com.floragunn.searchguard.test.helper.rest.RestHelper;
import io.netty.handler.ssl.OpenSsl;
import java.util.TreeSet;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class IntegrationTests
extends SingleClusterTest {
    @Test
    public void testSearchScroll() throws Exception {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
            }
        });
        Settings settings = Settings.builder().putList("searchguard.authcz.rest_impersonation_user.worf", new String[]{"knuddel", "nonexists"}).build();
        this.setup(settings);
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            for (int i = 0; i < 3; ++i) {
                tc.index(((IndexRequest)new IndexRequest("vulcangov").type("kolinahr").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            }
        }
        System.out.println("########search");
        RestHelper.HttpResponse res = rh.executeGetRequest("vulcangov/_search?scroll=1m&pretty=true", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println(res.getBody());
        int start = res.getBody().indexOf("_scroll_id") + 15;
        String scrollid = res.getBody().substring(start, res.getBody().indexOf("\"", start + 1));
        System.out.println(scrollid);
        System.out.println("########search scroll");
        res = rh.executePostRequest("/_search/scroll?pretty=true", "{\"scroll_id\" : \"" + scrollid + "\"}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println("########search done");
    }

    @Test
    public void testNotInsecure() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgRoles("sg_roles_deny.yml"), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("test").type("type1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"field2\":\"init\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("lorem").type("type1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"field2\":\"init\"}", XContentType.JSON)).actionGet();
            WhoAmIResponse wres = (WhoAmIResponse)tc.execute((Action)WhoAmIAction.INSTANCE, (ActionRequest)new WhoAmIRequest()).actionGet();
            System.out.println(wres);
            Assert.assertEquals((Object)"CN=kirk,OU=client,O=client,L=Test,C=DE", (Object)wres.getDn());
            Assert.assertTrue((boolean)wres.isAdmin());
            Assert.assertTrue((String)wres.toString(), (boolean)wres.isAuthenticated());
            Assert.assertFalse((String)wres.toString(), (boolean)wres.isNodeCertificateRequest());
        }
        RestHelper.HttpResponse res = rh.executePutRequest("test/_mapping/type1?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("writer", "writer"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePostRequest("_cluster/reroute", "{}", IntegrationTests.encodeBasicHeader("writer", "writer"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        try (TransportClient tc = this.getUserTransportClient(this.clusterInfo, "spock-keystore.jks", Settings.EMPTY);){
            try {
                tc.admin().indices().putMapping(new PutMappingRequest(new String[]{"test"}).type("typex").source(new Object[]{"fieldx", "type=text"})).actionGet();
                Assert.fail();
            }
            catch (ElasticsearchSecurityException e) {
                Assert.assertTrue((String)e.toString(), (boolean)e.getMessage().contains("no permissions for"));
            }
            try {
                tc.admin().cluster().reroute(new ClusterRerouteRequest()).actionGet();
                Assert.fail();
            }
            catch (ElasticsearchSecurityException e) {
                Assert.assertTrue((String)e.toString(), (boolean)e.getMessage().contains("no permissions for [cluster:admin/reroute]"));
            }
            WhoAmIResponse wres = (WhoAmIResponse)tc.execute((Action)WhoAmIAction.INSTANCE, (ActionRequest)new WhoAmIRequest()).actionGet();
            Assert.assertEquals((Object)"CN=spock,OU=client,O=client,L=Test,C=DE", (Object)wres.getDn());
            Assert.assertFalse((boolean)wres.isAdmin());
            Assert.assertTrue((String)wres.toString(), (boolean)wres.isAuthenticated());
            Assert.assertFalse((String)wres.toString(), (boolean)wres.isNodeCertificateRequest());
        }
    }

    @Test
    public void testDnParsingCertAuth() throws Exception {
        Settings settings = Settings.builder().put("username_attribute", "cn").put("roles_attribute", "l").build();
        HTTPClientCertAuthenticator auth = new HTTPClientCertAuthenticator(settings, null);
        Assert.assertEquals((Object)"abc", (Object)auth.extractCredentials(null, this.newThreadContext("cn=abc,cn=xxx,l=ert,st=zui,c=qwe")).getUsername());
        Assert.assertEquals((Object)"abc", (Object)auth.extractCredentials(null, this.newThreadContext("cn=abc,l=ert,st=zui,c=qwe")).getUsername());
        Assert.assertEquals((Object)"abc", (Object)auth.extractCredentials(null, this.newThreadContext("CN=abc,L=ert,st=zui,c=qwe")).getUsername());
        Assert.assertEquals((Object)"abc", (Object)auth.extractCredentials(null, this.newThreadContext("l=ert,cn=abc,st=zui,c=qwe")).getUsername());
        Assert.assertNull((Object)auth.extractCredentials(null, this.newThreadContext("L=ert,CN=abc,c,st=zui,c=qwe")));
        Assert.assertEquals((Object)"abc", (Object)auth.extractCredentials(null, this.newThreadContext("l=ert,st=zui,c=qwe,cn=abc")).getUsername());
        Assert.assertEquals((Object)"abc", (Object)auth.extractCredentials(null, this.newThreadContext("L=ert,st=zui,c=qwe,CN=abc")).getUsername());
        Assert.assertEquals((Object)"L=ert,st=zui,c=qwe", (Object)auth.extractCredentials(null, this.newThreadContext("L=ert,st=zui,c=qwe")).getUsername());
        Assert.assertArrayEquals((Object[])new String[]{"ert"}, (Object[])auth.extractCredentials(null, this.newThreadContext("cn=abc,l=ert,st=zui,c=qwe")).getBackendRoles().toArray(new String[0]));
        Assert.assertArrayEquals((Object[])new String[]{"bleh", "ert"}, (Object[])new TreeSet(auth.extractCredentials(null, this.newThreadContext("cn=abc,l=ert,L=bleh,st=zui,c=qwe")).getBackendRoles()).toArray(new String[0]));
        settings = Settings.builder().build();
        auth = new HTTPClientCertAuthenticator(settings, null);
        Assert.assertEquals((Object)"cn=abc,l=ert,st=zui,c=qwe", (Object)auth.extractCredentials(null, this.newThreadContext("cn=abc,l=ert,st=zui,c=qwe")).getUsername());
    }

    private ThreadContext newThreadContext(String sslPrincipal) {
        ThreadContext threadContext = new ThreadContext(Settings.EMPTY);
        threadContext.putTransient("_sg_ssl_principal", (Object)sslPrincipal);
        return threadContext;
    }

    @Test
    public void testDNSpecials() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("node-untspec5-keystore.p12")).put("searchguard.ssl.transport.keystore_alias", "1").put("searchguard.ssl.transport.keystore_type", "PKCS12").putList("searchguard.nodes_dn", new String[]{"EMAILADDRESS=unt@tst.com,CN=node-untspec5.example.com,OU=SSL,O=Te\\, st,L=Test,C=DE"}).putList("searchguard.authcz.admin_dn", new String[]{"EMAILADDRESS=unt@xxx.com,CN=node-untspec6.example.com,OU=SSL,O=Te\\, st,L=Test,C=DE"}).put("searchguard.cert.oid", "1.2.3.4.5.6").build();
        Settings tcSettings = Settings.builder().put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("node-untspec6-keystore.p12")).put("searchguard.ssl.transport.keystore_type", "PKCS12").build();
        this.setup(tcSettings, new DynamicSgConfig(), settings, true);
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[0]).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", IntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
    }

    @Test
    public void testDNSpecials1() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("node-untspec5-keystore.p12")).put("searchguard.ssl.transport.keystore_alias", "1").put("searchguard.ssl.transport.keystore_type", "PKCS12").putList("searchguard.nodes_dn", new String[]{"EMAILADDRESS=unt@tst.com,CN=node-untspec5.example.com,OU=SSL,O=Te\\, st,L=Test,C=DE"}).putList("searchguard.authcz.admin_dn", new String[]{"EMAILADDREss=unt@xxx.com,  cn=node-untspec6.example.com, OU=SSL,O=Te\\, st,L=Test, c=DE"}).put("searchguard.cert.oid", "1.2.3.4.5.6").build();
        Settings tcSettings = Settings.builder().put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("node-untspec6-keystore.p12")).put("searchguard.ssl.transport.keystore_type", "PKCS12").build();
        this.setup(tcSettings, new DynamicSgConfig(), settings, true);
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[0]).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", IntegrationTests.encodeBasicHeader("worf", "worf")).getStatusCode());
    }

    @Test
    public void testEnsureOpenSSLAvailability() {
        Assume.assumeTrue((boolean)this.allowOpenSSL);
        Assert.assertTrue((String)String.valueOf(OpenSsl.unavailabilityCause()), (boolean)OpenSsl.isAvailable());
    }

    @Test
    public void testMultiget() throws Exception {
        this.setup();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("mindex1").type("type").id("1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("mindex2").type("type").id("2").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":2}", XContentType.JSON)).actionGet();
        }
        String mgetBody = "{\"docs\" : [{\"_index\" : \"mindex1\",\"_type\" : \"type\",\"_id\" : \"1\" }, {\"_index\" : \"mindex2\", \"_type\" : \"type\", \"_id\" : \"2\"}]}";
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse resc = rh.executePostRequest("_mget?refresh=true", mgetBody, IntegrationTests.encodeBasicHeader("picard", "picard"));
        System.out.println(resc.getBody());
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertFalse((boolean)resc.getBody().contains("type2"));
    }

    @Test
    public void testRestImpersonation() throws Exception {
        Settings settings = Settings.builder().putList("searchguard.authcz.rest_impersonation_user.spock", new String[]{"knuddel", "userwhonotexists"}).build();
        this.setup(settings);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse resp = rh.executeGetRequest("/_searchguard/authinfo", new Header[]{new BasicHeader("sg_impersonate_as", "knuddel"), IntegrationTests.encodeBasicHeader("worf", "worf")});
        Assert.assertEquals((long)403L, (long)resp.getStatusCode());
        resp = rh.executeGetRequest("/_searchguard/authinfo", new Header[]{new BasicHeader("sg_impersonate_as", "knuddel"), IntegrationTests.encodeBasicHeader("spock", "spock")});
        Assert.assertEquals((long)200L, (long)resp.getStatusCode());
        Assert.assertTrue((boolean)resp.getBody().contains("name=knuddel"));
        Assert.assertFalse((boolean)resp.getBody().contains("spock"));
        resp = rh.executeGetRequest("/_searchguard/authinfo", new Header[]{new BasicHeader("sg_impersonate_as", "userwhonotexists"), IntegrationTests.encodeBasicHeader("spock", "spock")});
        System.out.println(resp.getBody());
        Assert.assertEquals((long)403L, (long)resp.getStatusCode());
        resp = rh.executeGetRequest("/_searchguard/authinfo", new Header[]{new BasicHeader("sg_impersonate_as", "invalid"), IntegrationTests.encodeBasicHeader("spock", "spock")});
        Assert.assertEquals((long)403L, (long)resp.getStatusCode());
    }

    @Test
    public void testSingle() throws Exception {
        this.setup();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("shakespeare").type("type").id("1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertFalse((boolean)cur.hasFailures());
            Assert.assertEquals((long)this.clusterInfo.numNodes, (long)cur.getNodes().size());
        }
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse resc = rh.executeGetRequest("shakespeare/_search", IntegrationTests.encodeBasicHeader("picard", "picard"));
        System.out.println(resc.getBody());
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("\"content\":1"));
        resc = rh.executeHeadRequest("shakespeare", IntegrationTests.encodeBasicHeader("picard", "picard"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
    }

    @Test
    public void testSpecialUsernames() throws Exception {
        this.setup();
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", IntegrationTests.encodeBasicHeader("bug.99", "nagilum")).getStatusCode());
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", IntegrationTests.encodeBasicHeader("a", "b")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", IntegrationTests.encodeBasicHeader("\"'+-,;_?*@<>!$%&/()=#", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", IntegrationTests.encodeBasicHeader("\u00a7\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df", "nagilum")).getStatusCode());
    }

    @Test
    public void testXff() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_xff.yml"), Settings.EMPTY, true);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse resc = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("x-forwarded-for", "10.0.0.7"), IntegrationTests.encodeBasicHeader("worf", "worf")});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("10.0.0.7"));
    }

    @Test
    public void testRegexExcludes() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), Settings.EMPTY);
        try (TransportClient tc = this.getInternalTransportClient(this.clusterInfo, Settings.EMPTY);){
            tc.index(((IndexRequest)new IndexRequest("indexa").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"indexa\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("indexb").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"indexb\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("isallowed").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"isallowed\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("special").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"special\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("alsonotallowed").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"alsonotallowed\":1}", XContentType.JSON)).actionGet();
        }
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("index*/_search", IntegrationTests.encodeBasicHeader("rexclude", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("indexa/_search", IntegrationTests.encodeBasicHeader("rexclude", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("isallowed/_search", IntegrationTests.encodeBasicHeader("rexclude", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("special/_search", IntegrationTests.encodeBasicHeader("rexclude", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executeGetRequest("alsonotallowed/_search", IntegrationTests.encodeBasicHeader("rexclude", "nagilum")).getStatusCode());
    }

    @Test
    public void testMultiRoleSpan() throws Exception {
        this.setup();
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("mindex_1").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("mindex_2").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":2}", XContentType.JSON)).actionGet();
        }
        RestHelper.HttpResponse res = rh.executeGetRequest("/mindex_1,mindex_2/_search", IntegrationTests.encodeBasicHeader("mindex12", "nagilum"));
        System.out.println(res.getBody());
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        Assert.assertFalse((boolean)res.getBody().contains("\"content\":1"));
        Assert.assertFalse((boolean)res.getBody().contains("\"content\":2"));
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("searchguard").type("sg").id("config").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{"config", FileHelper.readYamlContent("sg_config_multirolespan.yml")})).actionGet();
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config"})).actionGet();
            Assert.assertFalse((boolean)cur.hasFailures());
            Assert.assertEquals((long)this.clusterInfo.numNodes, (long)cur.getNodes().size());
        }
        res = rh.executeGetRequest("/mindex_1,mindex_2/_search", IntegrationTests.encodeBasicHeader("mindex12", "nagilum"));
        System.out.println(res.getBody());
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("\"content\":1"));
        Assert.assertTrue((boolean)res.getBody().contains("\"content\":2"));
    }

    @Test
    public void testMultiRoleSpan2() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_multirolespan.yml"), Settings.EMPTY);
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("mindex_1").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("mindex_2").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":2}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("mindex_3").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":2}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("mindex_4").type("logs").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":2}", XContentType.JSON)).actionGet();
        }
        RestHelper.HttpResponse res = rh.executeGetRequest("/mindex_1,mindex_2/_search", IntegrationTests.encodeBasicHeader("mindex12", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/mindex_1,mindex_3/_search", IntegrationTests.encodeBasicHeader("mindex12", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeGetRequest("/mindex_1,mindex_4/_search", IntegrationTests.encodeBasicHeader("mindex12", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
    }

    @Test
    public void testSGUnderscore() throws Exception {
        this.setup();
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executePostRequest("abc_xyz_2018_05_24/logs/1", "{\"content\":1}", IntegrationTests.encodeBasicHeader("underscore", "nagilum"));
        res = rh.executeGetRequest("abc_xyz_2018_05_24/logs/1", IntegrationTests.encodeBasicHeader("underscore", "nagilum"));
        Assert.assertTrue((String)res.getBody(), (boolean)res.getBody().contains("\"content\":1"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("abc_xyz_2018_05_24/_refresh", IntegrationTests.encodeBasicHeader("underscore", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executeGetRequest("aaa_bbb_2018_05_24/_refresh", IntegrationTests.encodeBasicHeader("underscore", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
    }

    @Test
    public void testDeleteByQueryDnfof() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_dnfof.yml"), Settings.EMPTY);
        try (TransportClient tc = this.getInternalTransportClient();){
            for (int i = 0; i < 3; ++i) {
                tc.index(((IndexRequest)new IndexRequest("vulcangov").type("kolinahr").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            }
        }
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executePostRequest("/vulcango*/_delete_by_query?refresh=true&wait_for_completion=true&pretty=true", "{\"query\" : {\"match_all\" : {}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("\"deleted\" : 3"));
    }

    @Test
    public void testUpdate() throws Exception {
        Settings settings = Settings.builder().put("searchguard.roles_mapping_resolution", "BOTH").build();
        this.setup(settings);
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("indexc").type("typec").id("0").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        }
        RestHelper.HttpResponse res = rh.executePostRequest("indexc/typec/0/_update?pretty=true&refresh=true", "{\"doc\" : {\"content\":2}}", IntegrationTests.encodeBasicHeader("user_c", "user_c"));
        System.out.println(res.getBody());
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
    }

    @Test
    public void testDnfof() throws Exception {
        Settings settings = Settings.builder().put("searchguard.roles_mapping_resolution", "BOTH").build();
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_dnfof.yml"), settings);
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.admin().indices().create(new CreateIndexRequest("copysf")).actionGet();
            tc.index(((IndexRequest)new IndexRequest("indexa").type("doc").id("0").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":\"indexa\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("indexb").type("doc").id("0").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":\"indexb\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("vulcangov").type("kolinahr").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("starfleet").type("ships").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("starfleet_academy").type("students").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("starfleet_library").type("public").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("klingonempire").type("ships").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("public").type("legends").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("spock").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("kirk").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("role01_role02").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"starfleet", "starfleet_academy", "starfleet_library"}).alias("sf"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"klingonempire", "vulcangov"}).alias("nonsf"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"public"}).alias("unrestricted"))).actionGet();
        }
        RestHelper.HttpResponse resc = rh.executeGetRequest("indexa,indexb/_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("indexa"));
        Assert.assertFalse((String)resc.getBody(), (boolean)resc.getBody().contains("indexb"));
        Assert.assertFalse((String)resc.getBody(), (boolean)resc.getBody().contains("exception"));
        Assert.assertFalse((String)resc.getBody(), (boolean)resc.getBody().contains("permission"));
        resc = rh.executeGetRequest("indexa,indexb/_search?pretty", IntegrationTests.encodeBasicHeader("user_b", "user_b"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        Assert.assertFalse((String)resc.getBody(), (boolean)resc.getBody().contains("indexa"));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("indexb"));
        Assert.assertFalse((String)resc.getBody(), (boolean)resc.getBody().contains("exception"));
        Assert.assertFalse((String)resc.getBody(), (boolean)resc.getBody().contains("permission"));
        String msearchBody = "{\"index\":\"indexa\", \"type\":\"doc\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator() + "{\"index\":\"indexb\", \"type\":\"doc\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator() + "{\"index\":\"index*\", \"type\":\"doc\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator();
        System.out.println("#### msearch");
        resc = rh.executePostRequest("_msearch?pretty", msearchBody, IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("indexa"));
        Assert.assertFalse((String)resc.getBody(), (boolean)resc.getBody().contains("indexb"));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("exception"));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("permission"));
        Assert.assertEquals((long)3L, (long)resc.getBody().split("\"status\" : 200").length);
        Assert.assertEquals((long)2L, (long)resc.getBody().split("\"status\" : 403").length);
        resc = rh.executePostRequest("_msearch?pretty", msearchBody, IntegrationTests.encodeBasicHeader("user_b", "user_b"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        Assert.assertFalse((String)resc.getBody(), (boolean)resc.getBody().contains("indexa"));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("indexb"));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("exception"));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("permission"));
        Assert.assertEquals((long)3L, (long)resc.getBody().split("\"status\" : 200").length);
        Assert.assertEquals((long)2L, (long)resc.getBody().split("\"status\" : 403").length);
        msearchBody = "{\"index\":\"indexc\", \"type\":\"doc\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator() + "{\"index\":\"indexd\", \"type\":\"doc\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator();
        resc = rh.executePostRequest("_msearch?pretty", msearchBody, IntegrationTests.encodeBasicHeader("user_b", "user_b"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        String mgetBody = "{\"docs\" : [{\"_index\" : \"indexa\",\"_type\" : \"doc\",\"_id\" : \"0\" }, {\"_index\" : \"indexb\", \"_type\" : \"doc\", \"_id\" : \"0\"}]}";
        System.out.println("#### mget");
        resc = rh.executePostRequest("_mget?pretty", mgetBody, IntegrationTests.encodeBasicHeader("user_b", "user_b"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertFalse((String)resc.getBody(), (boolean)resc.getBody().contains("\"content\" : \"indexa\""));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("\"content\" : \"indexb\""));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("exception"));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("permission"));
        mgetBody = "{\"docs\" : [{\"_index\" : \"indexx\",\"_type\" : \"doc\",\"_id\" : \"0\" }, {\"_index\" : \"indexy\", \"_type\" : \"doc\", \"_id\" : \"0\"}]}";
        resc = rh.executePostRequest("_mget?pretty", mgetBody, IntegrationTests.encodeBasicHeader("user_b", "user_b"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("indexa"));
        Assert.assertFalse((String)resc.getBody(), (boolean)resc.getBody().contains("indexb"));
        resc = rh.executeGetRequest("index*/_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("indexa"));
        Assert.assertFalse((String)resc.getBody(), (boolean)resc.getBody().contains("indexb"));
        Assert.assertFalse((String)resc.getBody(), (boolean)resc.getBody().contains("exception"));
        Assert.assertFalse((String)resc.getBody(), (boolean)resc.getBody().contains("permission"));
        resc = rh.executeGetRequest("indexa/_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        resc = rh.executeGetRequest("indexb/_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        resc = rh.executeGetRequest("*/_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        resc = rh.executeGetRequest("_all/_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        resc = rh.executeGetRequest("notexists/_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        resc = rh.executeGetRequest("permitnotexistentindex/_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)404L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        resc = rh.executeGetRequest("permitnotexistentindex*/_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        resc = rh.executeGetRequest("indexanbh,indexabb*/_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)404L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        resc = rh.executeGetRequest("starfleet/_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        resc = rh.executeGetRequest("starfleet/_search?pretty", IntegrationTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        System.out.println("#### _all/_mapping/field/*");
        resc = rh.executeGetRequest("_all/_mapping/field/*", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
    }

    @Test
    public void testNoDnfof() throws Exception {
        Settings settings = Settings.builder().put("searchguard.roles_mapping_resolution", "BOTH").build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings);
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.admin().indices().create(new CreateIndexRequest("copysf")).actionGet();
            tc.index(((IndexRequest)new IndexRequest("indexa").type("doc").id("0").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":\"indexa\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("indexb").type("doc").id("0").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":\"indexb\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("vulcangov").type("kolinahr").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("starfleet").type("ships").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("starfleet_academy").type("students").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("starfleet_library").type("public").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("klingonempire").type("ships").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("public").type("legends").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("spock").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("kirk").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("role01_role02").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"starfleet", "starfleet_academy", "starfleet_library"}).alias("sf"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"klingonempire", "vulcangov"}).alias("nonsf"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"public"}).alias("unrestricted"))).actionGet();
        }
        RestHelper.HttpResponse resc = rh.executeGetRequest("indexa,indexb/_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        resc = rh.executeGetRequest("indexa,indexb/_search?pretty", IntegrationTests.encodeBasicHeader("user_b", "user_b"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        String msearchBody = "{\"index\":\"indexa\", \"type\":\"doc\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator() + "{\"index\":\"indexb\", \"type\":\"doc\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator();
        System.out.println("#### msearch a");
        resc = rh.executePostRequest("_msearch?pretty", msearchBody, IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("indexa"));
        Assert.assertFalse((String)resc.getBody(), (boolean)resc.getBody().contains("indexb"));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("exception"));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("permission"));
        System.out.println("#### msearch b");
        resc = rh.executePostRequest("_msearch?pretty", msearchBody, IntegrationTests.encodeBasicHeader("user_b", "user_b"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        Assert.assertFalse((String)resc.getBody(), (boolean)resc.getBody().contains("indexa"));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("indexb"));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("exception"));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("permission"));
        msearchBody = "{\"index\":\"indexc\", \"type\":\"doc\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator() + "{\"index\":\"indexd\", \"type\":\"doc\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator();
        System.out.println("#### msearch b2");
        resc = rh.executePostRequest("_msearch?pretty", msearchBody, IntegrationTests.encodeBasicHeader("user_b", "user_b"));
        System.out.println(resc.getBody());
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertFalse((String)resc.getBody(), (boolean)resc.getBody().contains("indexc"));
        Assert.assertFalse((String)resc.getBody(), (boolean)resc.getBody().contains("indexd"));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("exception"));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("permission"));
        int count = resc.getBody().split("\"status\" : 403").length;
        Assert.assertEquals((long)3L, (long)count);
        String mgetBody = "{\"docs\" : [{\"_index\" : \"indexa\",\"_type\" : \"doc\",\"_id\" : \"0\" }, {\"_index\" : \"indexb\", \"_type\" : \"doc\", \"_id\" : \"0\"}]}";
        resc = rh.executePostRequest("_mget?pretty", mgetBody, IntegrationTests.encodeBasicHeader("user_b", "user_b"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertFalse((String)resc.getBody(), (boolean)resc.getBody().contains("\"content\" : \"indexa\""));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("indexb"));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("exception"));
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("permission"));
        mgetBody = "{\"docs\" : [{\"_index\" : \"indexx\",\"_type\" : \"doc\",\"_id\" : \"0\" }, {\"_index\" : \"indexy\", \"_type\" : \"doc\", \"_id\" : \"0\"}]}";
        resc = rh.executePostRequest("_mget?pretty", mgetBody, IntegrationTests.encodeBasicHeader("user_b", "user_b"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((String)resc.getBody(), (boolean)resc.getBody().contains("exception"));
        count = resc.getBody().split("root_cause").length;
        Assert.assertEquals((long)3L, (long)count);
        resc = rh.executeGetRequest("_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("index*/_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("indexa/_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        resc = rh.executeGetRequest("indexb/_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        resc = rh.executeGetRequest("*/_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        resc = rh.executeGetRequest("_all/_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        resc = rh.executeGetRequest("notexists/_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        resc = rh.executeGetRequest("indexanbh,indexabb*/_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)404L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        resc = rh.executeGetRequest("starfleet/_search?pretty", IntegrationTests.encodeBasicHeader("user_a", "user_a"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        resc = rh.executeGetRequest("starfleet/_search?pretty", IntegrationTests.encodeBasicHeader("worf", "worf"));
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        resc = rh.executeGetRequest("_all,-indexb/_search?pretty", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)400L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        System.out.println("#### _all/_mapping/field/*");
        resc = rh.executeGetRequest("_all/_mapping/field/*", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        System.out.println("#### _mapping/field/*");
        resc = rh.executeGetRequest("_mapping/field/*", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
        System.out.println("#### */_mapping/field/*");
        resc = rh.executeGetRequest("*/_mapping/field/*", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        System.out.println(resc.getBody());
    }

    @Test
    public void testSgIndexSecurity() throws Exception {
        this.setup();
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("indexa").type("doc").id("0").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":\"indexa\"}", XContentType.JSON)).actionGet();
        }
        RestHelper.HttpResponse res = rh.executePutRequest("searchguard,inde*/_mapping/doc?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("searchguard/_mapping/sg?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("*earc*gua*/_mapping/sg?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("_mapping/sg?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("*/_mapping/sg?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("_all/_mapping/sg?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePostRequest("searchguard/_close", "", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeDeleteRequest("searchguard", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeDeleteRequest("_all", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("*/_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("_all/_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("searchguard/_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("searchgu*/_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("*,-searchguard/_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("*,-searchguard,-index*/_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)404L, (long)res.getStatusCode());
    }

    @Test
    public void testSgIndexSecurityWithSgIndexExcluded() throws Exception {
        Settings settings = Settings.builder().put("searchguard.filter_sgindex_from_all_requests", true).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings);
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("indexa").type("doc").id("0").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":\"indexa\"}", XContentType.JSON)).actionGet();
        }
        RestHelper.HttpResponse res = rh.executePutRequest("searchguard,inde*/_mapping/doc?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("searchguard/_mapping/doc?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("*earc*gua*/_mapping/doc?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("_mapping/doc?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("*/_mapping/doc?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("_all/_mapping/doc?pretty", "{\"properties\": {\"name\":{\"type\":\"text\"}}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePostRequest("searchguard/_close", "", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executeDeleteRequest("searchguard", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("*/_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("_all/_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("searchguard/_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("searchgu*/_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)403L, (long)res.getStatusCode());
        res = rh.executePutRequest("*,-searchguard/_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        res = rh.executePutRequest("*,-searchguard,-index*/_settings", "{\"index\" : {\"number_of_replicas\" : 2}}", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)404L, (long)res.getStatusCode());
        res = rh.executeDeleteRequest("_all", IntegrationTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
    }
}

