/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.searchguard.test.DynamicSgConfig;
import com.floragunn.searchguard.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.file.FileHelper;
import com.floragunn.searchguard.test.helper.rest.RestHelper;
import com.floragunn.searchguard.tools.SearchGuardAdmin;
import java.io.File;
import java.util.ArrayList;
import org.apache.http.Header;
import org.elasticsearch.common.settings.Settings;
import org.junit.Assert;
import org.junit.Test;

public class SgAdminTests
extends SingleClusterTest {
    @Test
    public void testSgAdmin() throws Exception {
        this.setup(Settings.EMPTY, null, Settings.EMPTY, false);
        String prefix = this.getResourceFolder() == null ? "" : this.getResourceFolder() + "/";
        ArrayList<String> argsAsList = new ArrayList<String>();
        argsAsList.add("-ts");
        argsAsList.add(FileHelper.getAbsoluteFilePathFromClassPath(prefix + "truststore.jks").toFile().getAbsolutePath());
        argsAsList.add("-ks");
        argsAsList.add(FileHelper.getAbsoluteFilePathFromClassPath(prefix + "kirk-keystore.jks").toFile().getAbsolutePath());
        argsAsList.add("-p");
        argsAsList.add(String.valueOf(this.clusterInfo.nodePort));
        argsAsList.add("-cn");
        argsAsList.add(this.clusterInfo.clustername);
        argsAsList.add("-cd");
        argsAsList.add(new File("./sgconfig").getAbsolutePath());
        argsAsList.add("-nhnv");
        int returnCode = SearchGuardAdmin.execute((String[])argsAsList.toArray(new String[0]));
        Assert.assertEquals((long)0L, (long)returnCode);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/health?pretty", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println(res.getBody());
        this.assertContains(res, "*UP*");
        this.assertContains(res, "*strict*");
        this.assertNotContains(res, "*DOWN*");
    }

    @Test
    public void testSgAdminInvalidYml() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), Settings.EMPTY, true);
        String prefix = this.getResourceFolder() == null ? "" : this.getResourceFolder() + "/";
        ArrayList<String> argsAsList = new ArrayList<String>();
        argsAsList.add("-ts");
        argsAsList.add(FileHelper.getAbsoluteFilePathFromClassPath(prefix + "truststore.jks").toFile().getAbsolutePath());
        argsAsList.add("-ks");
        argsAsList.add(FileHelper.getAbsoluteFilePathFromClassPath(prefix + "kirk-keystore.jks").toFile().getAbsolutePath());
        argsAsList.add("-p");
        argsAsList.add(String.valueOf(this.clusterInfo.nodePort));
        argsAsList.add("-cn");
        argsAsList.add(this.clusterInfo.clustername);
        argsAsList.add("-f");
        argsAsList.add(FileHelper.getAbsoluteFilePathFromClassPath(prefix + "sg_roles_invalidxcontent.yml").toFile().getAbsolutePath());
        argsAsList.add("-t");
        argsAsList.add("roles");
        argsAsList.add("-nhnv");
        int returnCode = SearchGuardAdmin.execute((String[])argsAsList.toArray(new String[0]));
        Assert.assertNotEquals((long)0L, (long)returnCode);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/health?pretty", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println(res.getBody());
        this.assertContains(res, "*UP*");
        this.assertContains(res, "*strict*");
        this.assertNotContains(res, "*DOWN*");
    }

    @Test
    public void testSgAdminReloadInvalidConfig() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("truststore.jks")).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig(), settings, true);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        rh.keystore = "kirk-keystore.jks";
        System.out.println(rh.executePutRequest("searchguard/sg/roles", FileHelper.loadFile("sg_roles_invalidxcontent.yml"), new Header[0]).getBody());
        Assert.assertEquals((long)200L, (long)rh.executePutRequest("searchguard/sg/roles", "{\"roles\":\"dummy\"}", new Header[0]).getStatusCode());
        String prefix = this.getResourceFolder() == null ? "" : this.getResourceFolder() + "/";
        ArrayList<String> argsAsList = new ArrayList<String>();
        argsAsList.add("-ts");
        argsAsList.add(FileHelper.getAbsoluteFilePathFromClassPath(prefix + "truststore.jks").toFile().getAbsolutePath());
        argsAsList.add("-ks");
        argsAsList.add(FileHelper.getAbsoluteFilePathFromClassPath(prefix + "kirk-keystore.jks").toFile().getAbsolutePath());
        argsAsList.add("-p");
        argsAsList.add(String.valueOf(this.clusterInfo.nodePort));
        argsAsList.add("-cn");
        argsAsList.add(this.clusterInfo.clustername);
        argsAsList.add("-rl");
        argsAsList.add("-nhnv");
        int returnCode = SearchGuardAdmin.execute((String[])argsAsList.toArray(new String[0]));
        Assert.assertNotEquals((long)0L, (long)returnCode);
        RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/health?pretty", new Header[0]);
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        this.assertContains(res, "*UP*");
        this.assertContains(res, "*strict*");
        this.assertNotContains(res, "*DOWN*");
    }
}

