/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.searchguard.SearchGuardPlugin;
import com.floragunn.searchguard.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.file.FileHelper;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.PluginAwareNode;
import org.elasticsearch.transport.Netty4Plugin;
import org.junit.Assert;
import org.junit.Test;

public class SlowIntegrationTests
extends SingleClusterTest {
    @Test
    public void testCustomInterclusterRequestEvaluator() throws Exception {
        Settings settings = Settings.builder().put("searchguard.cert.intercluster_request_evaluator_class", "com.floragunn.searchguard.AlwaysFalseInterClusterRequestEvaluator").put("discovery.initial_state_timeout", "8s").build();
        this.setup(Settings.EMPTY, null, settings, false, ClusterConfiguration.DEFAULT, 5, 1);
        Assert.assertEquals((long)1L, (long)((ClusterHealthResponse)this.clusterHelper.nodeClient().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getNumberOfNodes());
        Assert.assertEquals((Object)ClusterHealthStatus.GREEN, (Object)((ClusterHealthResponse)this.clusterHelper.nodeClient().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getStatus());
    }

    @Test
    public void testNodeClientAllowedWithServerCertificate() throws Exception {
        this.setup();
        Assert.assertEquals((long)this.clusterInfo.numNodes, (long)((ClusterHealthResponse)this.clusterHelper.nodeClient().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getNumberOfNodes());
        Assert.assertEquals((Object)ClusterHealthStatus.GREEN, (Object)((ClusterHealthResponse)this.clusterHelper.nodeClient().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getStatus());
        Settings tcSettings = Settings.builder().put(this.minimumSearchGuardSettings(Settings.EMPTY).get(0)).put("cluster.name", this.clusterInfo.clustername).put("node.data", false).put("node.master", false).put("node.ingest", false).put("path.home", "/tmp").put("discovery.initial_state_timeout", "8s").putList("discovery.zen.ping.unicast.hosts", new String[]{this.clusterInfo.nodeHost + ":" + this.clusterInfo.nodePort}).build();
        this.log.debug("Start node client");
        try (Node node = new PluginAwareNode(false, tcSettings, Netty4Plugin.class, SearchGuardPlugin.class).start();){
            Thread.sleep(50L);
            Assert.assertEquals((long)(this.clusterInfo.numNodes + 1), (long)((NodesInfoResponse)node.client().admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes().size());
        }
    }

    @Test
    public void testNodeClientDisallowedWithNonServerCertificate() throws Exception {
        this.setup();
        Assert.assertEquals((long)this.clusterInfo.numNodes, (long)((ClusterHealthResponse)this.clusterHelper.nodeClient().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getNumberOfNodes());
        Assert.assertEquals((Object)ClusterHealthStatus.GREEN, (Object)((ClusterHealthResponse)this.clusterHelper.nodeClient().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getStatus());
        Settings tcSettings = Settings.builder().put(this.minimumSearchGuardSettings(Settings.EMPTY).get(0)).put("cluster.name", this.clusterInfo.clustername).put("node.data", false).put("node.master", false).put("node.ingest", false).put("path.home", "/tmp").put("discovery.initial_state_timeout", "8s").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("kirk-keystore.jks")).put("searchguard.ssl.transport.keystore_alias", "kirk").build();
        this.log.debug("Start node client");
        try (Node node = new PluginAwareNode(false, tcSettings, Netty4Plugin.class, SearchGuardPlugin.class).start();){
            Thread.sleep(50L);
            Assert.assertEquals((long)1L, (long)((NodesInfoResponse)node.client().admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes().size());
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testNodeClientDisallowedWithNonServerCertificate2() throws Exception {
        this.setup();
        Assert.assertEquals((long)this.clusterInfo.numNodes, (long)((ClusterHealthResponse)this.clusterHelper.nodeClient().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getNumberOfNodes());
        Assert.assertEquals((Object)ClusterHealthStatus.GREEN, (Object)((ClusterHealthResponse)this.clusterHelper.nodeClient().admin().cluster().health(new ClusterHealthRequest().waitForGreenStatus()).actionGet()).getStatus());
        Settings tcSettings = Settings.builder().put(this.minimumSearchGuardSettings(Settings.EMPTY).get(0)).put("cluster.name", this.clusterInfo.clustername).put("node.data", false).put("node.master", false).put("node.ingest", false).put("path.home", "/tmp").put("discovery.initial_state_timeout", "8s").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("spock-keystore.jks")).put("searchguard.ssl.transport.keystore_alias", "spock").build();
        this.log.debug("Start node client");
        try (Node node = new PluginAwareNode(false, tcSettings, Netty4Plugin.class, SearchGuardPlugin.class).start();){
            Thread.sleep(50L);
            Assert.assertEquals((long)1L, (long)((NodesInfoResponse)node.client().admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes().size());
        }
    }
}

