/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.test.DynamicSgConfig;
import com.floragunn.searchguard.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.rest.RestHelper;
import java.util.Arrays;
import java.util.Collection;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SnapshotRestoreTests
extends SingleClusterTest {
    @Parameterized.Parameter
    public ClusterConfiguration currentClusterConfig;

    @Parameterized.Parameters
    public static Collection<ClusterConfiguration> data() {
        return Arrays.asList(ClusterConfiguration.DEFAULT);
    }

    @Test
    public void testSnapshotEnableSgIndexRestore() throws Exception {
        Settings settings = Settings.builder().putList("path.repo", new String[]{this.repositoryPath.getRoot().getAbsolutePath()}).put("searchguard.enable_snapshot_restore_privilege", true).put("searchguard.check_snapshot_restore_write_privileges", false).put("searchguard.unsupported.restore.sgindex.enabled", true).build();
        this.setup(settings, this.currentClusterConfig);
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("vulcangov").type("kolinahr").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.admin().cluster().putRepository(new PutRepositoryRequest("vulcangov").type("fs").settings(Settings.builder().put("location", this.repositoryPath.getRoot().getAbsolutePath() + "/vulcangov"))).actionGet();
            tc.admin().cluster().createSnapshot(new CreateSnapshotRequest("vulcangov", "vulcangov_1").indices(new String[]{"vulcangov"}).includeGlobalState(true).waitForCompletion(true)).actionGet();
            tc.admin().cluster().putRepository(new PutRepositoryRequest("searchguard").type("fs").settings(Settings.builder().put("location", this.repositoryPath.getRoot().getAbsolutePath() + "/searchguard"))).actionGet();
            tc.admin().cluster().createSnapshot(new CreateSnapshotRequest("searchguard", "searchguard_1").indices(new String[]{"searchguard"}).includeGlobalState(false).waitForCompletion(true)).actionGet();
            tc.admin().cluster().putRepository(new PutRepositoryRequest("all").type("fs").settings(Settings.builder().put("location", this.repositoryPath.getRoot().getAbsolutePath() + "/all"))).actionGet();
            tc.admin().cluster().createSnapshot(new CreateSnapshotRequest("all", "all_1").indices(new String[]{"*"}).includeGlobalState(false).waitForCompletion(true)).actionGet();
        }
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/vulcangov", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/vulcangov/vulcangov_1", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"restored_index_$1\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"include_global_state\": true, \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"restored_index_with_global_state_$1\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)500L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"indices\": \"vulcangov\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/searchguard", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/searchguard/searchguard_1", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)500L, (long)rh.executePostRequest("_snapshot/searchguard/searchguard_1/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/searchguard/searchguard_1/_restore?wait_for_completion=true", "{ \"indices\": \"searchguard\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard_copy\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/all", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/all/all_1", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)500L, (long)rh.executePostRequest("_snapshot/all/all_1/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)500L, (long)rh.executePostRequest("_snapshot/all/all_1/_restore?wait_for_completion=true", "{ \"indices\": \"vulcangov\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeDeleteRequest("searchguard_copy", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/all/all_1/_restore?wait_for_completion=true", "{ \"indices\": \"searchguard\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard_copy\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)500L, (long)rh.executePostRequest("_snapshot/all/unknown-snapshot/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("searchguard/_close", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/searchguard/searchguard_1/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("searchguard/_open", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
    }

    @Test
    public void testSnapshot() throws Exception {
        Settings settings = Settings.builder().putList("path.repo", new String[]{this.repositoryPath.getRoot().getAbsolutePath()}).put("searchguard.enable_snapshot_restore_privilege", true).put("searchguard.check_snapshot_restore_write_privileges", false).build();
        this.setup(settings, this.currentClusterConfig);
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("vulcangov").type("kolinahr").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.admin().cluster().putRepository(new PutRepositoryRequest("vulcangov").type("fs").settings(Settings.builder().put("location", this.repositoryPath.getRoot().getAbsolutePath() + "/vulcangov"))).actionGet();
            tc.admin().cluster().createSnapshot(new CreateSnapshotRequest("vulcangov", "vulcangov_1").indices(new String[]{"vulcangov"}).includeGlobalState(true).waitForCompletion(true)).actionGet();
            tc.admin().cluster().putRepository(new PutRepositoryRequest("searchguard").type("fs").settings(Settings.builder().put("location", this.repositoryPath.getRoot().getAbsolutePath() + "/searchguard"))).actionGet();
            tc.admin().cluster().createSnapshot(new CreateSnapshotRequest("searchguard", "searchguard_1").indices(new String[]{"searchguard"}).includeGlobalState(false).waitForCompletion(true)).actionGet();
            tc.admin().cluster().putRepository(new PutRepositoryRequest("all").type("fs").settings(Settings.builder().put("location", this.repositoryPath.getRoot().getAbsolutePath() + "/all"))).actionGet();
            tc.admin().cluster().createSnapshot(new CreateSnapshotRequest("all", "all_1").indices(new String[]{"*"}).includeGlobalState(false).waitForCompletion(true)).actionGet();
        }
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/vulcangov", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/vulcangov/vulcangov_1", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"restored_index_$1\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"include_global_state\": true, \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"restored_index_with_global_state_$1\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"indices\": \"vulcangov\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/searchguard", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/searchguard/searchguard_1", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/searchguard/searchguard_1/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/searchguard/searchguard_1/_restore?wait_for_completion=true", "{ \"indices\": \"searchguard\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard_copy\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/all", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/all/all_1", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/all/all_1/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/all/all_1/_restore?wait_for_completion=true", "{ \"indices\": \"vulcangov\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/all/all_1/_restore?wait_for_completion=true", "{ \"indices\": \"searchguard\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard_copy\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/all/unknown-snapshot/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
    }

    @Test
    public void testSnapshotCheckWritePrivileges() throws Exception {
        Settings settings = Settings.builder().putList("path.repo", new String[]{this.repositoryPath.getRoot().getAbsolutePath()}).put("searchguard.enable_snapshot_restore_privilege", true).put("searchguard.check_snapshot_restore_write_privileges", true).build();
        this.setup(settings, this.currentClusterConfig);
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("vulcangov").type("kolinahr").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.admin().cluster().putRepository(new PutRepositoryRequest("vulcangov").type("fs").settings(Settings.builder().put("location", this.repositoryPath.getRoot().getAbsolutePath() + "/vulcangov"))).actionGet();
            tc.admin().cluster().createSnapshot(new CreateSnapshotRequest("vulcangov", "vulcangov_1").indices(new String[]{"vulcangov"}).includeGlobalState(true).waitForCompletion(true)).actionGet();
            tc.admin().cluster().putRepository(new PutRepositoryRequest("searchguard").type("fs").settings(Settings.builder().put("location", this.repositoryPath.getRoot().getAbsolutePath() + "/searchguard"))).actionGet();
            tc.admin().cluster().createSnapshot(new CreateSnapshotRequest("searchguard", "searchguard_1").indices(new String[]{"searchguard"}).includeGlobalState(false).waitForCompletion(true)).actionGet();
            tc.admin().cluster().putRepository(new PutRepositoryRequest("all").type("fs").settings(Settings.builder().put("location", this.repositoryPath.getRoot().getAbsolutePath() + "/all"))).actionGet();
            tc.admin().cluster().createSnapshot(new CreateSnapshotRequest("all", "all_1").indices(new String[]{"*"}).includeGlobalState(false).waitForCompletion(true)).actionGet();
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertFalse((boolean)cur.hasFailures());
            Assert.assertEquals((long)this.currentClusterConfig.getNodes(), (long)cur.getNodes().size());
            System.out.println(cur.getNodesMap());
        }
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/vulcangov", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/vulcangov/vulcangov_1", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"restored_index_$1\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"include_global_state\": true, \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"restored_index_with_global_state_$1\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("worf", "worf")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"indices\": \"vulcangov\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/searchguard", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/searchguard/searchguard_1", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/searchguard/searchguard_1/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/searchguard/searchguard_1/_restore?wait_for_completion=true", "{ \"indices\": \"searchguard\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard_copy\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/all", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_snapshot/all/all_1", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/all/all_1/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/all/all_1/_restore?wait_for_completion=true", "{ \"indices\": \"vulcangov\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/all/all_1/_restore?wait_for_completion=true", "{ \"indices\": \"searchguard\", \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"searchguard_copy\" }", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/all/unknown-snapshot/_restore?wait_for_completion=true", "", SnapshotRestoreTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"$1_restore_1\" }", SnapshotRestoreTests.encodeBasicHeader("restoreuser", "restoreuser")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"$1_restore_2a\" }", SnapshotRestoreTests.encodeBasicHeader("restoreuser", "restoreuser")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"$1_no_restore_1\" }", SnapshotRestoreTests.encodeBasicHeader("restoreuser", "restoreuser")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"$1_no_restore_2\" }", SnapshotRestoreTests.encodeBasicHeader("restoreuser", "restoreuser")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"$1_no_restore_3\" }", SnapshotRestoreTests.encodeBasicHeader("restoreuser", "restoreuser")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/vulcangov/vulcangov_1/_restore?wait_for_completion=true", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"$1_no_restore_4\" }", SnapshotRestoreTests.encodeBasicHeader("restoreuser", "restoreuser")).getStatusCode());
    }

    @Test
    public void testSnapshotRestore() throws Exception {
        Settings settings = Settings.builder().putList("path.repo", new String[]{this.repositoryPath.getRoot().getAbsolutePath()}).put("searchguard.enable_snapshot_restore_privilege", true).put("searchguard.check_snapshot_restore_write_privileges", true).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgActionGroups("sg_action_groups_packaged.yml"), settings, true, this.currentClusterConfig);
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("testsnap1").type("kolinahr").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("testsnap2").type("kolinahr").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("testsnap3").type("kolinahr").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("testsnap4").type("kolinahr").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("testsnap5").type("kolinahr").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("testsnap6").type("kolinahr").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.admin().cluster().putRepository(new PutRepositoryRequest("bckrepo").type("fs").settings(Settings.builder().put("location", this.repositoryPath.getRoot().getAbsolutePath() + "/bckrepo"))).actionGet();
        }
        RestHelper rh = this.nonSslRestHelper();
        String putSnapshot = "{\"indices\": \"testsnap1\",\"ignore_unavailable\": false,\"include_global_state\": false}";
        Assert.assertEquals((long)200L, (long)rh.executePutRequest("_snapshot/bckrepo/" + putSnapshot.hashCode() + "?wait_for_completion=true&pretty", putSnapshot, SnapshotRestoreTests.encodeBasicHeader("snapresuser", "nagilum")).getStatusCode());
        Assert.assertEquals((long)200L, (long)rh.executePostRequest("_snapshot/bckrepo/" + putSnapshot.hashCode() + "/_restore?wait_for_completion=true&pretty", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"restored_index_$1\" }", SnapshotRestoreTests.encodeBasicHeader("snapresuser", "nagilum")).getStatusCode());
        putSnapshot = "{\"indices\": \"searchguard\",\"ignore_unavailable\": false,\"include_global_state\": false}";
        Assert.assertEquals((long)200L, (long)rh.executePutRequest("_snapshot/bckrepo/" + putSnapshot.hashCode() + "?wait_for_completion=true&pretty", putSnapshot, SnapshotRestoreTests.encodeBasicHeader("snapresuser", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/bckrepo/" + putSnapshot.hashCode() + "/_restore?wait_for_completion=true&pretty", "{ \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"restored_index_$1\" }", SnapshotRestoreTests.encodeBasicHeader("snapresuser", "nagilum")).getStatusCode());
        putSnapshot = "{\"indices\": \"testsnap2\",\"ignore_unavailable\": false,\"include_global_state\": true}";
        Assert.assertEquals((long)200L, (long)rh.executePutRequest("_snapshot/bckrepo/" + putSnapshot.hashCode() + "?wait_for_completion=true&pretty", putSnapshot, SnapshotRestoreTests.encodeBasicHeader("snapresuser", "nagilum")).getStatusCode());
        Assert.assertEquals((long)403L, (long)rh.executePostRequest("_snapshot/bckrepo/" + putSnapshot.hashCode() + "/_restore?wait_for_completion=true&pretty", "{ \"include_global_state\": true, \"rename_pattern\": \"(.+)\", \"rename_replacement\": \"restored_index_$1\" }", SnapshotRestoreTests.encodeBasicHeader("snapresuser", "nagilum")).getStatusCode());
    }
}

