/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.ssl.util.ExceptionUtils;
import com.floragunn.searchguard.test.DynamicSgConfig;
import com.floragunn.searchguard.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.file.FileHelper;
import org.apache.http.Header;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Test;

public class TransportClientIntegrationTests
extends SingleClusterTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransportClient() throws Exception {
        Settings settings = Settings.builder().putList("searchguard.authcz.impersonation_dn.CN=spock,OU=client,O=client,L=Test,C=DE", new String[]{"worf", "nagilum"}).put("discovery.initial_state_timeout", "8s").build();
        this.setup(settings);
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("starfleet").type("ships").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        }
        Settings tcSettings = Settings.builder().put(settings).put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("spock-keystore.jks")).put("searchguard.ssl.transport.keystore_alias", "spock").build();
        System.out.println("------- 0 ---------");
        try (TransportClient tc = this.getInternalTransportClient(this.clusterInfo, tcSettings);){
            Header header;
            Header header2;
            ThreadContext.StoredContext ctx;
            Assert.assertEquals((long)this.clusterInfo.numNodes, (long)((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes().size());
            System.out.println("------- 1 ---------");
            CreateIndexResponse cir = (CreateIndexResponse)tc.admin().indices().create(new CreateIndexRequest("vulcan")).actionGet();
            Assert.assertTrue((boolean)cir.isAcknowledged());
            System.out.println("------- 2 ---------");
            IndexResponse ir = (IndexResponse)tc.index(((IndexRequest)new IndexRequest("vulcan").type("secrets").id("s1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"secret\":true}", XContentType.JSON)).actionGet();
            Assert.assertTrue((ir.getResult() == DocWriteResponse.Result.CREATED ? 1 : 0) != 0);
            System.out.println("------- 3 ---------");
            GetResponse gr = (GetResponse)tc.prepareGet("vulcan", "secrets", "s1").setRealtime(true).get();
            Assert.assertTrue((boolean)gr.isExists());
            System.out.println("------- 4 ---------");
            gr = (GetResponse)tc.prepareGet("vulcan", "secrets", "s1").setRealtime(false).get();
            Assert.assertTrue((boolean)gr.isExists());
            System.out.println("------- 5 ---------");
            SearchResponse actionGet = (SearchResponse)tc.search(new SearchRequest(new String[]{"vulcan"}).types(new String[]{"secrets"})).actionGet();
            Assert.assertEquals((long)1L, (long)actionGet.getHits().getHits().length);
            System.out.println("------- 6 ---------");
            gr = (GetResponse)tc.prepareGet("searchguard", "sg", "config").setRealtime(false).get();
            Assert.assertFalse((boolean)gr.isExists());
            System.out.println("------- 7 ---------");
            gr = (GetResponse)tc.prepareGet("searchguard", "sg", "config").setRealtime(true).get();
            Assert.assertFalse((boolean)gr.isExists());
            System.out.println("------- 8 ---------");
            actionGet = (SearchResponse)tc.search(new SearchRequest(new String[]{"searchguard"})).actionGet();
            Assert.assertEquals((long)0L, (long)actionGet.getHits().getHits().length);
            System.out.println("------- 9 ---------");
            try {
                tc.index(new IndexRequest("searchguard").type("sg").id("config").source(new Object[]{"config", FileHelper.readYamlContent("sg_config.yml")})).actionGet();
                Assert.fail();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            System.out.println("------- 10 ---------");
            try {
                ctx = tc.threadPool().getThreadContext().stashContext();
                try {
                    tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "worf");
                    gr = (GetResponse)tc.prepareGet("vulcan", "secrets", "s1").get();
                }
                finally {
                    ctx.close();
                }
                Assert.fail();
            }
            catch (ElasticsearchSecurityException e) {
                Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().startsWith("no permissions for [indices:data/read/get]"));
            }
            System.out.println("------- 11 ---------");
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                header2 = TransportClientIntegrationTests.encodeBasicHeader("worf", "worf");
                tc.threadPool().getThreadContext().putHeader(header2.getName(), header2.getValue());
                gr = (GetResponse)tc.prepareGet("vulcan", "secrets", "s1").get();
                Assert.fail();
            }
            catch (ElasticsearchSecurityException e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("no permissions for [indices:data/read/get]"));
            }
            finally {
                ctx.close();
            }
            System.out.println("------- 12 ---------");
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                header2 = TransportClientIntegrationTests.encodeBasicHeader("worf", "worf111");
                tc.threadPool().getThreadContext().putHeader(header2.getName(), header2.getValue());
                gr = (GetResponse)tc.prepareGet("vulcan", "secrets", "s1").get();
                Assert.fail();
            }
            catch (ElasticsearchSecurityException e) {
                e.printStackTrace();
            }
            finally {
                ctx.close();
            }
            System.out.println("------- 13 ---------");
            try {
                ctx = tc.threadPool().getThreadContext().stashContext();
                try {
                    tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "gkar");
                    gr = (GetResponse)tc.prepareGet("vulcan", "secrets", "s1").get();
                    Assert.fail();
                }
                finally {
                    ctx.close();
                }
            }
            catch (ElasticsearchSecurityException e) {
                Assert.assertEquals((Object)"'CN=spock,OU=client,O=client,L=Test,C=DE' is not allowed to impersonate as transport user 'gkar'", (Object)e.getMessage());
            }
            System.out.println("------- 12 ---------");
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "nagilum");
                gr = (GetResponse)tc.prepareGet("searchguard", "sg", "config").setRealtime(Boolean.TRUE.booleanValue()).get();
                Assert.assertFalse((boolean)gr.isExists());
                Assert.assertTrue((boolean)gr.isSourceEmpty());
            }
            finally {
                ctx.close();
            }
            System.out.println("------- 13 ---------");
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "nagilum");
                gr = (GetResponse)tc.prepareGet("searchguard", "config", "0").setRealtime(Boolean.FALSE.booleanValue()).get();
                Assert.assertFalse((boolean)gr.isExists());
                Assert.assertTrue((boolean)gr.isSourceEmpty());
            }
            finally {
                ctx.close();
            }
            System.out.println("------- 13.1 ---------");
            String scrollId = null;
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "nagilum");
                SearchResponse searchRes = (SearchResponse)tc.prepareSearch(new String[]{"starfleet"}).setTypes(new String[]{"ships"}).setScroll(TimeValue.timeValueMinutes((long)5L)).get();
                scrollId = searchRes.getScrollId();
            }
            finally {
                ctx.close();
            }
            System.out.println("------- 13.2 ---------");
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "nagilum");
                tc.prepareSearchScroll(scrollId).get();
            }
            finally {
                ctx.close();
            }
            System.out.println("------- 14 ---------");
            boolean ok = false;
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "nagilum");
                gr = (GetResponse)tc.prepareGet("vulcan", "secrets", "s1").get();
                ok = true;
                ctx.close();
                ctx = tc.threadPool().getThreadContext().stashContext();
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "nagilum");
                header = TransportClientIntegrationTests.encodeBasicHeader("worf", "worf");
                tc.threadPool().getThreadContext().putHeader(header.getName(), header.getValue());
                gr = (GetResponse)tc.prepareGet("vulcan", "secrets", "s1").get();
                Assert.fail();
            }
            catch (ElasticsearchSecurityException e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("no permissions for [indices:data/read/get]"));
                Assert.assertTrue((boolean)ok);
            }
            finally {
                ctx.close();
            }
            System.out.println("------- 15 ---------");
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "nagilum");
                gr = (GetResponse)tc.prepareGet("searchguard", "sg", "config").setRealtime(Boolean.TRUE.booleanValue()).get();
                Assert.assertFalse((boolean)gr.isExists());
                Assert.assertTrue((boolean)gr.isSourceEmpty());
            }
            finally {
                ctx.close();
            }
            System.out.println("------- 15 0---------");
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                header = TransportClientIntegrationTests.encodeBasicHeader("worf", "worf");
                tc.threadPool().getThreadContext().putHeader(header.getName(), header.getValue());
                gr = (GetResponse)tc.prepareGet("searchguard", "sg", "config").setRealtime(Boolean.TRUE.booleanValue()).get();
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("no permissions for [indices:data/read/get] and User [name=worf"));
            }
            finally {
                ctx.close();
            }
            System.out.println("------- 15 1---------");
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                header = TransportClientIntegrationTests.encodeBasicHeader("nagilum", "nagilum");
                tc.threadPool().getThreadContext().putHeader(header.getName(), header.getValue());
                gr = (GetResponse)tc.prepareGet("searchguard", "sg", "config").setRealtime(Boolean.TRUE.booleanValue()).get();
                Assert.assertFalse((boolean)gr.isExists());
                Assert.assertTrue((boolean)gr.isSourceEmpty());
            }
            finally {
                ctx.close();
            }
            System.out.println("------- 16---------");
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "nagilum");
                gr = (GetResponse)tc.prepareGet("searchguard", "sg", "config").setRealtime(Boolean.FALSE.booleanValue()).get();
                Assert.assertFalse((boolean)gr.isExists());
                Assert.assertTrue((boolean)gr.isSourceEmpty());
            }
            finally {
                ctx.close();
            }
            ctx = tc.threadPool().getThreadContext().stashContext();
            SearchResponse searchRes = null;
            try {
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "nagilum");
                searchRes = (SearchResponse)tc.prepareSearch(new String[]{"starfleet"}).setTypes(new String[]{"ships"}).setScroll(TimeValue.timeValueMinutes((long)5L)).get();
            }
            finally {
                ctx.close();
            }
            Assert.assertNotNull((Object)searchRes.getScrollId());
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "worf");
                tc.prepareSearchScroll(searchRes.getScrollId()).get();
                Assert.fail();
            }
            catch (Exception e) {
                Throwable root = ExceptionUtils.getRootCause((Throwable)e);
                e.printStackTrace();
                Assert.assertTrue((boolean)root.getMessage().contains("Wrong user in scroll context"));
            }
            finally {
                ctx.close();
            }
            ctx = tc.threadPool().getThreadContext().stashContext();
            searchRes = null;
            try {
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "nagilum");
                searchRes = (SearchResponse)tc.prepareSearch(new String[]{"starfleet"}).setTypes(new String[]{"ships"}).setScroll(TimeValue.timeValueMinutes((long)5L)).get();
                SearchResponse scrollRes = (SearchResponse)tc.prepareSearchScroll(searchRes.getScrollId()).get();
                Assert.assertEquals((long)0L, (long)scrollRes.getFailedShards());
            }
            finally {
                ctx.close();
            }
            System.out.println("------- TRC end ---------");
        }
        System.out.println("------- CTC end ---------");
    }

    @Test
    public void testTransportClientImpersonation() throws Exception {
        Settings settings = Settings.builder().putList("searchguard.authcz.impersonation_dn.CN=spock,OU=client,O=client,L=Test,C=DE", new String[]{"worf", "nagilum"}).build();
        this.setup(settings);
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("starfleet").type("ships").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertFalse((boolean)cur.hasFailures());
            Assert.assertEquals((long)this.clusterInfo.numNodes, (long)cur.getNodes().size());
        }
        Settings tcSettings = Settings.builder().put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("spock-keystore.jks")).put("searchguard.ssl.transport.keystore_alias", "spock").put("path.home", ".").put("request.headers.sg_impersonate_as", "worf").build();
        try (TransportClient tc = this.getInternalTransportClient(this.clusterInfo, tcSettings);){
            NodesInfoRequest nir = new NodesInfoRequest();
            Assert.assertEquals((long)this.clusterInfo.numNodes, (long)((NodesInfoResponse)tc.admin().cluster().nodesInfo(nir).actionGet()).getNodes().size());
        }
    }

    @Test
    public void testTransportClientImpersonationWildcard() throws Exception {
        Settings settings = Settings.builder().putList("searchguard.authcz.impersonation_dn.CN=spock,OU=client,O=client,L=Test,C=DE", new String[]{"*"}).build();
        this.setup(settings);
        Settings tcSettings = Settings.builder().put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("spock-keystore.jks")).put("searchguard.ssl.transport.keystore_alias", "spock").put("path.home", ".").put("request.headers.sg_impersonate_as", "worf").build();
        try (TransportClient tc = this.getInternalTransportClient(this.clusterInfo, tcSettings);){
            NodesInfoRequest nir = new NodesInfoRequest();
            Assert.assertEquals((long)this.clusterInfo.numNodes, (long)((NodesInfoResponse)tc.admin().cluster().nodesInfo(nir).actionGet()).getNodes().size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransportClientUsernameAttribute() throws Exception {
        Settings settings = Settings.builder().putList("searchguard.authcz.impersonation_dn.CN=spock,OU=client,O=client,L=Test,C=DE", new String[]{"worf", "nagilum", "nonexist"}).put("discovery.initial_state_timeout", "8s").build();
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_transport_username.yml").setSgRolesMapping("sg_roles_mapping_transport_username.yml").setSgInternalUsers("sg_internal_users_transport_username.yml"), settings);
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("starfleet").type("ships").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
        }
        Settings tcSettings = Settings.builder().put(settings).put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("spock-keystore.jks")).put("searchguard.ssl.transport.keystore_alias", "spock").build();
        System.out.println("------- 0 ---------");
        try (TransportClient tc = this.getInternalTransportClient(this.clusterInfo, tcSettings);){
            SearchResponse scrollRes;
            Throwable root;
            Header header;
            Header header2;
            ThreadContext.StoredContext ctx;
            Assert.assertEquals((long)this.clusterInfo.numNodes, (long)((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes().size());
            System.out.println("------- 1 ---------");
            CreateIndexResponse cir = (CreateIndexResponse)tc.admin().indices().create(new CreateIndexRequest("vulcan")).actionGet();
            Assert.assertTrue((boolean)cir.isAcknowledged());
            System.out.println("------- 2 ---------");
            IndexResponse ir = (IndexResponse)tc.index(((IndexRequest)new IndexRequest("vulcan").type("secrets").id("s1").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"secret\":true}", XContentType.JSON)).actionGet();
            Assert.assertTrue((ir.getResult() == DocWriteResponse.Result.CREATED ? 1 : 0) != 0);
            System.out.println("------- 3 ---------");
            GetResponse gr = (GetResponse)tc.prepareGet("vulcan", "secrets", "s1").setRealtime(true).get();
            Assert.assertTrue((boolean)gr.isExists());
            System.out.println("------- 4 ---------");
            gr = (GetResponse)tc.prepareGet("vulcan", "secrets", "s1").setRealtime(false).get();
            Assert.assertTrue((boolean)gr.isExists());
            System.out.println("------- 5 ---------");
            SearchResponse actionGet = (SearchResponse)tc.search(new SearchRequest(new String[]{"vulcan"}).types(new String[]{"secrets"})).actionGet();
            Assert.assertEquals((long)1L, (long)actionGet.getHits().getHits().length);
            System.out.println("------- 6 ---------");
            gr = (GetResponse)tc.prepareGet("searchguard", "sg", "config").setRealtime(false).get();
            Assert.assertFalse((boolean)gr.isExists());
            System.out.println("------- 7 ---------");
            gr = (GetResponse)tc.prepareGet("searchguard", "sg", "config").setRealtime(true).get();
            Assert.assertFalse((boolean)gr.isExists());
            System.out.println("------- 8 ---------");
            actionGet = (SearchResponse)tc.search(new SearchRequest(new String[]{"searchguard"})).actionGet();
            Assert.assertEquals((long)0L, (long)actionGet.getHits().getHits().length);
            System.out.println("------- 9 ---------");
            try {
                tc.index(new IndexRequest("searchguard").type("sg").id("config").source(new Object[]{"config", FileHelper.readYamlContent("sg_config.yml")})).actionGet();
                Assert.fail();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            System.out.println("------- 10 ---------");
            try {
                ctx = tc.threadPool().getThreadContext().stashContext();
                try {
                    tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "worf");
                    gr = (GetResponse)tc.prepareGet("vulcan", "secrets", "s1").get();
                }
                finally {
                    ctx.close();
                }
                Assert.fail();
            }
            catch (ElasticsearchSecurityException e) {
                Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().startsWith("no permissions for [indices:data/read/get]"));
            }
            System.out.println("------- 11 ---------");
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                header2 = TransportClientIntegrationTests.encodeBasicHeader("worf", "worf");
                tc.threadPool().getThreadContext().putHeader(header2.getName(), header2.getValue());
                gr = (GetResponse)tc.prepareGet("vulcan", "secrets", "s1").get();
                Assert.fail();
            }
            catch (ElasticsearchSecurityException e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("no permissions for [indices:data/read/get]"));
            }
            finally {
                ctx.close();
            }
            System.out.println("------- 12 ---------");
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                header2 = TransportClientIntegrationTests.encodeBasicHeader("worf", "worf111");
                tc.threadPool().getThreadContext().putHeader(header2.getName(), header2.getValue());
                gr = (GetResponse)tc.prepareGet("vulcan", "secrets", "s1").get();
                Assert.fail();
            }
            catch (ElasticsearchSecurityException e) {
                e.printStackTrace();
            }
            finally {
                ctx.close();
            }
            System.out.println("------- 13 ---------");
            try {
                ctx = tc.threadPool().getThreadContext().stashContext();
                try {
                    tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "gkar");
                    gr = (GetResponse)tc.prepareGet("vulcan", "secrets", "s1").get();
                    Assert.fail();
                }
                finally {
                    ctx.close();
                }
            }
            catch (ElasticsearchSecurityException e) {
                Assert.assertEquals((Object)"'CN=spock,OU=client,O=client,L=Test,C=DE' is not allowed to impersonate as transport user 'gkar'", (Object)e.getMessage());
            }
            System.out.println("------- 12 ---------");
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "nagilum");
                gr = (GetResponse)tc.prepareGet("searchguard", "sg", "config").setRealtime(Boolean.TRUE.booleanValue()).get();
                Assert.assertFalse((boolean)gr.isExists());
                Assert.assertTrue((boolean)gr.isSourceEmpty());
            }
            finally {
                ctx.close();
            }
            System.out.println("------- 13 ---------");
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "nagilum");
                gr = (GetResponse)tc.prepareGet("searchguard", "config", "0").setRealtime(Boolean.FALSE.booleanValue()).get();
                Assert.assertFalse((boolean)gr.isExists());
                Assert.assertTrue((boolean)gr.isSourceEmpty());
            }
            finally {
                ctx.close();
            }
            System.out.println("------- 13.1 ---------");
            String scrollId = null;
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "nagilum");
                SearchResponse searchRes = (SearchResponse)tc.prepareSearch(new String[]{"starfleet"}).setTypes(new String[]{"ships"}).setScroll(TimeValue.timeValueMinutes((long)5L)).get();
                scrollId = searchRes.getScrollId();
            }
            finally {
                ctx.close();
            }
            System.out.println("------- 13.2 ---------");
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "nagilum");
                tc.prepareSearchScroll(scrollId).get();
            }
            finally {
                ctx.close();
            }
            System.out.println("------- 14 ---------");
            boolean ok = false;
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "nagilum");
                gr = (GetResponse)tc.prepareGet("vulcan", "secrets", "s1").get();
                ok = true;
                ctx.close();
                ctx = tc.threadPool().getThreadContext().stashContext();
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "nagilum");
                header = TransportClientIntegrationTests.encodeBasicHeader("worf", "worf");
                tc.threadPool().getThreadContext().putHeader(header.getName(), header.getValue());
                gr = (GetResponse)tc.prepareGet("vulcan", "secrets", "s1").get();
                Assert.fail();
            }
            catch (ElasticsearchSecurityException e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("no permissions for [indices:data/read/get]"));
                Assert.assertTrue((boolean)ok);
            }
            finally {
                ctx.close();
            }
            System.out.println("------- 15 ---------");
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "nagilum");
                gr = (GetResponse)tc.prepareGet("searchguard", "sg", "config").setRealtime(Boolean.TRUE.booleanValue()).get();
                Assert.assertFalse((boolean)gr.isExists());
                Assert.assertTrue((boolean)gr.isSourceEmpty());
            }
            finally {
                ctx.close();
            }
            System.out.println("------- 15 0---------");
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                header = TransportClientIntegrationTests.encodeBasicHeader("worf", "worf");
                tc.threadPool().getThreadContext().putHeader(header.getName(), header.getValue());
                gr = (GetResponse)tc.prepareGet("searchguard", "sg", "config").setRealtime(Boolean.TRUE.booleanValue()).get();
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("no permissions for [indices:data/read/get] and User [name=worf"));
            }
            finally {
                ctx.close();
            }
            System.out.println("------- 15 1---------");
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                header = TransportClientIntegrationTests.encodeBasicHeader("nagilum", "nagilum");
                tc.threadPool().getThreadContext().putHeader(header.getName(), header.getValue());
                gr = (GetResponse)tc.prepareGet("searchguard", "sg", "config").setRealtime(Boolean.TRUE.booleanValue()).get();
                Assert.assertFalse((boolean)gr.isExists());
                Assert.assertTrue((boolean)gr.isSourceEmpty());
            }
            finally {
                ctx.close();
            }
            System.out.println("------- 16---------");
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "nagilum");
                gr = (GetResponse)tc.prepareGet("searchguard", "sg", "config").setRealtime(Boolean.FALSE.booleanValue()).get();
                Assert.assertFalse((boolean)gr.isExists());
                Assert.assertTrue((boolean)gr.isSourceEmpty());
            }
            finally {
                ctx.close();
            }
            ctx = tc.threadPool().getThreadContext().stashContext();
            SearchResponse searchRes = null;
            try {
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "nagilum");
                searchRes = (SearchResponse)tc.prepareSearch(new String[]{"starfleet"}).setTypes(new String[]{"ships"}).setScroll(TimeValue.timeValueMinutes((long)5L)).get();
            }
            finally {
                ctx.close();
            }
            Assert.assertNotNull((Object)searchRes.getScrollId());
            ctx = tc.threadPool().getThreadContext().stashContext();
            try {
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "worf");
                tc.prepareSearchScroll(searchRes.getScrollId()).get();
                Assert.fail();
            }
            catch (Exception e) {
                root = ExceptionUtils.getRootCause((Throwable)e);
                e.printStackTrace();
                Assert.assertTrue((boolean)root.getMessage().contains("Wrong user in scroll context"));
            }
            finally {
                ctx.close();
            }
            ctx = tc.threadPool().getThreadContext().stashContext();
            searchRes = null;
            try {
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "nagilum");
                searchRes = (SearchResponse)tc.prepareSearch(new String[]{"starfleet"}).setTypes(new String[]{"ships"}).setScroll(TimeValue.timeValueMinutes((long)5L)).get();
                scrollRes = (SearchResponse)tc.prepareSearchScroll(searchRes.getScrollId()).get();
                Assert.assertEquals((long)0L, (long)scrollRes.getFailedShards());
            }
            finally {
                ctx.close();
            }
            ctx = tc.threadPool().getThreadContext().stashContext();
            searchRes = null;
            try {
                tc.threadPool().getThreadContext().putHeader("sg_impersonate_as", "nonexist");
                searchRes = (SearchResponse)tc.prepareSearch(new String[]{"starfleet"}).setTypes(new String[]{"ships"}).setScroll(TimeValue.timeValueMinutes((long)5L)).get();
                scrollRes = (SearchResponse)tc.prepareSearchScroll(searchRes.getScrollId()).get();
                Assert.assertEquals((long)0L, (long)scrollRes.getFailedShards());
            }
            catch (Exception e) {
                root = ExceptionUtils.getRootCause((Throwable)e);
                Assert.assertTrue((String)root.getMessage(), (boolean)root.getMessage().contains("No such transport user: nonexist"));
            }
            finally {
                ctx.close();
            }
            System.out.println("------- TRC end ---------");
        }
        System.out.println("------- CTC end ---------");
    }

    @Test
    public void testTransportClientImpersonationUsernameAttribute() throws Exception {
        Settings settings = Settings.builder().putList("searchguard.authcz.impersonation_dn.CN=spock,OU=client,O=client,L=Test,C=DE", new String[]{"worf", "nagilum"}).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_transport_username.yml").setSgRolesMapping("sg_roles_mapping_transport_username.yml").setSgInternalUsers("sg_internal_users_transport_username.yml"), settings);
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.index(((IndexRequest)new IndexRequest("starfleet").type("ships").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
            Assert.assertFalse((boolean)cur.hasFailures());
            Assert.assertEquals((long)this.clusterInfo.numNodes, (long)cur.getNodes().size());
        }
        Settings tcSettings = Settings.builder().put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("spock-keystore.jks")).put("searchguard.ssl.transport.keystore_alias", "spock").put("path.home", ".").put("request.headers.sg_impersonate_as", "worf").build();
        try (TransportClient tc = this.getInternalTransportClient(this.clusterInfo, tcSettings);){
            NodesInfoRequest nir = new NodesInfoRequest();
            Assert.assertEquals((long)this.clusterInfo.numNodes, (long)((NodesInfoResponse)tc.admin().cluster().nodesInfo(nir).actionGet()).getNodes().size());
        }
    }

    @Test
    public void testTransportClientImpersonationWildcardUsernameAttribute() throws Exception {
        Settings settings = Settings.builder().putList("searchguard.authcz.impersonation_dn.CN=spock,OU=client,O=client,L=Test,C=DE", new String[]{"*"}).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfig("sg_config_transport_username.yml").setSgRolesMapping("sg_roles_mapping_transport_username.yml").setSgInternalUsers("sg_internal_users_transport_username.yml"), settings);
        Settings tcSettings = Settings.builder().put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("spock-keystore.jks")).put("searchguard.ssl.transport.keystore_alias", "spock").put("path.home", ".").put("request.headers.sg_impersonate_as", "worf").build();
        try (TransportClient tc = this.getInternalTransportClient(this.clusterInfo, tcSettings);){
            NodesInfoRequest nir = new NodesInfoRequest();
            Assert.assertEquals((long)this.clusterInfo.numNodes, (long)((NodesInfoResponse)tc.admin().cluster().nodesInfo(nir).actionGet()).getNodes().size());
        }
    }
}

