/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.searchguard.support.SgUtils;
import com.floragunn.searchguard.support.WildcardMatcher;
import java.util.Map;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;
import org.elasticsearch.common.settings.Settings;
import org.junit.Assert;
import org.junit.Test;

public class UtilTests {
    @Test
    public void testWildcards() {
        Assert.assertTrue((!WildcardMatcher.match((String)"a*?", (String)"a") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"a*?", (String)"aa"));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"a*?", (String)"ab"));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"*my*index", (String)"myindex"));
        Assert.assertTrue((!WildcardMatcher.match((String)"*my*index", (String)"myindex1") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"*my*index?", (String)"myindex1"));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"*my*index", (String)"this_is_my_great_index"));
        Assert.assertTrue((!WildcardMatcher.match((String)"*my*index", (String)"MYindex") ? 1 : 0) != 0);
        Assert.assertTrue((!WildcardMatcher.match((String)"?kibana", (String)"kibana") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"?kibana", (String)".kibana"));
        Assert.assertTrue((!WildcardMatcher.match((String)"?kibana", (String)"kibana.") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"?kibana?", (String)"?kibana."));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"/(\\d{3}-?\\d{2}-?\\d{4})/", (String)"123-45-6789"));
        Assert.assertTrue((!WildcardMatcher.match((String)"(\\d{3}-?\\d{2}-?\\d{4})", (String)"123-45-6789") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"/\\S*/", (String)"abc"));
        Assert.assertTrue((boolean)WildcardMatcher.match((String)"abc", (String)"abc"));
        Assert.assertTrue((!WildcardMatcher.match((String)"ABC", (String)"abc") ? 1 : 0) != 0);
        Assert.assertTrue((!WildcardMatcher.containsWildcard((String)"abc") ? 1 : 0) != 0);
        Assert.assertTrue((!WildcardMatcher.containsWildcard((String)"abc$") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)WildcardMatcher.containsWildcard((String)"abc*"));
        Assert.assertTrue((boolean)WildcardMatcher.containsWildcard((String)"a?bc"));
        Assert.assertTrue((boolean)WildcardMatcher.containsWildcard((String)"/(\\d{3}-\\d{2}-?\\d{4})/"));
    }

    @Test
    public void testMapFromArray() {
        Map map = SgUtils.mapFromArray((Object[])new Object[]{null});
        Assert.assertTrue((map == null ? 1 : 0) != 0);
        map = SgUtils.mapFromArray((Object[])new Object[]{"key"});
        Assert.assertTrue((map == null ? 1 : 0) != 0);
        map = SgUtils.mapFromArray((Object[])new Object[]{"key", "value", "otherkey"});
        Assert.assertTrue((map == null ? 1 : 0) != 0);
        map = SgUtils.mapFromArray((Object[])new Object[]{"key", "value"});
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"value", map.get("key"));
        map = SgUtils.mapFromArray((Object[])new Object[]{"key", "value", "key", "value"});
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertEquals((Object)"value", map.get("key"));
        map = SgUtils.mapFromArray((Object[])new Object[]{"key1", "value1", "key2", "value2"});
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"value1", map.get("key1"));
        Assert.assertEquals((Object)"value2", map.get("key2"));
    }

    @Test
    public void testEnvReplace() {
        Settings settings = Settings.EMPTY;
        Assert.assertEquals((Object)"abv${env.MYENV}xyz", (Object)SgUtils.replaceEnvVars((String)"abv${env.MYENV}xyz", (Settings)settings));
        Assert.assertEquals((Object)"abv${envbc.MYENV}xyz", (Object)SgUtils.replaceEnvVars((String)"abv${envbc.MYENV}xyz", (Settings)settings));
        Assert.assertEquals((Object)"abvtTtxyz", (Object)SgUtils.replaceEnvVars((String)"abv${env.MYENV:-tTt}xyz", (Settings)settings));
        Assert.assertTrue((boolean)OpenBSDBCrypt.checkPassword((String)SgUtils.replaceEnvVars((String)"${envbc.MYENV:-tTt}", (Settings)settings), (char[])"tTt".toCharArray()));
        Assert.assertEquals((Object)"abvtTtxyzxxx", (Object)SgUtils.replaceEnvVars((String)"abv${env.MYENV:-tTt}xyz${env.MYENV:-xxx}", (Settings)settings));
        Assert.assertTrue((boolean)SgUtils.replaceEnvVars((String)"abv${env.MYENV:-tTt}xyz${envbc.MYENV:-xxx}", (Settings)settings).startsWith("abvtTtxyz$2y$"));
        Assert.assertEquals((Object)"abv${env.MYENV:tTt}xyz", (Object)SgUtils.replaceEnvVars((String)"abv${env.MYENV:tTt}xyz", (Settings)settings));
        Assert.assertEquals((Object)"abv${env.MYENV-tTt}xyz", (Object)SgUtils.replaceEnvVars((String)"abv${env.MYENV-tTt}xyz", (Settings)settings));
        Map<String, String> env = System.getenv();
        Assert.assertTrue((env.size() > 0 ? 1 : 0) != 0);
        boolean checked = false;
        for (String k : env.keySet()) {
            String val = System.getenv().get(k);
            if (val == null || val.isEmpty()) continue;
            Assert.assertEquals((Object)("abv" + val + "xyz"), (Object)SgUtils.replaceEnvVars((String)("abv${env." + k + "}xyz"), (Settings)settings));
            Assert.assertEquals((Object)("abv${" + k + "}xyz"), (Object)SgUtils.replaceEnvVars((String)("abv${" + k + "}xyz"), (Settings)settings));
            Assert.assertEquals((Object)("abv" + val + "xyz"), (Object)SgUtils.replaceEnvVars((String)("abv${env." + k + ":-k182765ggh}xyz"), (Settings)settings));
            Assert.assertEquals((Object)("abv" + val + "xyzabv" + val + "xyz"), (Object)SgUtils.replaceEnvVars((String)("abv${env." + k + "}xyzabv${env." + k + "}xyz"), (Settings)settings));
            Assert.assertEquals((Object)("abv" + val + "xyz"), (Object)SgUtils.replaceEnvVars((String)("abv${env." + k + ":-k182765ggh}xyz"), (Settings)settings));
            Assert.assertTrue((boolean)OpenBSDBCrypt.checkPassword((String)SgUtils.replaceEnvVars((String)("${envbc." + k + "}"), (Settings)settings), (char[])val.toCharArray()));
            checked = true;
        }
        Assert.assertTrue((boolean)checked);
    }

    @Test
    public void testNoEnvReplace() {
        Settings settings = Settings.builder().put("searchguard.disable_envvar_replacement", true).build();
        Assert.assertEquals((Object)"abv${env.MYENV}xyz", (Object)SgUtils.replaceEnvVars((String)"abv${env.MYENV}xyz", (Settings)settings));
        Assert.assertEquals((Object)"abv${envbc.MYENV}xyz", (Object)SgUtils.replaceEnvVars((String)"abv${envbc.MYENV}xyz", (Settings)settings));
        Assert.assertEquals((Object)"abv${env.MYENV:-tTt}xyz", (Object)SgUtils.replaceEnvVars((String)"abv${env.MYENV:-tTt}xyz", (Settings)settings));
        Assert.assertEquals((Object)"abv${env.MYENV:-tTt}xyz${env.MYENV:-xxx}", (Object)SgUtils.replaceEnvVars((String)"abv${env.MYENV:-tTt}xyz${env.MYENV:-xxx}", (Settings)settings));
        Assert.assertFalse((boolean)SgUtils.replaceEnvVars((String)"abv${env.MYENV:-tTt}xyz${envbc.MYENV:-xxx}", (Settings)settings).startsWith("abvtTtxyz$2y$"));
        Assert.assertEquals((Object)"abv${env.MYENV:tTt}xyz", (Object)SgUtils.replaceEnvVars((String)"abv${env.MYENV:tTt}xyz", (Settings)settings));
        Assert.assertEquals((Object)"abv${env.MYENV-tTt}xyz", (Object)SgUtils.replaceEnvVars((String)"abv${env.MYENV-tTt}xyz", (Settings)settings));
        Map<String, String> env = System.getenv();
        Assert.assertTrue((env.size() > 0 ? 1 : 0) != 0);
        for (String k : env.keySet()) {
            Assert.assertEquals((Object)("abv${env." + k + "}xyz"), (Object)SgUtils.replaceEnvVars((String)("abv${env." + k + "}xyz"), (Settings)settings));
            Assert.assertEquals((Object)("abv${" + k + "}xyz"), (Object)SgUtils.replaceEnvVars((String)("abv${" + k + "}xyz"), (Settings)settings));
            Assert.assertEquals((Object)("abv${env." + k + ":-k182765ggh}xyz"), (Object)SgUtils.replaceEnvVars((String)("abv${env." + k + ":-k182765ggh}xyz"), (Settings)settings));
            Assert.assertEquals((Object)("abv${env." + k + "}xyzabv${env." + k + "}xyz"), (Object)SgUtils.replaceEnvVars((String)("abv${env." + k + "}xyzabv${env." + k + "}xyz"), (Settings)settings));
            Assert.assertEquals((Object)("abv${env." + k + ":-k182765ggh}xyz"), (Object)SgUtils.replaceEnvVars((String)("abv${env." + k + ":-k182765ggh}xyz"), (Settings)settings));
        }
    }
}

