/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgtest;

import com.floragunn.searchguard.test.AbstractSGUnitTest;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.cluster.ClusterHelper;
import com.floragunn.searchguard.test.helper.cluster.ClusterInfo;
import com.floragunn.searchguard.test.helper.rest.RestHelper;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class RemoteReindexTests
extends AbstractSGUnitTest {
    private final ClusterHelper cl1 = new ClusterHelper("crl1_n" + num.incrementAndGet() + "_f" + System.getProperty("forkno") + "_t" + System.nanoTime());
    private final ClusterHelper cl2 = new ClusterHelper("crl2_n" + num.incrementAndGet() + "_f" + System.getProperty("forkno") + "_t" + System.nanoTime());
    private ClusterInfo cl1Info;
    private ClusterInfo cl2Info;

    private void setupReindex() throws Exception {
        System.setProperty("sg.display_lic_none", "true");
        this.cl2Info = this.cl2.startCluster(this.minimumSearchGuardSettings(Settings.EMPTY), ClusterConfiguration.DEFAULT);
        this.initialize(this.cl2Info);
        this.cl1Info = this.cl1.startCluster(this.minimumSearchGuardSettings(this.crossClusterNodeSettings(this.cl2Info)), ClusterConfiguration.DEFAULT);
        this.initialize(this.cl1Info);
    }

    @After
    public void tearDown() throws Exception {
        this.cl1.stopCluster();
        this.cl2.stopCluster();
    }

    private Settings crossClusterNodeSettings(ClusterInfo remote) {
        Settings.Builder builder = Settings.builder().putList("reindex.remote.whitelist", new String[]{remote.httpHost + ":" + remote.httpPort});
        return builder.build();
    }

    @Test
    public void testNonSSLReindex() throws Exception {
        this.setupReindex();
        String cl1BodyMain = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("", RemoteReindexTests.encodeBasicHeader("nagilum", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl1BodyMain.contains("crl1"));
        try (TransportClient tc = this.getInternalTransportClient(this.cl1Info, Settings.EMPTY);){
            tc.admin().indices().create(new CreateIndexRequest("twutter")).actionGet();
        }
        String cl2BodyMain = new RestHelper(this.cl2Info, false, false, this.getResourceFolder()).executeGetRequest("", RemoteReindexTests.encodeBasicHeader("nagilum", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl2BodyMain.contains("crl2"));
        try (TransportClient tc = this.getInternalTransportClient(this.cl2Info, Settings.EMPTY);){
            tc.index(((IndexRequest)new IndexRequest("twitter").type("tweet").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
        }
        String reindex = "{\"source\": {\"remote\": {\"host\": \"http://" + this.cl2Info.httpHost + ":" + this.cl2Info.httpPort + "\",\"username\": \"nagilum\",\"password\": \"nagilum\"},\"index\": \"twitter\",\"size\": 10,\"query\": {\"match\": {\"_type\": \"tweet\"}}},\"dest\": {\"index\": \"twutter\"}}";
        System.out.println(reindex);
        RestHelper.HttpResponse ccs = null;
        System.out.println("###################### reindex");
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("_reindex?pretty", reindex, RemoteReindexTests.encodeBasicHeader("nagilum", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("created\" : 1"));
    }
}

