/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test;

import com.floragunn.searchguard.SearchGuardPlugin;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.support.ConfigConstants;
import com.floragunn.searchguard.support.WildcardMatcher;
import com.floragunn.searchguard.test.DynamicSgConfig;
import com.floragunn.searchguard.test.NodeSettingsSupplier;
import com.floragunn.searchguard.test.helper.cluster.ClusterInfo;
import com.floragunn.searchguard.test.helper.file.FileHelper;
import com.floragunn.searchguard.test.helper.rest.RestHelper;
import io.netty.handler.ssl.OpenSsl;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Netty4Plugin;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;

public abstract class AbstractSGUnitTest {
    protected static final AtomicLong num = new AtomicLong();
    protected static boolean withRemoteCluster;
    protected final Logger log = LogManager.getLogger(this.getClass());
    public static final ThreadPool MOCK_POOL;
    protected boolean allowOpenSSL = false;
    @Rule
    public TestName name = new TestName();
    @Rule
    public final TemporaryFolder repositoryPath = new TemporaryFolder();
    protected static ListAppender appender;
    @ClassRule
    public static LoggerContextRule init;

    public static Header encodeBasicHeader(String username, String password) {
        return new BasicHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((username + ":" + Objects.requireNonNull(password)).getBytes(StandardCharsets.UTF_8)));
    }

    @SafeVarargs
    protected static Collection<Class<? extends Plugin>> asCollection(Class<? extends Plugin> ... plugins) {
        return Arrays.asList(plugins);
    }

    protected TransportClient getInternalTransportClient(ClusterInfo info, Settings initTransportClientSettings) {
        String prefix = this.getResourceFolder() == null ? "" : this.getResourceFolder() + "/";
        Settings tcSettings = Settings.builder().put("cluster.name", info.clustername).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath(prefix + "truststore.jks")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath(prefix + "kirk-keystore.jks")).put(initTransportClientSettings).build();
        TransportClientImpl tc = new TransportClientImpl(tcSettings, AbstractSGUnitTest.asCollection(Netty4Plugin.class, SearchGuardPlugin.class));
        tc.addTransportAddress(new TransportAddress(new InetSocketAddress(info.nodeHost, info.nodePort)));
        return tc;
    }

    protected TransportClient getUserTransportClient(ClusterInfo info, String keyStore, Settings initTransportClientSettings) {
        String prefix = this.getResourceFolder() == null ? "" : this.getResourceFolder() + "/";
        Settings tcSettings = Settings.builder().put("cluster.name", info.clustername).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath(prefix + "truststore.jks")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath(prefix + keyStore)).put(initTransportClientSettings).build();
        TransportClientImpl tc = new TransportClientImpl(tcSettings, AbstractSGUnitTest.asCollection(Netty4Plugin.class, SearchGuardPlugin.class));
        tc.addTransportAddress(new TransportAddress(new InetSocketAddress(info.nodeHost, info.nodePort)));
        return tc;
    }

    protected void initialize(ClusterInfo info, Settings initTransportClientSettings, DynamicSgConfig sgconfig) {
        try (TransportClient tc = this.getInternalTransportClient(info, initTransportClientSettings);){
            tc.addTransportAddress(new TransportAddress(new InetSocketAddress(info.nodeHost, info.nodePort)));
            Assert.assertEquals((long)info.numNodes, (long)((NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet()).getNodes().size());
            try {
                tc.admin().indices().create(new CreateIndexRequest("searchguard")).actionGet();
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (IndexRequest ir : sgconfig.getDynamicConfig(this.getResourceFolder())) {
                tc.index(ir).actionGet();
            }
            ConfigUpdateResponse cur = (ConfigUpdateResponse)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(ConfigConstants.CONFIG_NAMES.toArray(new String[0]))).actionGet();
            Assert.assertFalse((String)cur.failures().toString(), (boolean)cur.hasFailures());
            Assert.assertEquals((long)info.numNodes, (long)cur.getNodes().size());
            SearchResponse sr = (SearchResponse)tc.search(new SearchRequest(new String[]{"searchguard"})).actionGet();
            sr = (SearchResponse)tc.search(new SearchRequest(new String[]{"searchguard"})).actionGet();
            Assert.assertTrue((boolean)((GetResponse)tc.get(new GetRequest("searchguard", "sg", "config")).actionGet()).isExists());
            Assert.assertTrue((boolean)((GetResponse)tc.get(new GetRequest("searchguard", "sg", "internalusers")).actionGet()).isExists());
            Assert.assertTrue((boolean)((GetResponse)tc.get(new GetRequest("searchguard", "sg", "roles")).actionGet()).isExists());
            Assert.assertTrue((boolean)((GetResponse)tc.get(new GetRequest("searchguard", "sg", "rolesmapping")).actionGet()).isExists());
            Assert.assertTrue((boolean)((GetResponse)tc.get(new GetRequest("searchguard", "sg", "actiongroups")).actionGet()).isExists());
            Assert.assertFalse((boolean)((GetResponse)tc.get(new GetRequest("searchguard", "sg", "rolesmapping_xcvdnghtu165759i99465")).actionGet()).isExists());
            Assert.assertTrue((boolean)((GetResponse)tc.get(new GetRequest("searchguard", "sg", "config")).actionGet()).isExists());
        }
    }

    protected Settings.Builder minimumSearchGuardSettingsBuilder(int node, boolean sslOnly) {
        String prefix = this.getResourceFolder() == null ? "" : this.getResourceFolder() + "/";
        Settings.Builder builder = Settings.builder().put("searchguard.ssl.http.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.enable_openssl_if_available", this.allowOpenSSL).put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath(prefix + "node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath(prefix + "truststore.jks")).put("searchguard.ssl.transport.enforce_hostname_verification", false);
        if (!sslOnly) {
            builder.putList("searchguard.authcz.admin_dn", new String[]{"CN=kirk,OU=client,O=client,l=tEst, C=De"});
            builder.put("searchguard.background_init_if_sgindex_not_exist", false);
        }
        return builder;
    }

    protected NodeSettingsSupplier minimumSearchGuardSettings(final Settings other) {
        return new NodeSettingsSupplier(){

            @Override
            public Settings get(int i) {
                return AbstractSGUnitTest.this.minimumSearchGuardSettingsBuilder(i, false).put(other).build();
            }
        };
    }

    protected NodeSettingsSupplier minimumSearchGuardSettingsSslOnly(final Settings other) {
        return new NodeSettingsSupplier(){

            @Override
            public Settings get(int i) {
                return AbstractSGUnitTest.this.minimumSearchGuardSettingsBuilder(i, true).put(other).build();
            }
        };
    }

    protected void initialize(ClusterInfo info) {
        this.initialize(info, Settings.EMPTY, new DynamicSgConfig());
    }

    protected void initialize(ClusterInfo info, DynamicSgConfig dynamicSgConfig) {
        this.initialize(info, Settings.EMPTY, dynamicSgConfig);
    }

    protected final void assertContains(RestHelper.HttpResponse res, String pattern) {
        Assert.assertTrue((boolean)WildcardMatcher.match((String)pattern, (String)res.getBody()));
    }

    protected final void assertNotContains(RestHelper.HttpResponse res, String pattern) {
        Assert.assertFalse((boolean)WildcardMatcher.match((String)pattern, (String)res.getBody()));
    }

    protected String getResourceFolder() {
        return null;
    }

    @BeforeClass
    public static void setupLogging() {
        try {
            appender = init.getListAppender("list");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Before
    public void clearAppender() {
        if (appender != null) {
            appender.clear();
        }
    }

    static {
        System.out.println("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version"));
        System.out.println("Java Version: " + System.getProperty("java.version") + " " + System.getProperty("java.vendor"));
        System.out.println("JVM Impl.: " + System.getProperty("java.vm.version") + " " + System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name"));
        System.out.println("Open SSL available: " + OpenSsl.isAvailable());
        System.out.println("Open SSL version: " + OpenSsl.versionString());
        withRemoteCluster = Boolean.parseBoolean(System.getenv("SG_TEST_WITH_REMOTE_CLUSTER"));
        System.out.println("With remote cluster: " + withRemoteCluster);
        MOCK_POOL = new ThreadPool(Settings.builder().put("node.name", "mock").build(), new ExecutorBuilder[0]);
        init = new LoggerContextRule("log4j2-test.properties");
    }

    protected static class TransportClientImpl
    extends TransportClient {
        public TransportClientImpl(Settings settings, Collection<Class<? extends Plugin>> plugins) {
            super(settings, plugins);
        }

        public TransportClientImpl(Settings settings, Settings defaultSettings, Collection<Class<? extends Plugin>> plugins) {
            super(settings, defaultSettings, plugins, null);
        }
    }
}

