/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test;

import com.floragunn.searchguard.test.AbstractSGUnitTest;
import com.floragunn.searchguard.test.DynamicSgConfig;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.cluster.ClusterHelper;
import com.floragunn.searchguard.test.helper.cluster.ClusterInfo;
import com.floragunn.searchguard.test.helper.rest.RestHelper;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.junit.After;

public abstract class SingleClusterTest
extends AbstractSGUnitTest {
    protected ClusterHelper clusterHelper = new ClusterHelper("utest_n" + num.incrementAndGet() + "_f" + System.getProperty("forkno") + "_t" + System.nanoTime());
    protected ClusterInfo clusterInfo;
    ClusterHelper remoteClusterHelper = null;

    protected void setup(Settings nodeOverride) throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), nodeOverride, true);
    }

    protected void setup(Settings nodeOverride, ClusterConfiguration clusterConfiguration) throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), nodeOverride, true, clusterConfiguration);
    }

    protected void setup() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), Settings.EMPTY, true);
    }

    protected void setup(Settings initTransportClientSettings, DynamicSgConfig dynamicSgSettings, Settings nodeOverride) throws Exception {
        this.setup(initTransportClientSettings, dynamicSgSettings, nodeOverride, true);
    }

    protected void setup(Settings initTransportClientSettings, DynamicSgConfig dynamicSgSettings, Settings nodeOverride, boolean initSearchGuardIndex) throws Exception {
        this.setup(initTransportClientSettings, dynamicSgSettings, nodeOverride, initSearchGuardIndex, ClusterConfiguration.DEFAULT);
    }

    private Settings ccs(Settings nodeOverride) throws Exception {
        if (withRemoteCluster) {
            this.remoteClusterHelper = new ClusterHelper("crl2_n" + num.incrementAndGet() + "_f" + System.getProperty("forkno") + "_t" + System.nanoTime());
            ClusterInfo cl2Info = this.remoteClusterHelper.startCluster(this.minimumSearchGuardSettings(Settings.EMPTY), ClusterConfiguration.SINGLENODE);
            Settings.Builder builder = Settings.builder().put(nodeOverride).putList("search.remote.cross_cluster_two.seeds", new String[]{cl2Info.nodeHost + ":" + cl2Info.nodePort});
            return builder.build();
        }
        return nodeOverride;
    }

    protected void setup(Settings initTransportClientSettings, DynamicSgConfig dynamicSgSettings, Settings nodeOverride, boolean initSearchGuardIndex, ClusterConfiguration clusterConfiguration) throws Exception {
        this.clusterInfo = this.clusterHelper.startCluster(this.minimumSearchGuardSettings(this.ccs(nodeOverride)), clusterConfiguration);
        if (initSearchGuardIndex && dynamicSgSettings != null) {
            this.initialize(this.clusterInfo, initTransportClientSettings, dynamicSgSettings);
        }
    }

    protected void setup(Settings initTransportClientSettings, DynamicSgConfig dynamicSgSettings, Settings nodeOverride, boolean initSearchGuardIndex, ClusterConfiguration clusterConfiguration, int timeout, Integer nodes) throws Exception {
        this.clusterInfo = this.clusterHelper.startCluster(this.minimumSearchGuardSettings(this.ccs(nodeOverride)), clusterConfiguration, timeout, nodes);
        if (initSearchGuardIndex) {
            this.initialize(this.clusterInfo, initTransportClientSettings, dynamicSgSettings);
        }
    }

    protected void setupSslOnlyMode(Settings nodeOverride) throws Exception {
        this.clusterInfo = this.clusterHelper.startCluster(this.minimumSearchGuardSettingsSslOnly(nodeOverride), ClusterConfiguration.DEFAULT);
    }

    protected RestHelper restHelper() {
        return new RestHelper(this.clusterInfo, this.getResourceFolder());
    }

    protected RestHelper nonSslRestHelper() {
        return new RestHelper(this.clusterInfo, false, false, this.getResourceFolder());
    }

    protected TransportClient getInternalTransportClient() {
        return this.getInternalTransportClient(this.clusterInfo, Settings.EMPTY);
    }

    @After
    public void tearDown() throws Exception {
        if (this.remoteClusterHelper != null) {
            this.remoteClusterHelper.stopCluster();
        }
        if (this.clusterInfo != null) {
            this.clusterHelper.stopCluster();
        }
    }
}

