/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import java.util.Arrays;
import java.util.Random;
import org.elasticsearch.common.logging.LogConfigurator;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.InternalSettingsPreparer;
import org.elasticsearch.node.Node;
import org.elasticsearch.plugins.Plugin;

public class PluginAwareNode
extends Node {
    private final boolean masterEligible;

    @SafeVarargs
    public PluginAwareNode(boolean masterEligible, Settings preparedSettings, Class<? extends Plugin> ... plugins) {
        super(InternalSettingsPreparer.prepareEnvironment((Settings)PluginAwareNode.checkAndAddNodeName(preparedSettings), null), Arrays.asList(plugins), true);
        this.masterEligible = masterEligible;
    }

    protected void registerDerivedNodeNameWithLogger(String nodeName) {
        LogConfigurator.setNodeName((String)nodeName);
    }

    public boolean isMasterEligible() {
        return this.masterEligible;
    }

    private static Settings checkAndAddNodeName(Settings settings) {
        if (!settings.hasValue("node.name")) {
            return Settings.builder().put(settings).put("node.name", "auto_node_name_" + System.currentTimeMillis() + "_" + new Random().nextInt()).build();
        }
        return settings;
    }
}

