/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.searchguard.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.rest.RestHelper;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.common.settings.Settings;
import org.junit.Assert;
import org.junit.Test;

public class SystemIntegratorsTests
extends SingleClusterTest {
    @Test
    public void testInjectedUserMalformed() throws Exception {
        Settings settings = Settings.builder().put("searchguard.unsupported.inject_user.enabled", true).put("http.type", "com.floragunn.searchguard.http.UserInjectingServerTransport").build();
        this.setup(settings, ClusterConfiguration.USERINJECTOR);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse resc = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("injected_user", null)});
        Assert.assertEquals((long)401L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("injected_user", "|||")});
        Assert.assertEquals((long)401L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("injected_user", "||127.0.0:80|")});
        Assert.assertEquals((long)401L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("injected_user", "username||ip|")});
        Assert.assertEquals((long)401L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("injected_user", "username||ip:port|")});
        Assert.assertEquals((long)401L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("injected_user", "username||ip:80|")});
        Assert.assertEquals((long)401L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("injected_user", "username||127.0.x:80|")});
        Assert.assertEquals((long)401L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("injected_user", "username||127.0.0:80|key1,value1,key2")});
        Assert.assertEquals((long)401L, (long)resc.getStatusCode());
        resc = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("injected_user", "||127.0.0:80|key1,value1,key2,value2")});
        Assert.assertEquals((long)401L, (long)resc.getStatusCode());
    }

    @Test
    public void testInjectedUser() throws Exception {
        Settings settings = Settings.builder().put("searchguard.unsupported.inject_user.enabled", true).put("http.type", "com.floragunn.searchguard.http.UserInjectingServerTransport").build();
        this.setup(settings, ClusterConfiguration.USERINJECTOR);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse resc = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("injected_user", "admin||127.0.0:80|")});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("User [name=admin, roles=[], requestedTenant=null]"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"remote_address\":\"127.0.0.0:80\""));
        Assert.assertTrue((boolean)resc.getBody().contains("\"backend_roles\":[]"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"custom_attribute_names\":[]"));
        resc = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("injected_user", "admin|role1|127.0.0:80|key1,value1")});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("User [name=admin, roles=[role1], requestedTenant=null]"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"remote_address\":\"127.0.0.0:80\""));
        Assert.assertTrue((boolean)resc.getBody().contains("\"backend_roles\":[\"role1\"]"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"custom_attribute_names\":[\"key1\"]"));
        resc = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("injected_user", "admin|role1,role2||key1,value1")});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("User [name=admin, roles=[role1, role2], requestedTenant=null]"));
        Assert.assertFalse((boolean)resc.getBody().contains("\"remote_address\":null"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"backend_roles\":[\"role1\",\"role2\"]"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"custom_attribute_names\":[\"key1\"]"));
        resc = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("injected_user", "admin|role1,role2|8.8.8.8:8|key1,value1,key2,value2")});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("User [name=admin, roles=[role1, role2], requestedTenant=null]"));
        Assert.assertFalse((boolean)resc.getBody().contains("\"remote_address\":null"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"backend_roles\":[\"role1\",\"role2\"]"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"custom_attribute_names\":[\"key1\",\"key2\"]"));
        resc = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("injected_user", "nagilum|role1,role2|8.8.8.8:8|key1,value1,key2,value2")});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("User [name=nagilum, roles=[role1, role2], requestedTenant=null]"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"remote_address\":\"8.8.8.8:8\""));
        Assert.assertTrue((boolean)resc.getBody().contains("\"backend_roles\":[\"role1\",\"role2\"]"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"sg_roles\":[\"sg_all_access\""));
        Assert.assertTrue((boolean)resc.getBody().contains("\"custom_attribute_names\":[\"key1\",\"key2\"]"));
        resc = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("injected_user", "myuser|role1,vulcanadmin|8.8.8.8:8|key1,value1,key2,value2")});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("User [name=myuser, roles=[role1, vulcanadmin], requestedTenant=null]"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"remote_address\":\"8.8.8.8:8\""));
        Assert.assertTrue((boolean)resc.getBody().contains("\"backend_roles\":[\"role1\",\"vulcanadmin\"]"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"sg_roles\":[\"sg_public\",\"sg_role_vulcans_admin\"]"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"custom_attribute_names\":[\"key1\",\"key2\"]"));
        resc = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("injected_user", "myuser|role1,vulcanadmin|8.8.8.8:8|key1,value1,key2,value2|")});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("User [name=myuser, roles=[role1, vulcanadmin], requestedTenant=null]"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"remote_address\":\"8.8.8.8:8\""));
        Assert.assertTrue((boolean)resc.getBody().contains("\"backend_roles\":[\"role1\",\"vulcanadmin\"]"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"sg_roles\":[\"sg_public\",\"sg_role_vulcans_admin\"]"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"custom_attribute_names\":[\"key1\",\"key2\"]"));
        resc = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("injected_user", "myuser|role1,vulcanadmin|8.8.8.8:8|key1,value1,key2,value2|mytenant")});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("User [name=myuser, roles=[role1, vulcanadmin], requestedTenant=mytenant]"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"remote_address\":\"8.8.8.8:8\""));
        Assert.assertTrue((boolean)resc.getBody().contains("\"backend_roles\":[\"role1\",\"vulcanadmin\"]"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"sg_roles\":[\"sg_public\",\"sg_role_vulcans_admin\"]"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"custom_attribute_names\":[\"key1\",\"key2\"]"));
        resc = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("injected_user", "myuser|role1,vulcanadmin|8.8.8.8:8||mytenant with whitespace")});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("User [name=myuser, roles=[role1, vulcanadmin], requestedTenant=mytenant with whitespace]"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"remote_address\":\"8.8.8.8:8\""));
        Assert.assertTrue((boolean)resc.getBody().contains("\"backend_roles\":[\"role1\",\"vulcanadmin\"]"));
        Assert.assertTrue((boolean)resc.getBody().contains("\"sg_roles\":[\"sg_public\",\"sg_role_vulcans_admin\"]"));
    }

    @Test
    public void testInjectedUserDisabled() throws Exception {
        Settings settings = Settings.builder().put("http.type", "com.floragunn.searchguard.http.UserInjectingServerTransport").build();
        this.setup(settings, ClusterConfiguration.USERINJECTOR);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse resc = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("injected_user", "admin|role1|127.0.0:80|key1,value1")});
        Assert.assertEquals((long)401L, (long)resc.getStatusCode());
    }

    @Test
    public void testInjectedAdminUser() throws Exception {
        Settings settings = Settings.builder().put("searchguard.unsupported.inject_user.enabled", true).put("searchguard.unsupported.inject_user.admin.enabled", true).putList("searchguard.authcz.admin_dn", (List)Lists.newArrayList((Object[])new String[]{"CN=kirk,OU=client,O=client,L=Test,C=DE", "injectedadmin"})).put("http.type", "com.floragunn.searchguard.http.UserInjectingServerTransport").build();
        this.setup(settings, ClusterConfiguration.USERINJECTOR);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse resc = rh.executeGetRequest("searchguard/_search?pretty", new Header[]{new BasicHeader("injected_user", "injectedadmin|role1|127.0.0:80|key1,value1")});
        Assert.assertEquals((long)200L, (long)resc.getStatusCode());
        Assert.assertTrue((boolean)resc.getBody().contains("\"_id\" : \"config\""));
        Assert.assertTrue((boolean)resc.getBody().contains("\"_id\" : \"roles\""));
        Assert.assertTrue((boolean)resc.getBody().contains("\"_id\" : \"internalusers\""));
        Assert.assertTrue((boolean)resc.getBody().contains("\"_id\" : \"tattr\""));
        Assert.assertTrue((boolean)resc.getBody().contains("\"total\" : 6"));
        resc = rh.executeGetRequest("searchguard/_search?pretty", new Header[]{new BasicHeader("injected_user", "wrongadmin|role1|127.0.0:80|key1,value1")});
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
    }

    @Test
    public void testInjectedAdminUserAdminInjectionDisabled() throws Exception {
        Settings settings = Settings.builder().put("searchguard.unsupported.inject_user.enabled", true).putList("searchguard.authcz.admin_dn", (List)Lists.newArrayList((Object[])new String[]{"CN=kirk,OU=client,O=client,L=Test,C=DE", "injectedadmin"})).put("http.type", "com.floragunn.searchguard.http.UserInjectingServerTransport").build();
        this.setup(settings, ClusterConfiguration.USERINJECTOR);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse resc = rh.executeGetRequest("searchguard/_search?pretty", new Header[]{new BasicHeader("injected_user", "injectedadmin|role1|127.0.0:80|key1,value1")});
        Assert.assertEquals((long)403L, (long)resc.getStatusCode());
        Assert.assertFalse((boolean)resc.getBody().contains("\"_id\" : \"config\""));
        Assert.assertFalse((boolean)resc.getBody().contains("\"_id\" : \"roles\""));
        Assert.assertFalse((boolean)resc.getBody().contains("\"_id\" : \"internalusers\""));
        Assert.assertFalse((boolean)resc.getBody().contains("\"_id\" : \"tattr\""));
        Assert.assertFalse((boolean)resc.getBody().contains("\"total\" : 6"));
    }
}

