/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.searchguard.test.DynamicSgConfig;
import com.floragunn.searchguard.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.file.FileHelper;
import com.floragunn.searchguard.test.helper.rest.RestHelper;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="subject for manual execution")
public class TracingTests
extends SingleClusterTest {
    @Test
    public void testAdvancedMapping() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), Settings.EMPTY, true, ClusterConfiguration.DEFAULT);
        try (TransportClient tc = this.getInternalTransportClient(this.clusterInfo, Settings.EMPTY);){
            tc.admin().indices().create(new CreateIndexRequest("myindex1").mapping("mytype1", FileHelper.loadFile("mapping1.json"), XContentType.JSON)).actionGet();
            tc.admin().indices().create(new CreateIndexRequest("myindex2").mapping("mytype2", FileHelper.loadFile("mapping2.json"), XContentType.JSON)).actionGet();
            tc.admin().indices().create(new CreateIndexRequest("myindex3").mapping("mytype3", FileHelper.loadFile("mapping3.json"), XContentType.JSON)).actionGet();
            tc.admin().indices().create(new CreateIndexRequest("myindex4").mapping("mytype4", FileHelper.loadFile("mapping4.json"), XContentType.JSON)).actionGet();
        }
        RestHelper rh = this.nonSslRestHelper();
        System.out.println("############ write into mapping 1");
        String data1 = FileHelper.loadFile("data1.json");
        System.out.println(rh.executePutRequest("myindex1/mytype1/1?refresh", data1, TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println(rh.executePutRequest("myindex1/mytype1/1?refresh", data1, TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ write into mapping 2");
        System.out.println(rh.executePutRequest("myindex2/mytype2/2?refresh", data1, TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println(rh.executePutRequest("myindex2/mytype2/2?refresh", data1, TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ write into mapping 3");
        String parent = FileHelper.loadFile("data2.json");
        String child = FileHelper.loadFile("data3.json");
        System.out.println(rh.executePutRequest("myindex3/mytype3/1?refresh", parent, TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println(rh.executePutRequest("myindex3/mytype3/2?routing=1&refresh", child, TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ write into mapping 4");
        System.out.println(rh.executePutRequest("myindex4/mytype4/1?refresh", parent, TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println(rh.executePutRequest("myindex4/mytype4/2?routing=1&refresh", child, TracingTests.encodeBasicHeader("nagilum", "nagilum")));
    }

    @Test
    public void testHTTPTraceNoSource() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), Settings.EMPTY, true, ClusterConfiguration.DEFAULT);
        try (TransportClient tc = this.getInternalTransportClient(this.clusterInfo, Settings.EMPTY);){
            tc.admin().indices().create(new CreateIndexRequest("a")).actionGet();
            tc.admin().indices().create(new CreateIndexRequest("c")).actionGet();
            tc.admin().indices().create(new CreateIndexRequest("test")).actionGet();
            tc.admin().indices().create(new CreateIndexRequest("u")).actionGet();
            tc.admin().indices().putMapping(new PutMappingRequest(new String[]{"a"}).type("b").source(new Object[]{"_source", "enabled=false", "content", "store=true,type=text", "field1", "store=true,type=text", "field2", "store=true,type=text", "a", "store=true,type=text", "b", "store=true,type=text", "my.nested.field", "store=true,type=text"})).actionGet();
            tc.admin().indices().putMapping(new PutMappingRequest(new String[]{"c"}).type("d").source(new Object[]{"_source", "enabled=false", "content", "store=true,type=text", "field1", "store=true,type=text", "field2", "store=true,type=text", "a", "store=true,type=text", "b", "store=true,type=text", "my.nested.field", "store=true,type=text"})).actionGet();
            tc.admin().indices().putMapping(new PutMappingRequest(new String[]{"test"}).type("type1").source(new Object[]{"_source", "enabled=false", "content", "store=true,type=text", "field1", "store=true,type=text", "field2", "store=true,type=text", "a", "store=true,type=text", "b", "store=true,type=text", "my.nested.field", "store=true,type=text"})).actionGet();
            tc.admin().indices().putMapping(new PutMappingRequest(new String[]{"u"}).type("b").source(new Object[]{"_source", "enabled=false", "content", "store=true,type=text", "field1", "store=true,type=text", "field2", "store=true,type=text", "a", "store=true,type=text", "b", "store=true,type=text", "my.nested.field", "store=true,type=text"})).actionGet();
            for (int i = 0; i < 50; ++i) {
                tc.index(((IndexRequest)new IndexRequest("a").type("b").id(i + "").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":" + i + "}", XContentType.JSON)).actionGet();
                tc.index(((IndexRequest)new IndexRequest("c").type("d").id(i + "").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":" + i + "}", XContentType.JSON)).actionGet();
            }
        }
        RestHelper rh = this.nonSslRestHelper();
        System.out.println("############ check shards");
        System.out.println(rh.executeGetRequest("_cat/shards?v", TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ _bulk");
        String bulkBody = "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"delete\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator();
        System.out.println(rh.executePostRequest("_bulk?refresh=true", bulkBody, TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ _bulk");
        bulkBody = "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"delete\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator();
        System.out.println(rh.executePostRequest("_bulk?refresh=true", bulkBody, TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ cat indices");
        System.out.println(rh.executeGetRequest("_cat/indices", TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ _search");
        System.out.println(rh.executeGetRequest("_search", TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ get 1");
        System.out.println(rh.executeGetRequest("a/b/1", TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ get 5");
        System.out.println(rh.executeGetRequest("a/b/5", TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ get 17");
        System.out.println(rh.executeGetRequest("a/b/17", TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ index (+create index)");
        System.out.println(rh.executePostRequest("u/b/1?refresh=true", "{}", TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ index only");
        System.out.println(rh.executePostRequest("u/b/2?refresh=true", "{}", TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ delete");
        System.out.println(rh.executeDeleteRequest("u/b/2?refresh=true", TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ msearch");
        String msearchBody = "{\"index\":\"a\", \"type\":\"b\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator() + "{\"index\":\"a\", \"type\":\"b\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator() + "{\"index\":\"public\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator();
        System.out.println(rh.executePostRequest("_msearch", msearchBody, TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ mget");
        String mgetBody = "{\"docs\" : [{\"_index\" : \"a\",\"_type\" : \"b\",\"_id\" : \"1\" }, {\"_index\" : \"a\", \"_type\" : \"b\", \"_id\" : \"12\"}, {\"_index\" : \"a\", \"_type\" : \"b\", \"_id\" : \"13\"}, {\"_index\" : \"a\", \"_type\" : \"b\", \"_id\" : \"14\"}]}";
        System.out.println(rh.executePostRequest("_mget?refresh=true", mgetBody, TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ delete by query");
        String dbqBody = "{  \"query\": {     \"match\": {      \"content\": 12    }  }}";
        System.out.println(rh.executePostRequest("a/b/_delete_by_query", dbqBody, TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        Thread.sleep(5000L);
    }

    @Test
    public void testHTTPSingle() throws Exception {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
            }
        });
        Settings settings = Settings.builder().putList("searchguard.authcz.rest_impersonation_user.worf", new String[]{"knuddel", "nonexists"}).build();
        this.setup(settings);
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            tc.admin().indices().create(new CreateIndexRequest("copysf")).actionGet();
            tc.index(((IndexRequest)new IndexRequest("vulcangov").type("kolinahr").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("starfleet").type("ships").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("starfleet_academy").type("students").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("starfleet_library").type("public").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("klingonempire").type("ships").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("public").type("legends").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("spock").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("kirk").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("role01_role02").type("type01").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"starfleet", "starfleet_academy", "starfleet_library"}).alias("sf"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"klingonempire", "vulcangov"}).alias("nonsf"))).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"public"}).alias("unrestricted"))).actionGet();
        }
        System.out.println("########pause1");
        Thread.sleep(5000L);
        System.out.println("########end pause1");
        System.out.println("########search");
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("_search", TracingTests.encodeBasicHeader("nagilum", "nagilum")).getStatusCode());
        System.out.println("########search done");
        System.out.println("########pause2");
        Thread.sleep(5000L);
        System.out.println("########end pause2");
        System.out.println("############ _bulk");
        String bulkBody = "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"delete\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"myindex\", \"_type\" : \"myindex\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"myindex\", \"_type\" : \"myindex\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator();
        System.out.println(rh.executePostRequest("_bulk?refresh=true", bulkBody, TracingTests.encodeBasicHeader("nagilum", "nagilum")).getBody());
        System.out.println("############ _end");
        Thread.sleep(5000L);
    }

    @Test
    public void testSearchScroll() throws Exception {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
            }
        });
        Settings settings = Settings.builder().putList("searchguard.authcz.rest_impersonation_user.worf", new String[]{"knuddel", "nonexists"}).build();
        this.setup(settings);
        RestHelper rh = this.nonSslRestHelper();
        try (TransportClient tc = this.getInternalTransportClient();){
            for (int i = 0; i < 3; ++i) {
                tc.index(((IndexRequest)new IndexRequest("vulcangov").type("kolinahr").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":1}", XContentType.JSON)).actionGet();
            }
        }
        System.out.println("########search");
        RestHelper.HttpResponse res = rh.executeGetRequest("vulcangov/_search?scroll=1m&pretty=true", TracingTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println(res.getBody());
        int start = res.getBody().indexOf("_scroll_id") + 15;
        String scrollid = res.getBody().substring(start, res.getBody().indexOf("\"", start + 1));
        System.out.println(scrollid);
        System.out.println("########search scroll");
        res = rh.executePostRequest("/_search/scroll?pretty=true", "{\"scroll_id\" : \"" + scrollid + "\"}", TracingTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        System.out.println("########search done");
    }

    @Test
    public void testHTTPTrace() throws Exception {
        this.setup(Settings.EMPTY, new DynamicSgConfig(), Settings.EMPTY, true, ClusterConfiguration.DEFAULT);
        try (TransportClient tc = this.getInternalTransportClient(this.clusterInfo, Settings.EMPTY);){
            for (int i = 0; i < 50; ++i) {
                tc.index(((IndexRequest)new IndexRequest("a").type("b").id(i + "").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":" + i + "}", XContentType.JSON)).actionGet();
                tc.index(((IndexRequest)new IndexRequest("c").type("d").id(i + "").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source("{\"content\":" + i + "}", XContentType.JSON)).actionGet();
            }
        }
        RestHelper rh = this.nonSslRestHelper();
        System.out.println("############ check shards");
        System.out.println(rh.executeGetRequest("_cat/shards?v", TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ _bulk");
        String bulkBody = "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"delete\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator();
        System.out.println(rh.executePostRequest("_bulk?refresh=true", bulkBody, TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ _bulk");
        bulkBody = "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"1\" } }" + System.lineSeparator() + "{ \"field1\" : \"value1\" }" + System.lineSeparator() + "{ \"index\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator() + "{ \"field2\" : \"value2\" }" + System.lineSeparator() + "{ \"delete\" : { \"_index\" : \"test\", \"_type\" : \"type1\", \"_id\" : \"2\" } }" + System.lineSeparator();
        System.out.println(rh.executePostRequest("_bulk?refresh=true", bulkBody, TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ cat indices");
        System.out.println(rh.executeGetRequest("_cat/indices", TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ _search");
        System.out.println(rh.executeGetRequest("_search", TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ get 1");
        System.out.println(rh.executeGetRequest("a/b/1", TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ get 5");
        System.out.println(rh.executeGetRequest("a/b/5", TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ get 17");
        System.out.println(rh.executeGetRequest("a/b/17", TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ index (+create index)");
        System.out.println(rh.executePostRequest("u/b/1?refresh=true", "{}", TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ index only");
        System.out.println(rh.executePostRequest("u/b/2?refresh=true", "{}", TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ update");
        System.out.println(rh.executePostRequest("u/b/2/_update?refresh=true", "{\"doc\" : {\"a\":1}}", TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ update2");
        System.out.println(rh.executePostRequest("u/b/2/_update?refresh=true", "{\"doc\" : {\"a\":44, \"b\":55}}", TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ update3");
        System.out.println(rh.executePostRequest("u/b/2/_update?refresh=true", "{\"doc\" : {\"b\":66}}", TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ delete");
        System.out.println(rh.executeDeleteRequest("u/b/2?refresh=true", TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ reindex");
        String reindex = "{  \"source\": {    \"index\": \"a\"  },  \"dest\": {    \"index\": \"new_a\"  }}";
        System.out.println(rh.executePostRequest("_reindex", reindex, TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ msearch");
        String msearchBody = "{\"index\":\"a\", \"type\":\"b\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator() + "{\"index\":\"a\", \"type\":\"b\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator() + "{\"index\":\"public\", \"ignore_unavailable\": true}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator();
        System.out.println(rh.executePostRequest("_msearch", msearchBody, TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ mget");
        String mgetBody = "{\"docs\" : [{\"_index\" : \"a\",\"_type\" : \"b\",\"_id\" : \"1\" }, {\"_index\" : \"a\", \"_type\" : \"b\", \"_id\" : \"12\"}, {\"_index\" : \"a\", \"_type\" : \"b\", \"_id\" : \"13\"}, {\"_index\" : \"a\", \"_type\" : \"b\", \"_id\" : \"14\"}]}";
        System.out.println(rh.executePostRequest("_mget?refresh=true", mgetBody, TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        System.out.println("############ delete by query");
        String dbqBody = "{  \"query\": {     \"match\": {      \"content\": 12    }  }}";
        System.out.println(rh.executePostRequest("a/b/_delete_by_query", dbqBody, TracingTests.encodeBasicHeader("nagilum", "nagilum")));
        Thread.sleep(5000L);
    }
}

