/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgtest;

import com.floragunn.searchguard.test.AbstractSGUnitTest;
import com.floragunn.searchguard.test.DynamicSgConfig;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.cluster.ClusterHelper;
import com.floragunn.searchguard.test.helper.cluster.ClusterInfo;
import com.floragunn.searchguard.test.helper.rest.RestHelper;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class CrossClusterSearchTests
extends AbstractSGUnitTest {
    private final ClusterHelper cl1 = new ClusterHelper("crl1_n" + num.incrementAndGet() + "_f" + System.getProperty("forkno") + "_t" + System.nanoTime());
    private final ClusterHelper cl2 = new ClusterHelper("crl2_n" + num.incrementAndGet() + "_f" + System.getProperty("forkno") + "_t" + System.nanoTime());
    private ClusterInfo cl1Info;
    private ClusterInfo cl2Info;

    private void setupCcs() throws Exception {
        this.setupCcs(new DynamicSgConfig());
    }

    private void setupCcs(DynamicSgConfig dynamicSgConfig) throws Exception {
        System.setProperty("sg.display_lic_none", "true");
        this.cl2Info = this.cl2.startCluster(this.minimumSearchGuardSettings(Settings.EMPTY), ClusterConfiguration.DEFAULT);
        this.initialize(this.cl2Info, dynamicSgConfig);
        System.out.println("### cl2 complete ###");
        this.cl1Info = this.cl1.startCluster(this.minimumSearchGuardSettings(this.crossClusterNodeSettings(this.cl2Info)), ClusterConfiguration.DEFAULT);
        System.out.println("### cl1 start ###");
        this.initialize(this.cl1Info, dynamicSgConfig);
        System.out.println("### cl1 initialized ###");
    }

    @After
    public void tearDown() throws Exception {
        this.cl1.stopCluster();
        this.cl2.stopCluster();
    }

    private Settings crossClusterNodeSettings(ClusterInfo remote) {
        Settings.Builder builder = Settings.builder().putList("search.remote.cross_cluster_two.seeds", new String[]{remote.nodeHost + ":" + remote.nodePort});
        return builder.build();
    }

    @Test
    public void testCcs() throws Exception {
        this.setupCcs();
        String cl1BodyMain = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl1BodyMain.contains("crl1"));
        try (TransportClient tc = this.getInternalTransportClient(this.cl1Info, Settings.EMPTY);){
            tc.index(((IndexRequest)new IndexRequest("twitter").type("tweet").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("twutter").type("tweet").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("special:index").type("spec").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("cross_cluster_two:xx").type("xx").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
        }
        String cl2BodyMain = new RestHelper(this.cl2Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl2BodyMain.contains("crl2"));
        try (TransportClient tc = this.getInternalTransportClient(this.cl2Info, Settings.EMPTY);){
            tc.index(((IndexRequest)new IndexRequest("twitter").type("tweet").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("twutter").type("tweet").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("special:index").type("spec").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("cross_cluster_two:xx").type("xx").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
        }
        RestHelper.HttpResponse ccs = null;
        System.out.println("###################### query 1");
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:*/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("crl1"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl2"));
        Assert.assertTrue((boolean)ccs.getBody().contains("twitter"));
        System.out.println("###################### query 2");
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("special:index/spec/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("crl1"));
        Assert.assertFalse((boolean)ccs.getBody().contains("crl2"));
        System.out.println("###################### query 3");
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:special:index,special:index/spec/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("crl1"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl2"));
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster"));
        System.out.println("###################### query 4");
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:xx,xx/xx/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        System.out.println(ccs.getBody());
        System.out.println("###################### query 5");
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:abcnonext/xx/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)404L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("index_not_found_exception"));
        System.out.println("###################### query 6");
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twitter,twutter/tweet/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"timed_out\" : false"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl1"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl2"));
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster"));
    }

    @Test
    public void testCcsNonadmin() throws Exception {
        this.setupCcs();
        String cl1BodyMain = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl1BodyMain.contains("crl1"));
        try (TransportClient tc = this.getInternalTransportClient(this.cl1Info, Settings.EMPTY);){
            tc.index(((IndexRequest)new IndexRequest("twitter").type("tweet").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("twutter").type("tweet").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"twitter"}).alias("coordalias"))).actionGet();
        }
        String cl2BodyMain = new RestHelper(this.cl2Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl2BodyMain.contains("crl2"));
        try (TransportClient tc = this.getInternalTransportClient(this.cl2Info, Settings.EMPTY);){
            tc.index(((IndexRequest)new IndexRequest("twitter").type("tweet").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("twutter").type("tweet").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"twitter"}).alias("remotealias"))).actionGet();
        }
        RestHelper.HttpResponse ccs = null;
        System.out.println("###################### query 1");
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:*/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        System.out.println("###################### query 2");
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twit*/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twitter/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        System.out.println("###################### query 3");
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twitter,twitter,twutter/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        System.out.println("###################### query 4");
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twitter,twitter/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("crl1_"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl2_"));
        System.out.println("###################### query 5");
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twutter,twitter/tweet/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        System.out.println("###################### query 6");
        String msearchBody = "{}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator();
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:twitter,twitter/tweet/_msearch?pretty", msearchBody, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        System.out.println("###################### query 7");
        msearchBody = "{}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator();
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:twitter/tweet/_msearch?pretty", msearchBody, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("_all/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("*/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twitter,twitter/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:*/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("*:*/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("hfghgtdhfhuth/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("hfghgtdhfhuth*/_search", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("\"hits\":[]"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest(":*/_search", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("\"hits\":[]"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("*:/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("%3Clogstash-%7Bnow%2Fd%7D%3E/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:%3Clogstash-%7Bnow%2Fd%7D%3E/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:%3Clogstash-%7Bnow%2Fd%7D%3E,%3Clogstash-%7Bnow%2Fd%7D%3E/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:remotealias/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("coordalias/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:remotealias,coordalias/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:remotealias/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("coordalias/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        System.out.println("#### Alias both");
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:remotealias,coordalias/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("notexist,coordalias/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twitter/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("crusherw", "crusherw"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
    }

    @Test
    public void testCcsNonadminDnfof() throws Exception {
        this.setupCcs(new DynamicSgConfig().setSgConfig("sg_config_dnfof.yml"));
        String cl1BodyMain = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl1BodyMain.contains("crl1"));
        try (TransportClient tc = this.getInternalTransportClient(this.cl1Info, Settings.EMPTY);){
            tc.index(((IndexRequest)new IndexRequest("twitter").type("tweet").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("twutter").type("tweet").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"twitter"}).alias("coordalias"))).actionGet();
        }
        String cl2BodyMain = new RestHelper(this.cl2Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl2BodyMain.contains("crl2"));
        try (TransportClient tc = this.getInternalTransportClient(this.cl2Info, Settings.EMPTY);){
            tc.index(((IndexRequest)new IndexRequest("twitter").type("tweet").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("twutter").type("tweet").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.admin().indices().aliases(new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.add().indices(new String[]{"twitter"}).alias("remotealias"))).actionGet();
        }
        RestHelper.HttpResponse ccs = null;
        System.out.println("###################### query 1");
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:*/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("crl1_"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl2_"));
        System.out.println("###################### query 2");
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twit*/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        System.out.println("###################### query 3");
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twitter,twitter,twutter/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("twutter"));
        System.out.println("###################### query 4");
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twitter,twitter/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("crl1_"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl2_"));
        System.out.println("###################### query 5");
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twutter,twitter/tweet/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        System.out.println("###################### query 6");
        String msearchBody = "{}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator();
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:twitter,twitter/tweet/_msearch?pretty", msearchBody, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        System.out.println("###################### query 7");
        msearchBody = "{}" + System.lineSeparator() + "{\"size\":10, \"query\":{\"bool\":{\"must\":{\"match_all\":{}}}}}" + System.lineSeparator();
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:twitter/tweet/_msearch?pretty", msearchBody, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("_all/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("*/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twitter,twitter/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:*/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        System.out.println("#####*");
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:*,*/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("crl1_"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl2_"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("*cross*:*twit*,*/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twitter,t*/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("*:*/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("hfghgtdhfhuth/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("hfghgtdhfhuth*/_search", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("\"hits\":[]"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest(":*/_search", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertTrue((boolean)ccs.getBody().contains("\"hits\":[]"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("*:/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("%3Clogstash-%7Bnow%2Fd%7D%3E/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:%3Clogstash-%7Bnow%2Fd%7D%3E/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:%3Clogstash-%7Bnow%2Fd%7D%3E,%3Clogstash-%7Bnow%2Fd%7D%3E/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:remotealias/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("coordalias/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:remotealias,coordalias/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("worf", "worf"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:remotealias/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("coordalias/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:remotealias,coordalias/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twitter/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("crusherw", "crusherw"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
    }

    @Test
    public void testCcsEmptyCoord() throws Exception {
        this.setupCcs();
        String cl1BodyMain = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl1BodyMain.contains("crl1"));
        String cl2BodyMain = new RestHelper(this.cl2Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl2BodyMain.contains("crl2"));
        try (TransportClient tc = this.getInternalTransportClient(this.cl2Info, Settings.EMPTY);){
            tc.index(((IndexRequest)new IndexRequest("twitter").type("tweet").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
        }
        RestHelper.HttpResponse ccs = null;
        System.out.println("###################### query 1");
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("cross_cluster_two:twitter/tweet/_search?pretty", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        System.out.println(ccs.getBody());
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"timed_out\" : false"));
        Assert.assertFalse((boolean)ccs.getBody().contains("crl1"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl2"));
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two:twitter"));
    }

    @Test
    public void testCcsKibanaAggregations() throws Exception {
        this.setupCcs();
        String cl1BodyMain = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl1BodyMain.contains("crl1"));
        String cl2BodyMain = new RestHelper(this.cl2Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl2BodyMain.contains("crl2"));
        try (TransportClient tc = this.getInternalTransportClient(this.cl1Info, Settings.EMPTY);){
            tc.index(((IndexRequest)new IndexRequest("coordinating").type("coordinating").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("abc").type("abc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
        }
        tc = this.getInternalTransportClient(this.cl2Info, Settings.EMPTY);
        var4_4 = null;
        try {
            tc.index(((IndexRequest)new IndexRequest("remote").type("remote").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tc != null) {
                if (var4_4 != null) {
                    try {
                        tc.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tc.close();
                }
            }
        }
        RestHelper.HttpResponse ccs = null;
        System.out.println("###################### kibana indices agg");
        String kibanaIndicesAgg = "{\"size\":0,\"aggs\":{\"indices\":{\"terms\":{\"field\":\"_index\",\"size\":100}}}}";
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("*/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertFalse((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)ccs.getBody().contains("coordinating"));
        Assert.assertTrue((boolean)ccs.getBody().contains("abc"));
        Assert.assertFalse((boolean)ccs.getBody().contains("remote"));
        ccs = new RestHelper(this.cl2Info, false, false, this.getResourceFolder()).executePostRequest("*/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertFalse((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertFalse((boolean)ccs.getBody().contains("coordinating"));
        Assert.assertFalse((boolean)ccs.getBody().contains("abc"));
        Assert.assertTrue((boolean)ccs.getBody().contains("remote"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)404L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:remo*,coo*/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)ccs.getBody().contains("remote"));
        Assert.assertTrue((boolean)ccs.getBody().contains("coordinating"));
        Assert.assertFalse((boolean)ccs.getBody().contains("abc"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:remote/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)ccs.getBody().contains("remote"));
        Assert.assertFalse((boolean)ccs.getBody().contains("coordinating"));
        Assert.assertFalse((boolean)ccs.getBody().contains("abc"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:*/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)ccs.getBody().contains("remote"));
        Assert.assertFalse((boolean)ccs.getBody().contains("coordinating"));
        Assert.assertFalse((boolean)ccs.getBody().contains("abc"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:*,*/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)ccs.getBody().contains("remote"));
        Assert.assertTrue((boolean)ccs.getBody().contains("coordinating"));
        Assert.assertTrue((boolean)ccs.getBody().contains("abc"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:remo*,ab*/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)ccs.getBody().contains("remote"));
        Assert.assertFalse((boolean)ccs.getBody().contains("coordinating"));
        Assert.assertTrue((boolean)ccs.getBody().contains("abc"));
    }

    @Test
    public void testCcsKibanaAggregationsNonAdminDnfof() throws Exception {
        this.setupCcs(new DynamicSgConfig().setSgConfig("sg_config_dnfof.yml"));
        String cl1BodyMain = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl1BodyMain.contains("crl1"));
        String cl2BodyMain = new RestHelper(this.cl2Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl2BodyMain.contains("crl2"));
        try (TransportClient tc = this.getInternalTransportClient(this.cl1Info, Settings.EMPTY);){
            tc.index(((IndexRequest)new IndexRequest("coordinating").type("coordinating").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("abc").type("abc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("twitter").type("twitter").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
        }
        tc = this.getInternalTransportClient(this.cl2Info, Settings.EMPTY);
        var4_4 = null;
        try {
            tc.index(((IndexRequest)new IndexRequest("remote").type("remote").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("analytics").type("analytics").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tc != null) {
                if (var4_4 != null) {
                    try {
                        tc.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tc.close();
                }
            }
        }
        RestHelper.HttpResponse ccs = null;
        System.out.println("###################### kibana indices agg");
        String kibanaIndicesAgg = "{\"size\":0,\"aggs\":{\"indices\":{\"terms\":{\"field\":\"_index\",\"size\":100}}}}";
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("*/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertFalse((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertTrue((boolean)ccs.getBody().contains("twitter"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"doc_count\" : 1"));
        Assert.assertFalse((boolean)ccs.getBody().contains("analytics"));
        Assert.assertFalse((boolean)ccs.getBody().contains("coordinating"));
        Assert.assertFalse((boolean)ccs.getBody().contains("abc"));
        Assert.assertFalse((boolean)ccs.getBody().contains("remote"));
        ccs = new RestHelper(this.cl2Info, false, false, this.getResourceFolder()).executePostRequest("*/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertFalse((boolean)ccs.getBody().contains("cross_cluster_two"));
        Assert.assertFalse((boolean)ccs.getBody().contains("twitter"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"doc_count\" : 1"));
        Assert.assertTrue((boolean)ccs.getBody().contains("analytics"));
        Assert.assertFalse((boolean)ccs.getBody().contains("coordinating"));
        Assert.assertFalse((boolean)ccs.getBody().contains("abc"));
        Assert.assertFalse((boolean)ccs.getBody().contains("remote"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:*,*/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two:analytics"));
        Assert.assertTrue((boolean)ccs.getBody().contains("twitter"));
        Assert.assertFalse((boolean)ccs.getBody().contains("coordinating"));
        Assert.assertFalse((boolean)ccs.getBody().contains("abc"));
        Assert.assertFalse((boolean)ccs.getBody().contains("remote"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:remo*,coo*/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:ana*,twi*/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two:analytics"));
        Assert.assertTrue((boolean)ccs.getBody().contains("twitter"));
        Assert.assertFalse((boolean)ccs.getBody().contains("coordinating"));
        Assert.assertFalse((boolean)ccs.getBody().contains("abc"));
        Assert.assertFalse((boolean)ccs.getBody().contains("remote"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:ana*,xyz*/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two:analytics"));
        Assert.assertFalse((boolean)ccs.getBody().contains("twitter"));
        Assert.assertFalse((boolean)ccs.getBody().contains("coordinating"));
        Assert.assertFalse((boolean)ccs.getBody().contains("abc"));
        Assert.assertFalse((boolean)ccs.getBody().contains("remote"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:ana*,xyz/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)404L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:*/_search?pretty", kibanaIndicesAgg, CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("cross_cluster_two:analytics"));
        Assert.assertFalse((boolean)ccs.getBody().contains("twitter"));
        Assert.assertFalse((boolean)ccs.getBody().contains("coordinating"));
        Assert.assertFalse((boolean)ccs.getBody().contains("abc"));
        Assert.assertFalse((boolean)ccs.getBody().contains("remote"));
    }

    @Test
    public void testCcsAggregations() throws Exception {
        this.setupCcs();
        String cl1BodyMain = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl1BodyMain.contains("crl1"));
        String cl2BodyMain = new RestHelper(this.cl2Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl2BodyMain.contains("crl2"));
        try (TransportClient tc = this.getInternalTransportClient(this.cl1Info, Settings.EMPTY);){
            tc.index(((IndexRequest)new IndexRequest("coordinating").type("coordinating").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("abc").type("abc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
        }
        tc = this.getInternalTransportClient(this.cl2Info, Settings.EMPTY);
        var4_4 = null;
        try {
            tc.index(((IndexRequest)new IndexRequest("remote").type("remote").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tc != null) {
                if (var4_4 != null) {
                    try {
                        tc.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tc.close();
                }
            }
        }
        RestHelper.HttpResponse ccs = null;
        System.out.println("###################### aggs");
        String agg = "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}";
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("*:*,*/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"timed_out\" : false"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl1"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl2"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"doc_count\" : 2"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"doc_count\" : 1"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("coordin*/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"timed_out\" : false"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl1"));
        Assert.assertFalse((boolean)ccs.getBody().contains("crl2"));
        Assert.assertFalse((boolean)ccs.getBody().contains("\"doc_count\" : 2"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"doc_count\" : 1"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:remo*/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"timed_out\" : false"));
        Assert.assertFalse((boolean)ccs.getBody().contains("crl1"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl2"));
        Assert.assertFalse((boolean)ccs.getBody().contains("\"doc_count\" : 2"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"doc_count\" : 1"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:notfound,*/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)404L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:*,notfound/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)404L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:notfound,notfound/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)404L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:notfou*,*/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:*,notfou*/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:not*,notf*/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("nagilum", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
    }

    @Test
    public void testCcsAggregationsDnfof() throws Exception {
        this.setupCcs(new DynamicSgConfig().setSgConfig("sg_config_dnfof.yml"));
        String cl1BodyMain = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl1BodyMain.contains("crl1"));
        String cl2BodyMain = new RestHelper(this.cl2Info, false, false, this.getResourceFolder()).executeGetRequest("", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum")).getBody();
        Assert.assertTrue((boolean)cl2BodyMain.contains("crl2"));
        try (TransportClient tc = this.getInternalTransportClient(this.cl1Info, Settings.EMPTY);){
            tc.index(((IndexRequest)new IndexRequest("coordinating").type("coordinating").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("abc").type("abc").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("twitter").type("twitter").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl1Info.clustername + "\"}", XContentType.JSON)).actionGet();
        }
        tc = this.getInternalTransportClient(this.cl2Info, Settings.EMPTY);
        var4_4 = null;
        try {
            tc.index(((IndexRequest)new IndexRequest("remote").type("remote").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
            tc.index(((IndexRequest)new IndexRequest("analytics").type("analytics").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id("0").source("{\"cluster\": \"" + this.cl2Info.clustername + "\"}", XContentType.JSON)).actionGet();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tc != null) {
                if (var4_4 != null) {
                    try {
                        tc.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tc.close();
                }
            }
        }
        RestHelper.HttpResponse ccs = null;
        System.out.println("###################### aggs");
        String agg = "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}";
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:notfound,*/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:notfound*,*/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        Assert.assertFalse((boolean)ccs.getBody().contains("security_exception"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"timed_out\" : false"));
        Assert.assertTrue((boolean)ccs.getBody().contains("crl1"));
        Assert.assertFalse((boolean)ccs.getBody().contains("crl2"));
        Assert.assertFalse((boolean)ccs.getBody().contains("\"doc_count\" : 2"));
        Assert.assertTrue((boolean)ccs.getBody().contains("\"doc_count\" : 1"));
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:*,notfound/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:notfound,notfound/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)403L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:notfou*,*/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:*,notfou*/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
        ccs = new RestHelper(this.cl1Info, false, false, this.getResourceFolder()).executePostRequest("cross_cluster_two:not*,notf*/_search?pretty", "{\"size\":0,\"aggs\":{\"clusteragg\":{\"terms\":{\"field\":\"cluster.keyword\",\"size\":100}}}}", CrossClusterSearchTests.encodeBasicHeader("twitter", "nagilum"));
        Assert.assertEquals((long)200L, (long)ccs.getStatusCode());
    }
}

