/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test;

import com.floragunn.searchguard.test.helper.file.FileHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;

public class DynamicSgConfig {
    private String searchGuardIndexName = "searchguard";
    private String sgConfig = "sg_config.yml";
    private String sgRoles = "sg_roles.yml";
    private String sgRolesMapping = "sg_roles_mapping.yml";
    private String sgInternalUsers = "sg_internal_users.yml";
    private String sgActionGroups = "sg_action_groups.yml";
    private String sgConfigAsYamlString = null;

    public String getSearchGuardIndexName() {
        return this.searchGuardIndexName;
    }

    public DynamicSgConfig setSearchGuardIndexName(String searchGuardIndexName) {
        this.searchGuardIndexName = searchGuardIndexName;
        return this;
    }

    public DynamicSgConfig setSgConfig(String sgConfig) {
        this.sgConfig = sgConfig;
        return this;
    }

    public DynamicSgConfig setSgConfigAsYamlString(String sgConfigAsYamlString) {
        this.sgConfigAsYamlString = sgConfigAsYamlString;
        return this;
    }

    public DynamicSgConfig setSgRoles(String sgRoles) {
        this.sgRoles = sgRoles;
        return this;
    }

    public DynamicSgConfig setSgRolesMapping(String sgRolesMapping) {
        this.sgRolesMapping = sgRolesMapping;
        return this;
    }

    public DynamicSgConfig setSgInternalUsers(String sgInternalUsers) {
        this.sgInternalUsers = sgInternalUsers;
        return this;
    }

    public DynamicSgConfig setSgActionGroups(String sgActionGroups) {
        this.sgActionGroups = sgActionGroups;
        return this;
    }

    public List<IndexRequest> getDynamicConfig(String folder) {
        String prefix = folder == null ? "" : folder + "/";
        ArrayList<IndexRequest> ret = new ArrayList<IndexRequest>();
        ret.add(((IndexRequest)new IndexRequest(this.searchGuardIndexName).type("sg").id("config").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{"config", this.sgConfigAsYamlString == null ? FileHelper.readYamlContent(prefix + this.sgConfig) : FileHelper.readYamlContentFromString(this.sgConfigAsYamlString)}));
        ret.add(((IndexRequest)new IndexRequest(this.searchGuardIndexName).type("sg").id("actiongroups").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{"actiongroups", FileHelper.readYamlContent(prefix + this.sgActionGroups)}));
        ret.add(((IndexRequest)new IndexRequest(this.searchGuardIndexName).type("sg").id("internalusers").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{"internalusers", FileHelper.readYamlContent(prefix + this.sgInternalUsers)}));
        ret.add(((IndexRequest)new IndexRequest(this.searchGuardIndexName).type("sg").id("roles").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{"roles", FileHelper.readYamlContent(prefix + this.sgRoles)}));
        ret.add(((IndexRequest)new IndexRequest(this.searchGuardIndexName).type("sg").id("rolesmapping").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(new Object[]{"rolesmapping", FileHelper.readYamlContent(prefix + this.sgRolesMapping)}));
        return Collections.unmodifiableList(ret);
    }
}

