/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.cluster;

import com.floragunn.searchguard.SearchGuardPlugin;
import com.floragunn.searchguard.test.plugin.UserInjectorPlugin;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.elasticsearch.index.reindex.ReindexPlugin;
import org.elasticsearch.join.ParentJoinPlugin;
import org.elasticsearch.percolator.PercolatorPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.script.mustache.MustachePlugin;
import org.elasticsearch.search.aggregations.matrix.MatrixAggregationPlugin;
import org.elasticsearch.transport.Netty4Plugin;

public enum ClusterConfiguration {
    DEFAULT(new NodeSettings(true, false, false), new NodeSettings(false, true, false), new NodeSettings(false, true, false)),
    SINGLENODE(new NodeSettings(true, true, false)),
    CLIENTNODE(new NodeSettings(true, false, false), new NodeSettings(false, true, false), new NodeSettings(false, true, false), new NodeSettings(false, false, false)),
    USERINJECTOR(new NodeSettings(true, false, false, Lists.newArrayList((Object[])new Class[]{UserInjectorPlugin.class})), new NodeSettings(false, true, false, Lists.newArrayList((Object[])new Class[]{UserInjectorPlugin.class})), new NodeSettings(false, true, false, Lists.newArrayList((Object[])new Class[]{UserInjectorPlugin.class})));

    private List<NodeSettings> nodeSettings = new LinkedList<NodeSettings>();

    private ClusterConfiguration(NodeSettings ... settings) {
        this.nodeSettings.addAll(Arrays.asList(settings));
    }

    public List<NodeSettings> getNodeSettings() {
        return Collections.unmodifiableList(this.nodeSettings);
    }

    public int getNodes() {
        return this.nodeSettings.size();
    }

    public int getMasterNodes() {
        return (int)this.nodeSettings.stream().filter(a -> a.masterNode).count();
    }

    public int getDataNodes() {
        return (int)this.nodeSettings.stream().filter(a -> a.dataNode).count();
    }

    public int getClientNodes() {
        return (int)this.nodeSettings.stream().filter(a -> !a.masterNode && !a.dataNode).count();
    }

    public static class NodeSettings {
        public boolean masterNode;
        public boolean dataNode;
        public boolean tribeNode;
        public List<Class<? extends Plugin>> plugins = Lists.newArrayList((Object[])new Class[]{Netty4Plugin.class, SearchGuardPlugin.class, MatrixAggregationPlugin.class, MustachePlugin.class, ParentJoinPlugin.class, PercolatorPlugin.class, ReindexPlugin.class});

        public NodeSettings(boolean masterNode, boolean dataNode, boolean tribeNode) {
            this.masterNode = masterNode;
            this.dataNode = dataNode;
            this.tribeNode = tribeNode;
        }

        public NodeSettings(boolean masterNode, boolean dataNode, boolean tribeNode, List<Class<? extends Plugin>> additionalPlugins) {
            this(masterNode, dataNode, tribeNode);
            this.plugins.addAll(additionalPlugins);
        }

        public Class<? extends Plugin>[] getPlugins() {
            return this.plugins.toArray(new Class[0]);
        }
    }
}

