/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.cluster;

import com.floragunn.searchguard.test.NodeSettingsSupplier;
import com.floragunn.searchguard.test.helper.cluster.ClusterConfiguration;
import com.floragunn.searchguard.test.helper.cluster.ClusterInfo;
import com.floragunn.searchguard.test.helper.network.SocketUtils;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.PluginAwareNode;
import org.junit.Assert;

public final class ClusterHelper {
    protected final Logger log = LogManager.getLogger(ClusterHelper.class);
    protected final List<PluginAwareNode> esNodes = new LinkedList<PluginAwareNode>();
    private final String clustername;

    public ClusterHelper(String clustername) {
        this.clustername = clustername;
    }

    public final ClusterInfo startCluster(NodeSettingsSupplier nodeSettingsSupplier, ClusterConfiguration clusterConfiguration) throws Exception {
        return this.startCluster(nodeSettingsSupplier, clusterConfiguration, 10, null);
    }

    public final synchronized ClusterInfo startCluster(NodeSettingsSupplier nodeSettingsSupplier, ClusterConfiguration clusterConfiguration, int timeout, Integer nodes) throws Exception {
        if (!this.esNodes.isEmpty()) {
            throw new RuntimeException("There are still " + this.esNodes.size() + " nodes instantiated, close them first.");
        }
        FileUtils.deleteDirectory((File)new File("data/" + this.clustername));
        List<ClusterConfiguration.NodeSettings> internalNodeSettings = clusterConfiguration.getNodeSettings();
        String forkno = System.getProperty("forkno");
        int forkNumber = 1;
        if (forkno != null && forkno.length() > 0) {
            forkNumber = Integer.parseInt(forkno.split("_")[1]);
        }
        int min = 1024 + forkNumber * 5000;
        int max = 1024 + (forkNumber + 1) * 5000 - 1;
        SortedSet<Integer> freePorts = SocketUtils.findAvailableTcpPorts(internalNodeSettings.size() * 2, min, max);
        assert (freePorts.size() == internalNodeSettings.size() * 2);
        TreeSet<Integer> tcpPorts = new TreeSet<Integer>();
        freePorts.stream().limit(internalNodeSettings.size()).forEach(el -> tcpPorts.add((Integer)el));
        Iterator tcpPortsIt = tcpPorts.iterator();
        TreeSet httpPorts = new TreeSet();
        freePorts.stream().skip(internalNodeSettings.size()).limit(internalNodeSettings.size()).forEach(el -> httpPorts.add(el));
        Iterator httpPortsIt = httpPorts.iterator();
        System.out.println("tcpPorts: " + tcpPorts + "/httpPorts: " + httpPorts + " for (" + min + "-" + max + ") fork " + forkNumber);
        final CountDownLatch latch = new CountDownLatch(internalNodeSettings.size());
        final AtomicReference err = new AtomicReference();
        for (int i = 0; i < internalNodeSettings.size(); ++i) {
            ClusterConfiguration.NodeSettings setting = internalNodeSettings.get(i);
            final PluginAwareNode node = new PluginAwareNode(setting.masterNode, this.getMinimumNonSgNodeSettingsBuilder(i, setting.masterNode, setting.dataNode, setting.tribeNode, internalNodeSettings.size(), clusterConfiguration.getMasterNodes(), tcpPorts, (Integer)tcpPortsIt.next(), (Integer)httpPortsIt.next()).put(nodeSettingsSupplier == null ? Settings.Builder.EMPTY_SETTINGS : nodeSettingsSupplier.get(i)).build(), setting.getPlugins());
            System.out.println(node.settings());
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        node.start();
                        latch.countDown();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ClusterHelper.this.log.error("Unable to start node: " + e);
                        err.set(e);
                        latch.countDown();
                    }
                }
            }).start();
            this.esNodes.add(node);
        }
        latch.await();
        if (err.get() != null) {
            throw new RuntimeException("Could not start all nodes " + err.get(), (Throwable)err.get());
        }
        ClusterInfo cInfo = this.waitForCluster(ClusterHealthStatus.GREEN, TimeValue.timeValueSeconds((long)timeout), nodes == null ? this.esNodes.size() : nodes.intValue());
        cInfo.numNodes = internalNodeSettings.size();
        cInfo.clustername = this.clustername;
        return cInfo;
    }

    public final void stopCluster() throws Exception {
        this.esNodes.stream().filter(n -> !n.isMasterEligible()).forEach(node -> ClusterHelper.closeNode(node));
        this.esNodes.stream().filter(n -> n.isMasterEligible()).forEach(node -> ClusterHelper.closeNode(node));
        this.esNodes.clear();
        FileUtils.deleteDirectory((File)new File("data/" + this.clustername));
    }

    private static void closeNode(Node node) {
        try {
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            Configurator.shutdown((LoggerContext)context);
            node.close();
            Thread.sleep(250L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Client nodeClient() {
        return this.esNodes.get(0).client();
    }

    public ClusterInfo waitForCluster(ClusterHealthStatus status, TimeValue timeout, int expectedNodeCount) throws IOException {
        ClusterInfo clusterInfo;
        block9: {
            if (this.esNodes.isEmpty()) {
                throw new RuntimeException("List of nodes was empty.");
            }
            clusterInfo = new ClusterInfo();
            Node node = this.esNodes.get(0);
            Client client = node.client();
            try {
                this.log.debug("waiting for cluster state {} and {} nodes", (Object)status.name(), (Object)expectedNodeCount);
                ClusterHealthResponse healthResponse = (ClusterHealthResponse)((ClusterHealthRequestBuilder)client.admin().cluster().prepareHealth(new String[0]).setWaitForStatus(status).setTimeout(timeout).setMasterNodeTimeout(timeout)).setWaitForNodes("" + expectedNodeCount).execute().actionGet();
                if (healthResponse.isTimedOut()) {
                    throw new IOException("cluster state is " + healthResponse.getStatus().name() + " with " + healthResponse.getNumberOfNodes() + " nodes");
                }
                this.log.debug("... cluster state ok " + healthResponse.getStatus().name() + " with " + healthResponse.getNumberOfNodes() + " nodes");
                Assert.assertEquals((long)expectedNodeCount, (long)healthResponse.getNumberOfNodes());
                NodesInfoResponse res = (NodesInfoResponse)client.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet();
                List nodes = res.getNodes();
                List dataNodes = nodes.stream().filter(n -> n.getNode().getRoles().contains(DiscoveryNode.Role.DATA) && !n.getNode().getRoles().contains(DiscoveryNode.Role.MASTER)).collect(Collectors.toList());
                List clientNodes = nodes.stream().filter(n -> !n.getNode().getRoles().contains(DiscoveryNode.Role.MASTER) && !n.getNode().getRoles().contains(DiscoveryNode.Role.DATA)).collect(Collectors.toList());
                if (!clientNodes.isEmpty()) {
                    NodeInfo nodeInfo = (NodeInfo)clientNodes.get(0);
                    if (nodeInfo.getHttp() == null || nodeInfo.getHttp().address() == null) {
                        throw new RuntimeException("no http host/port for client node");
                    }
                    TransportAddress his = nodeInfo.getHttp().address().publishAddress();
                    clusterInfo.httpPort = his.getPort();
                    clusterInfo.httpHost = his.getAddress();
                    clusterInfo.httpAdresses.add(his);
                    TransportAddress is = nodeInfo.getTransport().getAddress().publishAddress();
                    clusterInfo.nodePort = is.getPort();
                    clusterInfo.nodeHost = is.getAddress();
                    break block9;
                }
                if (!dataNodes.isEmpty()) {
                    for (NodeInfo nodeInfo : dataNodes) {
                        TransportAddress is = nodeInfo.getTransport().getAddress().publishAddress();
                        clusterInfo.nodePort = is.getPort();
                        clusterInfo.nodeHost = is.getAddress();
                        if (nodeInfo.getHttp() == null || nodeInfo.getHttp().address() == null) continue;
                        TransportAddress his = nodeInfo.getHttp().address().publishAddress();
                        clusterInfo.httpPort = his.getPort();
                        clusterInfo.httpHost = his.getAddress();
                        clusterInfo.httpAdresses.add(his);
                        break block9;
                    }
                    break block9;
                }
                for (NodeInfo nodeInfo : nodes) {
                    TransportAddress is = nodeInfo.getTransport().getAddress().publishAddress();
                    clusterInfo.nodePort = is.getPort();
                    clusterInfo.nodeHost = is.getAddress();
                    if (nodeInfo.getHttp() == null || nodeInfo.getHttp().address() == null) continue;
                    TransportAddress his = nodeInfo.getHttp().address().publishAddress();
                    clusterInfo.httpPort = his.getPort();
                    clusterInfo.httpHost = his.getAddress();
                    clusterInfo.httpAdresses.add(his);
                    break;
                }
            }
            catch (ElasticsearchTimeoutException e) {
                throw new IOException("timeout, cluster does not respond to health request, cowardly refusing to continue with operations");
            }
        }
        return clusterInfo;
    }

    private Settings.Builder getMinimumNonSgNodeSettingsBuilder(int nodenum, boolean masterNode, boolean dataNode, boolean tribeNode, int nodeCount, int masterCount, SortedSet<Integer> tcpPorts, int tcpPort, int httpPort) {
        return Settings.builder().put("node.name", "node_" + this.clustername + "_num" + nodenum).put("node.data", dataNode).put("node.master", masterNode).put("cluster.name", this.clustername).put("path.data", "data/" + this.clustername + "/data").put("path.logs", "data/" + this.clustername + "/logs").put("node.max_local_storage_nodes", nodeCount).put("discovery.zen.minimum_master_nodes", this.minMasterNodes(masterCount)).put("discovery.zen.no_master_block", "all").put("discovery.zen.fd.ping_timeout", "5s").put("discovery.initial_state_timeout", "8s").putList("discovery.zen.ping.unicast.hosts", tcpPorts.stream().map(s -> "127.0.0.1:" + s).collect(Collectors.toList())).put("transport.tcp.port", tcpPort).put("http.port", httpPort).put("http.enabled", true).put("cluster.routing.allocation.disk.threshold_enabled", false).put("http.cors.enabled", true).put("path.home", ".");
    }

    private int minMasterNodes(int masterEligibleNodes) {
        if (masterEligibleNodes <= 0) {
            throw new IllegalArgumentException("no master eligible nodes");
        }
        return masterEligibleNodes / 2 + 1;
    }

    static {
        System.setProperty("es.enforce.bootstrap.checks", "true");
        System.setProperty("sg.default_init.dir", new File("./sgconfig").getAbsolutePath());
    }
}

