/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.file;

import com.floragunn.searchguard.support.SearchGuardDeprecationHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class FileHelper {
    protected static final Logger log = LogManager.getLogger(FileHelper.class);

    public static KeyStore getKeystoreFromClassPath(String fileNameFromClasspath, String password) throws Exception {
        Path path = FileHelper.getAbsoluteFilePathFromClassPath(fileNameFromClasspath);
        if (path == null) {
            return null;
        }
        KeyStore ks = KeyStore.getInstance("JKS");
        try (FileInputStream fin = new FileInputStream(path.toFile());){
            ks.load(fin, password == null || password.isEmpty() ? null : password.toCharArray());
        }
        return ks;
    }

    public static Path getAbsoluteFilePathFromClassPath(String fileNameFromClasspath) {
        File file = null;
        URL fileUrl = FileHelper.class.getClassLoader().getResource(fileNameFromClasspath);
        if (fileUrl != null) {
            try {
                file = new File(URLDecoder.decode(fileUrl.getFile(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
            if (file.exists() && file.canRead()) {
                return Paths.get(file.getAbsolutePath(), new String[0]);
            }
            log.error("Cannot read from {}, maybe the file does not exists? ", (Object)file.getAbsolutePath());
        } else {
            log.error("Failed to load " + fileNameFromClasspath);
        }
        return null;
    }

    public static final String loadFile(String file) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtils.copy((InputStream)FileHelper.class.getResourceAsStream("/" + file), (Writer)sw, (Charset)StandardCharsets.UTF_8);
        return sw.toString();
    }

    public static BytesReference readYamlContent(String file) {
        XContentParser parser = null;
        try {
            parser = XContentFactory.xContent((XContentType)XContentType.YAML).createParser(NamedXContentRegistry.EMPTY, SearchGuardDeprecationHandler.INSTANCE, (Reader)new StringReader(FileHelper.loadFile(file)));
            parser.nextToken();
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.copyCurrentStructure(parser);
            BytesReference bytesReference = BytesReference.bytes((XContentBuilder)builder);
            return bytesReference;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static BytesReference readYamlContentFromString(String yaml) {
        XContentParser parser = null;
        try {
            parser = XContentFactory.xContent((XContentType)XContentType.YAML).createParser(NamedXContentRegistry.EMPTY, SearchGuardDeprecationHandler.INSTANCE, (Reader)new StringReader(yaml));
            parser.nextToken();
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.copyCurrentStructure(parser);
            BytesReference bytesReference = BytesReference.bytes((XContentBuilder)builder);
            return bytesReference;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

