/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.test.helper.rest;

import com.floragunn.searchguard.test.helper.cluster.ClusterInfo;
import com.floragunn.searchguard.test.helper.file.FileHelper;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RestHelper {
    protected final Logger log = LogManager.getLogger(RestHelper.class);
    public boolean enableHTTPClientSSL = true;
    public boolean enableHTTPClientSSLv3Only = false;
    public boolean sendHTTPClientCertificate = false;
    public boolean trustHTTPServerCertificate = true;
    public String keystore = "node-0-keystore.jks";
    public final String prefix;
    private ClusterInfo clusterInfo;

    public RestHelper(ClusterInfo clusterInfo, String prefix) {
        this.clusterInfo = clusterInfo;
        this.prefix = prefix;
    }

    public RestHelper(ClusterInfo clusterInfo, boolean enableHTTPClientSSL, boolean trustHTTPServerCertificate, String prefix) {
        this.clusterInfo = clusterInfo;
        this.enableHTTPClientSSL = enableHTTPClientSSL;
        this.trustHTTPServerCertificate = trustHTTPServerCertificate;
        this.prefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeSimpleRequest(String request) throws Exception {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = this.getHTTPClient();
            response = httpClient.execute((HttpUriRequest)new HttpGet(this.getHttpServerUri() + "/" + request));
            if (response.getStatusLine().getStatusCode() >= 300) {
                throw new Exception("Statuscode " + response.getStatusLine().getStatusCode());
            }
            String string = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            return string;
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
    }

    public HttpResponse executeGetRequest(String request, Header ... header) throws Exception {
        return this.executeRequest((HttpUriRequest)new HttpGet(this.getHttpServerUri() + "/" + request), header);
    }

    public HttpResponse executeHeadRequest(String request, Header ... header) throws Exception {
        return this.executeRequest((HttpUriRequest)new HttpHead(this.getHttpServerUri() + "/" + request), header);
    }

    public HttpResponse executeOptionsRequest(String request) throws Exception {
        return this.executeRequest((HttpUriRequest)new HttpOptions(this.getHttpServerUri() + "/" + request), new Header[0]);
    }

    public HttpResponse executePutRequest(String request, String body, Header ... header) throws Exception {
        HttpPut uriRequest = new HttpPut(this.getHttpServerUri() + "/" + request);
        if (body != null && !body.isEmpty()) {
            uriRequest.setEntity((HttpEntity)new StringEntity(body));
        }
        return this.executeRequest((HttpUriRequest)uriRequest, header);
    }

    public HttpResponse executeDeleteRequest(String request, Header ... header) throws Exception {
        return this.executeRequest((HttpUriRequest)new HttpDelete(this.getHttpServerUri() + "/" + request), header);
    }

    public HttpResponse executePostRequest(String request, String body, Header ... header) throws Exception {
        HttpPost uriRequest = new HttpPost(this.getHttpServerUri() + "/" + request);
        if (body != null && !body.isEmpty()) {
            uriRequest.setEntity((HttpEntity)new StringEntity(body));
        }
        return this.executeRequest((HttpUriRequest)uriRequest, header);
    }

    public HttpResponse executePatchRequest(String request, String body, Header ... header) throws Exception {
        HttpPatch uriRequest = new HttpPatch(this.getHttpServerUri() + "/" + request);
        if (body != null && !body.isEmpty()) {
            uriRequest.setEntity((HttpEntity)new StringEntity(body));
        }
        return this.executeRequest((HttpUriRequest)uriRequest, header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse executeRequest(HttpUriRequest uriRequest, Header ... header) throws Exception {
        try (CloseableHttpClient httpClient = null;){
            httpClient = this.getHTTPClient();
            if (header != null && header.length > 0) {
                for (int i = 0; i < header.length; ++i) {
                    Header h = header[i];
                    uriRequest.addHeader(h);
                }
            }
            if (!uriRequest.containsHeader("Content-Type")) {
                uriRequest.addHeader("Content-Type", "application/json");
            }
            HttpResponse res = new HttpResponse(httpClient.execute(uriRequest));
            this.log.debug(res.getBody());
            HttpResponse httpResponse = res;
            return httpResponse;
        }
    }

    protected final String getHttpServerUri() {
        String address = "http" + (this.enableHTTPClientSSL ? "s" : "") + "://" + this.clusterInfo.httpHost + ":" + this.clusterInfo.httpPort;
        this.log.debug("Connect to {}", (Object)address);
        return address;
    }

    protected final CloseableHttpClient getHTTPClient() throws Exception {
        HttpClientBuilder hcb = HttpClients.custom();
        if (this.enableHTTPClientSSL) {
            this.log.debug("Configure HTTP client with SSL");
            if (this.prefix != null && !this.keystore.contains("/")) {
                this.keystore = this.prefix + "/" + this.keystore;
            }
            String keyStorePath = FileHelper.getAbsoluteFilePathFromClassPath(this.keystore).toFile().getParent();
            KeyStore myTrustStore = KeyStore.getInstance("JKS");
            myTrustStore.load(new FileInputStream(keyStorePath + "/truststore.jks"), "changeit".toCharArray());
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(FileHelper.getAbsoluteFilePathFromClassPath(this.keystore).toFile()), "changeit".toCharArray());
            SSLContextBuilder sslContextbBuilder = SSLContexts.custom();
            if (this.trustHTTPServerCertificate) {
                sslContextbBuilder.loadTrustMaterial(myTrustStore, null);
            }
            if (this.sendHTTPClientCertificate) {
                sslContextbBuilder.loadKeyMaterial(keyStore, "changeit".toCharArray());
            }
            SSLContext sslContext = sslContextbBuilder.build();
            String[] protocols = null;
            protocols = this.enableHTTPClientSSLv3Only ? new String[]{"SSLv3"} : new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, protocols, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            hcb.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        }
        hcb.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(60000).build());
        return hcb.build();
    }

    public class HttpResponse {
        private final CloseableHttpResponse inner;
        private final String body;
        private final Header[] header;
        private final int statusCode;
        private final String statusReason;

        public HttpResponse(CloseableHttpResponse inner) throws IllegalStateException, IOException {
            this.inner = inner;
            HttpEntity entity = inner.getEntity();
            this.body = entity == null ? "" : IOUtils.toString((InputStream)entity.getContent(), (Charset)StandardCharsets.UTF_8);
            this.header = inner.getAllHeaders();
            this.statusCode = inner.getStatusLine().getStatusCode();
            this.statusReason = inner.getStatusLine().getReasonPhrase();
            inner.close();
        }

        public CloseableHttpResponse getInner() {
            return this.inner;
        }

        public String getBody() {
            return this.body;
        }

        public Header[] getHeader() {
            return this.header;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getStatusReason() {
            return this.statusReason;
        }

        public List<Header> getHeaders() {
            return this.header == null ? Collections.emptyList() : Arrays.asList(this.header);
        }

        public String toString() {
            return "HttpResponse [inner=" + this.inner + ", body=" + this.body + ", header=" + Arrays.toString(this.header) + ", statusCode=" + this.statusCode + ", statusReason=" + this.statusReason + "]";
        }
    }
}

