/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.ext.declarative.api.group;

import com.fluxtion.ext.declarative.api.numeric.NumericFunctionStateful;
import com.fluxtion.ext.declarative.api.numeric.NumericFunctionStateless;

public class AggregateFunctions {
    public static Class<AggregateAverage> Avg = AggregateAverage.class;
    public static Class<AggregateCount> Count = AggregateCount.class;
    public static Class<AggregateMax> Max = AggregateMax.class;
    public static Class<AggregateMin> Min = AggregateMin.class;
    public static Class<AggregateSum> Sum = AggregateSum.class;
    public static Class<AggregatePassThrough> Set = AggregatePassThrough.class;

    public static class AggregateAverage
    implements NumericFunctionStateful {
        private int count;
        private double sum;

        public double calcAverage(double newValue, double oldAverage) {
            ++this.count;
            this.sum += newValue;
            return this.sum / (double)this.count;
        }

        @Override
        public double reset() {
            this.count = 0;
            this.sum = 0.0;
            return Double.NaN;
        }
    }

    public static class AggregateMax
    implements NumericFunctionStateless {
        public static int maximum(int newValue, int oldValue) {
            return Math.max(newValue, oldValue);
        }
    }

    public static class AggregateMin
    implements NumericFunctionStateless {
        public static int minimum(int newValue, int oldValue) {
            return Math.min(newValue, oldValue);
        }
    }

    public static class AggregateCount
    implements NumericFunctionStateless {
        public static int increment(int newValue, int oldValue) {
            return ++oldValue;
        }
    }

    public static class AggregatePassThrough
    implements NumericFunctionStateless {
        public static double set(double newValue, double oldSum) {
            return newValue;
        }
    }

    public static class AggregateSum
    implements NumericFunctionStateless {
        public static double calcSum(double newValue, double oldSum) {
            return newValue + oldSum;
        }
    }
}

