/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.ext.declarative.api.log;

import com.fluxtion.api.annotations.EventHandler;
import com.fluxtion.api.annotations.Initialise;
import com.fluxtion.api.annotations.OnParentUpdate;
import com.fluxtion.ext.declarative.api.log.LogControlEvent;
import com.fluxtion.ext.declarative.api.log.MsgBuilder;
import java.util.Arrays;

public class AsciiConsoleLogger {
    private static final int MIN_CAPACITY_BUFFER = 512;
    public int initCapacity = 512;
    private byte[] buffer;
    private byte[] metaBuffer;
    public MsgBuilder[] msgBuilders;
    private boolean logName;
    private StringBuilder metaSb;
    private boolean logTime;
    private boolean logLevel;
    private boolean logThread;

    @Initialise
    public void init() {
        int multiplier = this.msgBuilders == null ? 1 : this.msgBuilders.length;
        this.initCapacity = Math.max(this.initCapacity, multiplier * 512);
        this.buffer = new byte[this.initCapacity];
        this.metaBuffer = new byte[512];
        this.logName = true;
        this.logTime = true;
        this.logLevel = true;
        this.logThread = true;
        this.metaSb = new StringBuilder(64);
    }

    public void addMsgBuilder(MsgBuilder sink) {
        if (this.msgBuilders == null) {
            this.msgBuilders = new MsgBuilder[0];
        }
        this.msgBuilders = Arrays.copyOf(this.msgBuilders, this.msgBuilders.length + 1);
        this.msgBuilders[this.msgBuilders.length - 1] = sink;
    }

    @EventHandler(filterString="RECORD_NAME")
    public void controlIdLogging(LogControlEvent control) {
        this.logName = control.isEnabled();
    }

    @EventHandler(filterString="RECORD_TIME")
    public void controlTimeLogging(LogControlEvent control) {
        this.logTime = control.isEnabled();
    }

    @EventHandler(filterString="RECORD_LEVEL")
    public void controlLevelLogging(LogControlEvent control) {
        this.logLevel = control.isEnabled();
    }

    @OnParentUpdate(value="msgBuilders")
    public void publishMessage(MsgBuilder msg) {
        this.logTime();
        this.logThread();
        this.logLevel(msg);
        this.logName(msg);
        int msgSize = msg.length();
        if (this.buffer.length < msgSize) {
            this.buffer = new byte[msgSize + 512];
        }
        msg.copyAsAscii(this.buffer);
        this.writeMetaMessage();
        System.out.write(this.buffer, 0, msgSize);
        this.metaSb.delete(0, this.metaSb.length());
    }

    public void writeMetaMessage() {
        int msgSize = this.metaSb.length();
        if (msgSize < 1) {
            return;
        }
        if (this.metaBuffer.length < msgSize) {
            this.metaBuffer = new byte[msgSize * 2];
        }
        for (int i = 0; i < msgSize; ++i) {
            this.metaBuffer[i] = (byte)this.metaSb.charAt(i);
        }
        System.out.write(this.metaBuffer, 0, msgSize);
    }

    private void logTime() {
        if (this.logTime) {
            long now = System.currentTimeMillis();
            long millis = now % 1000L;
            long seconds = now / 1000L;
            long s = seconds % 60L;
            long m = seconds / 60L % 60L;
            long h = seconds / 3600L % 24L;
            this.add2dig(h).append(':');
            this.add2dig(m).append(':');
            this.add2dig(s).append('.');
            this.add3dig(millis).append(' ');
        }
    }

    private StringBuilder add3dig(long num) {
        if (num < 100L) {
            this.metaSb.append('0');
        }
        return this.add2dig(num);
    }

    private StringBuilder add2dig(long num) {
        if (num < 10L) {
            this.metaSb.append('0');
        }
        return this.metaSb.append(num);
    }

    private void logName(MsgBuilder msg) {
        if (this.logName & msg.name != null) {
            this.metaSb.append('[').append(msg.name).append(']').append(' ');
        }
    }

    private void logLevel(MsgBuilder msg) {
        if (!this.logLevel) {
            return;
        }
        switch (msg.logLevel) {
            case 0: {
                this.metaSb.append("FATAL ");
                break;
            }
            case 1: {
                this.metaSb.append("ERROR ");
                break;
            }
            case 2: {
                this.metaSb.append("WARNING ");
                break;
            }
            case 3: {
                this.metaSb.append("INFO ");
                break;
            }
            case 4: {
                this.metaSb.append("DEBUG ");
                break;
            }
            default: {
                this.metaSb.append("TRACE ");
            }
        }
    }

    private void logThread() {
        if (this.logThread) {
            this.metaSb.append('[').append(Thread.currentThread().getName()).append("] ");
        }
    }
}

