/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.ext.declarative.api.log;

import com.fluxtion.api.event.Event;
import com.fluxtion.ext.declarative.api.log.LogService;

public final class LogControlEvent
extends Event {
    public static final String FILTER = "CHANGE_FILTER";
    public static final String PROVIDER = "CHANGE_LOG_PROVIDER";
    public static final String LEVEL = "CHANGE_LEVEL";
    public static final String LOG_TIME = "RECORD_TIME";
    public static final String LOG_NAME = "RECORD_NAME";
    public static final String LOG_LEVEL = "RECORD_LEVEL";
    private boolean enabled;
    private int level;
    private String[] filter;
    private LogService logService;

    private LogControlEvent(String controlType) {
        this.filterString = controlType;
    }

    private LogControlEvent(int controlType) {
        this.filterId = controlType;
    }

    public static LogControlEvent recordMsgBuilderId(boolean enabled) {
        LogControlEvent logControlEvent = new LogControlEvent(LOG_NAME);
        logControlEvent.enabled = enabled;
        return logControlEvent;
    }

    public static LogControlEvent recordMsgBuildTime(boolean enabled) {
        LogControlEvent logControlEvent = new LogControlEvent(LOG_TIME);
        logControlEvent.enabled = enabled;
        return logControlEvent;
    }

    public static LogControlEvent recordMsgLogLevel(boolean enabled) {
        LogControlEvent logControlEvent = new LogControlEvent(LOG_LEVEL);
        logControlEvent.enabled = enabled;
        return logControlEvent;
    }

    public static LogControlEvent disableIdFiltering() {
        LogControlEvent logControlEvent = new LogControlEvent(FILTER);
        logControlEvent.enabled = false;
        return logControlEvent;
    }

    public static LogControlEvent enableIdFiltering(String[] filters) {
        LogControlEvent logControlEvent = new LogControlEvent(FILTER);
        logControlEvent.enabled = true;
        logControlEvent.filter = filters;
        return logControlEvent;
    }

    public static LogControlEvent disableLevelFiltering() {
        LogControlEvent logControlEvent = new LogControlEvent(LEVEL);
        logControlEvent.enabled = false;
        return logControlEvent;
    }

    public static LogControlEvent enableLevelFiltering(int level) {
        LogControlEvent logControlEvent = new LogControlEvent(LEVEL);
        logControlEvent.enabled = true;
        logControlEvent.level = level;
        return logControlEvent;
    }

    public static LogControlEvent setLogService(LogService service) {
        LogControlEvent logControlEvent = new LogControlEvent(PROVIDER);
        logControlEvent.logService = service;
        return logControlEvent;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getLevel() {
        return this.level;
    }

    public String[] getFilter() {
        return this.filter;
    }

    public LogService getLogService() {
        return this.logService;
    }
}

