/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.ext.declarative.api.log;

import com.fluxtion.api.annotations.AfterEvent;
import com.fluxtion.api.annotations.EventHandler;
import com.fluxtion.api.annotations.Initialise;
import com.fluxtion.ext.declarative.api.log.LogControlEvent;
import com.fluxtion.ext.declarative.api.log.MsgSink;
import java.util.Arrays;

public abstract class MsgBuilder {
    public String name;
    public int logLevel = 3;
    private String _name;
    private boolean filterMatched;
    private boolean levelMatched;
    private boolean goodToLog;
    public MsgSink msgSink;
    private static final int MIN_CAPACITY = 256;
    public int initCapacity = 256;

    public String getName() {
        return this._name;
    }

    public boolean isGoodToLog() {
        return this.goodToLog;
    }

    public int length() {
        return this.msgSink.length();
    }

    public void copyAsAscii(byte[] target) {
        this.msgSink.copyAsAscii(target);
    }

    public void setMsgSink(MsgSink msgSink) {
        this.msgSink = msgSink;
    }

    @EventHandler(filterString="CHANGE_FILTER", propagate=false)
    public boolean controlLogIdFilter(LogControlEvent control) {
        control.getFilter();
        this.filterMatched = Arrays.stream(control.getFilter()).anyMatch(s -> this._name.startsWith((String)s));
        if (!(this.filterMatched & this.levelMatched)) {
            this.goodToLog = false;
        }
        return false;
    }

    @EventHandler(filterString="CHANGE_LEVEL", propagate=false)
    public boolean controlLogLevelFilter(LogControlEvent control) {
        boolean bl = this.levelMatched = this.logLevel < control.getLevel();
        if (!(this.filterMatched & this.levelMatched)) {
            this.goodToLog = false;
        }
        return false;
    }

    @AfterEvent
    public void afterEvent() {
        this.goodToLog = this.filterMatched & this.levelMatched;
        if (this.goodToLog) {
            this.msgSink.resetLogBuffer();
        }
    }

    @Initialise
    public void init() {
        if (this.msgSink == null) {
            this.msgSink = new MsgSink();
            this.msgSink.initCapacity = Math.max(256, this.initCapacity);
            this.msgSink.init();
        }
        this._name = this.name;
        this.filterMatched = true;
        this.levelMatched = true;
        this.goodToLog = true;
    }
}

