/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.ext.declarative.api.log;

import com.fluxtion.api.annotations.Initialise;

public class MsgSink {
    private static final int MIN_CAPACITY = 256;
    public int initCapacity = 256;
    private StringBuilder sb;

    public int length() {
        return this.sb.length();
    }

    public void copyAsAscii(byte[] target) {
        int msgSize = this.sb.length();
        for (int i = 0; i < msgSize; ++i) {
            target[i] = (byte)this.sb.charAt(i);
        }
    }

    @Initialise
    public void init() {
        this.sb = new StringBuilder(Math.max(256, this.initCapacity));
    }

    public void resetLogBuffer() {
        this.sb.delete(0, this.sb.length());
    }

    public MsgSink append(Object obj) {
        this.sb.append(obj);
        return this;
    }

    public MsgSink append(String str) {
        this.sb.append(str);
        return this;
    }

    public MsgSink append(StringBuffer sb) {
        sb.append(sb);
        return this;
    }

    public MsgSink append(CharSequence s) {
        this.sb.append(s);
        return this;
    }

    public MsgSink append(CharSequence s, int start, int end) {
        this.sb.append(s, start, end);
        return this;
    }

    public MsgSink append(char[] str) {
        this.sb.append(str);
        return this;
    }

    public MsgSink append(char[] str, int offset, int len) {
        this.sb.append(str, offset, len);
        return this;
    }

    public MsgSink append(boolean b) {
        this.sb.append(b);
        return this;
    }

    public MsgSink append(char c) {
        this.sb.append(c);
        return this;
    }

    public MsgSink append(int i) {
        this.sb.append(i);
        return this;
    }

    public MsgSink append(long lng) {
        this.sb.append(lng);
        return this;
    }

    public MsgSink append(float f) {
        this.sb.append(f);
        return this;
    }

    public MsgSink append(double d) {
        this.sb.append(d);
        return this;
    }

    public MsgSink appendCodePoint(int codePoint) {
        this.sb.appendCodePoint(codePoint);
        return this;
    }
}

