/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.ext.declarative.api.numeric;

import com.fluxtion.api.annotations.Initialise;
import com.fluxtion.ext.declarative.api.numeric.NumericValue;

public class NumericConstant
implements NumericValue {
    public int initialIntValue;
    public double initialDoubleValue;
    public long initialLongValue;
    private int intValue;
    private double doubleValue;
    private long longValue;

    public NumericConstant() {
    }

    public NumericConstant(Number value) {
        this.initialIntValue = value.intValue();
        this.initialDoubleValue = value.doubleValue();
        this.initialLongValue = value.longValue();
        this.initConstants();
    }

    public void setConstant(Number value) {
        this.initialIntValue = value.intValue();
        this.initialDoubleValue = value.doubleValue();
        this.initialLongValue = value.longValue();
        this.initConstants();
    }

    @Initialise
    public final void initConstants() {
        this.intValue = this.initialIntValue;
        this.doubleValue = this.initialDoubleValue;
        this.longValue = this.initialLongValue;
    }

    @Override
    public int intValue() {
        return this.intValue;
    }

    @Override
    public long longValue() {
        return this.longValue;
    }

    @Override
    public double doubleValue() {
        return this.doubleValue;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + this.intValue;
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.doubleValue) ^ Double.doubleToLongBits(this.doubleValue) >>> 32);
        hash = 17 * hash + (int)(this.longValue ^ this.longValue >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumericConstant other = (NumericConstant)obj;
        if (this.intValue != other.intValue) {
            return false;
        }
        if (Double.doubleToLongBits(this.doubleValue) != Double.doubleToLongBits(other.doubleValue)) {
            return false;
        }
        return this.longValue == other.longValue;
    }
}

