/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.ext.declarative.api.test;

import com.fluxtion.api.annotations.Initialise;
import com.fluxtion.api.annotations.OnEvent;
import com.fluxtion.api.annotations.OnParentUpdate;
import com.fluxtion.ext.declarative.api.Wrapper;

public class BooleanMatchFilter<T>
implements Wrapper<T> {
    private final Object notifier;
    private final T tracked;
    private final Wrapper<T> trackedWrapper;
    private boolean notifierUpdate;
    private boolean trackedUpdate;

    public BooleanMatchFilter(Wrapper<T> trackedWrapper, Object notifier) {
        this.notifier = notifier;
        this.tracked = null;
        this.trackedWrapper = trackedWrapper;
    }

    public BooleanMatchFilter(T tracked, Object notifier) {
        this.notifier = notifier;
        this.tracked = tracked;
        this.trackedWrapper = null;
    }

    @OnParentUpdate(value="notifier")
    public void notifier(Object notifier) {
        this.notifierUpdate = true;
    }

    @OnParentUpdate(value="tracked")
    public void trackedUpdated(T tracked) {
        this.trackedUpdate = true;
    }

    @OnParentUpdate(value="trackedWrapper")
    public void trackedWrapperUpdated(Wrapper<T> tracked) {
        this.trackedUpdate = true;
    }

    @OnEvent
    public boolean filteredUpdate() {
        boolean sendUpdate = this.notifierUpdate & this.trackedUpdate;
        this.notifierUpdate = false;
        this.trackedUpdate = false;
        return sendUpdate;
    }

    @Initialise
    public void init() {
        this.notifierUpdate = false;
        this.trackedUpdate = false;
    }

    @Override
    public T event() {
        return this.tracked == null ? this.trackedWrapper.event() : this.tracked;
    }

    @Override
    public Class<T> eventClass() {
        return this.tracked == null ? this.trackedWrapper.eventClass() : this.tracked.getClass();
    }
}

