/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.creator;

import com.fluxtion.api.generation.GenerationContext;
import com.fluxtion.creator.EventDefinition;
import com.fluxtion.creator.Node;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;

public class CreatorConfig {
    private String outputSepConfigClass;
    private String outputPackage;
    private String auditorClass;
    private List<Node> nodes;
    private List<EventDefinition> events;
    private String processorId;

    public CreatorConfig(String processorId, String sepConfigClass, String packageName) {
        this.processorId = processorId;
        this.outputSepConfigClass = sepConfigClass;
        this.outputPackage = packageName;
        this.nodes = new ArrayList<Node>();
        this.events = new ArrayList<EventDefinition>();
    }

    public CreatorConfig() {
    }

    public String getOutputSepConfigClass() {
        return this.outputSepConfigClass;
    }

    public void setOutputSepConfigClass(String outputSepConfigClass) {
        this.outputSepConfigClass = outputSepConfigClass;
    }

    public String getSepCfgShortClassName() {
        return ClassUtils.getShortCanonicalName((String)this.outputSepConfigClass);
    }

    public String getSepCfgPackageName() {
        return ClassUtils.getPackageCanonicalName((String)this.outputSepConfigClass);
    }

    public String getOutputPackage() {
        return this.outputPackage;
    }

    public void setOutputPackage(String outputPackage) {
        this.outputPackage = outputPackage;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }

    public String getProcessorId() {
        return this.processorId;
    }

    public void setProcessorId(String processorId) {
        this.processorId = processorId;
    }

    public String getAuditorClass() {
        return this.auditorClass;
    }

    public void setAuditorClass(String auditorClass) {
        this.auditorClass = auditorClass;
    }

    public void addNode(Node node) {
        this.getNodes().add(this.cleanNode(node));
    }

    private Node cleanNode(Node node) {
        try {
            GenerationContext.SINGLETON.getClassLoader().loadClass(node.getType());
        }
        catch (ClassNotFoundException ex) {
            node.setType(this.outputPackage + "." + node.getClassName());
        }
        return node;
    }

    private EventDefinition cleanEvent(EventDefinition node) {
        try {
            GenerationContext.SINGLETON.getClassLoader().loadClass(node.getType());
        }
        catch (ClassNotFoundException ex) {
            node.setType(this.outputPackage + "." + node.getClassName());
        }
        return node;
    }

    public List<EventDefinition> getEvents() {
        return this.events;
    }

    public void setEvents(List<EventDefinition> events) {
        this.events = events;
    }

    public void validateConfig() {
        this.nodes.stream().forEach(this::cleanNode);
        this.events.stream().forEach(this::cleanEvent);
    }
}

