/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.creator;

import com.fluxtion.creator.EventMethod;
import com.fluxtion.creator.ReferenceDefinition;
import com.fluxtion.creator.TypeDefinition;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;

public class Node
extends TypeDefinition {
    private String id;
    private boolean publicAccess;
    private List<EventMethod> events;
    private List<ReferenceDefinition> nodes;
    private Object configBean;
    private String factoryType;

    public Node() {
        this(null, null, false);
    }

    public Node(String fqn, String id, boolean publicAccess) {
        super(fqn);
        this.id = id;
        this.publicAccess = publicAccess;
        this.packageName = ClassUtils.getPackageCanonicalName((String)fqn);
        this.className = ClassUtils.getShortCanonicalName((String)fqn);
        this.events = new ArrayList<EventMethod>();
        this.nodes = new ArrayList<ReferenceDefinition>();
    }

    public Node(String fqn, String id) {
        this(fqn, id, false);
    }

    public <T> Class<T> getNodeClass() throws ClassNotFoundException {
        return Class.forName(this.getType());
    }

    public List<EventMethod> getEvents() {
        return this.events;
    }

    public void setEvents(List<EventMethod> events) {
        this.events = events;
    }

    public boolean isPublicAccess() {
        return this.publicAccess;
    }

    public void setPublicAccess(boolean publicAccess) {
        this.publicAccess = publicAccess;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<ReferenceDefinition> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<ReferenceDefinition> nodes) {
        this.nodes = nodes;
    }

    public void setRef(String nodeId, String fieldName) {
        ReferenceDefinition rd = new ReferenceDefinition();
        rd.setNode(nodeId);
        rd.setName(fieldName);
        this.nodes.add(rd);
    }

    public <T> T getConfigBean() {
        return (T)this.configBean;
    }

    public <T> void setConfigBean(T configBean) {
        this.configBean = configBean;
    }

    public String getFactoryType() {
        return this.factoryType;
    }

    public void setFactoryType(String factoryType) {
        this.factoryType = factoryType;
    }

    public boolean isFactoryCreated() {
        return this.factoryType != null;
    }

    @Override
    public String toString() {
        return "Node{id=" + this.id + ", publicAccess=" + this.publicAccess + ", events=" + this.events + ", nodes=" + this.nodes + '}';
    }
}

