/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator;

import com.fluxtion.api.generation.GenerationContext;
import com.fluxtion.api.node.SEPConfig;
import com.fluxtion.generator.exporter.PngGenerator;
import com.fluxtion.generator.model.SimpleEventProcessorModel;
import com.fluxtion.generator.model.TopologicallySortedDependecyGraph;
import com.fluxtion.generator.targets.SepJavaSourceModelHugeFilter;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.googlejavaformat.java.Formatter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class Generator {
    private SEPConfig config;
    private static final Logger LOG = LoggerFactory.getLogger(Generator.class);
    private SimpleEventProcessorModel sep;

    public void templateSep(SEPConfig config) throws Exception {
        config.buildConfig();
        this.config = config;
        LOG.debug("init velocity");
        Generator.initVelocity();
        LOG.debug("start graph calc");
        GenerationContext context = GenerationContext.SINGLETON;
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(config.nodeList, config.publicNodes, config.declarativeConfig, config.nodeNameStrategy, context, config.auditorMap, config);
        LOG.debug("start model gen");
        this.sep = new SimpleEventProcessorModel(graph, config.filterMap, config.filterDescriptionProducer, context.getProxyClassMap());
        this.sep.generateMetaModel(config.supportDirtyFiltering);
        LOG.debug("start template output");
        this.templateJavaOutput();
        LOG.debug("export graphML");
        this.exportGraphMl(graph);
        LOG.debug("finished generating SEP");
    }

    private static void initVelocity() throws Exception {
        Velocity.setProperty((String)"resource.loader", (Object)"classpath");
        Velocity.setProperty((String)"classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        Velocity.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void templateJavaOutput() throws Exception {
        Template template;
        SepJavaSourceModelHugeFilter srcModelHuge;
        SepJavaSourceModelHugeFilter srcModel = srcModelHuge = new SepJavaSourceModelHugeFilter(this.sep, this.config.inlineEventHandling, this.config.assignPrivateMembers, this.config.maxFiltersInline);
        LOG.debug("building source model");
        srcModel.buildSourceModel();
        if (this.config.templateFile == null) {
            this.config.templateFile = "template/base/javaTemplate.vsl";
        }
        if (this.config.debugTemplateFile == null) {
            this.config.debugTemplateFile = "template/base/javaTemplateDebug.vsl";
        }
        if (this.config.testTemplateFile == null) {
            this.config.testTemplateFile = "template/base/javaTestDecoratorTemplate.vsl";
        }
        if (this.config.introspectorTemplateFile == null) {
            this.config.introspectorTemplateFile = "template/base/javaIntrospectorTemplate.vsl";
        }
        LOG.debug("templating output source - start");
        String templateFile = this.config.templateFile;
        try {
            template = Velocity.getTemplate((String)templateFile);
        }
        catch (Exception e) {
            System.out.println("failed to load template, setting threadcontext class loader");
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(GenerationContext.SINGLETON.getClassLoader());
                template = Velocity.getTemplate((String)templateFile);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
        VelocityContext ctx = new VelocityContext();
        ctx.put("MODEL", (Object)srcModel);
        ctx.put("MODEL_EXTENSION", this.config.templateContextExtension);
        ctx.put("package", (Object)GenerationContext.SINGLETON.getPackageName());
        ctx.put("className", (Object)GenerationContext.SINGLETON.getSepClassName());
        File outFile = new File(GenerationContext.SINGLETON.getPackageDirectory(), GenerationContext.SINGLETON.getSepClassName() + ".java");
        FileWriter templateWriter = new FileWriter(outFile);
        template.merge((Context)ctx, (Writer)templateWriter);
        templateWriter.flush();
        LOG.debug("templating output source - finish");
        if (this.config.generateDebugPrep) {
            // empty if block
        }
        if (this.config.generateTestDecorator) {
            template = Velocity.getTemplate((String)this.config.testTemplateFile);
            ctx = new VelocityContext();
            ctx.put("MODEL", (Object)srcModel);
            ctx.put("MODEL_EXTENSION", this.config.templateContextExtension);
            ctx.put("package", (Object)GenerationContext.SINGLETON.getPackageName());
            ctx.put("className", (Object)GenerationContext.SINGLETON.getSepClassName());
            ctx.put("decoratorClassName", (Object)(GenerationContext.SINGLETON.getSepClassName() + "TestDecorator"));
            outFile = new File(GenerationContext.SINGLETON.getPackageDirectory(), GenerationContext.SINGLETON.getSepClassName() + "TestDecorator.java");
            templateWriter = new FileWriter(outFile);
            template.merge((Context)ctx, (Writer)templateWriter);
            templateWriter.flush();
        }
        templateWriter.close();
        if (this.config.formatSource) {
            LOG.debug("Reading source");
            CharSource source = Files.asCharSource((File)outFile, (Charset)Charset.defaultCharset());
            CharSink output = Files.asCharSink((File)outFile, (Charset)Charset.defaultCharset(), (FileWriteMode[])new FileWriteMode[0]);
            LOG.debug("formatting source - start");
            new Formatter().formatSource(source, output);
            LOG.debug("formatting source - finish");
        }
    }

    private void exportGraphMl(TopologicallySortedDependecyGraph graph) {
        if (this.config.generateDescription) {
            try {
                LOG.debug("generating event images and graphml");
                File graphMl = new File(GenerationContext.SINGLETON.getResourcesOutputDirectory(), GenerationContext.SINGLETON.getSepClassName() + ".graphml");
                File pngFile = new File(GenerationContext.SINGLETON.getResourcesOutputDirectory(), GenerationContext.SINGLETON.getSepClassName() + ".png");
                if (graphMl.getParentFile() != null) {
                    graphMl.getParentFile().mkdirs();
                }
                FileWriter graphMlWriter = new FileWriter(graphMl);
                graph.exportAsGraphMl(graphMlWriter, true);
                PngGenerator.generatePNG(graphMl, pngFile);
            }
            catch (IOException | TransformerConfigurationException | SAXException iOException) {
                System.out.println("error writing png and graphml:" + iOException.getMessage());
            }
        }
    }
}

