/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator;

import com.fluxtion.generator.compiler.SepCompiler;
import com.fluxtion.generator.compiler.SepCompilerConfig;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import net.openhft.compiler.CompilerUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    private static Options options;
    private static DefaultParser parser;
    private static CommandLine cmdLine;
    private static URLClassLoader loader;

    public static void main(String[] args) {
        LOG.debug("running gnerator application");
        Main.printErrorAndExit(Main.buildCommandLine(args));
        Main.printErrorAndExit(Main.buildClasspath());
        Main.printErrorAndExit(Main.buildSepProcessor());
    }

    public static Options addDefaultOptions(Options extendedptions) {
        if (options == null) {
            options = new Options();
            options.addOption(Option.builder((String)"cp").longOpt("classPath").valueSeparator(';').argName("classpath").desc("Classpath fluxtion uses to find application classes referenced in the SEPBuilder class. Separator char ';'.").required(true).hasArgs().build());
            options.addOption(Option.builder((String)"cc").longOpt("configClass").hasArg().desc("The SEPConfig class fluxtion will use to construct the SEP.").argName("class name").required(false).build());
            options.addOption(Option.builder((String)"st").longOpt("sepTemplate").hasArg().desc("Override the template file fluxtion will use to generate the SEP.").argName("velocity file").required(false).build());
            options.addOption(Option.builder((String)"dt").longOpt("sepDebugTemplate").hasArg().desc("Override the debug template file fluxtion will use to generate the debug SEP.").argName("velocity file").required(false).build());
            options.addOption(Option.builder((String)"nc").longOpt("nodeNamingClass").hasArg().desc("Override default naming strategy for variable names in generated SEP.").argName("class name").required(false).build());
            options.addOption(Option.builder((String)"fc").longOpt("filterNamingClass").hasArg().desc("Override default naming strategy for native filters names in generated SEP.").argName("class name").required(false).build());
            options.addOption(Option.builder((String)"df").longOpt("supportDirtyFiltering").hasArg().desc("If set at least one parent must return true from an event handling method for an event to propogate to dependent nodes.").required(false).build());
            options.addOption(Option.builder((String)"pa").longOpt("assignPrivate").hasArg().desc("If set generated SEP will attempt to use reflection style assignment for private non-transient members").required(false).build());
            options.addOption(Option.builder((String)"gd").longOpt("generateDescription").hasArg().desc("Generate a meta-data description of SEP.").required(false).build());
            options.addOption(Option.builder((String)"gb").longOpt("generateDebugPrep").hasArg().desc("Generate a debug version oi the SEP for using with fluxtion debug tool.").required(false).build());
            options.addOption(Option.builder((String)"bc").longOpt("buildClasses").hasArg(true).desc("Compile classes from generated source.").required(false).build());
            options.addOption(Option.builder((String)"fs").longOpt("formatSource").hasArg(true).desc("Format generated source.").required(false).build());
            options.addOption(Option.builder((String)"oc").longOpt("outClass").hasArg().desc("Simple class name for the generated SEP. This class is the entry point for event processing.").argName("class name").required(true).build());
            options.addOption(Option.builder((String)"op").longOpt("outPackage").hasArg().desc("Package name for the generated SEP.").argName("package name").required(true).build());
            options.addOption(Option.builder((String)"od").longOpt("outDirectory").hasArg().desc("The directory where the SEP will generate source artifacts.").argName("directory").required(false).build());
            options.addOption(Option.builder((String)"bd").longOpt("buildDirectory").hasArg().desc("The directory where the SEP will compile").argName("directory").required(false).build());
            options.addOption(Option.builder((String)"or").longOpt("outResDirectory").hasArg().desc("The directory where the SEP will generate non runtime artifacts, such as debug information.").argName("directory").required(false).build());
            options.addOption(Option.builder((String)"rf").longOpt("rootFactoryClass").hasArg().desc("The root factory SEP will use when using factory generation.").argName("class name").required(false).build());
            options.addOption(Option.builder((String)"yc").longOpt("yamlFactoryConfig").hasArg().desc("Yaml file for multiple factory configurations in a single SEP.").argName("yml file").required(false).build());
            options.addOption(Option.builder((String)"d").longOpt("debug").hasArg(false).desc("debug log output").argName("yml file").build());
        }
        if (extendedptions != null) {
            extendedptions.getOptions().stream().forEach(o -> options.addOption(o));
        }
        return options;
    }

    private static Pair<Boolean, String> buildSepProcessor() {
        LOG.debug("buildSepProcessor");
        MutablePair result = new MutablePair((Object)Boolean.TRUE, (Object)"");
        SepCompilerConfig cfg = Main.buildCompilerConfig();
        SepCompiler compiler = new SepCompiler();
        try {
            compiler.compile(cfg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LOG.debug("error compiling", (Throwable)ex);
            result.left = false;
            result.right = "could not compile :" + cmdLine.getOptionValue("configClass") + " error masg:" + ex.getMessage();
        }
        return result;
    }

    private static Pair<Boolean, String> buildClasspath() {
        LOG.debug("buildingClasspath");
        MutablePair result = new MutablePair((Object)Boolean.TRUE, (Object)"");
        String[] cpArray = cmdLine.getOptionValues("cp");
        Object[] urls = new URL[cpArray.length];
        for (int i = 0; i < cpArray.length; ++i) {
            try {
                File file = new File(cpArray[i]);
                urls[i] = file.isDirectory() ? file.toURI().toURL() : new URL("jar:" + new File(cpArray[i]).toURI().toURL() + "!/");
            }
            catch (MalformedURLException ex) {
                LOG.debug("error building classpath", (Throwable)ex);
                result.left = false;
                result.right = "could not load jar file:" + cpArray[i] + " error masg:" + ex.getMessage();
                return result;
            }
            CompilerUtils.addClassPath((String)cpArray[i]);
        }
        LOG.debug("user classpath URL list:" + Arrays.toString(urls));
        loader = URLClassLoader.newInstance((URL[])urls, Main.class.getClassLoader());
        try {
            Class<?> i = loader.loadClass(cmdLine.getOptionValue("configClass"));
        }
        catch (ClassNotFoundException ex) {
            result.left = false;
            result.right = "could not load builder class :" + cmdLine.getOptionValue("configClass") + " error masg:" + ex.getMessage();
            return result;
        }
        return result;
    }

    private static SepCompilerConfig buildCompilerConfig() {
        SepCompilerConfig config = new SepCompilerConfig();
        config.setAssignNonPublicMembers(Main.bool("pa", config.isAssignNonPublicMembers()));
        config.setBuildOutputdirectory(Main.val("bd", "output/classes"));
        config.setClassLoader(loader);
        config.setClassName(Main.val("oc", "SepProcessor"));
        config.setConfigClass(Main.val("cc", config.getConfigClass()));
        config.setFilterNamingClass(Main.val("fc", null));
        config.setGenerateDebugPrep(Main.bool("gb", config.isGenerateDebugPrep()));
        config.setGenerateDescription(Main.bool("gd", config.isGenerateDescription()));
        config.setGenerateTestDecorator(Main.bool("gt", config.isGenerateTestDecorator()));
        config.setCompileSource(Main.bool("bc", config.isCompileSource()));
        config.setFormatSource(Main.bool("fs", config.isFormatSource()));
        config.setNodeNamingClass(Main.val("nc", null));
        config.setOutputDirectory(Main.val("od", "output/source"));
        config.setPackageName(Main.val("op", "sep.generated"));
        config.setResourcesOutputDirectory(Main.val("or", "output/resources"));
        config.setRootFactoryClass(Main.val("rf", null));
        config.setSupportDirtyFiltering(Main.bool("df", config.isSupportDirtyFiltering()));
        config.setTemplateDebugSep(Main.val("dt", config.getTemplateDebugSep()));
        config.setTemplateSep(Main.val("st", config.getTemplateSep()));
        config.setYamlFactoryConfig(Main.val("yc", null));
        LOG.debug(config.toString());
        return config;
    }

    private static String val(String key, String defaultVal) {
        String val = cmdLine.getOptionValue(key);
        return val == null ? defaultVal : val;
    }

    private static boolean bool(String key, boolean defaultVal) {
        String val = cmdLine.getOptionValue(key);
        return val == null ? defaultVal : Boolean.valueOf(val);
    }

    private static Pair<Boolean, String> buildCommandLine(String[] args) {
        MutablePair result = new MutablePair((Object)Boolean.TRUE, (Object)"");
        LOG.debug("Command line args:" + Arrays.toString(args));
        Main.addDefaultOptions(null);
        parser = new DefaultParser();
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException parseException) {
            System.out.println("Problem parsing command line, " + parseException.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("fluxtion-generate", options, true);
            result.left = false;
            return result;
        }
        return result;
    }

    private static void printErrorAndExit(Pair<Boolean, String> result) {
        if (((Boolean)result.getKey()).booleanValue()) {
            return;
        }
        if (result.getRight() != null && ((String)result.getRight()).length() > 0) {
            System.err.println((String)result.getRight());
        }
        System.exit(-1);
    }
}

