/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.compiler;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.StatusPrinter;
import com.fluxtion.api.generation.FilterDescriptionProducer;
import com.fluxtion.api.generation.GenerationContext;
import com.fluxtion.api.generation.NodeNameProducer;
import com.fluxtion.api.node.DeclarativeNodeConiguration;
import com.fluxtion.api.node.NodeFactory;
import com.fluxtion.api.node.SEPConfig;
import com.fluxtion.generator.Generator;
import com.fluxtion.generator.compiler.SepCompilerConfig;
import com.fluxtion.generator.compiler.SepFactoryConfigBean;
import com.fluxtion.generator.graphbuilder.NodeFactoryLocator;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Set;
import net.openhft.compiler.CachedCompiler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class SepCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(SepCompiler.class);
    private SepCompilerConfig compilerConfig;
    private SEPConfig builderConfig;

    public static void main(String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException, Exception {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        StatusPrinter.print((Context)lc);
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        URL[] urls = ((URLClassLoader)cl).getURLs();
        LOG.debug("classpath");
        for (URL url : urls) {
            LOG.debug(url.getFile());
        }
        SepCompiler compiler = new SepCompiler();
        compiler.compile();
    }

    public void compile() throws ClassNotFoundException, InstantiationException, IllegalAccessException, Exception {
        this.compile(SepCompilerConfig.initFromSystemProperties());
    }

    public void compile(SepCompilerConfig compilerConfig) throws ClassNotFoundException, InstantiationException, IllegalAccessException, Exception {
        this.compile(compilerConfig, null);
    }

    public void compile(SepCompilerConfig compilerConfig, SEPConfig configOverride) throws ClassNotFoundException, InstantiationException, IllegalAccessException, Exception {
        LOG.debug("starting SEP compiler");
        this.compilerConfig = compilerConfig;
        this.initialiseGenerator(configOverride);
        if (configOverride == null) {
            this.initialiseNamingStrategy();
        }
        this.locateFactories();
        this.processYamlConfig();
        this.processRootFactoryConfig();
        this.generateSep();
        LOG.debug("finished SEP compiler");
    }

    private void initialiseGenerator(SEPConfig configOverride) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        LOG.debug("initialiseGenerator");
        LOG.debug(this.compilerConfig.toString());
        File buildDir = this.compilerConfig.getBuildOutputdirectory() == null ? null : new File(this.compilerConfig.getBuildOutputdirectory());
        GenerationContext.setupStaticContext((ClassLoader)this.compilerConfig.getClassLoader(), (String)this.compilerConfig.getPackageName(), (String)this.compilerConfig.getClassName(), (File)new File(this.compilerConfig.getOutputDirectory()), (File)new File(this.compilerConfig.getResourcesOutputDirectory()), (this.compilerConfig.isGenerateDebugPrep() || this.compilerConfig.isGenerateDescription() ? 1 : 0) != 0, (File)buildDir, (boolean)true, (CachedCompiler)this.compilerConfig.getCachedCompiler());
        if (configOverride == null) {
            Class<?> rootClazz = this.compilerConfig.getClassLoader().loadClass(this.compilerConfig.getConfigClass());
            this.builderConfig = (SEPConfig)rootClazz.newInstance();
        } else {
            this.builderConfig = configOverride;
        }
        this.builderConfig.templateFile = this.compilerConfig.getTemplateSep();
        this.builderConfig.debugTemplateFile = this.compilerConfig.getTemplateDebugSep();
        this.builderConfig.supportDirtyFiltering = this.compilerConfig.isSupportDirtyFiltering();
        this.builderConfig.generateDebugPrep = this.compilerConfig.isGenerateDebugPrep();
        this.builderConfig.generateDescription = this.compilerConfig.isGenerateDescription();
        this.builderConfig.generateTestDecorator = this.compilerConfig.isGenerateTestDecorator();
        this.builderConfig.assignPrivateMembers = this.compilerConfig.isAssignNonPublicMembers();
    }

    private void initialiseNamingStrategy() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> nodeNamingClazz;
        LOG.debug("initialiseNamingStrategy");
        if (this.compilerConfig.getNodeNamingClass() != null && !this.compilerConfig.getNodeNamingClass().isEmpty()) {
            nodeNamingClazz = this.compilerConfig.getClassLoader().loadClass(this.compilerConfig.getNodeNamingClass());
            this.builderConfig.nodeNameStrategy = (NodeNameProducer)nodeNamingClazz.newInstance();
        }
        if (this.compilerConfig.getFilterNamingClass() != null && !this.compilerConfig.getFilterNamingClass().isEmpty()) {
            nodeNamingClazz = this.compilerConfig.getClassLoader().loadClass(this.compilerConfig.getFilterNamingClass());
            this.builderConfig.filterDescriptionProducer = (FilterDescriptionProducer)nodeNamingClazz.newInstance();
        }
    }

    private void processYamlConfig() throws IOException, ClassNotFoundException, Exception {
        LOG.debug("staring :: processYamlConfig");
        if (this.compilerConfig.getYamlFactoryConfig() != null && !this.compilerConfig.getYamlFactoryConfig().isEmpty()) {
            File yamlFactoryConfig = new File(this.compilerConfig.getYamlFactoryConfig());
            LOG.debug("processing yaml factory config file:" + yamlFactoryConfig.getCanonicalPath());
            FileInputStream input = new FileInputStream(yamlFactoryConfig);
            Yaml beanLoader = new Yaml();
            LOG.debug("loading SepFactoryConfigBean with beanLoader");
            SepFactoryConfigBean loadedConfig = (SepFactoryConfigBean)beanLoader.loadAs((InputStream)input, SepFactoryConfigBean.class);
            LOG.debug("DeclarativeNodeConiguration load");
            DeclarativeNodeConiguration cfgActual = loadedConfig.asDeclarativeNodeConiguration();
            LOG.debug("searching for NodeFactory's");
            Set<Class<? extends NodeFactory>> class2Factory = NodeFactoryLocator.findFactoryByPackage("com");
            cfgActual.factoryClassSet.addAll(class2Factory);
            this.builderConfig.declarativeConfig = cfgActual;
            LOG.debug("completed :: processYamlConfig ");
        } else {
            LOG.debug("no yaml factory config file specified");
        }
    }

    private void processRootFactoryConfig() throws ClassNotFoundException, Exception {
        LOG.debug("processRootFactoryConfig");
        if (this.compilerConfig.getRootFactoryClass() != null && !this.compilerConfig.getRootFactoryClass().isEmpty()) {
            if (this.builderConfig.declarativeConfig == null) {
                HashMap<String, String> rootNodeMappings = new HashMap<String, String>();
                rootNodeMappings.put(this.compilerConfig.getRootFactoryClass(), "root");
                SepFactoryConfigBean loadedConfig = new SepFactoryConfigBean();
                loadedConfig.setRootNodeMappings(rootNodeMappings);
                loadedConfig.setConfig(new HashMap());
                DeclarativeNodeConiguration cfgActual = loadedConfig.asDeclarativeNodeConiguration();
                Set<Class<? extends NodeFactory>> class2Factory = NodeFactoryLocator.findFactoryByPackage("com");
                cfgActual.factoryClassSet.addAll(class2Factory);
                this.builderConfig.declarativeConfig = cfgActual;
            } else {
                this.builderConfig.declarativeConfig.rootNodeMappings.put(this.builderConfig.getClass(), "root");
            }
        }
    }

    private void locateFactories() throws Exception {
        LOG.debug("locateFactories");
        SepFactoryConfigBean loadedConfig = new SepFactoryConfigBean();
        Set<Class<? extends NodeFactory>> class2Factory = NodeFactoryLocator.findFactoryByPackage("com");
        loadedConfig.setConfig(new HashMap());
        DeclarativeNodeConiguration cfgActual = loadedConfig.asDeclarativeNodeConiguration();
        if (this.builderConfig == null || this.builderConfig.declarativeConfig == null) {
            cfgActual.factoryClassSet.addAll(class2Factory);
            this.builderConfig.declarativeConfig = cfgActual;
        } else {
            this.builderConfig.declarativeConfig.factoryClassSet.addAll(class2Factory);
        }
    }

    private void generateSep() throws Exception {
        LOG.debug("generateSep");
        Generator generator = new Generator();
        this.builderConfig.formatSource = this.compilerConfig.isFormatSource();
        generator.templateSep(this.builderConfig);
        if (this.compilerConfig.isCompileSource()) {
            LOG.debug("start compiling source");
            GenerationContext generationConfig = GenerationContext.SINGLETON;
            String fqn = generationConfig.getPackageName() + "." + generationConfig.getSepClassName();
            File file = new File(generationConfig.getPackageDirectory(), generationConfig.getSepClassName() + ".java");
            CachedCompiler javaCompiler = GenerationContext.SINGLETON.getJavaCompiler();
            javaCompiler.loadFromJava(GenerationContext.SINGLETON.getClassLoader(), fqn, SepCompiler.readText(file.getCanonicalPath()));
            LOG.debug("finished compiling source");
        }
    }

    public static Class loadFromResource(@NotNull String className, @NotNull String resourceName) throws IOException, ClassNotFoundException {
        return GenerationContext.SINGLETON.getJavaCompiler().loadFromJava(GenerationContext.SINGLETON.getClassLoader(), className, SepCompiler.readText(resourceName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readText(@NotNull String resourceName) throws IOException {
        LOG.debug("starting reading:" + resourceName);
        StringWriter sw = new StringWriter();
        InputStreamReader isr = new InputStreamReader(SepCompiler.getInputStream(resourceName), StandardCharsets.UTF_8);
        try {
            int len;
            char[] chars = new char[8192];
            while ((len = isr.read(chars)) > 0) {
                sw.write(chars, 0, len);
            }
        }
        finally {
            SepCompiler.close(isr);
        }
        LOG.debug("finished reading:" + resourceName);
        return sw.toString();
    }

    private static void close(@Nullable Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOG.trace("Failed to close {}", (Object)closeable, (Object)e);
            }
        }
    }

    private static InputStream getInputStream(@NotNull String filename) throws FileNotFoundException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        InputStream is = contextClassLoader.getResourceAsStream(filename);
        if (is != null) {
            return is;
        }
        InputStream is2 = contextClassLoader.getResourceAsStream('/' + filename);
        if (is2 != null) {
            return is2;
        }
        return new FileInputStream(filename);
    }
}

