/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.compiler;

import com.fluxtion.api.node.SEPConfig;
import net.openhft.compiler.CachedCompiler;

public class SepCompilerConfig {
    private static final String CONFIGCLASSDEFAULT = SEPConfig.class.getCanonicalName();
    private String configClass = CONFIGCLASSDEFAULT;
    private String rootFactoryClass;
    private String yamlFactoryConfig;
    private String packageName;
    private String className;
    private String outputDirectory;
    private String buildOutputdirectory;
    private boolean compileSource = true;
    private boolean formatSource = true;
    private String resourcesOutputDirectory;
    private String templateSep = "template/base/javaTemplate.vsl";
    private String templateDebugSep = "template/base/javaTemplateDebug.vsl";
    private boolean supportDirtyFiltering = true;
    private boolean generateDebugPrep = false;
    private boolean generateDescription = true;
    private boolean generateTestDecorator = false;
    private boolean assignNonPublicMembers = false;
    private String nodeNamingClass;
    private String filterNamingClass;
    private ClassLoader classLoader = SepCompilerConfig.class.getClassLoader();
    private CachedCompiler cachedCompiler;

    public static SepCompilerConfig initFromSystemProperties() {
        SepCompilerConfig config = new SepCompilerConfig();
        config.configClass = System.getProperty("fluxtion.configClass", CONFIGCLASSDEFAULT);
        config.className = System.getProperty("fluxtion.className");
        config.packageName = System.getProperty("fluxtion.packageName");
        config.rootFactoryClass = System.getProperty("fluxtion.rootFactoryClass");
        config.yamlFactoryConfig = System.getProperty("fluxtion.yamlFactoryConfig");
        config.outputDirectory = System.getProperty("fluxtion.outputDirectory");
        config.resourcesOutputDirectory = System.getProperty("fluxtion.resourcesOutputDirectory");
        config.templateSep = System.getProperty("fluxtion.templateSep", config.templateSep);
        config.templateDebugSep = System.getProperty("fluxtion.templateDebugSep", config.templateSep);
        config.supportDirtyFiltering = Boolean.valueOf(System.getProperty("fluxtion.supportDirtyFiltering", "true"));
        config.generateDebugPrep = Boolean.getBoolean("fluxtion.generateDebugPrep");
        config.generateDescription = Boolean.getBoolean("fluxtion.generateDescription");
        config.generateTestDecorator = Boolean.getBoolean("fluxtion.generateTestDecorator");
        config.assignNonPublicMembers = Boolean.getBoolean("fluxtion.assignNonPublicMembers");
        config.nodeNamingClass = System.getProperty("fluxtion.nodeNamingClass");
        config.filterNamingClass = System.getProperty("fluxtion.filterNamingClass");
        config.buildOutputdirectory = System.getProperty("fluxtion.build.outputdirectory", "");
        config.buildOutputdirectory = config.buildOutputdirectory.isEmpty() ? null : config.buildOutputdirectory;
        return config;
    }

    public String getConfigClass() {
        return this.configClass;
    }

    public String getRootFactoryClass() {
        return this.rootFactoryClass;
    }

    public String getYamlFactoryConfig() {
        return this.yamlFactoryConfig;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getBuildOutputdirectory() {
        return this.buildOutputdirectory;
    }

    public String getResourcesOutputDirectory() {
        return this.resourcesOutputDirectory;
    }

    public String getTemplateSep() {
        return this.templateSep;
    }

    public String getTemplateDebugSep() {
        return this.templateDebugSep;
    }

    public boolean isSupportDirtyFiltering() {
        return this.supportDirtyFiltering;
    }

    public boolean isGenerateDebugPrep() {
        return this.generateDebugPrep;
    }

    public boolean isGenerateDescription() {
        return this.generateDescription;
    }

    public boolean isGenerateTestDecorator() {
        return this.generateTestDecorator;
    }

    public boolean isAssignNonPublicMembers() {
        return this.assignNonPublicMembers;
    }

    public boolean isCompileSource() {
        return this.compileSource;
    }

    public boolean isFormatSource() {
        return this.formatSource;
    }

    public String getNodeNamingClass() {
        return this.nodeNamingClass;
    }

    public String getFilterNamingClass() {
        return this.filterNamingClass;
    }

    public String getFqn() {
        return this.getPackageName() + "." + this.getClassName();
    }

    public void setConfigClass(String configClass) {
        this.configClass = configClass;
    }

    public void setRootFactoryClass(String rootFactoryClass) {
        this.rootFactoryClass = rootFactoryClass;
    }

    public void setYamlFactoryConfig(String yamlFactoryConfig) {
        this.yamlFactoryConfig = yamlFactoryConfig;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setBuildOutputdirectory(String buildOutputdirectory) {
        this.buildOutputdirectory = buildOutputdirectory;
    }

    public void setResourcesOutputDirectory(String resourcesOutputDirectory) {
        this.resourcesOutputDirectory = resourcesOutputDirectory;
    }

    public void setTemplateSep(String templateSep) {
        this.templateSep = templateSep;
    }

    public void setTemplateDebugSep(String templateDebugSep) {
        this.templateDebugSep = templateDebugSep;
    }

    public void setSupportDirtyFiltering(boolean supportDirtyFiltering) {
        this.supportDirtyFiltering = supportDirtyFiltering;
    }

    public void setGenerateDebugPrep(boolean generateDebugPrep) {
        this.generateDebugPrep = generateDebugPrep;
    }

    public void setGenerateDescription(boolean generateDescription) {
        this.generateDescription = generateDescription;
    }

    public void setGenerateTestDecorator(boolean generateTestDecorator) {
        this.generateTestDecorator = generateTestDecorator;
    }

    public void setAssignNonPublicMembers(boolean assignNonPublicMembers) {
        this.assignNonPublicMembers = assignNonPublicMembers;
    }

    public void setNodeNamingClass(String nodeNamingClass) {
        this.nodeNamingClass = nodeNamingClass;
    }

    public void setFilterNamingClass(String filterNamingClass) {
        this.filterNamingClass = filterNamingClass;
    }

    public void setCompileSource(boolean compileSource) {
        this.compileSource = compileSource;
    }

    public void setFormatSource(boolean formatSource) {
        this.formatSource = formatSource;
    }

    public String toString() {
        return "SepCompilerConfig{configClass=" + this.configClass + ", rootFactoryClass=" + this.rootFactoryClass + ", yamlFactoryConfig=" + this.yamlFactoryConfig + ", packageName=" + this.packageName + ", className=" + this.className + ", resourcesOutputDirectory=" + this.resourcesOutputDirectory + ", outputDirectory=" + this.outputDirectory + ", buildOutputdirectory=" + this.buildOutputdirectory + ", compileSource=" + this.compileSource + ", formatSource=" + this.formatSource + ", templateSep=" + this.templateSep + ", templateDebugSep=" + this.templateDebugSep + ", supportDirtyFiltering=" + this.supportDirtyFiltering + ", generateDebugPrep=" + this.generateDebugPrep + ", generateDescription=" + this.generateDescription + ", generateTestDecorator=" + this.generateTestDecorator + ", assignNonPublicMembers=" + this.assignNonPublicMembers + ", nodeNamingClass=" + this.nodeNamingClass + ", filterNamingClass=" + this.filterNamingClass + '}';
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public CachedCompiler getCachedCompiler() {
        return this.cachedCompiler;
    }

    public void setCachedCompiler(CachedCompiler cachedCompiler) {
        this.cachedCompiler = cachedCompiler;
    }
}

