/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.graphbuilder;

import com.fluxtion.api.generation.GenerationContext;
import com.fluxtion.api.node.NodeFactory;
import com.fluxtion.api.node.NodeRegistry;
import com.fluxtion.generator.model.CbMethodHandle;
import com.google.common.base.Predicate;
import com.googlecode.gentyref.GenericTypeReflector;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeFactoryLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeFactoryLocator.class);

    public static final Map<Class, CbMethodHandle> findCallbackByPackage(String rootPackage) throws Exception {
        HashMap<Class, CbMethodHandle> class2Factory = new HashMap<Class, CbMethodHandle>();
        Reflections reflections = new Reflections(rootPackage, new Scanner[0]);
        Set subTypes = reflections.getSubTypesOf(NodeFactory.class);
        LOGGER.debug("search root:{} subtypes of NodeFactory:{}", (Object)rootPackage, (Object)subTypes);
        for (Class clazz : subTypes) {
            NodeFactory obj = (NodeFactory)clazz.newInstance();
            Method createMethod = clazz.getMethod("createNode", Map.class, NodeRegistry.class);
            ParameterizedType paramType = (ParameterizedType)GenericTypeReflector.getExactSuperType((Type)clazz, NodeFactory.class);
            Class targetClass = (Class)paramType.getActualTypeArguments()[0];
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("type:" + clazz.getCanonicalName() + " building:" + targetClass);
            }
            class2Factory.put(targetClass, new CbMethodHandle(createMethod, obj, "node_factory_" + targetClass.getName()));
        }
        return class2Factory;
    }

    public static final Set<Class<? extends NodeFactory>> findFactoryByPackage(String rootPackage) throws Exception {
        Reflections reflections;
        if (GenerationContext.SINGLETON != null && GenerationContext.SINGLETON.getClassLoader() != null) {
            LOGGER.debug("using custom class loader to search for factories");
            ClassLoader loader = GenerationContext.SINGLETON.getClassLoader();
            ConfigurationBuilder configBuilder = new ConfigurationBuilder().filterInputsBy((Predicate)FilterBuilder.parsePackages((String)"+com")).addClassLoaders(new ClassLoader[]{loader, NodeFactory.class.getClassLoader()}).addUrls(ClasspathHelper.forPackage((String)rootPackage, (ClassLoader[])new ClassLoader[0]));
            if (loader instanceof URLClassLoader) {
                configBuilder.addUrls(((URLClassLoader)loader).getURLs());
            }
            reflections = new Reflections((Configuration)configBuilder);
        } else {
            if (GenerationContext.SINGLETON == null) {
                LOGGER.debug("GenerationContext is null using default class loader to search for factories");
            } else {
                LOGGER.debug("custom class loader is null using default class loader to search for factories");
            }
            reflections = new Reflections(rootPackage, new Scanner[0]);
        }
        Set subTypes = reflections.getSubTypesOf(NodeFactory.class);
        LOGGER.debug("package search root:{}, found NodeFactory:{}", (Object)rootPackage, (Object)subTypes);
        return subTypes;
    }
}

