/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.model;

import com.fluxtion.api.annotations.AfterEvent;
import com.fluxtion.api.annotations.FilterId;
import com.fluxtion.api.annotations.FilterType;
import com.fluxtion.api.annotations.Initialise;
import com.fluxtion.api.annotations.NoEventReference;
import com.fluxtion.api.annotations.OnBatchEnd;
import com.fluxtion.api.annotations.OnBatchPause;
import com.fluxtion.api.annotations.OnEvent;
import com.fluxtion.api.annotations.OnEventComplete;
import com.fluxtion.api.annotations.OnParentUpdate;
import com.fluxtion.api.annotations.PushReference;
import com.fluxtion.api.annotations.TearDown;
import com.fluxtion.api.generation.FilterDescription;
import com.fluxtion.api.generation.FilterDescriptionProducer;
import com.fluxtion.generator.model.CbMethodHandle;
import com.fluxtion.generator.model.DefaultFilterDescriptionProducer;
import com.fluxtion.generator.model.DirtyFlag;
import com.fluxtion.generator.model.Field;
import com.fluxtion.generator.model.ParentFilter;
import com.fluxtion.generator.model.TopologicallySortedDependecyGraph;
import com.fluxtion.generator.util.ClassUtils;
import com.fluxtion.generator.util.NaturalOrderComparator;
import com.fluxtion.runtime.event.Event;
import com.fluxtion.runtime.lifecycle.EventHandler;
import com.fluxtion.runtime.lifecycle.FilteredEventHandler;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.jodah.typetools.TypeResolver;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleEventProcessorModel {
    private final Logger LOGGER = LoggerFactory.getLogger(SimpleEventProcessorModel.class);
    private List<Field> nodeFields;
    private List<Field> nodeFieldsSortedTopologically;
    private List<Field> registrationListenerFields;
    private final ArrayList<CbMethodHandle> initialiseMethods;
    private final ArrayList<CbMethodHandle> eventEndMethods;
    private final ArrayList<CbMethodHandle> batchEndMethods;
    private final ArrayList<CbMethodHandle> batchPauseMethods;
    private final ArrayList<CbMethodHandle> tearDownMethods;
    private final TopologicallySortedDependecyGraph dependencyGraph;
    private Map<Object, List<Field.MappedField>> constructorArgdMap;
    private Map<Object, List<String>> beanPropertyMap;
    private Set<Class<?>> importClasses;
    private Map<String, String> mappedClasses;
    private final Map<Class, Map<FilterDescription, List<CbMethodHandle>>> dispatchMap;
    private final Map<Class, Map<FilterDescription, List<CbMethodHandle>>> postDispatchMap;
    private Map<Object, List<CbMethodHandle>> parentUpdateListenerMethodMap;
    private Map<Object, CbMethodHandle> node2UpdateMethodMap;
    private final ArrayList<FilterDescription> filterDescriptionList;
    private FilterDescriptionProducer flterProducer;
    private Map<Field, DirtyFlag> dirtyFieldMap;
    private Multimap<Object, DirtyFlag> nodeGuardMap;
    private final Map<Object, Integer> filterMap;
    private final Map<Object, String> nodeClassMap;
    private NaturalOrderComparator comparator;
    private boolean supportDirtyFiltering;

    public SimpleEventProcessorModel(TopologicallySortedDependecyGraph dependencyGraph) throws Exception {
        this(dependencyGraph, new HashMap<Object, Integer>());
    }

    public SimpleEventProcessorModel(TopologicallySortedDependecyGraph dependencyGraph, Map<Object, Integer> filterMap) throws Exception {
        this(dependencyGraph, filterMap, null, null);
    }

    public SimpleEventProcessorModel(TopologicallySortedDependecyGraph dependencyGraph, FilterDescriptionProducer flterProducer) throws Exception {
        this(dependencyGraph, null, flterProducer, null);
    }

    public SimpleEventProcessorModel(TopologicallySortedDependecyGraph dependencyGraph, Map<Object, Integer> filterMap, FilterDescriptionProducer flterProducer, Map<Object, String> nodeClassMap) throws Exception {
        this.dependencyGraph = dependencyGraph;
        this.dependencyGraph.generateDependencyTree();
        this.filterMap = filterMap == null ? new HashMap() : filterMap;
        this.flterProducer = flterProducer == null ? new DefaultFilterDescriptionProducer() : flterProducer;
        this.nodeClassMap = nodeClassMap == null ? Collections.EMPTY_MAP : nodeClassMap;
        this.constructorArgdMap = new HashMap<Object, List<Field.MappedField>>();
        this.beanPropertyMap = new HashMap<Object, List<String>>();
        this.initialiseMethods = new ArrayList();
        this.tearDownMethods = new ArrayList();
        this.batchEndMethods = new ArrayList();
        this.batchPauseMethods = new ArrayList();
        this.eventEndMethods = new ArrayList();
        this.dispatchMap = new HashMap<Class, Map<FilterDescription, List<CbMethodHandle>>>();
        this.postDispatchMap = new HashMap<Class, Map<FilterDescription, List<CbMethodHandle>>>();
        this.filterDescriptionList = new ArrayList();
        this.parentUpdateListenerMethodMap = new HashMap<Object, List<CbMethodHandle>>();
        this.comparator = new NaturalOrderComparator();
        this.dirtyFieldMap = new HashMap<Field, DirtyFlag>();
        this.nodeGuardMap = HashMultimap.create();
        this.node2UpdateMethodMap = new HashMap<Object, CbMethodHandle>();
        this.importClasses = new HashSet();
        this.mappedClasses = new HashMap<String, String>();
    }

    public void generateMetaModel() throws Exception {
        this.generateMetaModel(false);
    }

    public void generateMetaModel(boolean supportDirtyFiltering) throws Exception {
        this.LOGGER.debug("start model");
        this.nodeFields = new ArrayList<Field>();
        this.nodeFieldsSortedTopologically = new ArrayList<Field>();
        this.registrationListenerFields = new ArrayList<Field>();
        this.supportDirtyFiltering = supportDirtyFiltering;
        this.generateDependentFields();
        this.generateComplexConstructors();
        this.generatePropertyAssignments();
        this.lifeCycleHandlers();
        this.eventHandlers();
        this.buildDirtySupport();
        this.filterList();
        this.LOGGER.debug("complete model");
    }

    private void generateDependentFields() throws Exception {
        for (Object object : this.dependencyGraph.getSortedDependents()) {
            String name = this.dependencyGraph.variableName(object);
            String overridenClassName = this.nodeClassMap.get(object);
            String defaultClassName = object.getClass().getCanonicalName();
            String className = overridenClassName == null ? defaultClassName : overridenClassName;
            boolean isPublic = this.dependencyGraph.isPublicNode(object);
            this.nodeFields.add(new Field(className, name, object, isPublic));
            this.nodeFieldsSortedTopologically.add(new Field(className, name, object, isPublic));
        }
        this.dependencyGraph.getRegistrationListenerMap().entrySet().stream().forEach(t -> {
            String name = (String)t.getKey();
            Object instance = t.getValue();
            this.registrationListenerFields.add(new Field(instance.getClass().getCanonicalName(), name, instance, true));
        });
        Collections.sort(this.nodeFields, (o1, o2) -> this.comparator.compare(o1.fqn + o1.name, o2.fqn + o2.name));
        Collections.sort(this.registrationListenerFields, (o1, o2) -> this.comparator.compare(o1.fqn + o1.name, o2.fqn + o2.name));
    }

    private void generatePropertyAssignments() {
        this.nodeFields.forEach(new Consumer<Field>(){

            @Override
            public void accept(Field f) {
                try {
                    Object field = f.instance;
                    SimpleEventProcessorModel.this.LOGGER.debug("mapping property mutators for var:{}", (Object)f.name);
                    List properties = Arrays.stream(Introspector.getBeanInfo(f.instance.getClass()).getPropertyDescriptors()).filter(p -> p.getWriteMethod() != null).filter(p -> ClassUtils.propertySupported(p, f, SimpleEventProcessorModel.this.nodeFields)).map(p -> ClassUtils.mapPropertyToJavaSource(p, f, SimpleEventProcessorModel.this.nodeFields, SimpleEventProcessorModel.this.importClasses)).filter(s -> s != null).collect(Collectors.toList());
                    SimpleEventProcessorModel.this.LOGGER.debug("{} properties:{}", (Object)f.name, properties);
                    SimpleEventProcessorModel.this.beanPropertyMap.put(field, properties);
                }
                catch (IntrospectionException ex) {
                    SimpleEventProcessorModel.this.LOGGER.warn("could not process bean properties", (Throwable)ex);
                }
            }
        });
    }

    private void generateComplexConstructors() {
        this.nodeFields.forEach(f -> {
            HashSet privateFields = new HashSet();
            Object field = f.instance;
            this.LOGGER.debug("mapping constructor for var:{}", (Object)f.name);
            List<?> directParents = this.dependencyGraph.getDirectParents(field);
            Field.MappedField[] cstrArgList = new Field.MappedField[directParents.size() + 200];
            Class<?> fieldClass = field.getClass();
            Set fields = ReflectionUtils.getAllFields(fieldClass, (Predicate[])new Predicate[]{input -> {
                if (Modifier.isStatic(input.getModifiers()) || !Modifier.isFinal(input.getModifiers())) {
                    this.LOGGER.debug("ignoring field:{} public:{} final:{} static:{}", new Object[]{input.getName(), Modifier.isPublic(input.getModifiers()), Modifier.isFinal(input.getModifiers()), Modifier.isStatic(input.getModifiers())});
                    return false;
                }
                try {
                    input.setAccessible(true);
                    Object parent = input.get(field);
                    if (parent == null) {
                        return false;
                    }
                    if (directParents.contains(parent)) {
                        Field.MappedField mappedField = new Field.MappedField(input.getName(), this.getFieldForInstance(parent));
                        mappedField.derivedVal = ClassUtils.mapToJavaSource(input.get(field), this.nodeFields, this.importClasses);
                        privateFields.add(mappedField);
                    } else if (List.class.isAssignableFrom(parent.getClass())) {
                        Field.MappedField collectionField = new Field.MappedField(input.getName());
                        List collection = (List)parent;
                        for (Object element : collection) {
                            collectionField.addField(this.getFieldForInstance(element));
                        }
                        collectionField.derivedVal = ClassUtils.mapToJavaSource(parent, this.nodeFields, this.importClasses);
                        if (!collectionField.isEmpty()) {
                            privateFields.add(collectionField);
                        }
                    } else if (Field.MappedField.typeSupported(input)) {
                        this.LOGGER.debug("primitive field:{}, val:{}", (Object)input.getName(), input.get(field));
                        Field.MappedField primitiveField = new Field.MappedField(input.getName(), input.get(field));
                        primitiveField.derivedVal = ClassUtils.mapToJavaSource(input.get(field), this.nodeFields, this.importClasses);
                        privateFields.add(primitiveField);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    java.util.logging.Logger.getLogger(SimpleEventProcessorModel.class.getName()).log(Level.SEVERE, null, ex);
                }
                return false;
            }});
            if (privateFields.isEmpty()) {
                this.LOGGER.debug("{}:default constructor applicable", (Object)f.name);
            } else {
                this.LOGGER.debug("{}:match comoplex constructor private fields:{}", (Object)f.name, privateFields);
                boolean[] matched = new boolean[]{false};
                Set allConstructors = ReflectionUtils.getConstructors(fieldClass, (Predicate[])new Predicate[]{input -> {
                    boolean match = matched[0];
                    if (match) {
                        this.LOGGER.debug("already matched constructor, ignoring");
                        return false;
                    }
                    this.LOGGER.debug("unmatched constructor, reset construtorArgs");
                    Arrays.fill(cstrArgList, null);
                    Parameter[] parameters = input.getParameters();
                    int parameterCount = parameters.length;
                    if (parameterCount == 0 || parameterCount != privateFields.size()) {
                        this.LOGGER.debug("parameterCount:{} privateFieldsCoumt:{} mismatch reject consturtcor", (Object)parameterCount, (Object)privateFields.size());
                    } else {
                        int matchCount = 0;
                        for (Field.MappedField mappedInstance : privateFields) {
                            int i;
                            Object parentInstance = mappedInstance.instance;
                            String varName = mappedInstance.mappedName;
                            Class parentClass = mappedInstance.parentClass();
                            this.LOGGER.debug("match field var:{}, type:{}", (Object)varName, (Object)parentClass);
                            boolean matchOnName = false;
                            this.LOGGER.debug("matching contructor by type and name");
                            for (i = 0; i < parameters.length; ++i) {
                                if (parameters[i] == null) continue;
                                String paramName = parameters[i].getName();
                                Class<?> parameterType = parameters[i].getType();
                                this.LOGGER.debug("constructor parameter type:{}, paramName:{}, varName:{}", new Object[]{parameterType, paramName, varName});
                                if (parameterType == null || !parameterType.isAssignableFrom(parentClass) || !paramName.equals(varName)) continue;
                                ++matchCount;
                                parameters[i] = null;
                                cstrArgList[i] = mappedInstance;
                                matchOnName = true;
                                this.LOGGER.debug("matched constructor arg:{}, by type and name", (Object)paramName);
                                break;
                            }
                            if (matchOnName) continue;
                            this.LOGGER.debug("no match, matching contructor by type only");
                            for (i = 0; i < parameters.length; ++i) {
                                if (parameters[i] == null) continue;
                                Class<?> parameterType = parameters[i].getType();
                                String paramName = parameters[i].getName();
                                this.LOGGER.debug("constructor parameter type:{}, paramName:{}, varName:{}", new Object[]{parameterType, paramName, varName});
                                if (parameterType == null || !parameterType.isAssignableFrom(parentClass)) continue;
                                ++matchCount;
                                parameters[i] = null;
                                cstrArgList[i] = mappedInstance;
                                matchOnName = true;
                                this.LOGGER.debug("matched constructor arg:{}, by type only", (Object)paramName);
                                break;
                            }
                            if (matchOnName) continue;
                            this.LOGGER.debug("no match for varName:{}", (Object)varName);
                            break;
                        }
                        if (matchCount == parameterCount) {
                            this.LOGGER.debug("matched constructor:{}", input);
                            matched[0] = true;
                        } else {
                            this.LOGGER.debug("unmatched constructor:{}", input);
                        }
                    }
                    return matched[0];
                }});
                List collect = Arrays.stream(cstrArgList).filter(f1 -> f1 != null).collect(Collectors.toList());
                this.constructorArgdMap.put(field, collect);
            }
        });
    }

    public List<Field.MappedField> constructorArgs(Object field) {
        List<Field.MappedField> args = this.constructorArgdMap.get(field);
        return args == null ? Collections.EMPTY_LIST : args;
    }

    public List<String> beanProperties(Object field) {
        List<String> args = this.beanPropertyMap.get(field);
        return args == null ? Collections.EMPTY_LIST : args;
    }

    private void lifeCycleHandlers() throws Exception {
        Map<Object, String> inst2Name = this.dependencyGraph.getInstanceMap();
        List<Object> topologicalHandlers = this.dependencyGraph.getSortedDependents();
        HashMultimap parentListenerMultiMap = HashMultimap.create();
        HashMultimap parentListenerMultiMapUnmatched = HashMultimap.create();
        for (Object object : topologicalHandlers) {
            Method[] methodList;
            String name = inst2Name.get(object);
            for (Method method : methodList = object.getClass().getMethods()) {
                String validCb;
                if (method.getAnnotation(Initialise.class) != null) {
                    this.initialiseMethods.add(new CbMethodHandle(method, object, name));
                    if (this.LOGGER.isDebugEnabled()) {
                        validCb = name + "." + method.getName() + "()";
                        this.LOGGER.debug("initialse call back : " + validCb);
                    }
                }
                if (method.getAnnotation(TearDown.class) != null) {
                    this.tearDownMethods.add(0, new CbMethodHandle(method, object, name));
                    if (this.LOGGER.isDebugEnabled()) {
                        validCb = name + "." + method.getName() + "()";
                        this.LOGGER.debug("tear down call back : " + validCb);
                    }
                }
                if (method.getAnnotation(OnBatchEnd.class) != null) {
                    this.batchEndMethods.add(0, new CbMethodHandle(method, object, name));
                    if (this.LOGGER.isDebugEnabled()) {
                        validCb = name + "." + method.getName() + "()";
                        this.LOGGER.debug("batch end call back : " + validCb);
                    }
                }
                if (method.getAnnotation(OnBatchPause.class) != null) {
                    this.batchPauseMethods.add(0, new CbMethodHandle(method, object, name));
                    if (this.LOGGER.isDebugEnabled()) {
                        validCb = name + "." + method.getName() + "()";
                        this.LOGGER.debug("batch pause call back : " + validCb);
                    }
                }
                if (method.getAnnotation(AfterEvent.class) != null) {
                    this.eventEndMethods.add(0, new CbMethodHandle(method, object, name));
                    if (this.LOGGER.isDebugEnabled()) {
                        validCb = name + "." + method.getName() + "()";
                        this.LOGGER.debug("event end call back : " + validCb);
                    }
                }
                if (method.getAnnotation(OnEvent.class) != null) {
                    this.node2UpdateMethodMap.put(object, new CbMethodHandle(method, object, name));
                }
                if (method.getAnnotation(com.fluxtion.api.annotations.EventHandler.class) != null) {
                    this.node2UpdateMethodMap.put(object, new CbMethodHandle(method, object, name));
                }
                if (method.getAnnotation(OnParentUpdate.class) == null) continue;
                CbMethodHandle cbMethodHandle = new CbMethodHandle(method, object, name);
                String val = method.getAnnotation(OnParentUpdate.class).value();
                if (method.getParameterTypes() == null || method.getParameterTypes().length != 1) {
                    String errorMsg = "Cannot create OnParentUpdate callback method must have a single parameter " + cbMethodHandle;
                    this.LOGGER.error(errorMsg);
                    throw new RuntimeException(errorMsg);
                }
                ParentFilter filter = new ParentFilter(method.getParameterTypes()[0], val, cbMethodHandle);
                if (val != null && val.length() > 0) {
                    java.lang.reflect.Field field = null;
                    try {
                        field = object.getClass().getDeclaredField(val);
                    }
                    catch (Exception e) {
                        try {
                            field = object.getClass().getField(val);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    field.setAccessible(true);
                    if (field != null && field.getAnnotation(NoEventReference.class) != null || field.getAnnotation(PushReference.class) != null) {
                        // empty if block
                    }
                    if (field != null && field.get(object) != null) {
                        ParentFilter testFilter;
                        Object parent = field.get(object);
                        if (field.getType().isArray()) {
                            Class<?> classType = field.getType().getComponentType();
                            int length = Array.getLength(parent);
                            for (int i = 0; i < length; ++i) {
                                ParentFilter testFilter2 = new ParentFilter(classType, val, null);
                                if (!testFilter2.exactmatch(filter)) continue;
                                parentListenerMultiMap.put(Array.get(parent, i), (Object)cbMethodHandle);
                            }
                        }
                        if (Collection.class.isAssignableFrom(field.getType())) {
                            ParameterizedType integerListType = (ParameterizedType)field.getGenericType();
                            Class classType = (Class)integerListType.getActualTypeArguments()[0];
                            Collection list = (Collection)field.get(object);
                            list.forEach(arg_0 -> SimpleEventProcessorModel.lambda$lifeCycleHandlers$7(classType, val, filter, (Multimap)parentListenerMultiMap, cbMethodHandle, arg_0));
                        }
                        if ((testFilter = new ParentFilter(parent.getClass(), val, null)).exactmatch(filter)) {
                            parentListenerMultiMap.put(parent, (Object)cbMethodHandle);
                            continue;
                        }
                        if (!testFilter.match(filter)) continue;
                        parentListenerMultiMap.put(parent, (Object)cbMethodHandle);
                        continue;
                    }
                    this.LOGGER.warn("Cannot create OnParentUpdate callback" + cbMethodHandle + " no parent field matches:'" + val + "'");
                    continue;
                }
                parentListenerMultiMapUnmatched.put(object, (Object)cbMethodHandle);
            }
        }
        this.createParentCallBacks((Multimap<Object, CbMethodHandle>)parentListenerMultiMap, (Multimap<Object, CbMethodHandle>)parentListenerMultiMapUnmatched);
    }

    private void createParentCallBacks(Multimap<Object, CbMethodHandle> parentListenerMultiMap, Multimap<Object, CbMethodHandle> parentListenerMultiMapUnmatched) throws Exception {
        List<Object> topologicalHandlers = this.dependencyGraph.getSortedDependents();
        for (Object parent2 : topologicalHandlers) {
            this.parentUpdateListenerMethodMap.put(parent2, new ArrayList());
            List<?> directChildren = this.dependencyGraph.getDirectChildren(parent2);
            Collection childCbList = parentListenerMultiMap.get(parent2);
            Set mappedCbs = childCbList.stream().map(cb -> cb.instance).collect(Collectors.toSet());
            directChildren.stream().filter(child -> !mappedCbs.contains(child)).map(child -> parentListenerMultiMapUnmatched.get(child)).map(cbs -> ClassUtils.findBestParentCB(parent2, cbs)).filter(bestParentCB -> bestParentCB != null).forEach(bestParentCB -> parentListenerMultiMap.put(parent2, bestParentCB));
        }
        parentListenerMultiMap.keySet().stream().forEach(parent -> this.parentUpdateListenerMethodMap.put(parent, new ArrayList(parentListenerMultiMap.get(parent))));
        this.parentUpdateListenerMethodMap.values().forEach(this.dependencyGraph::sortNodeList);
    }

    private void eventHandlers() throws Exception {
        Map<FilterDescription, List<CbMethodHandle>> handlerMap;
        List<Object> topologicalHandlers = this.dependencyGraph.getSortedDependents();
        ArrayList<EventCallList> eventCbList = new ArrayList<EventCallList>();
        HashSet<Object> TEMP_EH_SET = new HashSet<Object>();
        for (Object object : topologicalHandlers) {
            Method[] methodList;
            if (object instanceof FilteredEventHandler) {
                eventCbList.add(new EventCallList((FilteredEventHandler)object));
                TEMP_EH_SET.add(object);
            }
            for (Method method : methodList = object.getClass().getMethods()) {
                if (method.getAnnotation(com.fluxtion.api.annotations.EventHandler.class) == null) continue;
                eventCbList.add(new EventCallList(object, method));
                TEMP_EH_SET.add(object);
            }
        }
        for (EventCallList eventCb : eventCbList) {
            if (eventCb.isFiltered) continue;
            Class eventClass = eventCb.eventTypeClass;
            handlerMap = this.getHandlerMap(eventClass);
            ArrayList callList = new ArrayList(eventCb.dispatchMethods);
            if (!eventCb.isInverseFiltered) {
                if (handlerMap.get(FilterDescription.NO_FILTER) == null) {
                    handlerMap.put(FilterDescription.NO_FILTER, callList);
                } else {
                    handlerMap.get(FilterDescription.NO_FILTER).addAll(callList);
                }
            } else if (handlerMap.get(FilterDescription.INVERSE_FILTER) == null) {
                handlerMap.put(FilterDescription.INVERSE_FILTER, callList);
            } else {
                handlerMap.get(FilterDescription.INVERSE_FILTER).addAll(callList);
            }
            handlerMap = this.getPostHandlerMap(eventClass);
            callList = new ArrayList(eventCb.postDispatchMethods);
            if (!eventCb.isInverseFiltered) {
                if (handlerMap.get(FilterDescription.NO_FILTER) == null) {
                    handlerMap.put(FilterDescription.NO_FILTER, callList);
                    continue;
                }
                handlerMap.get(FilterDescription.NO_FILTER).addAll(callList);
                continue;
            }
            if (handlerMap.get(FilterDescription.INVERSE_FILTER) == null) {
                handlerMap.put(FilterDescription.INVERSE_FILTER, callList);
                continue;
            }
            handlerMap.get(FilterDescription.INVERSE_FILTER).addAll(callList);
        }
        Set<Class> eventClassSet = this.dispatchMap.keySet();
        for (Class eventClass : eventClassSet) {
            ArrayList<CbMethodHandle> callList;
            handlerMap = this.getHandlerMap(eventClass);
            List<CbMethodHandle> noFilterList = handlerMap.get(FilterDescription.NO_FILTER) == null ? Collections.EMPTY_LIST : handlerMap.get(FilterDescription.NO_FILTER);
            List<CbMethodHandle> inverseList = handlerMap.get(FilterDescription.INVERSE_FILTER) == null ? Collections.EMPTY_LIST : handlerMap.get(FilterDescription.INVERSE_FILTER);
            HashSet<CbMethodHandle> set = new HashSet<CbMethodHandle>(inverseList);
            set.addAll(noFilterList);
            if (set.size() > 0) {
                callList = new ArrayList<CbMethodHandle>(set);
                this.dependencyGraph.sortNodeList(callList);
                handlerMap.put(FilterDescription.DEFAULT_FILTER, callList);
            }
            noFilterList = (handlerMap = this.getPostHandlerMap(eventClass)).get(FilterDescription.NO_FILTER) == null ? Collections.EMPTY_LIST : handlerMap.get(FilterDescription.NO_FILTER);
            inverseList = handlerMap.get(FilterDescription.INVERSE_FILTER) == null ? Collections.EMPTY_LIST : handlerMap.get(FilterDescription.INVERSE_FILTER);
            set = new HashSet<CbMethodHandle>(inverseList);
            set.addAll(noFilterList);
            if (set.size() <= 0) continue;
            callList = new ArrayList<CbMethodHandle>(set);
            this.dependencyGraph.sortNodeList(callList);
            handlerMap.put(FilterDescription.DEFAULT_FILTER, callList);
        }
        for (EventCallList eventCb : eventCbList) {
            Map<FilterDescription, List<CbMethodHandle>> postHandlerMap;
            List<CbMethodHandle> postCallList;
            int filterId = eventCb.filterId;
            String filterString = eventCb.filterString;
            boolean isIntFilter = eventCb.isIntFilter;
            boolean isFiltering = eventCb.isFiltered;
            Class eventClass = eventCb.eventTypeClass;
            FilterDescription filterDescription = FilterDescription.NO_FILTER;
            if (isIntFilter && isFiltering) {
                filterDescription = this.flterProducer.getFilterDescription(eventClass, filterId);
            } else {
                if (!isFiltering) continue;
                filterDescription = this.flterProducer.getFilterDescription(eventClass, filterString);
            }
            Map<FilterDescription, List<CbMethodHandle>> handlerMap2 = this.getHandlerMap(eventClass);
            List<CbMethodHandle> callList = handlerMap2.get(filterDescription);
            if (callList == null) {
                callList = new ArrayList<CbMethodHandle>();
                handlerMap2.put(filterDescription, callList);
                callList.addAll(eventCb.dispatchMethods);
            } else {
                for (Object newCbMethod : eventCb.dispatchMethods) {
                    if (callList.contains(newCbMethod)) continue;
                    callList.add((CbMethodHandle)newCbMethod);
                }
            }
            List<CbMethodHandle> nonFilterCbList = handlerMap2.get(FilterDescription.NO_FILTER);
            if (nonFilterCbList != null) {
                Object newCbMethod;
                newCbMethod = nonFilterCbList.iterator();
                while (newCbMethod.hasNext()) {
                    CbMethodHandle nonFilterCb = (CbMethodHandle)newCbMethod.next();
                    if (callList.contains(nonFilterCb)) continue;
                    callList.add(nonFilterCb);
                }
            }
            if ((postCallList = (postHandlerMap = this.getPostHandlerMap(eventClass)).get(filterDescription)) == null) {
                postCallList = new ArrayList<CbMethodHandle>();
                postHandlerMap.put(filterDescription, postCallList);
                postCallList.addAll(eventCb.postDispatchMethods);
            } else {
                for (CbMethodHandle newCbMethod : eventCb.postDispatchMethods) {
                    if (postCallList.contains(newCbMethod)) continue;
                    postCallList.add(newCbMethod);
                }
            }
            List<CbMethodHandle> nonFilterPoistCbList = postHandlerMap.get(FilterDescription.NO_FILTER);
            if (nonFilterPoistCbList != null) {
                for (CbMethodHandle nonFilterCb : nonFilterPoistCbList) {
                    if (postCallList.contains(nonFilterCb)) continue;
                    postCallList.add(nonFilterCb);
                }
            }
            this.dependencyGraph.sortNodeList(callList);
            this.dependencyGraph.sortNodeList(postCallList);
            Collections.reverse(postCallList);
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug(this.dispatchMapToString());
        }
    }

    private Map<FilterDescription, List<CbMethodHandle>> getHandlerMap(Class eventClass) {
        Map<FilterDescription, List<CbMethodHandle>> handlerMap = this.dispatchMap.get(eventClass);
        if (handlerMap == null) {
            handlerMap = new HashMap<FilterDescription, List<CbMethodHandle>>();
            this.dispatchMap.put(eventClass, handlerMap);
        }
        return handlerMap;
    }

    private Map<FilterDescription, List<CbMethodHandle>> getPostHandlerMap(Class eventClass) {
        Map<FilterDescription, List<CbMethodHandle>> handlerMap = this.postDispatchMap.get(eventClass);
        if (handlerMap == null) {
            handlerMap = new HashMap<FilterDescription, List<CbMethodHandle>>();
            this.postDispatchMap.put(eventClass, handlerMap);
        }
        return handlerMap;
    }

    private void buildDirtySupport() throws Exception {
        if (this.supportDirtyFiltering()) {
            for (Field field : this.nodeFields) {
                CbMethodHandle cbHandle = this.node2UpdateMethodMap.get(field.instance);
                if (cbHandle == null || cbHandle.method.getReturnType() != Boolean.TYPE) continue;
                DirtyFlag flag = new DirtyFlag(field, "isDirty_" + field.name);
                this.dirtyFieldMap.put(field, flag);
            }
            for (Object object : this.dependencyGraph.getSortedDependents()) {
                List<?> directParents = this.dependencyGraph.getDirectParentsListeningForEvent(object);
                if (directParents.isEmpty()) continue;
                HashSet<DirtyFlag> guardSet = new HashSet<DirtyFlag>();
                for (Object parent : directParents) {
                    DirtyFlag parentDirtyFlag = this.getDirtyFlagForUpdateCb(this.node2UpdateMethodMap.get(parent));
                    Collection parentDirtyFlags = this.nodeGuardMap.get(parent);
                    if (parentDirtyFlag != null) {
                        guardSet.add(parentDirtyFlag);
                        continue;
                    }
                    if (!parentDirtyFlags.isEmpty()) {
                        guardSet.addAll(parentDirtyFlags);
                        continue;
                    }
                    guardSet.clear();
                    break;
                }
                this.nodeGuardMap.putAll(object, guardSet);
            }
        }
    }

    private void filterList() {
        Set<FilterDescription> keySet;
        HashSet<FilterDescription> uniqueFilterSet = new HashSet<FilterDescription>();
        Collection<Map<FilterDescription, List<CbMethodHandle>>> values = this.dispatchMap.values();
        for (Map<FilterDescription, List<CbMethodHandle>> value : values) {
            keySet = value.keySet();
            for (FilterDescription filterDescription : keySet) {
                uniqueFilterSet.add(filterDescription);
            }
        }
        values = this.postDispatchMap.values();
        for (Map<FilterDescription, List<CbMethodHandle>> value : values) {
            keySet = value.keySet();
            for (FilterDescription filterDescription : keySet) {
                uniqueFilterSet.add(filterDescription);
            }
        }
        this.filterDescriptionList.addAll(uniqueFilterSet);
        this.filterDescriptionList.remove(FilterDescription.NO_FILTER);
        this.LOGGER.debug("filterList:" + this.filterDescriptionList);
    }

    public DirtyFlag getDirtyFlagForNode(Object node) {
        return this.dirtyFieldMap.get(this.getFieldForInstance(node));
    }

    public Collection<DirtyFlag> getNodeGuardConditions(Object node) {
        ArrayList<DirtyFlag> guards = new ArrayList<DirtyFlag>(this.nodeGuardMap.get(node));
        Collections.sort(guards, (o1, o2) -> this.comparator.compare(o1.name, o2.name));
        return guards;
    }

    public Collection<DirtyFlag> getNodeGuardConditions(CbMethodHandle cb) {
        if (cb.isPostEventHandler && this.dependencyGraph.getDirectParents(cb.instance).isEmpty()) {
            DirtyFlag dirtyFlagForNode = this.getDirtyFlagForNode(cb.instance);
            return dirtyFlagForNode == null ? Collections.EMPTY_SET : Arrays.asList(dirtyFlagForNode);
        }
        return cb.isEventHandler ? Collections.EMPTY_SET : this.getNodeGuardConditions(cb.instance);
    }

    public List<DirtyFlag> getNodeGuardConditions_OLD(Object node) {
        ArrayList<DirtyFlag> guards = new ArrayList<DirtyFlag>();
        if (this.supportDirtyFiltering()) {
            List<?> directParents = this.dependencyGraph.getDirectParents(node);
            for (Object parent : directParents) {
                DirtyFlag parentDirtyFlag = this.getDirtyFlagForUpdateCb(this.node2UpdateMethodMap.get(parent));
                if (parentDirtyFlag == null) {
                    guards.clear();
                    break;
                }
                guards.add(parentDirtyFlag);
            }
        }
        return guards;
    }

    public DirtyFlag getDirtyFlagForUpdateCb(CbMethodHandle cbHandle) {
        DirtyFlag flag = null;
        if (this.supportDirtyFiltering() && cbHandle != null && cbHandle.method.getReturnType() == Boolean.TYPE) {
            flag = this.dirtyFieldMap.get(this.getFieldForInstance(cbHandle.instance));
        }
        return flag;
    }

    public Field getFieldForInstance(Object object) {
        Field ret = null;
        for (Field nodeField : this.nodeFields) {
            if (nodeField.instance != object) continue;
            ret = nodeField;
            break;
        }
        return ret;
    }

    public String getMappedClass(String className) {
        if (this.dependencyGraph == null || this.dependencyGraph.getConfig() == null) {
            return className;
        }
        return this.dependencyGraph.getConfig().class2replace.getOrDefault(className, className);
    }

    private boolean supportDirtyFiltering() {
        return this.supportDirtyFiltering;
    }

    public List<Field> getNodeFields() {
        return Collections.unmodifiableList(this.nodeFields);
    }

    public List<Field> getTopologigcallySortedNodeFields() {
        return Collections.unmodifiableList(this.nodeFieldsSortedTopologically);
    }

    public List<Field> getNodeRegistrationListenerFields() {
        return Collections.unmodifiableList(this.registrationListenerFields);
    }

    public List<CbMethodHandle> getInitialiseMethods() {
        return Collections.unmodifiableList(this.initialiseMethods);
    }

    public List<CbMethodHandle> getTearDownMethods() {
        return Collections.unmodifiableList(this.tearDownMethods);
    }

    public List<CbMethodHandle> getBatchEndMethods() {
        return Collections.unmodifiableList(this.batchEndMethods);
    }

    public List<CbMethodHandle> getBatchPauseMethods() {
        return Collections.unmodifiableList(this.batchPauseMethods);
    }

    public List<CbMethodHandle> getEventEndMethods() {
        return Collections.unmodifiableList(this.eventEndMethods);
    }

    public Map<Class, Map<FilterDescription, List<CbMethodHandle>>> getDispatchMap() {
        return Collections.unmodifiableMap(this.dispatchMap);
    }

    public Map<Class, Map<FilterDescription, List<CbMethodHandle>>> getPostDispatchMap() {
        return Collections.unmodifiableMap(this.postDispatchMap);
    }

    public Map<Object, List<CbMethodHandle>> getParentUpdateListenerMethodMap() {
        return Collections.unmodifiableMap(this.parentUpdateListenerMethodMap);
    }

    public Map<Field, DirtyFlag> getDirtyFieldMap() {
        return Collections.unmodifiableMap(this.dirtyFieldMap);
    }

    public List<FilterDescription> getFilterDescriptionList() {
        return Collections.unmodifiableList(this.filterDescriptionList);
    }

    public Set<Class<?>> getImportClasses() {
        return Collections.unmodifiableSet(this.importClasses);
    }

    private String dispatchMapToString() {
        List<CbMethodHandle> cbList;
        int filterId;
        Set<FilterDescription> filterIdSet;
        Map<FilterDescription, List<CbMethodHandle>> cbMap;
        String result = "DispatchMap[\n";
        Set<Class> keySet = this.dispatchMap.keySet();
        for (Class eventId : keySet) {
            result = result + "\tEvent Id:" + eventId + "\n";
            cbMap = this.dispatchMap.get(eventId);
            filterIdSet = cbMap.keySet();
            for (FilterDescription filterDescription : filterIdSet) {
                filterId = filterDescription.value;
                result = result + "\t\tFilter Id:" + filterId + "\n";
                cbList = cbMap.get(filterDescription);
                for (CbMethodHandle cbMethod : cbList) {
                    result = result + "\t\t\t" + cbMethod + "\n";
                }
            }
        }
        result = result + "]\n";
        result = result + "PostDispatchMap[\n";
        keySet = this.postDispatchMap.keySet();
        for (Class eventId : keySet) {
            result = result + "\tEvent Id:" + eventId + "\n";
            cbMap = this.dispatchMap.get(eventId);
            filterIdSet = cbMap.keySet();
            for (FilterDescription filterDescription : filterIdSet) {
                filterId = filterDescription.value;
                result = result + "\t\tFilter Id:" + filterId + "\n";
                cbList = cbMap.get(filterDescription);
                for (CbMethodHandle cbMethod : cbList) {
                    result = result + "\t\t\t" + cbMethod + "\n";
                }
            }
        }
        result = result + "]";
        return result;
    }

    private static /* synthetic */ void lambda$lifeCycleHandlers$7(Class classType, String val, ParentFilter filter, Multimap parentListenerMultiMap, CbMethodHandle cbMethodHandle, Object parent1) {
        ParentFilter testFilter = new ParentFilter(classType, val, null);
        if (testFilter.exactmatch(filter)) {
            parentListenerMultiMap.put(parent1, (Object)cbMethodHandle);
        }
    }

    private class EventCallList {
        final int filterId;
        final String filterString;
        final boolean isIntFilter;
        final boolean isFiltered;
        final boolean isInverseFiltered;
        final Class eventTypeClass;
        private final List sortedDependents;
        private final List<CbMethodHandle> dispatchMethods;
        private List<CbMethodHandle> postDispatchMethods;

        EventCallList(FilteredEventHandler eh) throws Exception {
            this.filterId = SimpleEventProcessorModel.this.filterMap.containsKey(eh) ? ((Integer)SimpleEventProcessorModel.this.filterMap.get(eh)).intValue() : eh.filterId();
            this.sortedDependents = SimpleEventProcessorModel.this.dependencyGraph.getEventSortedDependents(eh);
            this.dispatchMethods = new ArrayList<CbMethodHandle>();
            this.postDispatchMethods = new ArrayList<CbMethodHandle>();
            Class searchClass = Event.class;
            if (eh.eventClass() == null) {
                searchClass = this.eventTypeClass = TypeResolver.resolveRawArguments(EventHandler.class, eh.getClass())[0];
            } else {
                this.eventTypeClass = eh.eventClass();
            }
            Set ehMethodList = ReflectionUtils.getAllMethods(eh.getClass(), (Predicate[])new Predicate[]{Predicates.and((Predicate[])new Predicate[]{ReflectionUtils.withModifier((int)1), ReflectionUtils.withName((String)"onEvent"), ReflectionUtils.withParametersCount((int)1)}), ReflectionUtils.withParameters((Class[])new Class[]{searchClass})});
            Method onEventMethod = (Method)ehMethodList.iterator().next();
            String name = SimpleEventProcessorModel.this.dependencyGraph.variableName(eh);
            this.dispatchMethods.add(new CbMethodHandle(onEventMethod, eh, name, this.eventTypeClass, true));
            for (int i = 1; i < this.sortedDependents.size(); ++i) {
                Method[] methodList;
                Object object = this.sortedDependents.get(i);
                name = SimpleEventProcessorModel.this.dependencyGraph.variableName(object);
                for (Method method : methodList = object.getClass().getDeclaredMethods()) {
                    if (method.getAnnotation(OnEvent.class) != null) {
                        this.dispatchMethods.add(new CbMethodHandle(method, object, name));
                    }
                    if (method.getAnnotation(OnEventComplete.class) == null) continue;
                    this.postDispatchMethods.add(new CbMethodHandle(method, object, name));
                }
            }
            this.filterString = null;
            this.isIntFilter = this.filterId != Integer.MAX_VALUE;
            this.isFiltered = this.filterId != Integer.MAX_VALUE;
            this.isInverseFiltered = false;
        }

        EventCallList(Object instance, Method onEventMethod) throws Exception {
            Method[] methodList;
            boolean overideStringFilter;
            String tmpFilterString = null;
            int tmpFilterId = 0;
            boolean tmpIsIntFilter = true;
            boolean tmpIsFiltered = true;
            boolean tmpIsInverseFiltered = false;
            Set fields = ReflectionUtils.getAllFields(instance.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(FilterId.class)});
            com.fluxtion.api.annotations.EventHandler annotation = onEventMethod.getAnnotation(com.fluxtion.api.annotations.EventHandler.class);
            int filterIdOverride = annotation.filterId();
            String genericFilter = "";
            if (onEventMethod.getGenericParameterTypes().length == 1 && onEventMethod.getGenericParameterTypes()[0] instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)onEventMethod.getGenericParameterTypes()[0];
                Type actualType = pt.getActualTypeArguments()[0];
                genericFilter = actualType instanceof Class ? ((Class)actualType).getCanonicalName() : actualType.getTypeName();
            }
            String filterStringOverride = annotation.filterStringFromClass() != Void.TYPE ? annotation.filterStringFromClass().getCanonicalName() : annotation.filterString();
            filterStringOverride = filterStringOverride.isEmpty() ? genericFilter : filterStringOverride;
            Set s = ReflectionUtils.getAllFields(instance.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withName((String)annotation.filterVariable())});
            if (annotation.filterVariable().length() > 0 && s.size() > 0) {
                java.lang.reflect.Field f = (java.lang.reflect.Field)s.iterator().next();
                f.setAccessible(true);
                if (f.get(instance) != null) {
                    if (f.getType().equals(String.class)) {
                        filterStringOverride = (String)f.get(instance);
                    } else if (f.getType().equals(Integer.TYPE)) {
                        filterIdOverride = f.getInt(instance);
                    } else if (f.getType().equals(Character.TYPE)) {
                        filterIdOverride = f.getChar(instance);
                    } else if (f.getType().equals(Byte.TYPE)) {
                        filterIdOverride = f.getByte(instance);
                    } else if (f.getType().equals(Short.TYPE)) {
                        filterIdOverride = f.getShort(instance);
                    }
                }
            }
            boolean overrideFilter = filterIdOverride != Integer.MAX_VALUE;
            boolean bl = overideStringFilter = filterStringOverride != null && !filterStringOverride.isEmpty();
            if (SimpleEventProcessorModel.this.filterMap.containsKey(instance)) {
                tmpFilterId = (Integer)SimpleEventProcessorModel.this.filterMap.get(instance);
            } else if (fields.isEmpty() && overrideFilter) {
                tmpFilterId = filterIdOverride;
            } else if (fields.isEmpty() && overideStringFilter) {
                tmpFilterString = filterStringOverride;
                tmpIsIntFilter = false;
            } else if (fields.isEmpty()) {
                tmpIsFiltered = false;
                tmpIsIntFilter = false;
                tmpIsInverseFiltered = annotation.value() == FilterType.unmatched;
            } else {
                java.lang.reflect.Field field = (java.lang.reflect.Field)fields.iterator().next();
                field.setAccessible(true);
                Class<?> type = field.getType();
                if (type == Integer.TYPE) {
                    tmpFilterId = field.getInt(instance);
                    tmpIsFiltered = tmpFilterId != Integer.MAX_VALUE;
                } else if (type == String.class) {
                    tmpFilterString = (String)field.get(instance);
                    tmpIsIntFilter = false;
                    if (tmpFilterString == null || tmpFilterString.isEmpty()) {
                        tmpIsFiltered = false;
                    }
                } else {
                    throw new IllegalArgumentException("the annotation filter can only annotate int or String fields");
                }
            }
            this.sortedDependents = annotation.propagate() ? SimpleEventProcessorModel.this.dependencyGraph.getEventSortedDependents(instance) : Collections.EMPTY_LIST;
            this.dispatchMethods = new ArrayList<CbMethodHandle>();
            this.postDispatchMethods = new ArrayList<CbMethodHandle>();
            this.eventTypeClass = onEventMethod.getParameterTypes()[0];
            String name = SimpleEventProcessorModel.this.dependencyGraph.variableName(instance);
            this.dispatchMethods.add(new CbMethodHandle(onEventMethod, instance, name, this.eventTypeClass, true));
            for (Method method : methodList = instance.getClass().getDeclaredMethods()) {
                if (method.getAnnotation(OnEventComplete.class) == null) continue;
                this.postDispatchMethods.add(new CbMethodHandle(method, instance, name));
            }
            for (int i = 0; i < this.sortedDependents.size(); ++i) {
                Object object = this.sortedDependents.get(i);
                name = SimpleEventProcessorModel.this.dependencyGraph.variableName(object);
                for (Method method : methodList = object.getClass().getDeclaredMethods()) {
                    if (method.getAnnotation(OnEvent.class) != null) {
                        this.dispatchMethods.add(new CbMethodHandle(method, object, name));
                    }
                    if (method.getAnnotation(OnEventComplete.class) == null || i <= 0) continue;
                    this.postDispatchMethods.add(new CbMethodHandle(method, object, name));
                }
            }
            this.filterId = tmpFilterId;
            this.filterString = tmpFilterString;
            this.isIntFilter = tmpIsIntFilter;
            this.isFiltered = tmpIsFiltered;
            this.isInverseFiltered = tmpIsInverseFiltered;
        }
    }
}

