/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.util;

import com.fluxtion.generator.model.CbMethodHandle;
import com.google.common.base.Predicate;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ClassUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger(ClassUtils.class);

    public static CbMethodHandle findBestParentCB(Object parent, Collection<CbMethodHandle> cbs) {
        Set classList = cbs.stream().filter(cb -> cb.method.getParameterTypes()[0].isAssignableFrom(parent.getClass())).map(cb -> cb.method.getParameterTypes()[0]).collect(Collectors.toSet());
        if (classList.isEmpty()) {
            return null;
        }
        Optional bestMatch = classList.stream().sorted((c1, c2) -> {
            if (c1 == c2) {
                return 0;
            }
            if (c1.isAssignableFrom((Class<?>)c2)) {
                return 1;
            }
            return -1;
        }).findFirst();
        Optional<CbMethodHandle> findFirst = cbs.stream().filter(cb -> cb.method.getParameterTypes()[0] == bestMatch.orElse(null)).findFirst();
        return findFirst.orElse(null);
    }

    public static boolean typeSupported(Class<?> type) {
        return type.isPrimitive() || type == String.class || type.isEnum() || List.class.isAssignableFrom(type) || type.isArray();
    }

    public static String mapToJavaSource(Object primitiveVal, List<com.fluxtion.generator.model.Field> nodeFields, Set<Class<?>> importList) {
        Class<?> clazz = primitiveVal.getClass();
        String primitiveSuffix = "";
        String primitivePrefix = "";
        if (List.class.isAssignableFrom(clazz)) {
            importList.add(Arrays.class);
            List values = (List)primitiveVal;
            primitiveVal = values.stream().map(f -> ClassUtils.mapToJavaSource(f, nodeFields, importList)).collect(Collectors.joining(", ", "Arrays.asList(", ")"));
        }
        if (clazz.isArray()) {
            Class<?> arrayType = clazz.getComponentType();
            importList.add(arrayType);
            ArrayList<String> strings = new ArrayList<String>();
            int length = Array.getLength(primitiveVal);
            for (int i = 0; i < length; ++i) {
                Object arrayElement = Array.get(primitiveVal, i);
                strings.add(ClassUtils.mapToJavaSource(arrayElement, nodeFields, importList));
            }
            primitiveVal = strings.stream().collect(Collectors.joining(", ", "new " + arrayType.getSimpleName() + "[]{", "}"));
        }
        if (clazz.isEnum()) {
            primitiveVal = clazz.getSimpleName() + "." + ((Enum)primitiveVal).name();
            importList.add(clazz);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            primitiveSuffix = "f";
        }
        if ((clazz == Double.class || clazz == Double.TYPE) && Double.isNaN((Double)primitiveVal)) {
            primitiveVal = "Double.NaN";
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            primitivePrefix = "(byte)";
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            primitivePrefix = "(short)";
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            primitiveSuffix = "L";
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            primitivePrefix = "'";
            primitiveSuffix = "'";
            primitiveVal = StringEscapeUtils.escapeJava((String)primitiveVal.toString());
        }
        if (clazz == String.class || clazz == String.class) {
            primitivePrefix = "\"";
            primitiveSuffix = "\"";
            primitiveVal = StringEscapeUtils.escapeJava((String)primitiveVal.toString());
        }
        for (com.fluxtion.generator.model.Field nodeField : nodeFields) {
            if (nodeField.instance != primitiveVal) continue;
            primitiveVal = nodeField.name;
            break;
        }
        return primitivePrefix + primitiveVal.toString() + primitiveSuffix;
    }

    public static String mapPropertyToJavaSource(PropertyDescriptor property, com.fluxtion.generator.model.Field field, List<com.fluxtion.generator.model.Field> nodeFields, Set<Class<?>> importList) {
        String ret = null;
        if (!ClassUtils.isPropertyTransient(property, field)) {
            try {
                Object value = property.getReadMethod().invoke(field.instance, new Object[0]);
                String mappedValue = ClassUtils.mapToJavaSource(value, nodeFields, importList);
                String writeMethod = property.getWriteMethod().getName();
                for (com.fluxtion.generator.model.Field nodeField : nodeFields) {
                    if (nodeField.instance != value) continue;
                    mappedValue = nodeField.name;
                    break;
                }
                ret = writeMethod + "(" + mappedValue + ")";
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOGGER.warn("cannot introspect bean property", (Throwable)e);
            }
        }
        return ret;
    }

    public static boolean propertySupported(PropertyDescriptor property, com.fluxtion.generator.model.Field field, List<com.fluxtion.generator.model.Field> nodeFields) {
        try {
            boolean isTransient = ClassUtils.isPropertyTransient(property, field);
            boolean writeMethod = property.getWriteMethod() != null;
            boolean hasValue = property.getReadMethod() != null && property.getReadMethod().invoke(field.instance, new Object[0]) != null;
            boolean isNode = false;
            if (hasValue) {
                for (com.fluxtion.generator.model.Field nodeField : nodeFields) {
                    if (nodeField.instance != property.getReadMethod().invoke(field.instance, new Object[0])) continue;
                    isNode = true;
                    break;
                }
            }
            return !isTransient && writeMethod && hasValue && (ClassUtils.typeSupported(property.getPropertyType()) || isNode);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            LOGGER.warn("cannot introspect bean property", (Throwable)e);
            return false;
        }
    }

    public static boolean isPropertyTransient(PropertyDescriptor property, com.fluxtion.generator.model.Field field) throws SecurityException {
        Class<?> fieldClass = field.instance.getClass();
        String name = property.getName();
        Set allFields = ReflectionUtils.getAllFields(fieldClass, (Predicate[])new Predicate[]{ReflectionUtils.withName((String)name)});
        boolean isTransient = true;
        if (!allFields.isEmpty()) {
            Field fieldOfProperty = (Field)allFields.iterator().next();
            fieldOfProperty.setAccessible(true);
            isTransient = Modifier.isTransient(fieldOfProperty.getModifiers());
        }
        return isTransient;
    }
}

