/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator;

import com.fluxtion.builder.generation.GenerationContext;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.exporter.PngGenerator;
import com.fluxtion.generator.model.SimpleEventProcessorModel;
import com.fluxtion.generator.model.TopologicallySortedDependecyGraph;
import com.fluxtion.generator.targets.SepJavaSourceModelHugeFilter;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.transform.TransformerConfigurationException;
import net.openhft.compiler.CachedCompiler;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class Generator {
    private SEPConfig config;
    private static final Logger LOG = LoggerFactory.getLogger(Generator.class);
    private SimpleEventProcessorModel sep;

    public void templateSep(SEPConfig config) throws Exception {
        ExecutorService execSvc = Executors.newCachedThreadPool();
        execSvc.submit(Generator::warmupCompiler);
        config.buildConfig();
        this.config = config;
        LOG.debug("init velocity");
        Generator.initVelocity();
        LOG.debug("start graph calc");
        GenerationContext context = GenerationContext.SINGLETON;
        TopologicallySortedDependecyGraph graph = new TopologicallySortedDependecyGraph(config.nodeList, config.publicNodes, config.declarativeConfig, context, config.auditorMap, config);
        LOG.debug("start model gen");
        this.sep = new SimpleEventProcessorModel(graph, config.filterMap, context.getProxyClassMap());
        this.sep.generateMetaModel(config.supportDirtyFiltering);
        execSvc.submit(() -> {
            LOG.debug("start exporting graphML/images");
            this.exportGraphMl(graph);
            LOG.debug("completed exporting graphML/images");
            LOG.debug("finished generating SEP");
        });
        LOG.debug("start template output");
        File outFile = this.templateJavaOutput();
        LOG.debug("completed template output");
    }

    public static void warmupCompiler() {
        LOG.debug("running compiler warmup");
        try {
            CachedCompiler c = new CachedCompiler(null, null);
            c.loadFromJava("com.fluxtion.compiler.WarmupSample", "package com.fluxtion.compiler;\n\npublic class WarmupSample {\n\n    public String test;\n\n    public String getTest() {\n        return test;\n    }\n    \n}");
        }
        catch (Exception ex) {
            LOG.error("problem running warmup compile", (Throwable)ex);
        }
        finally {
            LOG.debug("completed compiler warmup");
        }
    }

    private static void initVelocity() throws Exception {
        Velocity.setProperty((String)"resource.loader", (Object)"classpath");
        Velocity.setProperty((String)"classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(GenerationContext.SINGLETON.getClassLoader());
        Velocity.init();
        Thread.currentThread().setContextClassLoader(originalClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File templateJavaOutput() throws Exception {
        Template template;
        SepJavaSourceModelHugeFilter srcModelHuge;
        SepJavaSourceModelHugeFilter srcModel = srcModelHuge = new SepJavaSourceModelHugeFilter(this.sep, this.config.inlineEventHandling, this.config.assignPrivateMembers, this.config.maxFiltersInline);
        LOG.debug("building source model");
        srcModel.buildSourceModel();
        if (this.config.templateFile == null) {
            this.config.templateFile = "template/base/javaTemplate.vsl";
        }
        if (this.config.debugTemplateFile == null) {
            this.config.debugTemplateFile = "template/base/javaTemplateDebug.vsl";
        }
        if (this.config.testTemplateFile == null) {
            this.config.testTemplateFile = "template/base/javaTestDecoratorTemplate.vsl";
        }
        if (this.config.introspectorTemplateFile == null) {
            this.config.introspectorTemplateFile = "template/base/javaIntrospectorTemplate.vsl";
        }
        LOG.debug("templating output source - start");
        String templateFile = this.config.templateFile;
        try {
            template = Velocity.getTemplate((String)templateFile);
        }
        catch (Exception e) {
            System.out.println("failed to load template, setting threadcontext class loader");
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(GenerationContext.SINGLETON.getClassLoader());
                template = Velocity.getTemplate((String)templateFile);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
        VelocityContext ctx = new VelocityContext();
        ctx.put("MODEL", (Object)srcModel);
        ctx.put("MODEL_EXTENSION", this.config.templateContextExtension);
        ctx.put("package", (Object)GenerationContext.SINGLETON.getPackageName());
        ctx.put("className", (Object)GenerationContext.SINGLETON.getSepClassName());
        File outFile = new File(GenerationContext.SINGLETON.getPackageDirectory(), GenerationContext.SINGLETON.getSepClassName() + ".java");
        FileWriter templateWriter = new FileWriter(outFile);
        template.merge((Context)ctx, (Writer)templateWriter);
        templateWriter.flush();
        LOG.debug("templating output source - finish");
        if (this.config.generateDebugPrep) {
            // empty if block
        }
        if (this.config.generateTestDecorator) {
            template = Velocity.getTemplate((String)this.config.testTemplateFile);
            ctx = new VelocityContext();
            ctx.put("MODEL", (Object)srcModel);
            ctx.put("MODEL_EXTENSION", this.config.templateContextExtension);
            ctx.put("package", (Object)GenerationContext.SINGLETON.getPackageName());
            ctx.put("className", (Object)GenerationContext.SINGLETON.getSepClassName());
            ctx.put("decoratorClassName", (Object)(GenerationContext.SINGLETON.getSepClassName() + "TestDecorator"));
            outFile = new File(GenerationContext.SINGLETON.getPackageDirectory(), GenerationContext.SINGLETON.getSepClassName() + "TestDecorator.java");
            templateWriter = new FileWriter(outFile);
            template.merge((Context)ctx, (Writer)templateWriter);
            templateWriter.flush();
        }
        templateWriter.close();
        return outFile;
    }

    public static void formatSource(File outFile) {
        try {
            LOG.debug("Reading source:'{}'", (Object)outFile.getCanonicalPath());
            CharSource source = Files.asCharSource((File)outFile, (Charset)Charset.defaultCharset());
            CharSink output = Files.asCharSink((File)outFile, (Charset)Charset.defaultCharset(), (FileWriteMode[])new FileWriteMode[0]);
            LOG.debug("formatting source - start");
            new Formatter().formatSource(source, output);
            LOG.debug("formatting source - finish");
        }
        catch (FormatterException | IOException ex) {
            LOG.error("problem formatting source file", ex);
        }
    }

    private void exportGraphMl(TopologicallySortedDependecyGraph graph) {
        if (this.config.generateDescription) {
            try {
                LOG.debug("generating event images and graphml");
                File graphMl = new File(GenerationContext.SINGLETON.getResourcesOutputDirectory(), GenerationContext.SINGLETON.getSepClassName() + ".graphml");
                File pngFile = new File(GenerationContext.SINGLETON.getResourcesOutputDirectory(), GenerationContext.SINGLETON.getSepClassName() + ".png");
                if (graphMl.getParentFile() != null) {
                    graphMl.getParentFile().mkdirs();
                }
                FileWriter graphMlWriter = new FileWriter(graphMl);
                graph.exportAsGraphMl(graphMlWriter, true);
                PngGenerator.generatePNG(graphMl, pngFile);
            }
            catch (IOException | TransformerConfigurationException | SAXException iOException) {
                LOG.error("error writing png and graphml:", (Throwable)iOException);
            }
        }
    }
}

