/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.compiler;

import com.fluxtion.builder.annotation.ClassProcessor;
import com.fluxtion.builder.annotation.Disabled;
import com.fluxtion.builder.annotation.SepBuilder;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.compiler.InprocessSepCompiler;
import io.github.classgraph.AnnotationParameterValueList;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationCompiler
implements ClassProcessor {
    private Logger LOGGER = LoggerFactory.getLogger((String)AnnotationCompiler.class.getName());
    private File generatedDir;
    private File resourceDir;
    private File rootDir;

    public void outputDirectories(File rootDir, File output, File resourceDir) {
        this.rootDir = rootDir;
        this.generatedDir = output;
        this.resourceDir = resourceDir;
    }

    public void process(URL classPath) {
        if (classPath == null) {
            this.LOGGER.warn("scan classpath is null, exiting AnnotationCompiler");
            return;
        }
        try {
            File fin = new File(classPath.toURI());
            this.LOGGER.debug("AnnotationCompiler scanning url:'{}' for SepBuilder annotations", (Object)fin);
            try (ScanResult scanResult = new ClassGraph().enableAllInfo().overrideClasspath(new Object[]{fin}).scan();){
                ClassInfoList csvList = scanResult.getClassesWithMethodAnnotation(SepBuilder.class.getCanonicalName()).exclude(scanResult.getClassesWithAnnotation(Disabled.class.getCanonicalName()));
                for (ClassInfo csvClassInfo : csvList) {
                    csvClassInfo.getMethodInfo().filter(methodInfo -> methodInfo.hasAnnotation(SepBuilder.class.getCanonicalName()) && !methodInfo.hasAnnotation(Disabled.class.getCanonicalName())).forEach(method -> {
                        try {
                            this.LOGGER.info("sep builder method:" + method);
                            final Object newInstance = csvClassInfo.loadClass().newInstance();
                            Consumer<SEPConfig> consumer = new Consumer<SEPConfig>(){

                                @Override
                                public void accept(SEPConfig cfg) {
                                    try {
                                        method.loadClassAndGetMethod().invoke(newInstance, cfg);
                                    }
                                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                                        AnnotationCompiler.this.LOGGER.error("problem executing SepConfig builder method", (Throwable)ex);
                                    }
                                }
                            };
                            AnnotationParameterValueList params = method.getAnnotationInfo(SepBuilder.class.getCanonicalName()).getParameterValues();
                            String outDir = this.generatedDir.getCanonicalPath();
                            String resDir = this.resourceDir.getCanonicalPath();
                            if (params.get("outputDir") != null) {
                                outDir = this.rootDir.getCanonicalPath() + "/" + params.get("outputDir").toString();
                            }
                            if (params.get("resourceDir") != null) {
                                outDir = this.rootDir.getCanonicalPath() + "/" + params.get("resourceDir").toString();
                            }
                            InprocessSepCompiler.sepInstance(consumer, params.get("packageName").toString(), params.get("name").toString(), outDir, resDir, false);
                        }
                        catch (Exception ex) {
                            this.LOGGER.error("problem creating class containing SepConfig builder method, should have default constructor", (Throwable)ex);
                        }
                    });
                }
            }
            catch (Exception ex) {
                this.LOGGER.error("problem generating static event processor", (Throwable)ex);
            }
        }
        catch (URISyntaxException ex) {
            this.LOGGER.error("problem generating static event processor", (Throwable)ex);
        }
        this.LOGGER.info("AnnotationCompiler completed");
    }
}

