/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.compiler;

import com.fluxtion.builder.annotation.ClassProcessor;
import com.fluxtion.builder.generation.GenerationContext;
import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassProcessorDispatcher
implements BiConsumer<URL, File> {
    static final Logger LOGGER = LoggerFactory.getLogger(ClassProcessorDispatcher.class);

    @Override
    public void accept(final URL url, final File baseDir) {
        ServiceLoader<ClassProcessor> loadServices;
        LOGGER.debug("AnnotationProcessor locator");
        HashSet subTypes = new HashSet();
        if (GenerationContext.SINGLETON != null && GenerationContext.SINGLETON.getClassLoader() != null) {
            LOGGER.debug("using custom class loader to search for factories");
            loadServices = ServiceLoader.load(ClassProcessor.class, GenerationContext.SINGLETON.getClassLoader());
        } else {
            LOGGER.debug("loading services through class loader for this class");
            loadServices = ServiceLoader.load(ClassProcessor.class, this.getClass().getClassLoader());
        }
        loadServices.forEach(t -> subTypes.add(t.getClass()));
        LOGGER.debug("loaded AnnotationProcessors: {}", subTypes);
        final File outDir = GenerationContext.SINGLETON != null && GenerationContext.SINGLETON.getSourceRootDirectory() != null ? GenerationContext.SINGLETON.getSourceRootDirectory() : new File(baseDir, "target/generated-sources/fluxtion");
        final File resDir = GenerationContext.SINGLETON != null && GenerationContext.SINGLETON.getResourcesRootDirectory() != null ? GenerationContext.SINGLETON.getResourcesRootDirectory() : new File(baseDir, "src/main/resources");
        loadServices.forEach(new Consumer<ClassProcessor>(){

            @Override
            public void accept(ClassProcessor t) {
                try {
                    t.outputDirectories(baseDir, outDir, resDir);
                    t.process(url);
                }
                catch (Exception e) {
                    LOGGER.warn("problem executing processor : '" + t + "'", (Throwable)e);
                }
            }
        });
    }
}

