/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.compiler;

import com.fluxtion.api.lifecycle.EventHandler;
import com.fluxtion.api.lifecycle.Lifecycle;
import com.fluxtion.builder.generation.GenerationContext;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.compiler.SepCompiler;
import com.fluxtion.generator.compiler.SepCompilerConfig;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;

public class InprocessSepCompiler {
    public static final String JAVA_TESTGEN_DIR = "target/generated-test-sources/fluxtion/";
    public static final String JAVA_GEN_DIR = "target/generated-sources/fluxtion/";
    public static final String JAVA_SRC_DIR = "src/main/java/";
    public static final String RESOURCE_TEST_DIR = "target/generated-test-sources/resources/";
    public static final String RESOURCE_DIR = "src/main/resources/";

    public static EventHandler sepInstance(Consumer<SEPConfig> cfgBuilder, String pckg, String sepName, DirOptions dirOptions, InitOptions initOptions) throws InstantiationException, IllegalAccessException, Exception {
        String genDir = JAVA_GEN_DIR;
        String resDir = RESOURCE_DIR;
        switch (dirOptions) {
            case JAVA_SRCDIR_OUTPUT: {
                genDir = JAVA_SRC_DIR;
                resDir = RESOURCE_DIR;
                break;
            }
            case TEST_DIR_OUTPUT: {
                genDir = JAVA_TESTGEN_DIR;
                resDir = RESOURCE_TEST_DIR;
            }
        }
        boolean init = initOptions == InitOptions.INIT;
        return InprocessSepCompiler.sepInstance(cfgBuilder, pckg, sepName, genDir, resDir, init);
    }

    public static EventHandler sepInstance(Consumer<SEPConfig> cfgBuilder, String pckg, String sepName) throws InstantiationException, IllegalAccessException, Exception {
        return InprocessSepCompiler.sepInstance(cfgBuilder, pckg, sepName, JAVA_GEN_DIR, RESOURCE_DIR, true);
    }

    public static EventHandler sepTestInstance(Consumer<SEPConfig> cfgBuilder, String pckg, String sepName) throws InstantiationException, IllegalAccessException, Exception {
        return InprocessSepCompiler.sepInstance(cfgBuilder, pckg, sepName, JAVA_TESTGEN_DIR, RESOURCE_TEST_DIR, true);
    }

    public static EventHandler sepInstanceNoInit(Consumer<SEPConfig> cfgBuilder, String pckg, String sepName) throws InstantiationException, IllegalAccessException, Exception {
        return InprocessSepCompiler.sepInstance(cfgBuilder, pckg, sepName, JAVA_GEN_DIR, RESOURCE_DIR, false);
    }

    public static EventHandler sepTestInstanceNoInit(Consumer<SEPConfig> cfgBuilder, String pckg, String sepName) throws InstantiationException, IllegalAccessException, Exception {
        return InprocessSepCompiler.sepInstance(cfgBuilder, pckg, sepName, JAVA_TESTGEN_DIR, RESOURCE_TEST_DIR, false);
    }

    public static EventHandler sepInstance(Consumer<SEPConfig> cfgBuilder, String pckg, String sepName, String srcGenDir, String resGenDir, boolean initialise) throws InstantiationException, IllegalAccessException, Exception {
        Class<EventHandler> sepClass = InprocessSepCompiler.compileSep(cfgBuilder, pckg, sepName, srcGenDir, resGenDir);
        EventHandler sep = sepClass.newInstance();
        if (initialise && sep instanceof Lifecycle) {
            ((Lifecycle)sep).init();
        }
        return sep;
    }

    public static Class<EventHandler> compileSep(Consumer<SEPConfig> cfgBuilder, String pckg, String sepName) throws IOException, InstantiationException, IllegalAccessException, Exception {
        return InprocessSepCompiler.compileSep(cfgBuilder, pckg, sepName, JAVA_GEN_DIR, RESOURCE_DIR);
    }

    public static Class<EventHandler> CompileTestSep(Consumer<SEPConfig> cfgBuilder, String pckg, String sepName) throws IOException, InstantiationException, IllegalAccessException, Exception {
        return InprocessSepCompiler.compileSep(cfgBuilder, pckg, sepName, JAVA_TESTGEN_DIR, RESOURCE_TEST_DIR);
    }

    private static Class<EventHandler> compileSep(Consumer<SEPConfig> cfgBuilder, String pckg, String sepName, String srcGenDir, String resGenDir) throws IOException, InstantiationException, IllegalAccessException, Exception {
        SepCompiler compiler = new SepCompiler();
        SepCompilerConfig compilerCfg = InprocessSepCompiler.getSepCompileConfig(pckg, sepName, srcGenDir, resGenDir);
        compiler.compile(compilerCfg, new InProcessSepConfig(cfgBuilder));
        return Class.forName(compilerCfg.getFqn());
    }

    public static SepCompilerConfig getSepCompileConfig(String packageName, String className, String srcGenDir, String resGenDir) throws IOException {
        File outputDir = new File(srcGenDir);
        File resourcesDir = new File(resGenDir);
        GenerationContext.setupStaticContext((String)packageName, (String)className, (File)outputDir, (File)resourcesDir);
        SepCompilerConfig cfg = new SepCompilerConfig();
        cfg.setOutputDirectory(GenerationContext.SINGLETON.getSourceRootDirectory().getCanonicalPath());
        cfg.setResourcesOutputDirectory(GenerationContext.SINGLETON.getResourcesRootDirectory().getCanonicalPath());
        cfg.setPackageName(packageName);
        cfg.setClassName(className);
        cfg.setCachedCompiler(GenerationContext.SINGLETON.getJavaCompiler());
        cfg.setConfigClass(InProcessSepConfig.class.getCanonicalName());
        return cfg;
    }

    private static class InProcessSepConfig
    extends SEPConfig {
        private final Consumer<SEPConfig> cfg;

        public InProcessSepConfig(Consumer<SEPConfig> cfg) {
            this.cfg = cfg;
        }

        public void buildConfig() {
            this.cfg.accept(this);
        }
    }

    public static enum InitOptions {
        INIT,
        NO_INIT;

    }

    public static enum DirOptions {
        TEST_DIR_OUTPUT,
        JAVA_GENDIR_OUTPUT,
        JAVA_SRCDIR_OUTPUT;

    }
}

