/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.exporter;

import com.fluxtion.generator.Main;
import com.mxgraph.io.mxGraphMlCodec;
import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxConstants;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxStylesheet;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PngGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(PngGenerator.class);

    public static void generatePNG(File graphmlFile, File pngFile) {
        mxGraph graph = new mxGraph();
        mxConstants.SPLIT_WORDS = false;
        mxStylesheet stylesheet = graph.getStylesheet();
        Hashtable<String, Object> style = new Hashtable<String, Object>();
        style.put(mxConstants.STYLE_SHAPE, "rectangle");
        style.put(mxConstants.STYLE_ROUNDED, true);
        style.put(mxConstants.STYLE_OPACITY, 100);
        style.put(mxConstants.STYLE_FILLCOLOR, "#53B9F0");
        style.put(mxConstants.STYLE_FONTCOLOR, "black");
        style.put(mxConstants.STYLE_WHITE_SPACE, "wrap");
        style.put(mxConstants.STYLE_VERTICAL_ALIGN, "middle");
        style.put(mxConstants.STYLE_FONTFAMILY, "Segoe");
        stylesheet.putCellStyle("EVENTHANDLER", style);
        style = new Hashtable();
        style.put(mxConstants.STYLE_SHAPE, "ellipse");
        style.put(mxConstants.STYLE_ROUNDED, true);
        style.put(mxConstants.STYLE_OPACITY, 100);
        style.put(mxConstants.STYLE_FILLCOLOR, "#ffbf80");
        style.put(mxConstants.STYLE_FONTCOLOR, "black");
        style.put(mxConstants.STYLE_FONTFAMILY, "Segoe");
        style.put(mxConstants.STYLE_WHITE_SPACE, "wrap");
        style.put(mxConstants.STYLE_VERTICAL_ALIGN, "middle");
        style.put(mxConstants.STYLE_AUTOSIZE, 1);
        stylesheet.putCellStyle("EVENT", style);
        style = new Hashtable();
        style.put(mxConstants.STYLE_SHAPE, "rectangle");
        style.put(mxConstants.STYLE_WHITE_SPACE, "wrap");
        style.put(mxConstants.STYLE_ROUNDED, true);
        style.put(mxConstants.STYLE_OPACITY, 100);
        mxConstants.SPLIT_WORDS = false;
        style.put(mxConstants.STYLE_FONTCOLOR, "black");
        style.put(mxConstants.STYLE_FILLCOLOR, "#53c68c");
        style.put(mxConstants.STYLE_FONTFAMILY, "Segoe");
        style.put(mxConstants.STYLE_VERTICAL_ALIGN, "middle");
        style.put(mxConstants.STYLE_AUTOSIZE, 1);
        stylesheet.putCellStyle("NODE", style);
        style = new Hashtable();
        style.put(mxConstants.STYLE_SHAPE, "cloud");
        style.put(mxConstants.STYLE_WHITE_SPACE, "wrap");
        style.put(mxConstants.STYLE_ROUNDED, true);
        style.put(mxConstants.STYLE_OPACITY, 100);
        mxConstants.SPLIT_WORDS = false;
        style.put(mxConstants.STYLE_FONTCOLOR, "red");
        style.put(mxConstants.STYLE_FILLCOLOR, "#346789");
        style.put(mxConstants.STYLE_FONTFAMILY, "Segoe");
        style.put(mxConstants.STYLE_VERTICAL_ALIGN, "middle");
        style.put(mxConstants.STYLE_AUTOSIZE, 1);
        stylesheet.putCellStyle("SELECTED", style);
        try {
            Document document = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            document = parser.parse(graphmlFile);
            Object parent = graph.getDefaultParent();
            mxGraphMlCodec.decode((Document)document, (mxGraph)graph);
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            java.util.logging.Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        graph.setCellsEditable(false);
        graph.setCellsMovable(false);
        graph.setCellsResizable(false);
        graph.setCellsDisconnectable(false);
        graph.setCellsLocked(true);
        graph.setConnectableEdges(false);
        Object parent = graph.getDefaultParent();
        mxHierarchicalLayout layoutImpl = new mxHierarchicalLayout(graph);
        layoutImpl.setInterRankCellSpacing(80.0);
        layoutImpl.setIntraCellSpacing(70.0);
        layoutImpl.setFineTuning(true);
        layoutImpl.execute(parent);
        BufferedImage image = mxCellRenderer.createBufferedImage((mxGraph)graph, null, (double)1.0, (Color)Color.WHITE, (boolean)true, null);
        if (!(pngFile.getParentFile() != null && pngFile.getParentFile().mkdirs() || pngFile.getParentFile().exists())) {
            LOG.error("failed to make parent directories for image output");
        }
        if (image == null) {
            LOG.info("no png image generated, need more than one node in sep");
        } else {
            try {
                ImageIO.write((RenderedImage)image, "PNG", pngFile);
                LOG.debug("png image generated:{}", (Object)pngFile.getCanonicalPath());
            }
            catch (IOException ex) {
                java.util.logging.Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

