/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.model;

import com.fluxtion.api.annotations.OnEvent;
import com.fluxtion.api.annotations.OnEventComplete;
import java.lang.reflect.Method;
import java.util.Objects;

public class CbMethodHandle {
    public final Method method;
    public final Object instance;
    public final String variableName;
    public final Class parameterClass;
    public final boolean isEventHandler;
    public final boolean isPostEventHandler;
    public final boolean isInvertedDirtyHandler;

    public CbMethodHandle(Method method, Object instance, String variableName) {
        this(method, instance, variableName, null, false);
    }

    public CbMethodHandle(Method method, Object instance, String variableName, Class parameterClass, boolean isEventHandler) {
        this.method = method;
        this.instance = instance;
        this.variableName = variableName;
        this.parameterClass = parameterClass;
        this.isEventHandler = isEventHandler;
        this.isPostEventHandler = method.getAnnotation(OnEventComplete.class) != null;
        this.isInvertedDirtyHandler = method.getAnnotation(OnEvent.class) != null && !method.getAnnotation(OnEvent.class).dirty();
    }

    public boolean isInvertedDirtyHandler() {
        if (this.isPostEventHandler || this.isEventHandler) {
            return false;
        }
        return this.method.getAnnotation(OnEvent.class) != null && !this.method.getAnnotation(OnEvent.class).dirty();
    }

    public String toString() {
        return "CbMethodHandle{method=" + this.method + ", instance=" + this.instance + ", variableName=" + this.variableName + ", parameterClass=" + this.parameterClass + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Objects.hashCode(this.method);
        hash = 23 * hash + Objects.hashCode(this.instance);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CbMethodHandle other = (CbMethodHandle)obj;
        if (!Objects.equals(this.method, other.method)) {
            return false;
        }
        return Objects.equals(this.instance, other.instance);
    }
}

