/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.model;

import com.fluxtion.api.event.Event;
import com.fluxtion.builder.generation.FilterDescription;
import com.fluxtion.builder.generation.FilterDescriptionProducer;
import com.fluxtion.builder.generation.GenerationContext;
import java.util.ArrayList;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFilterDescriptionProducer
implements FilterDescriptionProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFilterDescriptionProducer.class);
    private ArrayList<FilterDescriptionProducer> namingStrategies;

    public DefaultFilterDescriptionProducer() {
        this.loadServices();
    }

    public final void loadServices() {
        ServiceLoader<FilterDescriptionProducer> loadServices;
        LOGGER.debug("DefaultFilterDescriptionProducer (re)loading strategies");
        this.namingStrategies = new ArrayList();
        if (GenerationContext.SINGLETON != null && GenerationContext.SINGLETON.getClassLoader() != null) {
            LOGGER.debug("using custom class loader to search for NodeNameProducer");
            loadServices = ServiceLoader.load(FilterDescriptionProducer.class, GenerationContext.SINGLETON.getClassLoader());
        } else {
            loadServices = ServiceLoader.load(FilterDescriptionProducer.class);
        }
        loadServices.forEach(this.namingStrategies::add);
        LOGGER.debug("sorted FilterDescriptionProducer strategies : {}", this.namingStrategies);
    }

    public FilterDescription getFilterDescription(Class<? extends Event> event, int filterId) {
        FilterDescription filterDescription = super.getFilterDescription(event, filterId);
        filterDescription.comment = "Event Class:[" + event.getCanonicalName() + "] filterId:[" + filterId + "]";
        for (FilterDescriptionProducer namingStrategy : this.namingStrategies) {
            String commnent = namingStrategy.getFilterDescription(event, (int)filterId).comment;
            if (commnent == null) continue;
            filterDescription.comment = commnent;
            break;
        }
        return filterDescription;
    }

    public FilterDescription getFilterDescription(Class<? extends Event> event, String filterId) {
        FilterDescription filterDescription = super.getFilterDescription(event, filterId);
        filterDescription.comment = "Event Class:[" + event.getCanonicalName() + "] filterString:[" + filterId + "]";
        for (FilterDescriptionProducer namingStrategy : this.namingStrategies) {
            String commnent = namingStrategy.getFilterDescription(event, (String)filterId).comment;
            if (commnent == null) continue;
            filterDescription.comment = commnent;
            break;
        }
        return filterDescription;
    }
}

