/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.model;

import com.fluxtion.generator.util.ClassUtils;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class Field {
    public final String name;
    public final String fqn;
    public final boolean publicAccess;
    public final Object instance;

    public Field(String fqn, String name, Object instance, boolean publicAccess) {
        this.fqn = fqn;
        this.name = name;
        this.instance = instance;
        this.publicAccess = publicAccess;
    }

    public String toString() {
        return "Field{name=" + this.name + ", fqn=" + this.fqn + ", publicAccess=" + this.publicAccess + ", instance=" + this.instance + '}';
    }

    public static class MappedField
    extends Field {
        public final String mappedName;
        public boolean collection = false;
        public boolean primitive = false;
        public Object primitiveVal;
        public ArrayList<Field> elements;
        private String primitivePrefix = "";
        private String primitiveSuffix = "";
        public String derivedVal;

        public MappedField(String mappedName, Field f) {
            super(f.fqn, f.name, f.instance, f.publicAccess);
            this.mappedName = mappedName;
            Class<?> aClass = f.instance.getClass();
            this.collection = List.class.isAssignableFrom(aClass);
            this.elements = new ArrayList();
        }

        public MappedField(String mappedName) {
            super(List.class.getName(), null, null, false);
            this.mappedName = mappedName;
            this.collection = true;
            this.elements = new ArrayList();
        }

        public MappedField(String mappedName, Object primitiveValue) {
            super(null, null, null, false);
            this.mappedName = mappedName;
            this.collection = false;
            this.primitive = true;
            this.primitiveVal = primitiveValue;
            if (this.primitiveVal.getClass() == Float.class) {
                this.primitiveSuffix = "f";
            }
            if (this.primitiveVal.getClass() == Byte.class) {
                this.primitivePrefix = "(byte)";
            }
            if (this.primitiveVal.getClass() == Short.class) {
                this.primitivePrefix = "(short)";
            }
            if (this.primitiveVal.getClass() == Long.class) {
                this.primitiveSuffix = "L";
            }
            if (this.primitiveVal.getClass() == Character.class) {
                this.primitivePrefix = "'";
                this.primitiveSuffix = "'";
            }
            if (this.primitiveVal.getClass() == String.class) {
                this.primitivePrefix = "\"";
                this.primitiveSuffix = "\"";
            }
        }

        public Class parentClass() {
            if (this.collection) {
                return List.class;
            }
            if (this.primitive) {
                if (this.primitiveVal.getClass() == Integer.class) {
                    return Integer.TYPE;
                }
                if (this.primitiveVal.getClass() == Double.class) {
                    return Double.TYPE;
                }
                if (this.primitiveVal.getClass() == Float.class) {
                    return Float.TYPE;
                }
                if (this.primitiveVal.getClass() == Byte.class) {
                    return Byte.TYPE;
                }
                if (this.primitiveVal.getClass() == Short.class) {
                    return Short.TYPE;
                }
                if (this.primitiveVal.getClass() == Long.class) {
                    return Long.TYPE;
                }
                if (this.primitiveVal.getClass() == Boolean.class) {
                    return Boolean.TYPE;
                }
                if (this.primitiveVal.getClass() == Character.class) {
                    return Character.TYPE;
                }
                return this.primitiveVal.getClass();
            }
            return this.instance.getClass();
        }

        public String value() {
            return this.derivedVal;
        }

        public void addField(Field field) {
            if (field != null) {
                this.elements.add(field);
            }
        }

        public boolean isEmpty() {
            return this.elements.isEmpty();
        }

        @Override
        public String toString() {
            return "MappedField{mappedName=" + this.mappedName + ", name=" + this.name + ", collection=" + this.collection + ", fqn=" + this.fqn + ", publicAccess=" + this.publicAccess + ", instance=" + this.instance + '}';
        }

        public static boolean typeSupported(java.lang.reflect.Field input) {
            int modifiers = input.getModifiers();
            return Modifier.isFinal(modifiers) && !Modifier.isStatic(modifiers) && ClassUtils.typeSupported(input.getType());
        }
    }
}

