/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.targets;

import com.fluxtion.builder.generation.FilterDescription;
import com.fluxtion.generator.model.CbMethodHandle;
import com.fluxtion.generator.model.DirtyFlag;
import com.fluxtion.generator.model.SimpleEventProcessorModel;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.reflections.ReflectionUtils;

public class SepJavaSourceModel {
    private final ArrayList<String> initialiseMethodList;
    private String initialiseMethods;
    private final ArrayList<String> batchEndMethodList;
    private String batchEndMethods;
    private final ArrayList<String> eventEndMethodList;
    private String eventEndMethods;
    private final ArrayList<String> batchPauseMethodList;
    private String batchPauseMethods;
    private final ArrayList<String> tearDownMethodList;
    private String tearDownMethods;
    private final ArrayList<String> nodeDeclarationList;
    private String nodeDeclarations;
    private String dirtyFlagDeclarations;
    private String resetDirtyFlags;
    private String filterConstantDeclarations;
    private final ArrayList<String> nodeMemberAssignmentList;
    private String nodeMemberAssignments;
    private String eventDispatch;
    private String eventHandlers;
    private String debugEventHandlers;
    private final boolean isInlineEventHandling;
    private String debugEventDispatch;
    private String testDispatch;
    private final ArrayList<String> publicNodeIdentifierList;
    private final SimpleEventProcessorModel model;

    public SepJavaSourceModel(SimpleEventProcessorModel model) {
        this(model, false);
    }

    public SepJavaSourceModel(SimpleEventProcessorModel model, boolean inlineEventHandling) {
        this.model = model;
        this.eventHandlers = "";
        this.debugEventHandlers = "";
        this.isInlineEventHandling = inlineEventHandling;
        this.initialiseMethodList = new ArrayList();
        this.batchEndMethodList = new ArrayList();
        this.batchPauseMethodList = new ArrayList();
        this.eventEndMethodList = new ArrayList();
        this.tearDownMethodList = new ArrayList();
        this.nodeDeclarationList = new ArrayList();
        this.nodeMemberAssignmentList = new ArrayList();
        this.publicNodeIdentifierList = new ArrayList();
    }

    public void buildSourceModel() throws Exception {
        this.buildMethodSource(this.model.getInitialiseMethods(), this.initialiseMethodList);
        this.buildMethodSource(this.model.getBatchPauseMethods(), this.batchPauseMethodList);
        this.buildMethodSource(this.model.getEventEndMethods(), this.eventEndMethodList);
        this.buildMethodSource(this.model.getBatchEndMethods(), this.batchEndMethodList);
        this.buildMethodSource(this.model.getTearDownMethods(), this.tearDownMethodList);
        this.buildNodeDeclarations();
        this.buildDirtyFlags();
        this.buildFilterConstantDeclarations();
        this.buildMemberAssignments();
        this.buildEventDispatch();
        this.buildTestDispatch();
        this.initialiseMethods = "";
        boolean firstLine = true;
        for (String initialiseMethod : this.initialiseMethodList) {
            this.initialiseMethods = this.initialiseMethods + (firstLine ? "" : "\n") + initialiseMethod;
            firstLine = false;
        }
        this.batchPauseMethods = "";
        firstLine = true;
        for (String initialiseMethod : this.batchPauseMethodList) {
            this.batchPauseMethods = this.batchPauseMethods + (firstLine ? "" : "\n") + initialiseMethod;
            firstLine = false;
        }
        this.batchEndMethods = "";
        firstLine = true;
        for (String initialiseMethod : this.batchEndMethodList) {
            this.batchEndMethods = this.batchEndMethods + (firstLine ? "" : "\n") + initialiseMethod;
            firstLine = false;
        }
        this.eventEndMethods = "";
        firstLine = true;
        for (String initialiseMethod : this.eventEndMethodList) {
            this.eventEndMethods = this.eventEndMethods + (firstLine ? "" : "\n") + initialiseMethod;
            firstLine = false;
        }
        this.tearDownMethods = "";
        for (String initialiseMethod : this.tearDownMethodList) {
            this.tearDownMethods = this.tearDownMethods + initialiseMethod + "\n";
        }
        this.tearDownMethods = StringUtils.chomp((String)this.tearDownMethods);
        this.nodeMemberAssignments = "";
        firstLine = true;
        for (String initialiseMethod : this.nodeMemberAssignmentList) {
            this.nodeMemberAssignments = this.nodeMemberAssignments + (firstLine ? "    " : "\n    ") + initialiseMethod;
            firstLine = false;
        }
    }

    private void buildMethodSource(List<CbMethodHandle> methodList, List methodSourceList) {
        for (CbMethodHandle method : methodList) {
            String methodString = String.format("%8s%s.%s();", "", method.variableName, method.method.getName());
            methodSourceList.add(methodString);
        }
    }

    private void buildDirtyFlags() {
        this.dirtyFlagDeclarations = "";
        this.resetDirtyFlags = "";
        for (DirtyFlag flag : this.model.getDirtyFieldMap().values()) {
            this.dirtyFlagDeclarations = this.dirtyFlagDeclarations + String.format("%4sprivate boolean %s = false;%n", "", flag.name);
            this.resetDirtyFlags = this.resetDirtyFlags + String.format("%8s%s = false;%n", "", flag.name);
        }
        this.dirtyFlagDeclarations = StringUtils.chomp((String)this.dirtyFlagDeclarations);
        this.resetDirtyFlags = StringUtils.chomp((String)this.resetDirtyFlags);
    }

    private void buildNodeDeclarations() {
        this.nodeDeclarations = "";
        boolean firstLine = true;
        for (com.fluxtion.generator.model.Field field : this.model.getNodeFields()) {
            String access = field.publicAccess ? "public" : "private";
            String declaration = String.format("%4s%s final %s %s = new %s();", "", access, field.fqn.replace("$", "."), field.name, field.fqn.replace("$", "."));
            this.nodeDeclarationList.add(declaration);
            this.nodeDeclarations = this.nodeDeclarations + (firstLine ? "" : "\n") + declaration;
            firstLine = false;
            if (!field.publicAccess) continue;
            this.publicNodeIdentifierList.add(field.name);
        }
    }

    private void buildFilterConstantDeclarations() {
        this.filterConstantDeclarations = "";
        boolean firstLine = true;
        ArrayList<FilterDescription> tmp = new ArrayList<FilterDescription>(this.model.getFilterDescriptionList());
        tmp.sort((o1, o2) -> o1.value - o2.value);
        for (FilterDescription filterDescription : tmp) {
            if (filterDescription.variableName == null) continue;
            String declaration = String.format("    public static final int %s = %d;", filterDescription.variableName, filterDescription.value);
            this.filterConstantDeclarations = this.filterConstantDeclarations + (firstLine ? "" : "\n") + declaration;
            firstLine = false;
        }
    }

    private void buildEventDispatch() {
        this.buildEventDispatch(false);
        this.buildEventDispatch(true);
    }

    private void buildEventDispatch(boolean isDebug) {
        String dispatchString = "        switch (event.eventId()) {\n";
        String dispatchStringNoId = "        switch (event.getClass().getName()) {\n";
        boolean idDispatch = false;
        boolean noIdDispatch = false;
        Map<Class, Map<FilterDescription, List<CbMethodHandle>>> dispatchMap = this.model.getDispatchMap();
        Map<Class, Map<FilterDescription, List<CbMethodHandle>>> postDispatchMap = this.model.getPostDispatchMap();
        Set<Class> keySet = dispatchMap.keySet();
        HashSet<Class> classSet = new HashSet<Class>(keySet);
        classSet.addAll(postDispatchMap.keySet());
        ArrayList<Class> clazzList = new ArrayList<Class>(classSet);
        Collections.sort(clazzList, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        for (Class eventId : clazzList) {
            Map<FilterDescription, List<CbMethodHandle>> cbMapPostEvent;
            Map<FilterDescription, List<CbMethodHandle>> cbMap;
            if (SepJavaSourceModel.hasIdField(eventId)) {
                dispatchString = dispatchString + String.format("%12scase (%s.ID):{%n", "", eventId.getCanonicalName());
                dispatchString = dispatchString + String.format("%16s%s typedEvent = (%s)event;%n", "", eventId.getCanonicalName(), eventId.getCanonicalName());
                if (isDebug) {
                    dispatchString = dispatchString + String.format("%16sdebugger.eventInvocation(event);%n", "");
                }
                cbMap = dispatchMap.get(eventId);
                cbMapPostEvent = postDispatchMap.get(eventId);
                dispatchString = dispatchString + this.buildFiteredDispatch(cbMap, cbMapPostEvent, isDebug, eventId);
                dispatchString = dispatchString + String.format("%16sbreak;%n", "");
                dispatchString = dispatchString + String.format("%12s}%n", "");
                idDispatch = true;
                continue;
            }
            dispatchStringNoId = dispatchStringNoId + String.format("%12scase (\"%s\"):{%n", "", eventId.getName());
            dispatchStringNoId = dispatchStringNoId + String.format("%16s%s typedEvent = (%s)event;%n", "", eventId.getCanonicalName(), eventId.getCanonicalName());
            if (isDebug) {
                dispatchStringNoId = dispatchStringNoId + String.format("%16sdebugger.eventInvocation(event);%n", "");
            }
            cbMap = dispatchMap.get(eventId);
            cbMapPostEvent = postDispatchMap.get(eventId);
            dispatchStringNoId = dispatchStringNoId + this.buildFiteredDispatch(cbMap, cbMapPostEvent, isDebug, eventId);
            dispatchStringNoId = dispatchStringNoId + String.format("%16sbreak;%n", "");
            dispatchStringNoId = dispatchStringNoId + String.format("%12s}%n", "");
            noIdDispatch = true;
        }
        dispatchString = dispatchString + String.format("%8s}%n", "");
        dispatchStringNoId = dispatchStringNoId + String.format("%8s}%n", "");
        if (this.isInlineEventHandling) {
            dispatchString = dispatchString + String.format("%8safterEvent();%n", "");
            dispatchStringNoId = dispatchStringNoId + String.format("%8safterEvent();%n", "");
        }
        if (!idDispatch) {
            dispatchString = "";
        }
        if (!noIdDispatch) {
            dispatchStringNoId = "";
        }
        dispatchString = dispatchString + dispatchStringNoId;
        if (isDebug) {
            this.debugEventDispatch = "//DEBUG\n" + dispatchString;
        } else {
            this.eventDispatch = dispatchString;
        }
    }

    private static boolean hasIdField(Class e) {
        Set allFields = ReflectionUtils.getFields((Class)e, (Predicate[])new Predicate[]{Predicates.and((Predicate[])new Predicate[]{ReflectionUtils.withName((String)"ID"), ReflectionUtils.withType(Integer.TYPE), ReflectionUtils.withModifier((int)1), ReflectionUtils.withModifier((int)8), ReflectionUtils.withModifier((int)16)})});
        return allFields.size() > 0;
    }

    private String buildFilteredSwitch(Map<FilterDescription, List<CbMethodHandle>> cbMap, Map<FilterDescription, List<CbMethodHandle>> cbMapPostEvent, boolean isDebug, boolean intFilter, boolean noFilter) {
        Set<FilterDescription> filterIdSet = cbMap.keySet();
        ArrayList<FilterDescription> clazzList = new ArrayList<FilterDescription>(filterIdSet);
        Collections.sort(clazzList, (o1, o2) -> {
            int ret = o1.value - o2.value;
            if (!o1.isIntFilter && !o2.isIntFilter) {
                ret = o1.stringValue.compareTo(o2.stringValue);
            } else if (o1.isIntFilter && !o2.isIntFilter) {
                ret = 1;
            } else if (!o1.isIntFilter && o2.isIntFilter) {
                ret = -1;
            }
            return ret;
        });
        String switchFilter = "";
        for (FilterDescription filterDescription : clazzList) {
            if (intFilter != filterDescription.isIntFilter && !noFilter) continue;
            boolean noFilterDescription = filterDescription == FilterDescription.NO_FILTER;
            String filterValue = intFilter ? filterDescription.value + "" : "\"" + filterDescription.stringValue + "\"";
            String filterVariable = filterDescription.variableName;
            List<CbMethodHandle> cbList = cbMap.get(filterDescription);
            if (!noFilter || !noFilterDescription) {
                if (noFilter || noFilterDescription) continue;
                if (filterDescription.comment != null) {
                    switchFilter = switchFilter + String.format("%-20s%s%n", "//", filterDescription.comment);
                }
                switchFilter = filterVariable == null ? switchFilter + String.format("%20scase (%s):%n", "", filterValue) : switchFilter + String.format("%20scase (%s):%n", "", filterVariable);
            }
            cbList = cbList == null ? Collections.EMPTY_LIST : cbList;
            for (CbMethodHandle method : cbList) {
                DirtyFlag dirtyFlagForUpdateCb = this.model.getDirtyFlagForUpdateCb(method);
                String dirtyAssignment = "";
                if (dirtyFlagForUpdateCb != null) {
                    dirtyAssignment = dirtyFlagForUpdateCb.name + " = ";
                }
                Collection<DirtyFlag> nodeGuardConditions = this.model.getNodeGuardConditions(method);
                String OR = "";
                if (nodeGuardConditions.size() > 0) {
                    switchFilter = switchFilter + String.format("%24sif(", "");
                    for (DirtyFlag nodeGuardCondition : nodeGuardConditions) {
                        switchFilter = switchFilter + OR + nodeGuardCondition.name;
                        OR = " || ";
                    }
                    switchFilter = switchFilter + ") {\n";
                }
                if (isDebug) {
                    switchFilter = switchFilter + String.format("%24sdebugger.nodeInvocation(%s, \"%s\");%n", "", method.variableName, method.variableName);
                }
                switchFilter = method.parameterClass == null ? switchFilter + String.format("%24s%s%s.%s();\n", "", dirtyAssignment, method.variableName, method.method.getName()) : switchFilter + String.format("%24s%s%s.%s(typedEvent);%n", "", dirtyAssignment, method.variableName, method.method.getName());
                Map<Object, List<CbMethodHandle>> listenerMethodMap = this.model.getParentUpdateListenerMethodMap();
                Object parent = method.instance;
                String parentVar = method.variableName;
                DirtyFlag parentFlag = this.model.getDirtyFieldMap().get(this.model.getFieldForInstance(parent));
                List<CbMethodHandle> updateListenerCbList = listenerMethodMap.get(parent);
                if (parentFlag != null && updateListenerCbList.size() > 0) {
                    switchFilter = switchFilter + String.format("%20sif(%s) {\n", "", parentFlag.name);
                }
                for (CbMethodHandle cbMethod : updateListenerCbList) {
                    switchFilter = switchFilter + String.format("%24s%s.%s(%s);%n", "", cbMethod.variableName, cbMethod.method.getName(), parentVar);
                }
                if (parentFlag != null && updateListenerCbList.size() > 0) {
                    switchFilter = switchFilter + String.format("%20s}\n", "", parentFlag.name);
                }
                if (nodeGuardConditions.size() <= 0) continue;
                switchFilter = switchFilter + String.format("%16s}\n", "");
            }
            cbList = cbMapPostEvent.get(filterDescription);
            if (cbList == null || cbList.size() > 0) {
                switchFilter = switchFilter + String.format("%16s//event stack unwind callbacks\n", "");
            }
            cbList = cbList == null ? Collections.EMPTY_LIST : cbList;
            for (CbMethodHandle method : cbList) {
                Collection<DirtyFlag> nodeGuardConditions = this.model.getNodeGuardConditions(method);
                String OR = "";
                if (nodeGuardConditions.size() > 0) {
                    switchFilter = switchFilter + String.format("%24sif(", "");
                    for (DirtyFlag nodeGuardCondition : nodeGuardConditions) {
                        switchFilter = switchFilter + OR + nodeGuardCondition.name;
                        OR = " || ";
                    }
                    switchFilter = switchFilter + ") {\n";
                }
                if (isDebug) {
                    switchFilter = switchFilter + String.format("%24sdebugger.nodeInvocation(%s, \"%s\");%n", "", method.variableName, method.variableName);
                }
                switchFilter = method.parameterClass == null ? switchFilter + String.format("%24s%s%s.%s();\n", "", "", method.variableName, method.method.getName()) : switchFilter + String.format("%24s%s%s.%s(typedEvent);%n", "", "", method.variableName, method.method.getName());
                if (nodeGuardConditions.size() <= 0) continue;
                switchFilter = switchFilter + String.format("%16s}\n", "");
            }
            if (noFilter) continue;
            switchFilter = switchFilter + String.format("%24sbreak;%n", "");
        }
        return switchFilter.length() == 0 ? null : switchFilter;
    }

    private String buildFiteredDispatch(Map<FilterDescription, List<CbMethodHandle>> cbMap, Map<FilterDescription, List<CbMethodHandle>> cbMapPostEvent, boolean isDebug, Class eventClass) {
        String dispatchString = "";
        String eventHandlerString = "";
        String intFilterSwitch = this.buildFilteredSwitch(cbMap, cbMapPostEvent, isDebug, true, false);
        String stringFilterSwitch = this.buildFilteredSwitch(cbMap, cbMapPostEvent, isDebug, false, false);
        String noFilterDispatch = this.buildFilteredSwitch(cbMap, cbMapPostEvent, isDebug, false, true);
        if (!this.isInlineEventHandling) {
            dispatchString = dispatchString + String.format("%16shandleEvent(typedEvent);%n", "");
            eventHandlerString = eventHandlerString + String.format("%n%4spublic void handleEvent(%s typedEvent) {%n", "", eventClass.getCanonicalName());
            if (intFilterSwitch != null) {
                eventHandlerString = eventHandlerString + String.format("%8sswitch (typedEvent.filterId()) {%n", "");
                eventHandlerString = eventHandlerString + intFilterSwitch;
                if (noFilterDispatch != null) {
                    eventHandlerString = eventHandlerString + String.format("//No filter match%n%12sdefault:%n%s%12sbreak;%n", "", noFilterDispatch, "");
                }
                eventHandlerString = eventHandlerString + String.format("%8s}%n", "");
            }
            if (stringFilterSwitch != null) {
                eventHandlerString = eventHandlerString + String.format("%8sswitch (typedEvent.filterString()) {%n", "");
                eventHandlerString = eventHandlerString + stringFilterSwitch;
                if (noFilterDispatch != null) {
                    eventHandlerString = eventHandlerString + String.format("//No filter match%n%12sdefault:%n%s%12sbreak;%n", "", noFilterDispatch, "");
                }
                eventHandlerString = eventHandlerString + String.format("%8s}%n", "");
            }
            eventHandlerString = eventHandlerString + String.format("%8safterEvent();%n", "");
            eventHandlerString = eventHandlerString + String.format("%4s}%n", "");
        } else {
            if (noFilterDispatch != null) {
                dispatchString = dispatchString + noFilterDispatch;
            }
            if (intFilterSwitch != null) {
                dispatchString = dispatchString + String.format("%16sswitch (typedEvent.filterId()) {%n", "");
                dispatchString = dispatchString + intFilterSwitch;
                dispatchString = dispatchString + String.format("%16s}%n", "");
            }
            if (stringFilterSwitch != null) {
                dispatchString = dispatchString + String.format("%16sswitch (typedEvent.filterString()) {%n", "");
                dispatchString = dispatchString + stringFilterSwitch;
                dispatchString = dispatchString + String.format("%16s}%n", "");
            }
        }
        if (isDebug) {
            this.debugEventHandlers = this.debugEventHandlers + eventHandlerString;
        } else {
            this.eventHandlers = this.eventHandlers + eventHandlerString;
        }
        return dispatchString;
    }

    private void buildTestDispatch() {
        this.testDispatch = "";
        this.testDispatch = this.testDispatch + "    public void testNode(AssertTestEvent assertTestEvent) {\n";
        this.testDispatch = this.testDispatch + "        switch (assertTestEvent.nodeName) {\n";
        for (com.fluxtion.generator.model.Field field : this.model.getNodeFields()) {
            if (!field.publicAccess) continue;
            this.testDispatch = this.testDispatch + String.format("%12scase (\"%s\"): {%n", "", field.name);
            this.testDispatch = this.testDispatch + String.format("%16s%s node = sep.%s;%n", "", field.fqn, field.name);
            this.testDispatch = this.testDispatch + String.format("%16sbreak;%n", "");
            this.testDispatch = this.testDispatch + String.format("%12s}%n", "");
        }
        this.testDispatch = this.testDispatch + String.format("%8s}%n", "");
        this.testDispatch = this.testDispatch + String.format("%4s}%n", "");
    }

    private void buildMemberAssignments() throws Exception {
        List<com.fluxtion.generator.model.Field> nodeFields = this.model.getNodeFields();
        for (com.fluxtion.generator.model.Field field : nodeFields) {
            Object object = field.instance;
            String varName = field.name;
            Field[] fields = object.getClass().getFields();
            this.nodeMemberAssignmentList.add(String.format("%4s//%s", "", varName));
            for (Field instanceField : fields) {
                Collection list;
                if ((instanceField.getModifiers() & 0x98) != 0 || (instanceField.getModifiers() & 6) != 0) continue;
                instanceField.setAccessible(true);
                if (instanceField.getType().isArray()) {
                    int i;
                    Object array = instanceField.get(object);
                    if (array == null) continue;
                    int length = Array.getLength(array);
                    String className = instanceField.getType().getComponentType().getName();
                    this.nodeMemberAssignmentList.add(String.format("%4s%s.%s = new %s[%d];", "", varName, instanceField.getName(), className, length));
                    if (instanceField.getType().getComponentType().isPrimitive()) {
                        for (i = 0; i < length; ++i) {
                            String value = Array.get(array, i).toString();
                            this.nodeMemberAssignmentList.add(String.format("%4s%s.%s[%d] = %s;", "", varName, instanceField.getName(), i, value));
                        }
                        continue;
                    }
                    for (i = 0; i < length; ++i) {
                        Object refField = Array.get(array, i);
                        com.fluxtion.generator.model.Field nodeReference = this.model.getFieldForInstance(refField);
                        if (nodeReference == null) continue;
                        this.nodeMemberAssignmentList.add(String.format("%4s%s.%s[%d] = %s;", "", varName, instanceField.getName(), i, nodeReference.name));
                    }
                    continue;
                }
                com.fluxtion.generator.model.Field nodeReference = this.model.getFieldForInstance(instanceField.get(object));
                if (instanceField.getType().isPrimitive()) {
                    String value = instanceField.get(object).toString();
                    if (instanceField.getType().equals(Character.TYPE)) {
                        this.nodeMemberAssignmentList.add(String.format("%4s%s.%s = '%s';", "", varName, instanceField.getName(), value));
                        continue;
                    }
                    this.nodeMemberAssignmentList.add(String.format("%4s%s.%s = %s;", "", varName, instanceField.getName(), value));
                    continue;
                }
                if (instanceField.isEnumConstant()) {
                    String value = instanceField.get(object).toString();
                    this.nodeMemberAssignmentList.add(String.format("//ENUM %4s%s.%s = \"%s\";", "", varName, instanceField.getName(), value));
                    continue;
                }
                if (nodeReference != null) {
                    this.nodeMemberAssignmentList.add(String.format("%4s%s.%s = %s;", "", varName, instanceField.getName(), nodeReference.name));
                    continue;
                }
                if (instanceField.getType().equals(String.class)) {
                    String value = instanceField.get(object).toString();
                    this.nodeMemberAssignmentList.add(String.format("%4s%s.%s = \"%s\";", "", varName, instanceField.getName(), value));
                    continue;
                }
                if (!Collection.class.isAssignableFrom(instanceField.getType()) || (list = (Collection)instanceField.get(object)) == null) continue;
                for (Object parent : list) {
                    com.fluxtion.generator.model.Field nodeParentReference = this.model.getFieldForInstance(parent);
                    String joiner = ".";
                    if (nodeParentReference == null) continue;
                    this.nodeMemberAssignmentList.add(String.format("%4s%s%s%s.add(%s);", "", varName, joiner, instanceField.getName(), nodeParentReference.name));
                }
            }
        }
    }

    public ArrayList<String> getInitialiseMethodList() {
        return this.initialiseMethodList;
    }

    public String getInitialiseMethods() {
        return this.initialiseMethods;
    }

    public ArrayList<String> getBatchEndMethodList() {
        return this.batchEndMethodList;
    }

    public ArrayList<String> getBatchPauseMethodList() {
        return this.batchPauseMethodList;
    }

    public ArrayList<String> getEventEndMethodList() {
        return this.eventEndMethodList;
    }

    public ArrayList<String> getTearDownMethodList() {
        return this.tearDownMethodList;
    }

    public ArrayList<String> getNodeDeclarationList() {
        return this.nodeDeclarationList;
    }

    public ArrayList<String> getNodeMemberAssignmentList() {
        return this.nodeMemberAssignmentList;
    }

    public ArrayList<String> getPublicNodeList() {
        return this.publicNodeIdentifierList;
    }

    public String getTestDispatch() {
        return this.testDispatch;
    }

    public String getNodeMemberAssignments() {
        return this.nodeMemberAssignments;
    }

    public String getFilterConstantDeclarations() {
        return this.filterConstantDeclarations;
    }

    public String getEventDispatch() {
        return this.eventDispatch;
    }

    public String getEventHandlers() {
        return this.eventHandlers;
    }

    public String getDebugEventHandlers() {
        return this.debugEventHandlers;
    }

    public String getDebugEventDispatch() {
        return this.debugEventDispatch;
    }

    public String getNodeDeclarations() {
        return this.nodeDeclarations;
    }

    public String getDirtyFlagDeclarations() {
        return this.dirtyFlagDeclarations;
    }

    public String getResetDirtyFlags() {
        return this.resetDirtyFlags;
    }

    public String getBatchEndMethods() {
        return this.batchEndMethods;
    }

    public String getEventEndMethods() {
        return this.eventEndMethods;
    }

    public String getBatchPauseMethods() {
        return this.batchPauseMethods;
    }

    public String getTearDownMethods() {
        return this.tearDownMethods;
    }

    public String toString() {
        return "SepJavaSourceModel{\ninitialiseMethods=" + this.initialiseMethodList + ", \nbatchEndMethods=" + this.batchEndMethodList + ", \nbatchPauseMethods=" + this.batchPauseMethodList + ", \neventEndMethods=" + this.eventEndMethodList + ", \ntearDownMethods=" + this.tearDownMethodList + ", \nnodeDeclarations=" + this.nodeDeclarationList + ", \neventDispatch=" + this.eventDispatch + ", \nnodeMemberAssignments=" + this.nodeMemberAssignmentList + ", \nmodel=" + this.model + "\n}";
    }
}

