/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.generator.targets;

import com.fluxtion.api.annotations.EventHandler;
import com.fluxtion.api.annotations.OnEvent;
import com.fluxtion.api.annotations.OnParentUpdate;
import com.fluxtion.api.audit.Auditor;
import com.fluxtion.builder.generation.FilterDescription;
import com.fluxtion.builder.generation.GenerationContext;
import com.fluxtion.generator.model.CbMethodHandle;
import com.fluxtion.generator.model.DirtyFlag;
import com.fluxtion.generator.model.Field;
import com.fluxtion.generator.model.InvokerFilterTarget;
import com.fluxtion.generator.model.SimpleEventProcessorModel;
import com.fluxtion.generator.targets.JavaGenHelper;
import com.fluxtion.generator.util.NaturalOrderComparator;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.list.dsl.MirrorList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.reflections.ReflectionUtils;

public class SepJavaSourceModelHugeFilter {
    private int maxFilterBranches = 2;
    private final ArrayList<String> initialiseMethodList;
    private String initialiseMethods;
    private final ArrayList<String> batchEndMethodList;
    private String batchEndMethods;
    private final ArrayList<String> eventEndMethodList;
    private String eventEndMethods;
    private final ArrayList<String> batchPauseMethodList;
    private String batchPauseMethods;
    private final ArrayList<String> tearDownMethodList;
    private String tearDownMethods;
    private final ArrayList<String> nodeDeclarationList;
    private final ArrayList<String> importList;
    private String nodeDeclarations;
    private String dirtyFlagDeclarations;
    private String resetDirtyFlags;
    private String filterConstantDeclarations;
    private final ArrayList<String> nodeMemberAssignmentList;
    private String nodeMemberAssignments;
    private String eventDispatch;
    private String eventHandlers;
    private ArrayList<InvokerFilterTarget> filteredInvokerList;
    private ArrayList<InvokerFilterTarget> filteredInvokerListDebug;
    private String debugEventHandlers;
    private final boolean isInlineEventHandling;
    private String debugEventDispatch;
    private String eventAuditDispatch;
    private String testDispatch;
    private final ArrayList<String> publicNodeIdentifierList;
    private final SimpleEventProcessorModel model;
    private boolean assignPrivateMembers;
    private boolean auditingEvent;
    private boolean auditingInvocations;
    private String auditMethodString;
    private final StringBuilder nodeDecBuilder = new StringBuilder(5000000);
    private HashMap<String, String> importMap = new HashMap();
    private static final String s4 = "    ";
    private static final String s8 = "        ";
    private static final String s12 = "            ";
    private static final String s16 = "                ";
    private static final String s20 = "                    ";
    private static final String s24 = "                        ";
    private final StringBuilder ct = new StringBuilder(5000000);
    private final StringBuilder switchF = new StringBuilder(5000000);

    public SepJavaSourceModelHugeFilter(SimpleEventProcessorModel model) {
        this(model, false);
    }

    public SepJavaSourceModelHugeFilter(SimpleEventProcessorModel model, boolean inlineEventHandling) {
        this(model, inlineEventHandling, false);
    }

    public SepJavaSourceModelHugeFilter(SimpleEventProcessorModel model, boolean inlineEventHandling, boolean assignPrivateMembers) {
        this(model, inlineEventHandling, assignPrivateMembers, 2);
    }

    public SepJavaSourceModelHugeFilter(SimpleEventProcessorModel model, boolean inlineEventHandling, boolean assignPrivateMembers, int maxFilterBranches) {
        this.model = model;
        this.eventHandlers = "";
        this.debugEventHandlers = "";
        this.isInlineEventHandling = inlineEventHandling;
        this.assignPrivateMembers = assignPrivateMembers;
        this.maxFilterBranches = maxFilterBranches;
        this.initialiseMethodList = new ArrayList();
        this.batchEndMethodList = new ArrayList();
        this.batchPauseMethodList = new ArrayList();
        this.eventEndMethodList = new ArrayList();
        this.tearDownMethodList = new ArrayList();
        this.nodeDeclarationList = new ArrayList();
        this.nodeMemberAssignmentList = new ArrayList();
        this.publicNodeIdentifierList = new ArrayList();
        this.filteredInvokerList = new ArrayList();
        this.filteredInvokerListDebug = new ArrayList();
        this.importList = new ArrayList();
    }

    public void buildSourceModel() throws Exception {
        this.buildMethodSource(this.model.getInitialiseMethods(), this.initialiseMethodList);
        this.buildMethodSource(this.model.getBatchPauseMethods(), this.batchPauseMethodList);
        this.buildMethodSource(this.model.getEventEndMethods(), this.eventEndMethodList);
        this.buildMethodSource(this.model.getBatchEndMethods(), this.batchEndMethodList);
        this.buildMethodSource(this.model.getTearDownMethods(), this.tearDownMethodList);
        this.addDefacultImports();
        this.buildNodeDeclarations();
        this.buildDirtyFlags();
        this.buildFilterConstantDeclarations();
        this.buildMemberAssignments();
        this.buildNodeRegistrationListeners();
        this.buildEventDispatch();
        this.buildTestDispatch();
        this.initialiseMethods = "";
        boolean firstLine = true;
        for (String initialiseMethod : this.initialiseMethodList) {
            this.initialiseMethods = this.initialiseMethods + (firstLine ? "" : "\n") + initialiseMethod;
            firstLine = false;
        }
        this.batchPauseMethods = "";
        firstLine = true;
        for (String initialiseMethod : this.batchPauseMethodList) {
            this.batchPauseMethods = this.batchPauseMethods + (firstLine ? "" : "\n") + initialiseMethod;
            firstLine = false;
        }
        this.batchEndMethods = "";
        firstLine = true;
        for (String initialiseMethod : this.batchEndMethodList) {
            this.batchEndMethods = this.batchEndMethods + (firstLine ? "" : "\n") + initialiseMethod;
            firstLine = false;
        }
        this.eventEndMethods = "";
        firstLine = true;
        for (String initialiseMethod : this.eventEndMethodList) {
            this.eventEndMethods = this.eventEndMethods + (firstLine ? "" : "\n") + initialiseMethod;
            firstLine = false;
        }
        this.tearDownMethods = "";
        for (String initialiseMethod : this.tearDownMethodList) {
            this.tearDownMethods = this.tearDownMethods + initialiseMethod + "\n";
        }
        this.tearDownMethods = StringUtils.chomp((String)this.tearDownMethods);
        this.nodeMemberAssignments = "";
        StringBuilder memberAssignments = new StringBuilder(200 * this.nodeMemberAssignmentList.size());
        firstLine = true;
        for (String initialiseMethod : this.nodeMemberAssignmentList) {
            memberAssignments.append(firstLine ? s4 : "\n    ").append(initialiseMethod);
            firstLine = false;
        }
        this.nodeMemberAssignments = memberAssignments.toString();
    }

    private void buildMethodSource(List<CbMethodHandle> methodList, List methodSourceList) {
        for (CbMethodHandle method : methodList) {
            String methodString = String.format("%8s%s.%s();", "", method.variableName, method.method.getName());
            methodSourceList.add(methodString);
        }
    }

    private void buildDirtyFlags() {
        this.dirtyFlagDeclarations = "";
        this.resetDirtyFlags = "";
        ArrayList<DirtyFlag> values = new ArrayList<DirtyFlag>(this.model.getDirtyFieldMap().values());
        NaturalOrderComparator comparator = new NaturalOrderComparator();
        Collections.sort(values, (o1, o2) -> comparator.compare(o1.name, o2.name));
        for (DirtyFlag flag : values) {
            this.dirtyFlagDeclarations = this.dirtyFlagDeclarations + String.format("%4sprivate boolean %s = false;%n", "", flag.name);
            this.resetDirtyFlags = this.resetDirtyFlags + String.format("%8s%s = false;%n", "", flag.name);
        }
        for (DirtyFlag flag : values) {
            if (!flag.requiresInvert) continue;
            this.dirtyFlagDeclarations = this.dirtyFlagDeclarations + String.format("%4sprivate boolean not%s = false;%n", "", flag.name);
            this.resetDirtyFlags = this.resetDirtyFlags + String.format("%8snot%s = false;%n", "", flag.name);
        }
        this.dirtyFlagDeclarations = StringUtils.chomp((String)this.dirtyFlagDeclarations);
        this.resetDirtyFlags = StringUtils.chomp((String)this.resetDirtyFlags);
    }

    private String getClassName(String clazzName) {
        clazzName = this.model.getMappedClass(clazzName);
        String[] split = clazzName.split("\\.");
        String ret = clazzName;
        if (split.length > 1) {
            String simpleName = split[split.length - 1];
            String fqnName = clazzName;
            String pkgName = fqnName.replace("." + simpleName, "");
            ret = simpleName;
            if (!fqnName.startsWith("java.lang") && !GenerationContext.SINGLETON.getPackageName().equals(pkgName)) {
                if (this.importMap.containsKey(simpleName)) {
                    if (!this.importMap.get(simpleName).equalsIgnoreCase(fqnName)) {
                        ret = fqnName;
                    }
                } else {
                    this.importMap.put(simpleName, fqnName);
                    this.importList.add(fqnName);
                }
            }
        }
        return ret;
    }

    private void buildNodeDeclarations() {
        this.nodeDeclarations = "";
        StringBuilder declarationBuilder = new StringBuilder(2000);
        StringBuilder fqnBuilder = new StringBuilder(500);
        boolean firstLine = true;
        if (this.assignPrivateMembers) {
            declarationBuilder.append(s4).append("final net.vidageek.mirror.dsl.Mirror constructor = new net.vidageek.mirror.dsl.Mirror();\n");
        }
        for (com.fluxtion.generator.model.Field field : this.model.getTopologigcallySortedNodeFields()) {
            String access = field.publicAccess ? "public" : "private";
            fqnBuilder.append(this.getClassName(field.fqn));
            boolean syntheticConstructor = true;
            try {
                field.instance.getClass().getConstructor(new Class[0]);
                syntheticConstructor = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.assignPrivateMembers && syntheticConstructor) {
                declarationBuilder.append(s4).append(access).append(" final ").append((CharSequence)fqnBuilder).append(" ").append(field.name).append(" = constructor.on(").append((CharSequence)fqnBuilder).append(".class).invoke().constructor().bypasser();");
            } else {
                String args = "";
                List<Field.MappedField> constructorArgs = this.model.constructorArgs(field.instance);
                args = constructorArgs.stream().map(f -> f.value()).collect(Collectors.joining(", "));
                declarationBuilder.append(s4).append(access).append(" final ").append((CharSequence)fqnBuilder).append(" ").append(field.name).append(" = new ").append((CharSequence)fqnBuilder).append("(" + args + ");");
            }
            String declaration = declarationBuilder.toString();
            this.nodeDeclarationList.add(declaration);
            this.nodeDecBuilder.append(firstLine ? "" : "\n").append(declaration);
            firstLine = false;
            if (field.publicAccess) {
                this.publicNodeIdentifierList.add(field.name);
            }
            fqnBuilder.delete(0, fqnBuilder.length());
            declarationBuilder.delete(0, declarationBuilder.length());
        }
        this.nodeDeclarations = this.nodeDecBuilder.toString();
        this.nodeDecBuilder.delete(0, this.nodeDecBuilder.length());
    }

    private void buildFilterConstantDeclarations() {
        this.filterConstantDeclarations = "";
        boolean firstLine = true;
        ArrayList<FilterDescription> tmp = new ArrayList<FilterDescription>(this.model.getFilterDescriptionList());
        tmp.sort((o1, o2) -> o1.value - o2.value);
        HashMap<String, Integer> filterVariableMap = new HashMap<String, Integer>();
        for (FilterDescription filterDescription : tmp) {
            if (filterDescription.variableName == null) continue;
            int value = filterDescription.value;
            String variableName = filterDescription.variableName;
            if (filterVariableMap.containsKey(variableName)) {
                int mappedValue = (Integer)filterVariableMap.get(variableName);
                if (mappedValue == value) continue;
                throw new IllegalStateException("two mappings for the same filter constant '" + variableName + "'");
            }
            filterVariableMap.put(variableName, value);
            String declaration = String.format("    public static final int %s = %d;", variableName, value);
            this.filterConstantDeclarations = this.filterConstantDeclarations + (firstLine ? "" : "\n") + declaration;
            firstLine = false;
        }
    }

    private void buildEventDispatch() {
        this.generateClassBasedDipsatcher(false);
        this.generateClassBasedDipsatcher(true);
        if (!this.isInlineEventHandling) {
            ArrayList importClassList = new ArrayList();
            this.eventHandlers = this.eventHandlers + JavaGenHelper.generateMapDisaptch(this.filteredInvokerList, importClassList);
            this.debugEventHandlers = this.debugEventHandlers + JavaGenHelper.generateMapDisaptch(this.filteredInvokerListDebug, importClassList);
            if (importClassList.size() > 0) {
                this.getClassName("it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap");
            }
            importClassList.stream().map(Class::getCanonicalName).forEach(this::getClassName);
        }
        if (this.auditingEvent) {
            this.eventHandlers = this.eventHandlers + this.auditMethodString;
        }
    }

    private void generateClassBasedDipsatcher(boolean isDebug) {
        String dispatchString = "        switch (event.eventId()) {\n";
        String dispatchStringNoId = "        switch (event.getClass().getName()) {\n";
        boolean idDispatch = false;
        boolean noIdDispatch = false;
        Map<Class, Map<FilterDescription, List<CbMethodHandle>>> dispatchMap = this.model.getDispatchMap();
        Map<Class, Map<FilterDescription, List<CbMethodHandle>>> postDispatchMap = this.model.getPostDispatchMap();
        Set<Class> keySet = dispatchMap.keySet();
        HashSet<Class> classSet = new HashSet<Class>(keySet);
        classSet.addAll(postDispatchMap.keySet());
        ArrayList<Class> clazzList = new ArrayList<Class>(classSet);
        Collections.sort(clazzList, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        for (Class eventId : clazzList) {
            Map<FilterDescription, List<CbMethodHandle>> cbMapPostEvent;
            Map<FilterDescription, List<CbMethodHandle>> cbMap;
            String className = this.getClassName(eventId.getCanonicalName());
            if (SepJavaSourceModelHugeFilter.hasIdField(eventId)) {
                dispatchString = dispatchString + String.format("%12scase (%s.ID):{%n", "", className);
                dispatchString = dispatchString + String.format("%16s%s typedEvent = (%s)event;%n", "", className, className);
                if (isDebug) {
                    dispatchString = dispatchString + String.format("%16sdebugger.eventInvocation(event);%n", "");
                }
                cbMap = dispatchMap.get(eventId);
                cbMapPostEvent = postDispatchMap.get(eventId);
                dispatchString = dispatchString + this.buildFiteredDispatch(cbMap, cbMapPostEvent, isDebug, eventId);
                dispatchString = dispatchString + String.format("%16sbreak;%n", "");
                dispatchString = dispatchString + String.format("%12s}%n", "");
                idDispatch = true;
                continue;
            }
            dispatchStringNoId = dispatchStringNoId + String.format("%12scase (\"%s\"):{%n", "", eventId.getName());
            dispatchStringNoId = dispatchStringNoId + String.format("%16s%s typedEvent = (%s)event;%n", "", className, className);
            if (isDebug) {
                dispatchStringNoId = dispatchStringNoId + String.format("%16sdebugger.eventInvocation(event);%n", "");
            }
            cbMap = dispatchMap.get(eventId);
            cbMapPostEvent = postDispatchMap.get(eventId);
            dispatchStringNoId = dispatchStringNoId + this.buildFiteredDispatch(cbMap, cbMapPostEvent, isDebug, eventId);
            dispatchStringNoId = dispatchStringNoId + String.format("%16sbreak;%n", "");
            dispatchStringNoId = dispatchStringNoId + String.format("%12s}%n", "");
            noIdDispatch = true;
        }
        dispatchString = dispatchString + String.format("%8s}%n", "");
        dispatchStringNoId = dispatchStringNoId + String.format("%8s}%n", "");
        if (this.isInlineEventHandling) {
            dispatchString = dispatchString + String.format("%8safterEvent();%n", "");
            dispatchStringNoId = dispatchStringNoId + String.format("%8safterEvent();%n", "");
        }
        if (!idDispatch) {
            dispatchString = "";
        }
        if (!noIdDispatch) {
            dispatchStringNoId = "";
        }
        dispatchString = dispatchString + dispatchStringNoId;
        if (isDebug) {
            this.debugEventDispatch = "//DEBUG\n" + dispatchString;
        } else {
            this.eventDispatch = dispatchString + "\n";
        }
    }

    private static boolean hasIdField(Class e) {
        Set allFields = ReflectionUtils.getFields((Class)e, (Predicate[])new Predicate[]{Predicates.and((Predicate[])new Predicate[]{ReflectionUtils.withName((String)"ID"), ReflectionUtils.withType(Integer.TYPE), ReflectionUtils.withModifier((int)1), ReflectionUtils.withModifier((int)8), ReflectionUtils.withModifier((int)16)})});
        return allFields.size() > 0;
    }

    private String buildFilteredSwitch(Map<FilterDescription, List<CbMethodHandle>> cbMap, Map<FilterDescription, List<CbMethodHandle>> cbMapPostEvent, Class eventClass, boolean isDebug, boolean intFilter, boolean noFilter) {
        Set<FilterDescription> filterIdSet = cbMap.keySet();
        ArrayList<FilterDescription> clazzList = new ArrayList<FilterDescription>(filterIdSet);
        int caseCount = Math.max(cbMap.size(), cbMapPostEvent.size());
        Collections.sort(clazzList, (o1, o2) -> {
            int ret = o1.value - o2.value;
            if (!o1.isIntFilter && !o2.isIntFilter) {
                ret = o1.stringValue.compareTo(o2.stringValue);
            } else if (o1.isIntFilter && !o2.isIntFilter) {
                ret = 1;
            } else if (!o1.isIntFilter && o2.isIntFilter) {
                ret = -1;
            }
            return ret;
        });
        String switchFilter = "";
        this.switchF.delete(0, this.switchF.length());
        for (FilterDescription filterDescription : clazzList) {
            InvokerFilterTarget invokerTarget = new InvokerFilterTarget();
            invokerTarget.methodName = JavaGenHelper.generateFilteredDispatchMethodName(filterDescription);
            invokerTarget.filterDescription = filterDescription;
            invokerTarget.stringMapName = JavaGenHelper.generateFilteredDispatchMap(filterDescription);
            invokerTarget.intMapName = JavaGenHelper.generateFilteredDispatchMap(filterDescription);
            if (intFilter != filterDescription.isIntFilter && !noFilter) continue;
            boolean isDefaultFilter = filterDescription == FilterDescription.DEFAULT_FILTER;
            boolean isNoFilter = filterDescription == FilterDescription.NO_FILTER || filterDescription == FilterDescription.INVERSE_FILTER;
            String filterValue = intFilter ? filterDescription.value + "" : "\"" + filterDescription.stringValue + "\"";
            String filterVariable = filterDescription.variableName;
            List<CbMethodHandle> cbList = cbMap.get(filterDescription);
            if (noFilter && isDefaultFilter) {
                invokerTarget.filterDescription = new FilterDescription(eventClass);
                invokerTarget.methodName = JavaGenHelper.generateFilteredDispatchMethodName(invokerTarget.filterDescription);
                invokerTarget.stringMapName = JavaGenHelper.generateFilteredDispatchMap(invokerTarget.filterDescription);
                invokerTarget.intMapName = JavaGenHelper.generateFilteredDispatchMap(invokerTarget.filterDescription);
            } else {
                if (noFilter || isNoFilter || isDefaultFilter) continue;
                if (filterDescription.comment != null) {
                    this.switchF.append(s20).append("//").append(filterDescription.comment).append("\n");
                }
                if (filterVariable == null) {
                    this.switchF.append(s20).append("case(").append(filterValue).append("):\n");
                } else {
                    this.switchF.append(s20).append("case(").append(filterVariable).append("):\n");
                }
            }
            cbList = cbList == null ? Collections.EMPTY_LIST : cbList;
            this.ct.delete(0, this.ct.length());
            for (CbMethodHandle method : cbList) {
                DirtyFlag dirtyFlagForUpdateCb = this.model.getDirtyFlagForUpdateCb(method);
                String dirtyAssignment = "";
                if (dirtyFlagForUpdateCb != null) {
                    dirtyAssignment = dirtyFlagForUpdateCb.alwaysDirty ? dirtyFlagForUpdateCb.name + " = true;\n" + s24 : dirtyFlagForUpdateCb.name + " = ";
                }
                Collection<DirtyFlag> nodeGuardConditions = this.model.getNodeGuardConditions(method);
                String OR = "";
                if (nodeGuardConditions.size() > 0) {
                    OnEvent onEvent = method.method.getAnnotation(OnEvent.class);
                    String invert = "";
                    if (onEvent != null && !onEvent.dirty()) {
                        invert = " not";
                    }
                    this.ct.append(s24).append("if(");
                    for (DirtyFlag nodeGuardCondition : nodeGuardConditions) {
                        this.ct.append(OR).append(invert).append(nodeGuardCondition.name);
                        OR = " | ";
                    }
                    this.ct.append(") {\n");
                }
                if (this.auditingInvocations) {
                    this.ct.append(s24).append("auditInvocation(").append(method.variableName).append(", \"").append(method.variableName).append("\"").append(", \"").append(method.method.getName()).append("\"").append(", typedEvent").append(");\n");
                }
                if (isDebug) {
                    this.ct.append(s24).append("debugger.nodeInvocation(").append(method.variableName).append(", \"").append(method.variableName).append("\");\n");
                }
                if (method.parameterClass == null) {
                    this.ct.append(s24).append(dirtyAssignment).append(method.variableName).append(".").append(method.method.getName()).append("();\n");
                } else {
                    this.ct.append(s24).append(dirtyAssignment).append(method.variableName).append(".").append(method.method.getName()).append("(typedEvent);\n");
                }
                if (dirtyFlagForUpdateCb != null && dirtyFlagForUpdateCb.requiresInvert) {
                    this.ct.append(s24).append("not" + dirtyFlagForUpdateCb.name + " = !" + dirtyFlagForUpdateCb.name + ";\n");
                }
                Map<Object, List<CbMethodHandle>> listenerMethodMap = this.model.getParentUpdateListenerMethodMap();
                Object parent = method.instance;
                String parentVar = method.variableName;
                DirtyFlag parentFlag = this.model.getDirtyFieldMap().get(this.model.getFieldForInstance(parent));
                List<CbMethodHandle> updateListenerCbList = listenerMethodMap.get(parent);
                EventHandler handlerAnnotation = method.method.getAnnotation(EventHandler.class);
                if (handlerAnnotation != null && !handlerAnnotation.propagate()) continue;
                if (parentFlag != null && updateListenerCbList.size() > 0) {
                    this.ct.append("                    if(").append(parentFlag.name).append(") {\n");
                }
                boolean unguarded = false;
                StringBuilder sbUnguarded = new StringBuilder();
                for (CbMethodHandle cbMethod : updateListenerCbList) {
                    if (!cbMethod.method.getAnnotation(OnParentUpdate.class).guarded()) {
                        unguarded = true;
                        sbUnguarded.append(s20).append(cbMethod.variableName).append(".").append(cbMethod.method.getName()).append("(").append(parentVar).append(");\n");
                        continue;
                    }
                    this.ct.append(s24).append(cbMethod.variableName).append(".").append(cbMethod.method.getName()).append("(").append(parentVar).append(");\n");
                }
                if (parentFlag != null && updateListenerCbList.size() > 0) {
                    this.ct.append(s20).append("}\n");
                    if (unguarded) {
                        this.ct.append((CharSequence)sbUnguarded);
                    }
                }
                if (nodeGuardConditions.size() <= 0) continue;
                this.ct.append("                }\n");
            }
            cbList = cbMapPostEvent.get(filterDescription);
            if (cbList == null || cbList.size() > 0) {
                this.ct.append("                //event stack unwind callbacks\n");
            }
            cbList = cbList == null ? Collections.EMPTY_LIST : cbList;
            for (CbMethodHandle method : cbList) {
                Collection<DirtyFlag> nodeGuardConditions = this.model.getNodeGuardConditions(method);
                String OR = "";
                if (nodeGuardConditions.size() > 0) {
                    this.ct.append("                        if(");
                    for (DirtyFlag nodeGuardCondition : nodeGuardConditions) {
                        this.ct.append(OR).append(nodeGuardCondition.name);
                        OR = " | ";
                    }
                    this.ct.append(") {\n");
                }
                if (isDebug) {
                    this.ct.append("                        debugger.nodeInvocation(").append(method.variableName).append(", \"").append(method.variableName).append("\");");
                }
                if (method.parameterClass == null) {
                    this.ct.append(s24).append(method.variableName).append(".").append(method.method.getName()).append("();\n");
                } else {
                    this.ct.append(s24).append(method.variableName).append(".").append(method.method.getName()).append("(typedEvent);\n");
                }
                if (nodeGuardConditions.size() <= 0) continue;
                this.ct.append("                }\n");
            }
            invokerTarget.methodBody = this.ct.toString();
            if (isDebug && caseCount > this.maxFilterBranches) {
                this.filteredInvokerListDebug.add(invokerTarget);
            } else if (caseCount > this.maxFilterBranches) {
                this.filteredInvokerList.add(invokerTarget);
            }
            if (!noFilter) {
                this.ct.append("                        afterEvent();\n");
                this.ct.append("                        return;\n");
            }
            this.switchF.append((CharSequence)this.ct);
        }
        return this.switchF.length() == 0 ? null : this.switchF.toString();
    }

    private String buildFiteredDispatch(Map<FilterDescription, List<CbMethodHandle>> cbMap, Map<FilterDescription, List<CbMethodHandle>> cbMapPostEvent, boolean isDebug, Class eventClass) {
        String dispatchString = "";
        String eventHandlerString = "";
        String intFilterSwitch = this.buildFilteredSwitch(cbMap, cbMapPostEvent, eventClass, isDebug, true, false);
        String stringFilterSwitch = this.buildFilteredSwitch(cbMap, cbMapPostEvent, eventClass, isDebug, false, false);
        String noFilterDispatch = this.buildFilteredSwitch(cbMap, cbMapPostEvent, eventClass, isDebug, false, true);
        int caseCount = cbMap.size();
        if (!this.isInlineEventHandling && caseCount > this.maxFilterBranches) {
            String mapName;
            dispatchString = dispatchString + String.format("%16shandleEvent(typedEvent);%n", "");
            eventHandlerString = eventHandlerString + String.format("%n%4spublic void handleEvent(%s typedEvent) {%n", "", this.getClassName(eventClass.getCanonicalName()));
            eventHandlerString = eventHandlerString + this.eventAuditDispatch;
            String filterDec = "FilteredHandlerInvoker ";
            if (intFilterSwitch != null) {
                mapName = JavaGenHelper.generateFilteredDispatchMap(eventClass, true);
                eventHandlerString = eventHandlerString + String.format("%8sFilteredHandlerInvoker invoker = %s.get(typedEvent.filterId());%n        if(invoker!=null){%n             invoker.invoke(typedEvent);%n             afterEvent();%n             return;%n        }%n", "", mapName);
                filterDec = "";
            }
            if (stringFilterSwitch != null) {
                mapName = JavaGenHelper.generateFilteredDispatchMap(eventClass, false);
                eventHandlerString = eventHandlerString + String.format("%8s%sinvoker = %s.get(typedEvent.filterString());%n        if(invoker!=null){%n             invoker.invoke(typedEvent);%n             afterEvent();%n             return;%n        }%n", "", filterDec, mapName);
            }
            if (noFilterDispatch != null) {
                eventHandlerString = eventHandlerString + "        //Default, no filter methods\n";
                eventHandlerString = eventHandlerString + noFilterDispatch;
            }
            eventHandlerString = eventHandlerString + "        afterEvent();\n";
            eventHandlerString = eventHandlerString + "    }\n\n";
        } else if (!this.isInlineEventHandling) {
            dispatchString = dispatchString + String.format("%16shandleEvent(typedEvent);%n", "");
            eventHandlerString = eventHandlerString + String.format("%n%4spublic void handleEvent(%s typedEvent) {%n", "", this.getClassName(eventClass.getCanonicalName()));
            eventHandlerString = eventHandlerString + this.eventAuditDispatch;
            if (intFilterSwitch != null) {
                eventHandlerString = eventHandlerString + String.format("%8sswitch (typedEvent.filterId()) {%n", "");
                eventHandlerString = eventHandlerString + intFilterSwitch;
                eventHandlerString = eventHandlerString + String.format("%8s}%n", "");
            }
            if (stringFilterSwitch != null) {
                eventHandlerString = eventHandlerString + String.format("%8sswitch (typedEvent.filterString()) {%n", "");
                eventHandlerString = eventHandlerString + stringFilterSwitch;
                eventHandlerString = eventHandlerString + String.format("%8s}%n", "");
            }
            if (noFilterDispatch != null) {
                eventHandlerString = eventHandlerString + "        //Default, no filter methods\n";
                eventHandlerString = eventHandlerString + noFilterDispatch;
            }
            eventHandlerString = eventHandlerString + String.format("%8safterEvent();%n", "");
            eventHandlerString = eventHandlerString + String.format("%4s}%n", "");
        } else {
            dispatchString = dispatchString + this.eventAuditDispatch;
            if (intFilterSwitch != null) {
                dispatchString = dispatchString + String.format("%16sswitch (typedEvent.filterId()) {%n", "");
                dispatchString = dispatchString + intFilterSwitch;
                dispatchString = dispatchString + String.format("%16s}%n", "");
            }
            if (stringFilterSwitch != null) {
                dispatchString = dispatchString + String.format("%16sswitch (typedEvent.filterString()) {%n", "");
                dispatchString = dispatchString + stringFilterSwitch;
                dispatchString = dispatchString + String.format("%16s}%n", "");
            }
            if (noFilterDispatch != null) {
                dispatchString = dispatchString + noFilterDispatch;
            }
        }
        if (isDebug) {
            this.debugEventHandlers = this.debugEventHandlers + eventHandlerString;
        } else {
            this.eventHandlers = this.eventHandlers + eventHandlerString;
        }
        return dispatchString;
    }

    private void buildTestDispatch() {
        this.testDispatch = "";
        this.testDispatch = this.testDispatch + "    public void testNode(AssertTestEvent assertTestEvent) {\n";
        this.testDispatch = this.testDispatch + "        switch (assertTestEvent.nodeName) {\n";
        for (com.fluxtion.generator.model.Field field : this.model.getNodeFields()) {
            if (!field.publicAccess) continue;
            this.testDispatch = this.testDispatch + String.format("%12scase (\"%s\"): {%n", "", field.name);
            this.testDispatch = this.testDispatch + String.format("%16s%s node = sep.%s;%n", "", field.fqn, field.name);
            this.testDispatch = this.testDispatch + String.format("%16sbreak;%n", "");
            this.testDispatch = this.testDispatch + String.format("%12s}%n", "");
        }
        this.testDispatch = this.testDispatch + String.format("%8s}%n", "");
        this.testDispatch = this.testDispatch + String.format("%4s}%n", "");
    }

    private void buildMemberAssignments() throws Exception {
        List<com.fluxtion.generator.model.Field> nodeFields = this.model.getNodeFields();
        if (this.assignPrivateMembers) {
            this.nodeMemberAssignmentList.add("    final net.vidageek.mirror.dsl.Mirror assigner = new net.vidageek.mirror.dsl.Mirror();");
        }
        for (com.fluxtion.generator.model.Field field : nodeFields) {
            Object object = field.instance;
            String varName = field.name;
            this.model.beanProperties(object).stream().forEach(s -> this.nodeMemberAssignmentList.add(varName + "." + s + ";"));
            Object[] fields = object.getClass().getFields();
            MirrorList fields1 = new Mirror().on(object.getClass()).reflectAll().fields();
            for (Object instanceField : fields = (Field[])fields1.toArray(fields)) {
                String joiner;
                Collection list;
                boolean useRefelction = false;
                if ((((Field)instanceField).getModifiers() & 0x88) != 0 || !this.assignPrivateMembers && (((Field)instanceField).getModifiers() & 0x16) != 0 || !this.assignPrivateMembers && ((Field)instanceField).getModifiers() == 0) continue;
                if (this.assignPrivateMembers && !Modifier.isPublic(((Field)instanceField).getModifiers())) {
                    useRefelction = true;
                }
                ((Field)instanceField).setAccessible(true);
                if (((Field)instanceField).getType().isArray()) {
                    String joiner2;
                    String value;
                    int i;
                    Object array = ((Field)instanceField).get(object);
                    if (array == null) continue;
                    int length = Array.getLength(array);
                    String className = this.getClassName(((Field)instanceField).getType().getComponentType().getCanonicalName());
                    if (useRefelction) {
                        this.nodeMemberAssignmentList.add(String.format("%4s%s[] %s_%s = new %s[%d];", "", className, varName, ((Field)instanceField).getName(), className, length));
                        this.nodeMemberAssignmentList.add(String.format("%4sassigner.on(%s).set().field(\"%s\").withValue(%s_%s);", "", varName, ((Field)instanceField).getName(), varName, ((Field)instanceField).getName()));
                    } else {
                        this.nodeMemberAssignmentList.add(String.format("%4s%s.%s = new %s[%d];", "", varName, ((Field)instanceField).getName(), className, length));
                    }
                    if (((Field)instanceField).getType().getComponentType().isPrimitive()) {
                        for (i = 0; i < length; ++i) {
                            value = Array.get(array, i).toString();
                            joiner2 = useRefelction ? "_" : ".";
                            this.nodeMemberAssignmentList.add(String.format("%4s%s%s%s[%d] = %s;", "", varName, joiner2, ((Field)instanceField).getName(), i, value));
                        }
                        continue;
                    }
                    if (((Field)instanceField).getType().getComponentType().equals(String.class)) {
                        for (i = 0; i < length; ++i) {
                            value = StringEscapeUtils.escapeJava((String)Array.get(array, i).toString());
                            joiner2 = useRefelction ? "_" : ".";
                            this.nodeMemberAssignmentList.add(String.format("%4s%s%s%s[%d] = \"%s\";", "", varName, joiner2, ((Field)instanceField).getName(), i, value));
                        }
                        continue;
                    }
                    for (i = 0; i < length; ++i) {
                        String joiner3;
                        Object refField = Array.get(array, i);
                        com.fluxtion.generator.model.Field nodeReference = this.model.getFieldForInstance(refField);
                        String string = joiner3 = useRefelction ? "_" : ".";
                        if (nodeReference == null) continue;
                        this.nodeMemberAssignmentList.add(String.format("%4s%s%s%s[%d] = %s;", "", varName, joiner3, ((Field)instanceField).getName(), i, nodeReference.name));
                    }
                    continue;
                }
                if (((Field)instanceField).get(object) == null) continue;
                com.fluxtion.generator.model.Field nodeReference = this.model.getFieldForInstance(((Field)instanceField).get(object));
                if (((Field)instanceField).getType().equals(Character.TYPE)) {
                    String value = ((Field)instanceField).get(object).toString();
                    if (useRefelction) {
                        this.nodeMemberAssignmentList.add(String.format("%4sassigner.on(%s).set().field(\"%s\").withValue('%s');", "", varName, ((Field)instanceField).getName(), value));
                        continue;
                    }
                    this.nodeMemberAssignmentList.add(String.format("%4s%s.%s = '%s';", "", varName, ((Field)instanceField).getName(), value));
                    continue;
                }
                if (((Field)instanceField).getType().isPrimitive()) {
                    String value = ((Field)instanceField).get(object).toString();
                    value = value.equalsIgnoreCase("NaN") ? "Double.NaN" : value;
                    value = "(" + ((Field)instanceField).getType().toString() + ")" + value;
                    if (useRefelction) {
                        this.nodeMemberAssignmentList.add(String.format("%4sassigner.on(%s).set().field(\"%s\").withValue(%s);", "", varName, ((Field)instanceField).getName(), value));
                        continue;
                    }
                    this.nodeMemberAssignmentList.add(String.format("%4s%s.%s = %s;", "", varName, ((Field)instanceField).getName(), value));
                    continue;
                }
                if (((Field)instanceField).getType().isEnum()) {
                    String value = ((Field)instanceField).get(object).toString();
                    String enumClass = ((Field)instanceField).getType().getCanonicalName();
                    if (useRefelction) {
                        this.nodeMemberAssignmentList.add(String.format("%4sassigner.on(%s).set().field(\"%s\").withValue(%s.%s);", "", varName, ((Field)instanceField).getName(), enumClass, value));
                        continue;
                    }
                    this.nodeMemberAssignmentList.add(String.format("%4s%s.%s = %s.%s;", "", varName, ((Field)instanceField).getName(), enumClass, value));
                    continue;
                }
                if (nodeReference != null) {
                    if (useRefelction) {
                        this.nodeMemberAssignmentList.add(String.format("%4sassigner.on(%s).set().field(\"%s\").withValue(%s);", "", varName, ((Field)instanceField).getName(), nodeReference.name));
                        continue;
                    }
                    this.nodeMemberAssignmentList.add(String.format("%4s%s.%s = %s;", "", varName, ((Field)instanceField).getName(), nodeReference.name));
                    continue;
                }
                if (((Field)instanceField).getType().equals(String.class)) {
                    String value = StringEscapeUtils.escapeJava((String)((Field)instanceField).get(object).toString());
                    if (useRefelction) {
                        this.nodeMemberAssignmentList.add(String.format("%4sassigner.on(%s).set().field(\"%s\").withValue(\"%s\");", "", varName, ((Field)instanceField).getName(), value));
                        continue;
                    }
                    this.nodeMemberAssignmentList.add(String.format("%4s%s.%s = \"%s\";", "", varName, ((Field)instanceField).getName(), value));
                    continue;
                }
                if (!Collection.class.isAssignableFrom(((Field)instanceField).getType()) || (list = (Collection)((Field)instanceField).get(object)) == null) continue;
                String string = joiner = useRefelction ? "_" : ".";
                if (useRefelction) {
                    String className = this.getClassName(Collection.class.getCanonicalName());
                    this.nodeMemberAssignmentList.add(String.format("%4sCollection %s_%s = (Collection)assigner.on(%s).get().field(\"%s\");", "", varName, ((Field)instanceField).getName(), varName, ((Field)instanceField).getName()));
                }
                for (Object parent : list) {
                    if (((Field)instanceField).getGenericType() instanceof ParameterizedType) {
                        String value;
                        com.fluxtion.generator.model.Field nodeParentReference;
                        ParameterizedType integerListType = (ParameterizedType)((Field)instanceField).getGenericType();
                        Class classType = Object.class;
                        if (integerListType.getActualTypeArguments()[0] instanceof Class) {
                            classType = (Class)integerListType.getActualTypeArguments()[0];
                        }
                        if ((nodeParentReference = this.model.getFieldForInstance(parent)) != null) {
                            this.nodeMemberAssignmentList.add(String.format("%4s%s%s%s.add(%s);", "", varName, joiner, ((Field)instanceField).getName(), nodeParentReference.name));
                            continue;
                        }
                        if (classType == String.class) {
                            value = StringEscapeUtils.escapeJava((String)parent.toString());
                            this.nodeMemberAssignmentList.add(String.format("%4s%s%s%s.add(\"%s\");", "", varName, joiner, ((Field)instanceField).getName(), value));
                            continue;
                        }
                        if (classType == Character.class) {
                            value = parent.toString();
                            this.nodeMemberAssignmentList.add(String.format("%4s%s%s%s.add('%s');", "", varName, joiner, ((Field)instanceField).getName(), parent));
                            continue;
                        }
                        if (Number.class.isAssignableFrom(classType)) {
                            value = parent.toString();
                            String cast = JavaGenHelper.mapWrapperToPrimitive(classType).getSimpleName();
                            this.nodeMemberAssignmentList.add(String.format("%4s%s%s%s.add((%s)%s);", "", varName, joiner, ((Field)instanceField).getName(), cast, value));
                            continue;
                        }
                        if (!classType.isEnum()) continue;
                        String enumClass = this.getClassName(classType.getCanonicalName());
                        String value2 = parent.toString();
                        this.nodeMemberAssignmentList.add(String.format("%4s%s%s%s.add(%s.%s);", "", varName, joiner, ((Field)instanceField).getName(), enumClass, value2));
                        continue;
                    }
                    com.fluxtion.generator.model.Field nodeParentReference = this.model.getFieldForInstance(parent);
                    if (nodeParentReference == null) continue;
                    this.nodeMemberAssignmentList.add(String.format("%4s%s%s%s.add(%s);", "", varName, joiner, ((Field)instanceField).getName(), nodeParentReference.name));
                }
            }
        }
    }

    public ArrayList<String> getInitialiseMethodList() {
        return this.initialiseMethodList;
    }

    public String getInitialiseMethods() {
        return this.initialiseMethods;
    }

    public ArrayList<String> getBatchEndMethodList() {
        return this.batchEndMethodList;
    }

    public ArrayList<String> getBatchPauseMethodList() {
        return this.batchPauseMethodList;
    }

    public ArrayList<String> getEventEndMethodList() {
        return this.eventEndMethodList;
    }

    public ArrayList<String> getTearDownMethodList() {
        return this.tearDownMethodList;
    }

    public ArrayList<String> getNodeDeclarationList() {
        return this.nodeDeclarationList;
    }

    public ArrayList<String> getNodeMemberAssignmentList() {
        return this.nodeMemberAssignmentList;
    }

    public ArrayList<String> getPublicNodeList() {
        return this.publicNodeIdentifierList;
    }

    public String getTestDispatch() {
        return this.testDispatch;
    }

    public String getNodeMemberAssignments() {
        return this.nodeMemberAssignments;
    }

    public String getFilterConstantDeclarations() {
        return this.filterConstantDeclarations;
    }

    public String getEventDispatch() {
        return this.eventDispatch;
    }

    public String getEventHandlers() {
        return this.eventHandlers;
    }

    public String getDebugEventHandlers() {
        return this.debugEventHandlers;
    }

    public String getDebugEventDispatch() {
        return this.debugEventDispatch;
    }

    public String getNodeDeclarations() {
        return this.nodeDeclarations;
    }

    public String getDirtyFlagDeclarations() {
        return this.dirtyFlagDeclarations;
    }

    public String getResetDirtyFlags() {
        return this.resetDirtyFlags;
    }

    public String getBatchEndMethods() {
        return this.batchEndMethods;
    }

    public String getEventEndMethods() {
        return this.eventEndMethods;
    }

    public String getBatchPauseMethods() {
        return this.batchPauseMethods;
    }

    public String getTearDownMethods() {
        return this.tearDownMethods;
    }

    public String getImports() {
        Collections.sort(this.importList);
        StringBuilder sb = new StringBuilder(2048);
        this.importList.stream().forEach(s -> sb.append("import ").append((String)s).append(";\n"));
        return sb.toString();
    }

    public String toString() {
        return "SepJavaSourceModel{\ninitialiseMethods=" + this.initialiseMethodList + ", \nbatchEndMethods=" + this.batchEndMethodList + ", \nbatchPauseMethods=" + this.batchPauseMethodList + ", \neventEndMethods=" + this.eventEndMethodList + ", \ntearDownMethods=" + this.tearDownMethodList + ", \nnodeDeclarations=" + this.nodeDeclarationList + ", \neventDispatch=" + this.eventDispatch + ", \nnodeMemberAssignments=" + this.nodeMemberAssignmentList + ", \nmodel=" + this.model + "\n}";
    }

    private void buildNodeRegistrationListeners() {
        List<com.fluxtion.generator.model.Field> nodeFields = this.model.getNodeFields();
        this.auditingEvent = false;
        this.eventAuditDispatch = "";
        List<com.fluxtion.generator.model.Field> listenerFields = this.model.getNodeRegistrationListenerFields();
        if (listenerFields == null || listenerFields.isEmpty()) {
            return;
        }
        this.auditingEvent = true;
        this.auditingInvocations = false;
        this.auditMethodString = "";
        String auditEvent = "private void auditEvent(Object typedEvent){\n";
        String auditInvocation = "private void auditInvocation(Object node, String nodeName, String methodName, Object typedEvent){\n";
        String initialiseAuditor = "private void initialiseAuditor(" + this.getClassName(Auditor.class.getName()) + " auditor){\n\tauditor.init();\n";
        for (com.fluxtion.generator.model.Field nodeField : nodeFields) {
            String nodeName = nodeField.name;
            if (listenerFields.stream().anyMatch(t -> t.name.equals(nodeName))) continue;
            initialiseAuditor = initialiseAuditor + String.format("auditor.nodeRegistered(%s, \"%s\");", nodeName, nodeName);
        }
        this.eventAuditDispatch = "";
        this.nodeMemberAssignmentList.add("\t//node auditors");
        for (com.fluxtion.generator.model.Field listenerField : listenerFields) {
            String listenerName = listenerField.name;
            this.nodeMemberAssignmentList.add("initialiseAuditor(" + listenerField.name + ");");
            this.tearDownMethodList.add(0, String.format("%8s%s.tearDown();", "", listenerName));
            this.eventEndMethodList.add(String.format("%8s%s.processingComplete();", "", listenerName));
            this.eventAuditDispatch = this.eventAuditDispatch + String.format("%8s%s.eventReceived(typedEvent);%n", "", listenerName);
            if (!((Auditor)listenerField.instance).auditInvocations()) continue;
            auditInvocation = auditInvocation + String.format("%8s%s.nodeInvoked(node, nodeName, methodName, typedEvent);%n", "", listenerName);
            this.auditingInvocations = true;
        }
        auditEvent = auditEvent + this.eventAuditDispatch + "}\n";
        if (this.auditingInvocations) {
            auditEvent = auditEvent + auditInvocation + "}\n";
        }
        initialiseAuditor = initialiseAuditor + "}\n";
        this.eventAuditDispatch = "auditEvent(typedEvent);\n";
        this.auditMethodString = this.auditMethodString + auditEvent;
        this.auditMethodString = this.auditMethodString + initialiseAuditor;
    }

    private void addDefacultImports() {
        this.model.getImportClasses().stream().map(Class::getCanonicalName).sorted().forEach(this::getClassName);
    }
}

