/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler;

import com.fluxtion.api.annotations.EventHandler;
import com.fluxtion.api.annotations.Initialise;
import com.fluxtion.builder.annotation.ClassProcessor;
import com.fluxtion.builder.annotation.SepBuilder;
import com.fluxtion.builder.annotation.SepInstance;
import com.fluxtion.builder.node.SEPConfig;
import com.fluxtion.generator.compiler.ClassProcessorDispatcher;
import com.fluxtion.generator.targets.JavaTestGeneratorHelper;
import com.fluxtion.test.event.TimeEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class AnnotatedCompilerTest {
    @Test
    public void testAnnotationLoading() {
        ClassProcessorDispatcher acp = new ClassProcessorDispatcher();
        MyClassProcessor.invokeCount = 0;
        acp.accept(null, null);
        Assert.assertThat((Object)MyClassProcessor.invokeCount, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testSepBuilderLoading() throws MalformedURLException, ClassNotFoundException {
        Assert.assertThat((Object)MyNodeIntsance.initCount, (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)MyHandler.initCount, (Matcher)CoreMatchers.is((Object)0));
        JavaTestGeneratorHelper.setupDefaultTestContext("com.fluxtion.compiler.gen.methoduilder", "");
        ClassProcessorDispatcher acp = new ClassProcessorDispatcher();
        acp.accept(new File("target/test-classes").toURI().toURL(), new File("."));
        Assert.assertThat((Object)MyNodeIntsance.initCount, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)MyHandler.initCount, (Matcher)CoreMatchers.is((Object)1));
    }

    @SepBuilder(name="TestEH_1", packageName="com.fluxtion.compiler.gen.methoduilder", cleanOutputDir=true, outputDir="target/generated-test-sources/fluxtion")
    public void buildSepTest(SEPConfig cfg) {
        cfg.addNode((Object)new MyHandler());
    }

    @SepInstance(name="TestNode_1", packageName="com.fluxtion.compiler.gen.classbuilder", outputDir="target/generated-test-sources/fluxtion", cleanOutputDir=true)
    public static class MyNodeIntsance {
        int count;
        public static int initCount;

        @EventHandler
        public void onAllTimeEvents(TimeEvent e) {
            ++this.count;
        }

        @Initialise
        public void init() {
            ++initCount;
        }
    }

    public static class MyHandler {
        int count;
        public static int initCount;

        @EventHandler
        public void onAllTimeEvents(TimeEvent e) {
            ++this.count;
        }

        @Initialise
        public void init() {
            ++initCount;
        }
    }

    public static class MyClassProcessor
    implements ClassProcessor {
        public static int invokeCount = 0;

        public void process(URL classPath) {
            ++invokeCount;
        }
    }
}

