/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.creator;

import com.fluxtion.api.event.Event;
import com.fluxtion.builder.generation.GenerationContext;
import com.fluxtion.creator.ConfigParser;
import com.fluxtion.creator.Creator;
import com.fluxtion.creator.CreatorConfig;
import com.fluxtion.creator.MathFactory;
import com.fluxtion.creator.MyPredefinedEvent;
import com.fluxtion.creator.Node;
import com.fluxtion.creator.TestAuditor;
import com.fluxtion.generator.util.BaseSepTest;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.yaml.snakeyaml.Yaml;

public class CreatorTest
extends BaseSepTest {
    @Test
    public void testCreateModel() throws Exception {
        MathFactory.FunctionCfg mathCfg = new MathFactory.FunctionCfg("max", "src::intValue");
        Node node = new Node("com.text.xx", "nodeId_1", true);
        node.setConfigBean((Object)mathCfg);
        Yaml beanLoader = new Yaml();
        String dump = beanLoader.dumpAsMap((Object)node);
        System.out.println("dump:\n" + dump);
        Node loadedNode = (Node)beanLoader.loadAs(dump, Node.class);
        mathCfg = (MathFactory.FunctionCfg)loadedNode.getConfigBean();
        System.out.println("config:" + mathCfg);
    }

    @Test
    public void parserTest() throws Exception {
        ConfigParser parser = new ConfigParser();
        String outPkg = GenerationContext.SINGLETON.getPackageName();
        String configDoc = "outputPackage: " + outPkg + "\noutputSepConfigClass: " + outPkg + ".MySepCfg\nprocessorId: processor1\nauditorClass: com.fluxtion.creator.TestAuditor\nevents: \n  - type: com.config.MySepCfg.PnlEvent\n    id: pnlEvent\n  - type: CharEvent\n    id: charEvent\nnodes:\n    - id: dataHandler\n      type: com.config.DataHandler\n      publicAccess: true\n      events: \n         - eventId: charEvent\n           #filter: 10\n    - id: calculator\n      type: com.config.Calculator\n      publicAccess: true\n      nodes:\n          - node: dataHandler\n            name: data\n";
        CreatorConfig cfg = parser.parse(configDoc);
        Creator instance = new Creator();
        Class modelClass = instance.createModel(cfg);
        this.buildAndInitSep(modelClass);
        TestAuditor auditor = (TestAuditor)this.getField("auditor");
        auditor.matchRegisteredNodes("dataHandler", "calculator");
        Assert.assertFalse((boolean)auditor.isProcessingComplete());
        Event charEvent = (Event)GenerationContext.SINGLETON.forName(outPkg + ".CharEvent").newInstance();
        Event pnl = (Event)GenerationContext.SINGLETON.forName(outPkg + ".PnlEvent").newInstance();
        this.onEvent(charEvent);
        this.onEvent(pnl);
        this.onEvent(charEvent);
        Assert.assertTrue((boolean)auditor.isProcessingComplete());
        auditor.matchEvents(charEvent.getClass(), charEvent.getClass());
        auditor.matchCallbackMethodOrderPartial("handlerCharEvent", "onEvent", "handlerCharEvent");
        auditor.matchCallbackMethod("handlerCharEvent", "onEvent", "handlerCharEvent", "onEvent");
    }

    @Test
    public void predefinedEvent() throws Exception {
        ConfigParser parser = new ConfigParser();
        String outPkg = GenerationContext.SINGLETON.getPackageName();
        String configDoc = "outputPackage: " + outPkg + "\noutputSepConfigClass: " + outPkg + ".MySepCfg\nprocessorId: processor1\nauditorClass: com.fluxtion.creator.TestAuditor\nevents: \n  - type: com.fluxtion.creator.MyPredefinedEvent\n    id: myEvent\nnodes:\n    - id: dataHandler\n      type: com.config.DataHandler\n      publicAccess: true\n      events: \n         - eventId: myEvent\n    - id: myProcessor\n      type: com.fluxtion.creator.MyPredefinedNode\n      publicAccess: true\n      nodes:\n          - node: dataHandler\n            name: parent\n";
        CreatorConfig cfg = parser.parse(configDoc);
        Creator instance = new Creator();
        Class modelClass = instance.createModel(cfg);
        this.buildAndInitSep(modelClass);
        TestAuditor auditor = (TestAuditor)this.getField("auditor");
        auditor.matchRegisteredNodes("dataHandler", "myProcessor");
        Assert.assertFalse((boolean)auditor.isProcessingComplete());
        this.onEvent(new MyPredefinedEvent());
        this.onEvent(new MyPredefinedEvent());
        Assert.assertTrue((boolean)auditor.isProcessingComplete());
        auditor.matchEvents(MyPredefinedEvent.class, MyPredefinedEvent.class);
        auditor.matchCallbackMethodOrderPartial("handlerMyPredefinedEvent", "process");
        auditor.matchCallbackMethod("handlerMyPredefinedEvent", "process", "handlerMyPredefinedEvent", "process");
    }

    @Test
    public void factoryMethod() throws Exception {
        ConfigParser parser = new ConfigParser();
        String outPkg = GenerationContext.SINGLETON.getPackageName();
        String configDoc = "outputPackage: " + outPkg + "\noutputSepConfigClass: " + outPkg + ".MySepCfg\nprocessorId: processor1\nauditorClass: com.fluxtion.creator.TestAuditor\nevents: \n  - type: com.fluxtion.creator.MyPredefinedEvent\n    id: myEvent\nnodes:\n    - id: dataHandler\n      type: com.config.DataHandler\n      publicAccess: true\n      events: \n         - eventId: myEvent\n    - id: myProcessor\n      type: com.fluxtion.creator.MyPredefinedNode\n      publicAccess: true\n      nodes:\n          - node: dataHandler\n            name: parent\n    - id: max\n      type: com.fluxtion.creator.MathFactory$Value\n      factoryType: com.fluxtion.creator.MathFactory\n      publicAccess: true\n      configBean: !!com.fluxtion.creator.MathFactory$FunctionCfg\n          functionName: max\n          methodRef: myProcessor\n";
        CreatorConfig cfg = parser.parse(configDoc);
        Creator instance = new Creator();
        Class modelClass = instance.createModel(cfg);
        this.buildAndInitSep(modelClass);
        TestAuditor auditor = (TestAuditor)this.getField("auditor");
        auditor.matchRegisteredNodes("dataHandler", "myProcessor", "max");
        Assert.assertFalse((boolean)auditor.isProcessingComplete());
        this.onEvent(new MyPredefinedEvent());
        this.onEvent(new MyPredefinedEvent());
        Assert.assertTrue((boolean)auditor.isProcessingComplete());
        auditor.matchEvents(MyPredefinedEvent.class, MyPredefinedEvent.class);
        auditor.matchCallbackMethodOrderPartial("handlerMyPredefinedEvent", "process");
        auditor.matchCallbackMethod("handlerMyPredefinedEvent", "process", "evauateMax", "handlerMyPredefinedEvent", "process", "evauateMax");
    }

    public static class MyNode {
        private String name;
        private Map config = new HashMap();

        public Map getConfig() {
            return this.config;
        }

        public void setConfig(Map config) {
            this.config = config;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return "MyNode{name=" + this.name + ", config=" + this.config + '}';
        }
    }
}

